/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C, I extends ToFloatFunction<C>>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String a();

    public CubicSpline<C, I> a(d<I> var1);

    public static <C, I extends ToFloatFunction<C>> Codec<CubicSpline<C, I>> a(Codec<I> locationFunctionCodec) {
        record A<C, I extends ToFloatFunction<C>>(float a, CubicSpline<C, I> b, float c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "location;value;derivative", "a", "b", "c"}, this, object);
            }
        }
        MutableObject mutableObject = new MutableObject();
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("location").forGetter(A::a), (App)Codec.lazyInitialized(() -> ((MutableObject)mutableObject).getValue()).fieldOf("value").forGetter(A::b), (App)Codec.FLOAT.fieldOf("derivative").forGetter(A::c)).apply((Applicative)instance, (location, value, derivative) -> new A((float)location, value, (float)derivative)));
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)locationFunctionCodec.fieldOf("coordinate").forGetter(e::d), (App)ExtraCodecs.a(codec.listOf()).fieldOf("points").forGetter(spline -> IntStream.range(0, spline.c.length).mapToObj(index -> new A(spline.e()[index], spline.f().get(index), spline.g()[index])).toList())).apply((Applicative)instance, (locationFunction, splines) -> {
            float[] fs = new float[splines.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] gs = new float[splines.size()];
            for (int i2 = 0; i2 < splines.size(); ++i2) {
                A lv = (A)splines.get(i2);
                fs[i2] = lv.a();
                builder.add(lv.b());
                gs[i2] = lv.c();
            }
            return e.a(locationFunction, fs, builder.build(), gs);
        }));
        mutableObject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec2).xmap(either -> (CubicSpline)((Object)either.map(c::new, spline -> spline)), spline -> {
            Either either;
            if (spline instanceof c) {
                c constant = (c)spline;
                either = Either.left(Float.valueOf(constant.d()));
            } else {
                either = Either.right((e)spline);
            }
            return either;
        }));
        return (Codec)mutableObject.getValue();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> a(float value) {
        return new c(value);
    }

    public static <C, I extends ToFloatFunction<C>> b<C, I> a(I locationFunction) {
        return new b(locationFunction);
    }

    public static <C, I extends ToFloatFunction<C>> b<C, I> a(I locationFunction, ToFloatFunction<Float> amplifier) {
        return new b(locationFunction, amplifier);
    }

    @VisibleForDebug
    public record c<C, I extends ToFloatFunction<C>>(float b) implements CubicSpline<C, I>
    {
        @Override
        @Override
        public float a(C x2) {
            return this.b;
        }

        @Override
        @Override
        public String a() {
            return String.format(Locale.ROOT, "k=%.3f", Float.valueOf(this.b));
        }

        @Override
        @Override
        public float c() {
            return this.b;
        }

        @Override
        @Override
        public CubicSpline<C, I> a(d<I> visitor) {
            return this;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "value", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "value", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "value", "b"}, this, object);
        }

        public float d() {
            return this.b;
        }
    }

    public static final class b<C, I extends ToFloatFunction<C>> {
        private final I a;
        private final ToFloatFunction<Float> b;
        private final FloatList c = new FloatArrayList();
        private final List<CubicSpline<C, I>> d = Lists.newArrayList();
        private final FloatList e = new FloatArrayList();

        protected b(I locationFunction) {
            this(locationFunction, ToFloatFunction.a);
        }

        protected b(I locationFunction, ToFloatFunction<Float> amplifier) {
            this.a = locationFunction;
            this.b = amplifier;
        }

        public b<C, I> a(float location, float value) {
            return this.a(location, new c(this.b.a(Float.valueOf(value))), 0.0f);
        }

        public b<C, I> a(float location, float value, float derivative) {
            return this.a(location, new c(this.b.a(Float.valueOf(value))), derivative);
        }

        public b<C, I> a(float location, CubicSpline<C, I> value) {
            return this.a(location, value, 0.0f);
        }

        private b<C, I> a(float location, CubicSpline<C, I> value, float derivative) {
            if (!this.c.isEmpty() && location <= this.c.getFloat(this.c.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.c.add(location);
            this.d.add(value);
            this.e.add(derivative);
            return this;
        }

        public CubicSpline<C, I> a() {
            if (this.c.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return net.minecraft.util.CubicSpline$e.a(this.a, this.c.toFloatArray(), ImmutableList.copyOf(this.d), this.e.toFloatArray());
        }
    }

    @VisibleForDebug
    public record e<C, I extends ToFloatFunction<C>>(I b, float[] c, List<CubicSpline<C, I>> d, float[] e, float f, float g) implements CubicSpline<C, I>
    {
        private final I b;
        private final float[] c;
        private final List<CubicSpline<C, I>> d;
        private final float[] e;
        private final float f;
        private final float g;

        public e {
            net.minecraft.util.CubicSpline$e.a(fs, list, gs);
        }

        static <C, I extends ToFloatFunction<C>> e<C, I> a(I locationFunction, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            net.minecraft.util.CubicSpline$e.a(locations, values, derivatives);
            int i2 = locations.length - 1;
            float f2 = Float.POSITIVE_INFINITY;
            float g2 = Float.NEGATIVE_INFINITY;
            float h2 = locationFunction.b();
            float j2 = locationFunction.c();
            if (h2 < locations[0]) {
                float k2 = net.minecraft.util.CubicSpline$e.a(h2, locations, values.get(0).b(), derivatives, 0);
                float l2 = net.minecraft.util.CubicSpline$e.a(h2, locations, values.get(0).c(), derivatives, 0);
                f2 = Math.min(f2, Math.min(k2, l2));
                g2 = Math.max(g2, Math.max(k2, l2));
            }
            if (j2 > locations[i2]) {
                float m2 = net.minecraft.util.CubicSpline$e.a(j2, locations, values.get(i2).b(), derivatives, i2);
                float n2 = net.minecraft.util.CubicSpline$e.a(j2, locations, values.get(i2).c(), derivatives, i2);
                f2 = Math.min(f2, Math.min(m2, n2));
                g2 = Math.max(g2, Math.max(m2, n2));
            }
            for (CubicSpline<C, I> cubicSpline : values) {
                f2 = Math.min(f2, cubicSpline.b());
                g2 = Math.max(g2, cubicSpline.c());
            }
            for (int o2 = 0; o2 < i2; ++o2) {
                float p2 = locations[o2];
                float q2 = locations[o2 + 1];
                float r2 = q2 - p2;
                CubicSpline<C, I> cubicSpline2 = values.get(o2);
                CubicSpline<C, I> cubicSpline3 = values.get(o2 + 1);
                float s2 = cubicSpline2.b();
                float t2 = cubicSpline2.c();
                float u2 = cubicSpline3.b();
                float v2 = cubicSpline3.c();
                float w2 = derivatives[o2];
                float x2 = derivatives[o2 + 1];
                if (w2 == 0.0f && x2 == 0.0f) continue;
                float y2 = w2 * r2;
                float z2 = x2 * r2;
                float aa2 = Math.min(s2, u2);
                float ab = Math.max(t2, v2);
                float ac = y2 - v2 + s2;
                float ad = y2 - u2 + t2;
                float ae = -z2 + u2 - t2;
                float af = -z2 + v2 - s2;
                float ag = Math.min(ac, ae);
                float ah = Math.max(ad, af);
                f2 = Math.min(f2, aa2 + 0.25f * ag);
                g2 = Math.max(g2, ab + 0.25f * ah);
            }
            return new e<C, I>(locationFunction, locations, values, derivatives, f2, g2);
        }

        private static float a(float point, float[] locations, float value, float[] derivatives, int i2) {
            float f2 = derivatives[i2];
            if (f2 == 0.0f) {
                return value;
            }
            return value + f2 * (point - locations[i2]);
        }

        private static <C, I extends ToFloatFunction<C>> void a(float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            if (locations.length != values.size() || locations.length != derivatives.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + locations.length + " " + values.size() + " " + derivatives.length);
            }
            if (locations.length == 0) {
                throw new IllegalArgumentException("Cannot create a multipoint spline with no points");
            }
        }

        @Override
        @Override
        public float a(C x2) {
            float f2 = this.b.a(x2);
            int i2 = net.minecraft.util.CubicSpline$e.a(this.c, f2);
            int j2 = this.c.length - 1;
            if (i2 < 0) {
                return net.minecraft.util.CubicSpline$e.a(f2, this.c, this.d.get(0).a(x2), this.e, 0);
            }
            if (i2 == j2) {
                return net.minecraft.util.CubicSpline$e.a(f2, this.c, this.d.get(j2).a(x2), this.e, j2);
            }
            float g2 = this.c[i2];
            float h2 = this.c[i2 + 1];
            float k2 = (f2 - g2) / (h2 - g2);
            ToFloatFunction toFloatFunction = this.d.get(i2);
            ToFloatFunction toFloatFunction2 = this.d.get(i2 + 1);
            float l2 = this.e[i2];
            float m2 = this.e[i2 + 1];
            float n2 = toFloatFunction.a(x2);
            float o2 = toFloatFunction2.a(x2);
            float p2 = l2 * (h2 - g2) - (o2 - n2);
            float q2 = -m2 * (h2 - g2) + (o2 - n2);
            float r2 = MathHelper.h(k2, n2, o2) + k2 * (1.0f - k2) * MathHelper.h(k2, p2, q2);
            return r2;
        }

        private static int a(float[] locations, float x2) {
            return MathHelper.a(0, locations.length, (int i2) -> x2 < locations[i2]) - 1;
        }

        @Override
        @VisibleForTesting
        @Override
        public String a() {
            return "Spline{coordinate=" + String.valueOf(this.b) + ", locations=" + this.a(this.c) + ", derivatives=" + this.a(this.e) + ", values=" + this.d.stream().map(CubicSpline::a).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String a(float[] values) {
            return "[" + IntStream.range(0, values.length).mapToDouble(index -> values[index]).mapToObj(value -> String.format(Locale.ROOT, "%.3f", value)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        @Override
        public CubicSpline<C, I> a(d<I> visitor) {
            return net.minecraft.util.CubicSpline$e.a((ToFloatFunction)visitor.visit(this.b), this.c, this.f().stream().map(value -> value.a(visitor)).toList(), this.e);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "coordinate;locations;values;derivatives;minValue;maxValue", "b", "c", "d", "e", "f", "g"}, this, object);
        }

        public I d() {
            return this.b;
        }

        public float[] e() {
            return this.c;
        }

        public List<CubicSpline<C, I>> f() {
            return this.d;
        }

        public float[] g() {
            return this.e;
        }

        @Override
        @Override
        public float b() {
            return this.f;
        }

        @Override
        @Override
        public float c() {
            return this.g;
        }
    }

    public static interface d<I> {
        public I visit(I var1);
    }
}

