/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ExtraCodecs {
    public static final Codec<JsonElement> a = ExtraCodecs.a(JsonOps.INSTANCE);
    public static final Codec<Object> b = ExtraCodecs.a(JavaOps.INSTANCE);
    public static final Codec<Vector3f> c = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 3).map(listx -> new Vector3f(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue())), vec3f -> List.of(Float.valueOf(vec3f.x()), Float.valueOf(vec3f.y()), Float.valueOf(vec3f.z())));
    public static final Codec<Vector4f> d = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 4).map(listx -> new Vector4f(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue(), ((Float)listx.get(3)).floatValue())), vec4f -> List.of(Float.valueOf(vec4f.x()), Float.valueOf(vec4f.y()), Float.valueOf(vec4f.z()), Float.valueOf(vec4f.w())));
    public static final Codec<Quaternionf> e = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 4).map(listx -> new Quaternionf(((Float)listx.get(0)).floatValue(), ((Float)listx.get(1)).floatValue(), ((Float)listx.get(2)).floatValue(), ((Float)listx.get(3)).floatValue()).normalize()), quaternion -> List.of(Float.valueOf(quaternion.x), Float.valueOf(quaternion.y), Float.valueOf(quaternion.z), Float.valueOf(quaternion.w)));
    public static final Codec<AxisAngle4f> f = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("angle").forGetter(axisAngle -> Float.valueOf(axisAngle.angle)), (App)c.fieldOf("axis").forGetter(axisAngle -> new Vector3f(axisAngle.x, axisAngle.y, axisAngle.z))).apply((Applicative)instance, AxisAngle4f::new));
    public static final Codec<Quaternionf> g = Codec.withAlternative(e, (Codec)f.xmap(Quaternionf::new, AxisAngle4f::new));
    public static final Codec<Matrix4f> h = Codec.FLOAT.listOf().comapFlatMap(list -> SystemUtils.a(list, 16).map(listx -> {
        Matrix4f matrix4f = new Matrix4f();
        for (int i2 = 0; i2 < listx.size(); ++i2) {
            matrix4f.setRowColumn(i2 >> 2, i2 & 3, ((Float)listx.get(i2)).floatValue());
        }
        return matrix4f.determineProperties();
    }), matrix4f -> {
        FloatArrayList floatList = new FloatArrayList(16);
        for (int i2 = 0; i2 < 16; ++i2) {
            floatList.add(matrix4f.getRowColumn(i2 >> 2, i2 & 3));
        }
        return floatList;
    });
    public static final Codec<Integer> i = Codec.withAlternative((Codec)Codec.INT, c, vec3f -> ARGB.a(1.0f, vec3f.x(), vec3f.y(), vec3f.z()));
    public static final Codec<Integer> j = Codec.withAlternative((Codec)Codec.INT, d, vec4f -> ARGB.a(vec4f.w(), vec4f.x(), vec4f.y(), vec4f.z()));
    public static final Codec<Integer> k = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, value -> {
        if (value > 255) {
            return DataResult.error(() -> "Unsigned byte was too large: " + value + " > 255");
        }
        return DataResult.success((Object)value.byteValue());
    });
    public static final Codec<Integer> l = ExtraCodecs.a(0, Integer.MAX_VALUE, (Integer v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Integer> m = ExtraCodecs.a(1, Integer.MAX_VALUE, (Integer v2) -> "Value must be positive: " + v2);
    public static final Codec<Float> n = ExtraCodecs.a(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be non-negative: " + v2);
    public static final Codec<Float> o = ExtraCodecs.b(0.0f, Float.MAX_VALUE, (Float v2) -> "Value must be positive: " + v2);
    public static final Codec<Pattern> p = Codec.STRING.comapFlatMap(pattern -> {
        try {
            return DataResult.success((Object)Pattern.compile(pattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return DataResult.error(() -> "Invalid regex pattern '" + pattern + "': " + patternSyntaxException.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> q = ExtraCodecs.a(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> r = Codec.STRING.comapFlatMap(encoded -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)encoded));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, data -> Base64.getEncoder().encodeToString((byte[])data));
    public static final Codec<String> s = Codec.STRING.comapFlatMap(string -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)string)), StringEscapeUtils::escapeJava);
    public static final Codec<c> t = Codec.STRING.comapFlatMap(tagEntry -> tagEntry.startsWith("#") ? MinecraftKey.d(tagEntry.substring(1)).map(id -> new c((MinecraftKey)id, true)) : MinecraftKey.d(tagEntry).map(id -> new c((MinecraftKey)id, false)), c::c);
    public static final Function<Optional<Long>, OptionalLong> u = optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> v = optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> w = Codec.LONG_STREAM.xmap(stream -> BitSet.valueOf(stream.toArray()), set -> Arrays.stream(set.toLongArray()));
    private static final Codec<Property> D = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.lenientOptionalFieldOf("signature").forGetter(property -> Optional.ofNullable(property.signature()))).apply((Applicative)instance, (key, value, signature) -> new Property(key, value, (String)signature.orElse(null))));
    public static final Codec<PropertyMap> x = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)D.listOf()).xmap(either -> {
        PropertyMap propertyMap = new PropertyMap();
        either.ifLeft(map -> map.forEach((key, values) -> {
            for (String string : values) {
                propertyMap.put(key, (Object)new Property(key, string));
            }
        })).ifRight(properties -> {
            for (Property property : properties) {
                propertyMap.put((Object)property.name(), (Object)property);
            }
        });
        return propertyMap;
    }, properties -> Either.right(properties.values().stream().toList()));
    public static final Codec<String> y = Codec.string((int)0, (int)16).validate(name -> {
        if (UtilColor.f(name)) {
            return DataResult.success((Object)name);
        }
        return DataResult.error(() -> "Player name contained disallowed characters: '" + name + "'");
    });
    private static final MapCodec<GameProfile> E = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.e.fieldOf("id").forGetter(GameProfile::getId), (App)y.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)instance, GameProfile::new));
    public static final Codec<GameProfile> z = RecordCodecBuilder.create(instance -> instance.group((App)E.forGetter(Function.identity()), (App)x.lenientOptionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)instance, (profile, properties) -> {
        properties.forEach((key, property) -> profile.getProperties().put(key, property));
        return profile;
    }));
    public static final Codec<String> A = Codec.STRING.validate(string -> string.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)string));
    public static final Codec<Integer> B = Codec.STRING.comapFlatMap(string -> {
        int[] is = string.codePoints().toArray();
        if (is.length != 1) {
            return DataResult.error(() -> "Expected one codepoint, got: " + string);
        }
        return DataResult.success((Object)is[0]);
    }, Character::toString);
    public static final Codec<String> C = Codec.STRING.validate(path -> {
        if (!MinecraftKey.i(path)) {
            return DataResult.error(() -> "Invalid string to use as a resource path element: " + path);
        }
        return DataResult.success((Object)path);
    });

    public static <T> Codec<T> a(DynamicOps<T> ops) {
        return Codec.PASSTHROUGH.xmap(dynamic -> dynamic.convert(ops).getValue(), object -> new Dynamic<Object>(ops, object));
    }

    public static <P, I> Codec<I> a(Codec<P> codec, String leftFieldName, String rightFieldName, BiFunction<P, P, DataResult<I>> combineFunction, Function<I, P> leftFunction, Function<I, P> rightFunction) {
        Codec codec2 = Codec.list(codec).comapFlatMap(list -> SystemUtils.a(list, 2).flatMap(listx -> {
            Object object = listx.get(0);
            Object object2 = listx.get(1);
            return (DataResult)combineFunction.apply(object, object2);
        }), pair -> ImmutableList.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec3 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(leftFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(rightFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)combineFunction.apply(pair.getFirst(), pair.getSecond()), pair -> Pair.of(leftFunction.apply(pair), rightFunction.apply(pair)));
        Codec codec4 = Codec.withAlternative((Codec)codec2, (Codec)codec3);
        return Codec.either(codec, (Codec)codec4).comapFlatMap(either -> either.map(object -> (DataResult)combineFunction.apply(object, object), DataResult::success), pair -> {
            Object object2;
            Object object = leftFunction.apply(pair);
            if (Objects.equals(object, object2 = rightFunction.apply(pair))) {
                return Either.left(object);
            }
            return Either.right(pair);
        });
    }

    public static <A> Codec.ResultFunction<A> a(final A object) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> dynamicOps, T object2, DataResult<Pair<A, T>> dataResult) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = dataResult.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                if (optional.isPresent()) {
                    return dataResult;
                }
                return DataResult.error(() -> "(" + (String)mutableObject.getValue() + " -> using default)", (Object)Pair.of((Object)object, object2));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, A object2, DataResult<T> dataResult) {
                return dataResult;
            }

            @Override
            public String toString() {
                return "OrElsePartial[" + String.valueOf(object) + "]";
            }
        };
    }

    public static <E> Codec<E> a(ToIntFunction<E> elementToRawId, IntFunction<E> rawIdToElement, int errorRawId) {
        return Codec.INT.flatXmap(rawId -> Optional.ofNullable(rawIdToElement.apply((int)rawId)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + rawId)), element -> {
            int j2 = elementToRawId.applyAsInt(element);
            return j2 == errorRawId ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(element)) : DataResult.success((Object)j2);
        });
    }

    public static <E> Codec<E> a(final Codec<E> uncompressedCodec, final Codec<E> compressedCodec) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E object, DynamicOps<T> dynamicOps, T object2) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, object2);
                }
                return uncompressedCodec.encode(object, dynamicOps, object2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, object);
                }
                return uncompressedCodec.decode(dynamicOps, object);
            }

            @Override
            public String toString() {
                return String.valueOf(uncompressedCodec) + " orCompressed " + String.valueOf(compressedCodec);
            }
        };
    }

    public static <E> MapCodec<E> a(final MapCodec<E> uncompressedCodec, final MapCodec<E> compressedCodec) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.encode(object, dynamicOps, recordBuilder);
                }
                return uncompressedCodec.encode(object, dynamicOps, recordBuilder);
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                if (dynamicOps.compressMaps()) {
                    return compressedCodec.decode(dynamicOps, mapLike);
                }
                return uncompressedCodec.decode(dynamicOps, mapLike);
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return compressedCodec.keys(dynamicOps);
            }

            public String toString() {
                return String.valueOf(uncompressedCodec) + " orCompressed " + String.valueOf(compressedCodec);
            }
        };
    }

    public static <E> Codec<E> a(Codec<E> originalCodec, final Function<E, Lifecycle> entryLifecycleGetter, final Function<E, Lifecycle> lifecycleGetter) {
        return originalCodec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)entryLifecycleGetter.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)lifecycleGetter.apply(object));
            }

            @Override
            public String toString() {
                return "WithLifecycle[" + String.valueOf(entryLifecycleGetter) + " " + String.valueOf(lifecycleGetter) + "]";
            }
        });
    }

    public static <E> Codec<E> a(Codec<E> originalCodec, Function<E, Lifecycle> lifecycleGetter) {
        return ExtraCodecs.a(originalCodec, lifecycleGetter, lifecycleGetter);
    }

    public static <K, V> b<K, V> b(Codec<K> keyCodec, Codec<V> elementCodec) {
        return new b<K, V>(keyCodec, elementCodec);
    }

    private static Codec<Integer> a(int min, int max, Function<Integer, String> messageFactory) {
        return Codec.INT.validate(value -> {
            if (value.compareTo(min) >= 0 && value.compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Integer)value));
        });
    }

    public static Codec<Integer> a(int min, int max) {
        return ExtraCodecs.a(min, max, (Integer value) -> "Value must be within range [" + min + ";" + max + "]: " + value);
    }

    private static Codec<Float> a(float minInclusive, float maxInclusive, Function<Float, String> messageFactory) {
        return Codec.FLOAT.validate(value -> {
            if (value.compareTo(Float.valueOf(minInclusive)) >= 0 && value.compareTo(Float.valueOf(maxInclusive)) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Float)value));
        });
    }

    private static Codec<Float> b(float minExclusive, float maxInclusive, Function<Float, String> messageFactory) {
        return Codec.FLOAT.validate(value -> {
            if (value.compareTo(Float.valueOf(minExclusive)) > 0 && value.compareTo(Float.valueOf(maxInclusive)) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply((Float)value));
        });
    }

    public static <T> Codec<List<T>> a(Codec<List<T>> originalCodec) {
        return originalCodec.validate(list -> list.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)list));
    }

    public static <T> Codec<HolderSet<T>> b(Codec<HolderSet<T>> originalCodec) {
        return originalCodec.validate(entryList -> {
            if (entryList.d().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)entryList);
        });
    }

    public static <M extends Map<?, ?>> Codec<M> c(Codec<M> originalCodec) {
        return originalCodec.validate(map -> map.isEmpty() ? DataResult.error(() -> "Map must have contents") : DataResult.success((Object)map));
    }

    public static <E> MapCodec<E> a(Function<DynamicOps<?>, DataResult<E>> retriever) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function retriever) {
                this.a = retriever;
            }

            public <T> RecordBuilder<T> encode(E object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                return recordBuilder;
            }

            public <T> DataResult<E> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return (DataResult)this.a.apply(dynamicOps);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + String.valueOf(this.a) + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.empty();
            }
        }
        return new A(retriever);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> b(Function<E, T> typeGetter) {
        return collection -> {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = typeGetter.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    Object object3 = typeGetter.apply(object2);
                    if (object3 == object) continue;
                    return DataResult.error(() -> "Mixed type list: element " + String.valueOf(object2) + " had type " + String.valueOf(object3) + ", but list is of type " + String.valueOf(object));
                }
            }
            return DataResult.success((Object)collection, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> d(final Codec<A> codec) {
        return Codec.of(codec, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> dynamicOps, T object) {
                try {
                    return codec.decode(dynamicOps, object);
                }
                catch (Exception exception) {
                    return DataResult.error(() -> "Caught exception decoding " + String.valueOf(object) + ": " + exception.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> a(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)formatter.parse((CharSequence)string));
            }
            catch (Exception exception) {
                return DataResult.error(exception::getMessage);
            }
        }, formatter::format);
    }

    public static MapCodec<OptionalLong> a(MapCodec<Optional<Long>> codec) {
        return codec.xmap(u, v);
    }

    public static <K, V> Codec<Map<K, V>> a(Codec<Map<K, V>> codec, int maxLength) {
        return codec.validate(map -> {
            if (map.size() > maxLength) {
                return DataResult.error(() -> "Map is too long: " + map.size() + ", expected range [0-" + maxLength + "]");
            }
            return DataResult.success((Object)map);
        });
    }

    public static <T> Codec<Object2BooleanMap<T>> e(Codec<T> keyCodec) {
        return Codec.unboundedMap(keyCodec, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    @Deprecated
    public static <K, V> MapCodec<V> a(final String typeKey, final String parametersKey, final Codec<K> typeCodec, final Function<? super V, ? extends K> typeGetter, final Function<? super K, ? extends Codec<? extends V>> parametersCodecGetter) {
        return new MapCodec<V>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Stream.of(dynamicOps.createString(typeKey), dynamicOps.createString(parametersKey));
            }

            public <T> DataResult<V> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                Object object = mapLike.get(typeKey);
                if (object == null) {
                    return DataResult.error(() -> "Missing \"" + typeKey + "\" in: " + String.valueOf(mapLike));
                }
                return typeCodec.decode(dynamicOps, object).flatMap(pair -> {
                    Object object = Objects.requireNonNullElseGet(mapLike.get(parametersKey), () -> ((DynamicOps)dynamicOps).emptyMap());
                    return ((Codec)parametersCodecGetter.apply(pair.getFirst())).decode(dynamicOps, object).map(Pair::getFirst);
                });
            }

            public <T> RecordBuilder<T> encode(V object, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                Object object2 = typeGetter.apply(object);
                recordBuilder.add(typeKey, typeCodec.encodeStart(dynamicOps, object2));
                DataResult<T> dataResult = this.a((Codec)parametersCodecGetter.apply(object2), object, dynamicOps);
                if (dataResult.result().isEmpty() || !Objects.equals(dataResult.result().get(), dynamicOps.emptyMap())) {
                    recordBuilder.add(parametersKey, dataResult);
                }
                return recordBuilder;
            }

            private <T, V2 extends V> DataResult<T> a(Codec<V2> codec, V value, DynamicOps<T> ops) {
                return codec.encodeStart(ops, value);
            }
        };
    }

    public static <A> Codec<Optional<A>> f(final Codec<A> codec) {
        return new Codec<Optional<A>>(){

            public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> dynamicOps, T object) {
                if (7.a(dynamicOps, object)) {
                    return DataResult.success((Object)Pair.of(Optional.empty(), object));
                }
                return codec.decode(dynamicOps, object).map(pair -> pair.mapFirst(Optional::of));
            }

            private static <T> boolean a(DynamicOps<T> ops, T input) {
                Optional optional = ops.getMap(input).result();
                return optional.isPresent() && ((MapLike)optional.get()).entries().findAny().isEmpty();
            }

            public <T> DataResult<T> a(Optional<A> optional, DynamicOps<T> dynamicOps, T object) {
                if (optional.isEmpty()) {
                    return DataResult.success((Object)dynamicOps.emptyMap());
                }
                return codec.encode(optional.get(), dynamicOps, object);
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.a((Optional)object, dynamicOps, object2);
            }
        };
    }

    public static final class b<K, V>
    extends Record
    implements Codec<Map<K, V>>,
    BaseMapCodec<K, V> {
        private final Codec<K> a;
        private final Codec<V> b;

        public b(Codec<K> keyCodec, Codec<V> elementCodec) {
            this.a = keyCodec;
            this.b = elementCodec;
        }

        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Pair pair : mapLike.entries().toList()) {
                DataResult dataResult2;
                DataResult dataResult = this.keyCodec().parse(dynamicOps, pair.getFirst());
                DataResult dataResult3 = dataResult.apply2stable(Pair::of, dataResult2 = this.elementCodec().parse(dynamicOps, pair.getSecond()));
                Optional optional = dataResult3.error();
                if (optional.isPresent()) {
                    String string = ((DataResult.Error)optional.get()).message();
                    return DataResult.error(() -> {
                        if (dataResult.result().isPresent()) {
                            return "Map entry '" + String.valueOf(dataResult.result().get()) + "' : " + string;
                        }
                        return string;
                    });
                }
                if (dataResult3.result().isPresent()) {
                    Pair pair2 = (Pair)dataResult3.result().get();
                    builder.put(pair2.getFirst(), pair2.getSecond());
                    continue;
                }
                return DataResult.error(() -> "Empty or invalid map contents are not allowed");
            }
            ImmutableMap map = builder.build();
            return DataResult.success((Object)map);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return dynamicOps.getMap(object).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(dynamicOps, (Object)map)).map(map -> Pair.of((Object)map, (Object)object));
        }

        public <T> DataResult<T> a(Map<K, V> map, DynamicOps<T> dynamicOps, T object) {
            return this.encode(map, dynamicOps, dynamicOps.mapBuilder()).build(object);
        }

        @Override
        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + String.valueOf(this.a) + " -> " + String.valueOf(this.b) + "]";
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "keyCodec;elementCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "keyCodec;elementCodec", "a", "b"}, this, object);
        }

        public Codec<K> keyCodec() {
            return this.a;
        }

        public Codec<V> elementCodec() {
            return this.b;
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.a((Map)object, dynamicOps, object2);
        }
    }

    public record c(MinecraftKey a, boolean b) {
        @Override
        @Override
        public String toString() {
            return this.c();
        }

        private String c() {
            return this.b ? "#" + String.valueOf(this.a) : this.a.toString();
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;tag", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;tag", "a", "b"}, this, object);
        }
    }
}

