/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MathHelper {
    private static final long k = 61440L;
    private static final long l = 16384L;
    private static final long m = -4611686018427387904L;
    private static final long n = Long.MIN_VALUE;
    public static final float a = (float)java.lang.Math.PI;
    public static final float b = 1.5707964f;
    public static final float c = (float)java.lang.Math.PI * 2;
    public static final float d = (float)java.lang.Math.PI / 180;
    public static final float e = 57.295776f;
    public static final float f = 1.0E-5f;
    public static final float g = MathHelper.c(2.0f);
    private static final float o = 10430.378f;
    public static final Vector3f h = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f i = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f j = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final float[] p = SystemUtils.a(new float[65536], sineTable -> {
        for (int i2 = 0; i2 < ((float[])sineTable).length; ++i2) {
            sineTable[i2] = (float)java.lang.Math.sin((double)i2 * java.lang.Math.PI * 2.0 / 65536.0);
        }
    });
    private static final RandomSource q = RandomSource.b();
    private static final int[] r = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double s = 0.16666666666666666;
    private static final int t = 8;
    private static final int u = 257;
    private static final double v = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] w = new double[257];
    private static final double[] x = new double[257];

    public static float a(float value) {
        return p[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float b(float value) {
        return p[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float c(float value) {
        return (float)java.lang.Math.sqrt(value);
    }

    public static int d(float value) {
        int i2 = (int)value;
        return value < (float)i2 ? i2 - 1 : i2;
    }

    public static int a(double value) {
        int i2 = (int)value;
        return value < (double)i2 ? i2 - 1 : i2;
    }

    public static long b(double value) {
        long l2 = (long)value;
        return value < (double)l2 ? l2 - 1L : l2;
    }

    public static float e(float value) {
        return java.lang.Math.abs(value);
    }

    public static int a(int value) {
        return java.lang.Math.abs(value);
    }

    public static int f(float value) {
        int i2 = (int)value;
        return value > (float)i2 ? i2 + 1 : i2;
    }

    public static int c(double value) {
        int i2 = (int)value;
        return value > (double)i2 ? i2 + 1 : i2;
    }

    public static int a(int value, int min, int max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static long a(long value, long min, long max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static float a(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return java.lang.Math.min(value, max);
    }

    public static double a(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return java.lang.Math.min(value, max);
    }

    public static double b(double start, double end, double delta) {
        if (delta < 0.0) {
            return start;
        }
        if (delta > 1.0) {
            return end;
        }
        return MathHelper.d(delta, start, end);
    }

    public static float b(float start, float end, float delta) {
        if (delta < 0.0f) {
            return start;
        }
        if (delta > 1.0f) {
            return end;
        }
        return MathHelper.h(delta, start, end);
    }

    public static double a(double a2, double b2) {
        if (a2 < 0.0) {
            a2 = -a2;
        }
        if (b2 < 0.0) {
            b2 = -b2;
        }
        return java.lang.Math.max(a2, b2);
    }

    public static int a(int dividend, int divisor) {
        return java.lang.Math.floorDiv(dividend, divisor);
    }

    public static int a(RandomSource random, int min, int max) {
        if (min >= max) {
            return min;
        }
        return random.a(max - min + 1) + min;
    }

    public static float a(RandomSource random, float min, float max) {
        if (min >= max) {
            return min;
        }
        return random.i() * (max - min) + min;
    }

    public static double a(RandomSource random, double min, double max) {
        if (min >= max) {
            return min;
        }
        return random.j() * (max - min) + min;
    }

    public static boolean a(float a2, float b2) {
        return java.lang.Math.abs(b2 - a2) < 1.0E-5f;
    }

    public static boolean b(double a2, double b2) {
        return java.lang.Math.abs(b2 - a2) < (double)1.0E-5f;
    }

    public static int b(int dividend, int divisor) {
        return java.lang.Math.floorMod(dividend, divisor);
    }

    public static float b(float dividend, float divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static double c(double dividend, double divisor) {
        return (dividend % divisor + divisor) % divisor;
    }

    public static boolean c(int a2, int b2) {
        return a2 % b2 == 0;
    }

    public static byte g(float degrees) {
        return (byte)MathHelper.d(degrees * 256.0f / 360.0f);
    }

    public static float a(byte packedDegrees) {
        return (float)(packedDegrees * 360) / 256.0f;
    }

    public static int b(int degrees) {
        int i2 = degrees % 360;
        if (i2 >= 180) {
            i2 -= 360;
        }
        if (i2 < -180) {
            i2 += 360;
        }
        return i2;
    }

    public static float a(long degrees) {
        float f2 = degrees % 360L;
        if (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        if (f2 < -180.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static float h(float degrees) {
        float f2 = degrees % 360.0f;
        if (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        if (f2 < -180.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static double d(double degrees) {
        double d2 = degrees % 360.0;
        if (d2 >= 180.0) {
            d2 -= 360.0;
        }
        if (d2 < -180.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static float c(float start, float end) {
        return MathHelper.h(end - start);
    }

    public static float d(float first, float second) {
        return MathHelper.e(MathHelper.c(first, second));
    }

    public static float c(float value, float mean, float delta) {
        float f2 = MathHelper.c(value, mean);
        float g2 = MathHelper.a(f2, -delta, delta);
        return mean - g2;
    }

    public static float d(float from, float to, float step) {
        step = MathHelper.e(step);
        if (from < to) {
            return MathHelper.a(from + step, from, to);
        }
        return MathHelper.a(from - step, to, from);
    }

    public static float e(float from, float to, float step) {
        float f2 = MathHelper.c(from, to);
        return MathHelper.d(from, from + f2, step);
    }

    public static int a(String string, int fallback) {
        return NumberUtils.toInt((String)string, (int)fallback);
    }

    public static int c(int value) {
        int i2 = value - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public static boolean d(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int e(int value) {
        value = MathHelper.d(value) ? value : MathHelper.c(value);
        return r[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int f(int value) {
        return MathHelper.e(value) - (MathHelper.d(value) ? 0 : 1);
    }

    public static float i(float value) {
        return value - (float)MathHelper.d(value);
    }

    public static double e(double value) {
        return value - (double)MathHelper.b(value);
    }

    @Deprecated
    public static long a(BaseBlockPosition vec) {
        return MathHelper.b(vec.u(), vec.v(), vec.w());
    }

    @Deprecated
    public static long b(int x2, int y2, int z2) {
        long l2 = (long)(x2 * 3129871) ^ (long)z2 * 116129781L ^ (long)y2;
        l2 = l2 * l2 * 42317861L + l2 * 11L;
        return l2 >> 16;
    }

    public static UUID a(RandomSource random) {
        long l2 = random.g() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long m2 = random.g() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(l2, m2);
    }

    public static UUID a() {
        return MathHelper.a(q);
    }

    public static double c(double value, double start, double end) {
        return (value - start) / (end - start);
    }

    public static float f(float value, float start, float end) {
        return (value - start) / (end - start);
    }

    public static boolean a(Vec3D origin, Vec3D direction, AxisAlignedBB box) {
        double d2 = (box.a + box.d) * 0.5;
        double e2 = (box.d - box.a) * 0.5;
        double f2 = origin.d - d2;
        if (java.lang.Math.abs(f2) > e2 && f2 * direction.d >= 0.0) {
            return false;
        }
        double g2 = (box.b + box.e) * 0.5;
        double h2 = (box.e - box.b) * 0.5;
        double i2 = origin.e - g2;
        if (java.lang.Math.abs(i2) > h2 && i2 * direction.e >= 0.0) {
            return false;
        }
        double j2 = (box.c + box.f) * 0.5;
        double k2 = (box.f - box.c) * 0.5;
        double l2 = origin.f - j2;
        if (java.lang.Math.abs(l2) > k2 && l2 * direction.f >= 0.0) {
            return false;
        }
        double m2 = java.lang.Math.abs(direction.d);
        double n2 = java.lang.Math.abs(direction.e);
        double o2 = java.lang.Math.abs(direction.f);
        double p2 = direction.e * l2 - direction.f * i2;
        if (java.lang.Math.abs(p2) > h2 * o2 + k2 * n2) {
            return false;
        }
        p2 = direction.f * f2 - direction.d * l2;
        if (java.lang.Math.abs(p2) > e2 * o2 + k2 * m2) {
            return false;
        }
        p2 = direction.d * i2 - direction.e * f2;
        return java.lang.Math.abs(p2) < e2 * n2 + h2 * m2;
    }

    public static double d(double y2, double x2) {
        boolean bl3;
        boolean bl2;
        boolean bl;
        double d2 = x2 * x2 + y2 * y2;
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        boolean bl4 = bl = y2 < 0.0;
        if (bl) {
            y2 = -y2;
        }
        boolean bl5 = bl2 = x2 < 0.0;
        if (bl2) {
            x2 = -x2;
        }
        boolean bl6 = bl3 = y2 > x2;
        if (bl3) {
            double e2 = x2;
            x2 = y2;
            y2 = e2;
        }
        double f2 = MathHelper.g(d2);
        x2 *= f2;
        double g2 = v + (y2 *= f2);
        int i2 = (int)Double.doubleToRawLongBits(g2);
        double h2 = w[i2];
        double j2 = x[i2];
        double k2 = g2 - v;
        double l2 = y2 * j2 - x2 * k2;
        double m2 = (6.0 + l2 * l2) * l2 * 0.16666666666666666;
        double n2 = h2 + m2;
        if (bl3) {
            n2 = 1.5707963267948966 - n2;
        }
        if (bl2) {
            n2 = java.lang.Math.PI - n2;
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    public static float j(float x2) {
        return Math.invsqrt((float)x2);
    }

    public static double f(double x2) {
        return Math.invsqrt((double)x2);
    }

    @Deprecated
    public static double g(double x2) {
        double d2 = 0.5 * x2;
        long l2 = Double.doubleToRawLongBits(x2);
        l2 = 6910469410427058090L - (l2 >> 1);
        x2 = Double.longBitsToDouble(l2);
        x2 *= 1.5 - d2 * x2 * x2;
        return x2;
    }

    public static float k(float x2) {
        int i2 = Float.floatToIntBits(x2);
        i2 = 1419967116 - i2 / 3;
        float f2 = Float.intBitsToFloat(i2);
        f2 = 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * x2);
        f2 = 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * x2);
        return f2;
    }

    public static int g(float hue, float saturation, float value) {
        return MathHelper.a(hue, saturation, value, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int a(float hue, float saturation, float value, int alpha) {
        void ae;
        void ad;
        void ac;
        int i2 = (int)(hue * 6.0f) % 6;
        float f2 = hue * 6.0f - (float)i2;
        float g2 = value * (1.0f - saturation);
        float h2 = value * (1.0f - f2 * saturation);
        float j2 = value * (1.0f - (1.0f - f2) * saturation);
        switch (i2) {
            case 0: {
                float k2 = value;
                float l2 = j2;
                float m2 = g2;
                break;
            }
            case 1: {
                float n2 = h2;
                float o2 = value;
                float p2 = g2;
                break;
            }
            case 2: {
                float q2 = g2;
                float r2 = value;
                float s2 = j2;
                break;
            }
            case 3: {
                float t2 = g2;
                float u2 = h2;
                float v2 = value;
                break;
            }
            case 4: {
                float w2 = j2;
                float x2 = g2;
                float y2 = value;
                break;
            }
            case 5: {
                float z2 = value;
                float aa2 = g2;
                float ab = h2;
                break;
            }
            default: {
                throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
            }
        }
        return ARGB.a(alpha, MathHelper.a((int)(ac * 255.0f), 0, 255), MathHelper.a((int)(ad * 255.0f), 0, 255), MathHelper.a((int)(ae * 255.0f), 0, 255));
    }

    public static int g(int value) {
        value ^= value >>> 16;
        value *= -2048144789;
        value ^= value >>> 13;
        value *= -1028477387;
        value ^= value >>> 16;
        return value;
    }

    public static int a(int min, int max, IntPredicate predicate) {
        int i2 = max - min;
        while (i2 > 0) {
            int j2 = i2 / 2;
            int k2 = min + j2;
            if (predicate.test(k2)) {
                i2 = j2;
                continue;
            }
            min = k2 + 1;
            i2 -= j2 + 1;
        }
        return min;
    }

    public static int a(float delta, int start, int end) {
        return start + MathHelper.d(delta * (float)(end - start));
    }

    public static int b(float delta, int start, int end) {
        int i2 = end - start;
        return start + MathHelper.d(delta * (float)(i2 - 1)) + (delta > 0.0f ? 1 : 0);
    }

    public static float h(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static Vec3D a(double delta, Vec3D start, Vec3D end) {
        return new Vec3D(MathHelper.d(delta, start.d, end.d), MathHelper.d(delta, start.e, end.e), MathHelper.d(delta, start.f, end.f));
    }

    public static double d(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static double a(double deltaX, double deltaY, double x0y0, double x1y0, double x0y1, double x1y1) {
        return MathHelper.d(deltaY, MathHelper.d(deltaX, x0y0, x1y0), MathHelper.d(deltaX, x0y1, x1y1));
    }

    public static double a(double deltaX, double deltaY, double deltaZ, double x0y0z0, double x1y0z0, double x0y1z0, double x1y1z0, double x0y0z1, double x1y0z1, double x0y1z1, double x1y1z1) {
        return MathHelper.d(deltaZ, MathHelper.a(deltaX, deltaY, x0y0z0, x1y0z0, x0y1z0, x1y1z0), MathHelper.a(deltaX, deltaY, x0y0z1, x1y0z1, x0y1z1, x1y1z1));
    }

    public static float a(float delta, float p0, float p1, float p2, float p3) {
        return 0.5f * (2.0f * p1 + (p2 - p0) * delta + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * delta * delta + (3.0f * p1 - p0 - 3.0f * p2 + p3) * delta * delta * delta);
    }

    public static double h(double value) {
        return value * value * value * (value * (value * 6.0 - 15.0) + 10.0);
    }

    public static double i(double value) {
        return 30.0 * value * value * (value - 1.0) * (value - 1.0);
    }

    public static int j(double value) {
        if (value == 0.0) {
            return 0;
        }
        return value > 0.0 ? 1 : -1;
    }

    public static float i(float delta, float start, float end) {
        return start + delta * MathHelper.h(end - start);
    }

    public static double e(double delta, double start, double end) {
        return start + delta * MathHelper.d(end - start);
    }

    public static float j(float delta, float start, float end) {
        float f2;
        for (f2 = end - start; f2 < (float)(-java.lang.Math.PI); f2 += (float)java.lang.Math.PI * 2) {
        }
        while (f2 >= (float)java.lang.Math.PI) {
            f2 -= (float)java.lang.Math.PI * 2;
        }
        return start + delta * f2;
    }

    public static float e(float value, float maxDeviation) {
        return (java.lang.Math.abs(value % maxDeviation - maxDeviation * 0.5f) - maxDeviation * 0.25f) / (maxDeviation * 0.25f);
    }

    public static float l(float n2) {
        return n2 * n2;
    }

    public static double k(double n2) {
        return n2 * n2;
    }

    public static int h(int n2) {
        return n2 * n2;
    }

    public static long b(long n2) {
        return n2 * n2;
    }

    public static double a(double value, double oldStart, double oldEnd, double newStart, double newEnd) {
        return MathHelper.b(newStart, newEnd, MathHelper.c(value, oldStart, oldEnd));
    }

    public static float b(float value, float oldStart, float oldEnd, float newStart, float newEnd) {
        return MathHelper.b(newStart, newEnd, MathHelper.f(value, oldStart, oldEnd));
    }

    public static double b(double value, double oldStart, double oldEnd, double newStart, double newEnd) {
        return MathHelper.d(MathHelper.c(value, oldStart, oldEnd), newStart, newEnd);
    }

    public static float c(float value, float oldStart, float oldEnd, float newStart, float newEnd) {
        return MathHelper.h(MathHelper.f(value, oldStart, oldEnd), newStart, newEnd);
    }

    public static double l(double d2) {
        return d2 + (2.0 * RandomSource.a(MathHelper.a(d2 * 3000.0)).j() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int d(int value, int divisor) {
        return MathHelper.e(value, divisor) * divisor;
    }

    public static int e(int a2, int b2) {
        return -java.lang.Math.floorDiv(-a2, b2);
    }

    public static int b(RandomSource random, int min, int max) {
        return random.a(max - min + 1) + min;
    }

    public static float b(RandomSource random, float min, float max) {
        return random.i() * (max - min) + min;
    }

    public static float c(RandomSource random, float mean, float deviation) {
        return mean + (float)random.k() * deviation;
    }

    public static double e(double a2, double b2) {
        return a2 * a2 + b2 * b2;
    }

    public static double f(double a2, double b2) {
        return java.lang.Math.sqrt(MathHelper.e(a2, b2));
    }

    public static float f(float a2, float b2) {
        return (float)java.lang.Math.sqrt(MathHelper.e((double)a2, (double)b2));
    }

    public static double f(double a2, double b2, double c2) {
        return a2 * a2 + b2 * b2 + c2 * c2;
    }

    public static double g(double a2, double b2, double c2) {
        return java.lang.Math.sqrt(MathHelper.f(a2, b2, c2));
    }

    public static float k(float a2, float b2, float c2) {
        return a2 * a2 + b2 * b2 + c2 * c2;
    }

    public static int a(double a2, int b2) {
        return MathHelper.a(a2 / (double)b2) * b2;
    }

    public static IntStream c(int seed, int lowerBound, int upperBound) {
        return MathHelper.a(seed, lowerBound, upperBound, 1);
    }

    public static IntStream a(int seed, int lowerBound, int upperBound, int steps) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "upperbound %d expected to be > lowerBound %d", upperBound, lowerBound));
        }
        if (steps < 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "steps expected to be >= 1, was %d", steps));
        }
        if (seed < lowerBound || seed > upperBound) {
            return IntStream.empty();
        }
        return IntStream.iterate(seed, i2 -> {
            int m2 = java.lang.Math.abs(seed - i2);
            return seed - m2 >= lowerBound || seed + m2 <= upperBound;
        }, i2 -> {
            int o2;
            boolean bl2;
            boolean bl = i2 <= seed;
            int n2 = java.lang.Math.abs(seed - i2);
            boolean bl3 = bl2 = seed + n2 + steps <= upperBound;
            if (!(bl && bl2 || (o2 = seed - n2 - (bl ? steps : 0)) < lowerBound)) {
                return o2;
            }
            return seed + n2 + steps;
        });
    }

    public static Quaternionf a(Vector3f axis, Quaternionf rotation, Quaternionf result) {
        float f2 = axis.dot(rotation.x, rotation.y, rotation.z);
        return result.set(axis.x * f2, axis.y * f2, axis.z * f2, rotation.w).normalize();
    }

    public static int a(Fraction fraction, int multiplier) {
        return fraction.getNumerator() * multiplier / fraction.getDenominator();
    }

    public static float m(float value) {
        return -(MathHelper.b((float)java.lang.Math.PI * value) - 1.0f) / 2.0f;
    }

    static {
        for (int i2 = 0; i2 < 257; ++i2) {
            double d2 = (double)i2 / 256.0;
            double e2 = java.lang.Math.asin(d2);
            MathHelper.x[i2] = java.lang.Math.cos(e2);
            MathHelper.w[i2] = e2;
        }
    }
}

