/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class ParticleUtils {
    public static void a(World world, BlockPosition pos, ParticleParam effect, IntProvider count) {
        for (EnumDirection direction : EnumDirection.values()) {
            ParticleUtils.a(world, pos, effect, count, direction, () -> ParticleUtils.a(level.A), 0.55);
        }
    }

    public static void a(World world, BlockPosition pos, ParticleParam effect, IntProvider count, EnumDirection direction, Supplier<Vec3D> velocity, double offsetMultiplier) {
        int i2 = count.a(world.A);
        for (int j2 = 0; j2 < i2; ++j2) {
            ParticleUtils.a(world, pos, direction, effect, velocity.get(), offsetMultiplier);
        }
    }

    private static Vec3D a(RandomSource random) {
        return new Vec3D(MathHelper.a(random, -0.5, 0.5), MathHelper.a(random, -0.5, 0.5), MathHelper.a(random, -0.5, 0.5));
    }

    public static void a(EnumDirection.EnumAxis axis, World world, BlockPosition pos, double variance, ParticleParam effect, UniformInt range) {
        Vec3D vec3 = Vec3D.b(pos);
        boolean bl = axis == EnumDirection.EnumAxis.a;
        boolean bl2 = axis == EnumDirection.EnumAxis.b;
        boolean bl3 = axis == EnumDirection.EnumAxis.c;
        int i2 = range.a(world.A);
        for (int j2 = 0; j2 < i2; ++j2) {
            double d2 = vec3.d + MathHelper.a(world.A, -1.0, 1.0) * (bl ? 0.5 : variance);
            double e2 = vec3.e + MathHelper.a(world.A, -1.0, 1.0) * (bl2 ? 0.5 : variance);
            double f2 = vec3.f + MathHelper.a(world.A, -1.0, 1.0) * (bl3 ? 0.5 : variance);
            double g2 = bl ? MathHelper.a(world.A, -1.0, 1.0) : 0.0;
            double h2 = bl2 ? MathHelper.a(world.A, -1.0, 1.0) : 0.0;
            double k2 = bl3 ? MathHelper.a(world.A, -1.0, 1.0) : 0.0;
            world.a(effect, d2, e2, f2, g2, h2, k2);
        }
    }

    public static void a(World world, BlockPosition pos, EnumDirection direction, ParticleParam effect, Vec3D velocity, double offsetMultiplier) {
        Vec3D vec3 = Vec3D.b(pos);
        int i2 = direction.j();
        int j2 = direction.k();
        int k2 = direction.l();
        double d2 = vec3.d + (i2 == 0 ? MathHelper.a(world.A, -0.5, 0.5) : (double)i2 * offsetMultiplier);
        double e2 = vec3.e + (j2 == 0 ? MathHelper.a(world.A, -0.5, 0.5) : (double)j2 * offsetMultiplier);
        double f2 = vec3.f + (k2 == 0 ? MathHelper.a(world.A, -0.5, 0.5) : (double)k2 * offsetMultiplier);
        double g2 = i2 == 0 ? velocity.a() : 0.0;
        double h2 = j2 == 0 ? velocity.b() : 0.0;
        double l2 = k2 == 0 ? velocity.c() : 0.0;
        world.a(effect, d2, e2, f2, g2, h2, l2);
    }

    public static void a(World world, BlockPosition pos, RandomSource random, ParticleParam effect) {
        double d2 = (double)pos.u() + random.j();
        double e2 = (double)pos.v() - 0.05;
        double f2 = (double)pos.w() + random.j();
        world.a(effect, d2, e2, f2, 0.0, 0.0, 0.0);
    }

    public static void a(GeneratorAccess world, BlockPosition pos, int count, ParticleParam effect) {
        double d2 = 0.5;
        IBlockData blockState = world.a_(pos);
        double e2 = blockState.l() ? 1.0 : blockState.f(world, pos).c(EnumDirection.EnumAxis.b);
        ParticleUtils.a(world, pos, count, 0.5, e2, true, effect);
    }

    public static void a(GeneratorAccess world, BlockPosition pos, int count, double horizontalOffset, double verticalOffset, boolean force, ParticleParam effect) {
        RandomSource randomSource = world.H_();
        for (int i2 = 0; i2 < count; ++i2) {
            double d2 = randomSource.k() * 0.02;
            double e2 = randomSource.k() * 0.02;
            double f2 = randomSource.k() * 0.02;
            double g2 = 0.5 - horizontalOffset;
            double h2 = (double)pos.u() + g2 + randomSource.j() * horizontalOffset * 2.0;
            double j2 = (double)pos.v() + randomSource.j() * verticalOffset;
            double k2 = (double)pos.w() + g2 + randomSource.j() * horizontalOffset * 2.0;
            if (!force && world.a_(BlockPosition.a(h2, j2, k2).e()).l()) continue;
            world.a(effect, h2, j2, k2, d2, e2, f2);
        }
    }

    public static void a(GeneratorAccess world, BlockPosition pos, int count) {
        Vec3D vec3 = pos.b().b(0.0, 0.5, 0.0);
        ParticleParamBlock blockParticleOption = new ParticleParamBlock(Particles.bc, world.a_(pos));
        int i2 = 0;
        while ((float)i2 < (float)count / 3.0f) {
            double d2 = vec3.d + world.H_().k() / 2.0;
            double e2 = vec3.e;
            double f2 = vec3.f + world.H_().k() / 2.0;
            double g2 = world.H_().k() * (double)0.2f;
            double h2 = world.H_().k() * (double)0.2f;
            double j2 = world.H_().k() * (double)0.2f;
            world.a(blockParticleOption, d2, e2, f2, g2, h2, j2);
            ++i2;
        }
        int k2 = 0;
        while ((float)k2 < (float)count / 1.5f) {
            double l2 = vec3.d + 3.5 * Math.cos(k2) + world.H_().k() / 2.0;
            double m2 = vec3.e;
            double n2 = vec3.f + 3.5 * Math.sin(k2) + world.H_().k() / 2.0;
            double o2 = world.H_().k() * (double)0.05f;
            double p2 = world.H_().k() * (double)0.05f;
            double q2 = world.H_().k() * (double)0.05f;
            world.a(blockParticleOption, l2, m2, n2, o2, p2, q2);
            ++k2;
        }
    }
}

