/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import io.papermc.paper.util.MCUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockStainedGlass;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends EntityInsentient> Optional<T> a(EntityTypes<T> entityType, EntitySpawnReason reason, WorldServer world, BlockPosition pos, int tries, int horizontalRange, int verticalRange, a requirements) {
        return SpawnUtil.trySpawnMob(entityType, reason, world, pos, tries, horizontalRange, verticalRange, requirements, CreatureSpawnEvent.SpawnReason.DEFAULT, null);
    }

    public static <T extends EntityInsentient> Optional<T> trySpawnMob(EntityTypes<T> entitytypes, EntitySpawnReason entityspawnreason, WorldServer worldserver, BlockPosition blockposition, int i2, int j2, int k2, a spawnutil_a, CreatureSpawnEvent.SpawnReason reason, @Nullable Runnable onAbort) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (int l2 = 0; l2 < i2; ++l2) {
            int i1 = MathHelper.b(worldserver.A, -j2, j2);
            int j1 = MathHelper.b(worldserver.A, -j2, j2);
            blockposition_mutableblockposition.a(blockposition, i1, k2, j1);
            if (!worldserver.F_().a(blockposition_mutableblockposition) || !SpawnUtil.a(worldserver, k2, blockposition_mutableblockposition, spawnutil_a)) continue;
            PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(worldserver, blockposition), CraftEntityType.minecraftToBukkit(entitytypes), reason);
            if (!event.callEvent()) {
                if (!event.shouldAbortSpawn()) break;
                if (onAbort != null) {
                    onAbort.run();
                }
                return Optional.empty();
            }
            EntityInsentient t0 = (EntityInsentient)entitytypes.b(worldserver, null, blockposition_mutableblockposition, entityspawnreason, false, false);
            if (t0 == null) continue;
            if (t0.a((GeneratorAccess)worldserver, entityspawnreason) && t0.a((IWorldReader)worldserver)) {
                worldserver.addFreshEntityWithPassengers(t0, reason);
                return Optional.of(t0);
            }
            t0.discard(null);
        }
        return Optional.empty();
    }

    private static boolean a(WorldServer world, int verticalRange, BlockPosition.MutableBlockPosition pos, a requirements) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition().g(pos);
        IBlockData iblockdata = world.a_(blockposition_mutableblockposition1);
        for (int j2 = verticalRange; j2 >= -verticalRange; --j2) {
            pos.c(EnumDirection.a);
            blockposition_mutableblockposition1.a((BaseBlockPosition)pos, EnumDirection.b);
            IBlockData iblockdata1 = world.a_(pos);
            if (requirements.canSpawnOn(world, pos, iblockdata1, blockposition_mutableblockposition1, iblockdata)) {
                pos.c(EnumDirection.b);
                return true;
            }
            iblockdata = iblockdata1;
        }
        return false;
    }

    public static interface a {
        @Deprecated
        public static final a a = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> !(iblockdata.a(Blocks.bz) || iblockdata.a(Blocks.ed) || iblockdata.a(Blocks.fm) || iblockdata.b() instanceof BlockStainedGlassPane || iblockdata.b() instanceof BlockStainedGlass || iblockdata.b() instanceof BlockLeaves || iblockdata.a(Blocks.ns) || iblockdata.a(Blocks.eb) || iblockdata.a(Blocks.cr) || iblockdata.a(Blocks.ep) || iblockdata.a(Blocks.gc) || iblockdata.a(Blocks.iz) || iblockdata.a(Blocks.ld) || iblockdata.a(Blocks.rj) || iblockdata.a(Blocks.aX)) ? (iblockdata1.l() || iblockdata1.n()) && (iblockdata.e() || iblockdata.a(Blocks.rk)) : false;
        public static final a b = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> iblockdata1.g(worldserver, blockposition1).c() && Block.a(iblockdata.g(worldserver, blockposition), EnumDirection.b);
        public static final a c = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> iblockdata1.g(worldserver, blockposition1).c() && !iblockdata.a(TagsBlock.Q) && Block.a(iblockdata.g(worldserver, blockposition), EnumDirection.b);

        public boolean canSpawnOn(WorldServer var1, BlockPosition var2, IBlockData var3, BlockPosition var4, IBlockData var5);
    }
}

