/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.StringUtils;

public class UtilColor {
    private static final Pattern a = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private static final Pattern b = Pattern.compile("\\r\\n|\\v");
    private static final Pattern c = Pattern.compile("(?:\\r\\n|\\v)$");

    public static String a(int ticks, float tickRate) {
        int i2 = MathHelper.d((float)ticks / tickRate);
        int j2 = i2 / 60;
        int k2 = j2 / 60;
        return k2 > 0 ? String.format(Locale.ROOT, "%02d:%02d:%02d", k2, j2, i2) : String.format(Locale.ROOT, "%02d:%02d", j2 %= 60, i2 %= 60);
    }

    public static String a(String text) {
        return a.matcher(text).replaceAll("");
    }

    public static boolean b(@Nullable String text) {
        return StringUtils.isEmpty((CharSequence)text);
    }

    public static String a(String text, int maxLength, boolean addEllipsis) {
        if (text.length() <= maxLength) {
            return text;
        }
        return addEllipsis && maxLength > 3 ? text.substring(0, maxLength - 3) + "..." : text.substring(0, maxLength);
    }

    public static int c(String text) {
        if (text.isEmpty()) {
            return 0;
        }
        Matcher matcher = b.matcher(text);
        int i2 = 1;
        while (matcher.find()) {
            ++i2;
        }
        return i2;
    }

    public static boolean d(String text) {
        return c.matcher(text).find();
    }

    public static String e(String text) {
        return UtilColor.a(text, 256, false);
    }

    public static boolean a(char c2) {
        return c2 != '\u00a7' && c2 >= ' ' && c2 != '\u007f';
    }

    public static boolean f(String name) {
        return name.length() <= 16 && name.chars().filter(c2 -> c2 <= 32 || c2 >= 127).findAny().isEmpty();
    }

    public static boolean isReasonablePlayerName(String name) {
        if (name.isEmpty() || name.length() > 16) {
            return false;
        }
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    public static String g(String string) {
        return UtilColor.a(string, false);
    }

    public static String a(String string, boolean allowLinebreak) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (UtilColor.a(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            if (!allowLinebreak || c2 != '\n') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean a(int c2) {
        return Character.isWhitespace(c2) || Character.isSpaceChar(c2);
    }

    public static boolean h(@Nullable String string) {
        return string == null || string.isEmpty() || string.chars().allMatch(UtilColor::a);
    }
}

