/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import org.jetbrains.annotations.Contract;

public class ContextMap {
    private final Map<ContextKey<?>, Object> a;

    ContextMap(Map<ContextKey<?>, Object> map) {
        this.a = map;
    }

    public boolean a(ContextKey<?> parameter) {
        return this.a.containsKey(parameter);
    }

    public <T> T b(ContextKey<T> parameter) {
        Object object = this.a.get(parameter);
        if (object == null) {
            throw new NoSuchElementException(parameter.a().toString());
        }
        return (T)object;
    }

    @Nullable
    public <T> T c(ContextKey<T> parameter) {
        return (T)this.a.get(parameter);
    }

    @Nullable
    @Contract(value="_,!null->!null; _,_->_")
    public <T> T a(ContextKey<T> parameter, @Nullable T defaultValue) {
        return (T)this.a.getOrDefault(parameter, defaultValue);
    }

    public static class a {
        private final Map<ContextKey<?>, Object> a = new IdentityHashMap();

        public <T> a a(ContextKey<T> parameter, T value) {
            this.a.put(parameter, value);
            return this;
        }

        public <T> a b(ContextKey<T> parameter, @Nullable T value) {
            if (value == null) {
                this.a.remove(parameter);
            } else {
                this.a.put(parameter, value);
            }
            return this;
        }

        public <T> T a(ContextKey<T> parameter) {
            Object object = this.a.get(parameter);
            if (object == null) {
                throw new NoSuchElementException(parameter.a().toString());
            }
            return (T)object;
        }

        @Nullable
        public <T> T b(ContextKey<T> parameter) {
            return (T)this.a.get(parameter);
        }

        public ContextMap a(ContextKeySet type) {
            Sets.SetView set = Sets.difference(this.a.keySet(), type.b());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf(set));
            }
            Sets.SetView set2 = Sets.difference(type.a(), this.a.keySet());
            if (!set2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(set2));
            }
            return new ContextMap(this.a);
        }
    }
}

