/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class CauldronRenameFix
extends DataFix {
    public CauldronRenameFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private static Dynamic<?> a(Dynamic<?> cauldronDynamic) {
        Optional optional = cauldronDynamic.get("Name").asString().result();
        if (optional.equals(Optional.of("minecraft:cauldron"))) {
            Dynamic dynamic = cauldronDynamic.get("Properties").orElseEmptyMap();
            if (dynamic.get("level").asString("0").equals("0")) {
                return cauldronDynamic.remove("Properties");
            }
            return cauldronDynamic.set("Name", cauldronDynamic.createString("minecraft:water_cauldron"));
        }
        return cauldronDynamic;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("cauldron_rename_fix", this.getInputSchema().getType(DataConverterTypes.u), typed -> typed.update(DSL.remainderFinder(), CauldronRenameFix::a));
    }
}

