/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryID;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class ChunkConverterPalette
extends DataFix {
    private static final int a = 128;
    private static final int b = 64;
    private static final int c = 32;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 4;
    private static final int g = 2;
    private static final int h = 1;
    static final Logger i = LogUtils.getLogger();
    private static final int j = 4096;

    public ChunkConverterPalette(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public static String a(Dynamic<?> dynamic) {
        return dynamic.get("Name").asString("");
    }

    public static String a(Dynamic<?> dynamic, String propertyKey) {
        return dynamic.get("Properties").get(propertyKey).asString("");
    }

    public static int a(RegistryID<Dynamic<?>> crudeIncrementalIntIdentityHashBiMap, Dynamic<?> dynamic) {
        int i2 = crudeIncrementalIntIdentityHashBiMap.a(dynamic);
        if (i2 == -1) {
            i2 = crudeIncrementalIntIdentityHashBiMap.d(dynamic);
        }
        return i2;
    }

    private Dynamic<?> b(Dynamic<?> chunkDynamic) {
        Optional optional = chunkDynamic.get("Level").result();
        if (optional.isPresent() && ((Dynamic)((Object)optional.get())).get("Sections").asStreamOpt().result().isPresent()) {
            return chunkDynamic.set("Level", new e((Dynamic)((Object)optional.get())).a());
        }
        return chunkDynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.c);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type2, this::b);
    }

    public static int a(boolean west, boolean east, boolean north, boolean south) {
        int i2 = 0;
        if (north) {
            i2 = east ? (i2 |= 2) : (west ? (i2 |= 0x80) : (i2 |= 1));
        } else if (south) {
            i2 = west ? (i2 |= 0x20) : (east ? (i2 |= 8) : (i2 |= 0x10));
        } else if (east) {
            i2 |= 4;
        } else if (west) {
            i2 |= 0x40;
        }
        return i2;
    }

    static final class e {
        private int a;
        private final d[] b = new d[16];
        private final Dynamic<?> c;
        private final int d;
        private final int e;
        private final Int2ObjectMap<Dynamic<?>> f = new Int2ObjectLinkedOpenHashMap(16);

        public e(Dynamic<?> chunkTag) {
            this.c = chunkTag;
            this.d = chunkTag.get("xPos").asInt(0) << 4;
            this.e = chunkTag.get("zPos").asInt(0) << 4;
            chunkTag.get("TileEntities").asStreamOpt().ifSuccess(stream -> stream.forEach(blockEntityTag -> {
                int k2;
                int i2 = blockEntityTag.get("x").asInt(0) - this.d & 0xF;
                int j2 = blockEntityTag.get("y").asInt(0);
                int l2 = j2 << 8 | (k2 = blockEntityTag.get("z").asInt(0) - this.e & 0xF) << 4 | i2;
                if (this.f.put(l2, (Object)blockEntityTag) != null) {
                    i.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.d, this.e, i2, j2, k2});
                }
            }));
            boolean bl = chunkTag.get("convertedFromAlphaFormat").asBoolean(false);
            chunkTag.get("Sections").asStreamOpt().ifSuccess(stream -> stream.forEach(sectionTag -> {
                d section = new d((Dynamic<?>)((Object)((Object)sectionTag)));
                this.a = section.b(this.a);
                this.b[section.a] = section;
            }));
            for (d section : this.b) {
                if (section == null) continue;
                block30: for (Int2ObjectMap.Entry entry : section.f.int2ObjectEntrySet()) {
                    int i2 = section.a << 12;
                    switch (entry.getIntKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string;
                                int j2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic = this.a(j2 |= i2);
                                if (!"minecraft:grass_block".equals(ChunkConverterPalette.a(dynamic)) || !"minecraft:snow".equals(string = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(j2, Direction.b)))) && !"minecraft:snow_layer".equals(string)) continue;
                                this.a(j2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.e);
                            }
                            continue block30;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string2;
                                int k2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic2 = this.a(k2 |= i2);
                                if (!"minecraft:podzol".equals(ChunkConverterPalette.a(dynamic2)) || !"minecraft:snow".equals(string2 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(k2, Direction.b)))) && !"minecraft:snow_layer".equals(string2)) continue;
                                this.a(k2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.d);
                            }
                            continue block30;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string3;
                                int l2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic3 = this.a(l2 |= i2);
                                if (!"minecraft:mycelium".equals(ChunkConverterPalette.a(dynamic3)) || !"minecraft:snow".equals(string3 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(l2, Direction.b)))) && !"minecraft:snow_layer".equals(string3)) continue;
                                this.a(l2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.f);
                            }
                            continue block30;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int m2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic4 = this.c(m2 |= i2);
                                if (dynamic4 == null) continue;
                                String string4 = Boolean.toString(dynamic4.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(dynamic4.get("note").asInt(0), 0), 24);
                                this.a(m2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.getOrDefault(string4, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.get("false0")));
                            }
                            continue block30;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string5;
                                int o2;
                                int n2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic5 = this.b(n2 |= i2);
                                Dynamic<?> dynamic6 = this.a(n2);
                                if (dynamic5 == null || (o2 = dynamic5.get("color").asInt(0)) == 14 || o2 < 0 || o2 >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.containsKey(string5 = ChunkConverterPalette.a(dynamic6, "facing") + ChunkConverterPalette.a(dynamic6, "occupied") + ChunkConverterPalette.a(dynamic6, "part") + o2)) continue;
                                this.a(n2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.get(string5));
                            }
                            continue block30;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string6;
                                int q2;
                                int p2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic7 = this.b(p2 |= i2);
                                Dynamic<?> dynamic8 = this.a(p2);
                                if (dynamic7 == null || (q2 = dynamic7.get("Base").asInt(0)) == 15 || q2 < 0 || q2 >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.containsKey(string6 = ChunkConverterPalette.a(dynamic8, entry.getIntKey() == 176 ? "rotation" : "facing") + "_" + q2)) continue;
                                this.a(p2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.get(string6));
                            }
                            continue block30;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string7;
                                int r2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic9 = this.a(r2 |= i2);
                                if (!"minecraft:carved_pumpkin".equals(ChunkConverterPalette.a(dynamic9)) || !"minecraft:grass_block".equals(string7 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(r2, Direction.a)))) && !"minecraft:dirt".equals(string7)) continue;
                                this.a(r2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.c);
                            }
                            continue block30;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int s2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic10 = this.c(s2 |= i2);
                                if (dynamic10 == null) continue;
                                String string8 = dynamic10.get("Item").asString("") + dynamic10.get("Data").asInt(0);
                                this.a(s2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.getOrDefault(string8, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.get("minecraft:air0")));
                            }
                            continue block30;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string12;
                                int t2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic11 = this.b(t2 |= i2);
                                if (dynamic11 == null) continue;
                                String string9 = String.valueOf(dynamic11.get("SkullType").asInt(0));
                                String string10 = ChunkConverterPalette.a(this.a(t2), "facing");
                                if ("up".equals(string10) || "down".equals(string10)) {
                                    String string11 = string9 + String.valueOf(dynamic11.get("Rot").asInt(0));
                                } else {
                                    string12 = string9 + string10;
                                }
                                dynamic11.remove("SkullType");
                                dynamic11.remove("facing");
                                dynamic11.remove("Rot");
                                this.a(t2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.getOrDefault(string12, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.get("0north")));
                            }
                            continue block30;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> dynamic13;
                                int u2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic12 = this.a(u2 |= i2);
                                if (!ChunkConverterPalette.a(dynamic12).endsWith("_door") || !"lower".equals(ChunkConverterPalette.a(dynamic13 = this.a(u2), "half"))) continue;
                                int v2 = net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(u2, Direction.b);
                                Dynamic<?> dynamic14 = this.a(v2);
                                String string13 = ChunkConverterPalette.a(dynamic13);
                                if (!string13.equals(ChunkConverterPalette.a(dynamic14))) continue;
                                String string14 = ChunkConverterPalette.a(dynamic13, "facing");
                                String string15 = ChunkConverterPalette.a(dynamic13, "open");
                                String string16 = bl ? "left" : ChunkConverterPalette.a(dynamic14, "hinge");
                                String string17 = bl ? "false" : ChunkConverterPalette.a(dynamic14, "powered");
                                this.a(u2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(string13 + string14 + "lower" + string16 + string15 + string17));
                                this.a(v2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(string13 + string14 + "upper" + string16 + string15 + string17));
                            }
                            continue block30;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string18;
                                int w2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic15 = this.a(w2 |= i2);
                                if (!"upper".equals(ChunkConverterPalette.a(dynamic15, "half"))) continue;
                                Dynamic<?> dynamic16 = this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(w2, Direction.a));
                                switch (string18 = ChunkConverterPalette.a(dynamic16)) {
                                    case "minecraft:sunflower": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.g);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.h);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.i);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.j);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.k);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.a(w2, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.l);
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> b(int packedLocalPos) {
            return (Dynamic)((Object)this.f.get(packedLocalPos));
        }

        @Nullable
        private Dynamic<?> c(int packedLocalPos) {
            return (Dynamic)((Object)this.f.remove(packedLocalPos));
        }

        public static int a(int packedLocalPos, Direction direction) {
            return switch (direction.b().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int i = (packedLocalPos & 0xF) + direction.a().a();
                    if (i < 0 || i > 15) {
                        yield -1;
                    }
                    yield packedLocalPos & 0xFFFFFFF0 | i;
                }
                case 1 -> {
                    int j = (packedLocalPos >> 8) + direction.a().a();
                    if (j < 0 || j > 255) {
                        yield -1;
                    }
                    yield packedLocalPos & 0xFF | j << 8;
                }
                case 2 -> {
                    int k = (packedLocalPos >> 4 & 0xF) + direction.a().a();
                    if (k < 0 || k > 15) {
                        yield -1;
                    }
                    yield packedLocalPos & 0xFFFFFF0F | k << 4;
                }
            };
        }

        private void a(int packedLocalPos, Dynamic<?> dynamic) {
            if (packedLocalPos < 0 || packedLocalPos > 65535) {
                return;
            }
            d section = this.d(packedLocalPos);
            if (section == null) {
                return;
            }
            section.a(packedLocalPos & 0xFFF, dynamic);
        }

        @Nullable
        private d d(int packedLocalPos) {
            int i2 = packedLocalPos >> 12;
            return i2 < this.b.length ? this.b[i2] : null;
        }

        public Dynamic<?> a(int packedLocalPos) {
            if (packedLocalPos < 0 || packedLocalPos > 65535) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            d section = this.d(packedLocalPos);
            if (section == null) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            return section.a(packedLocalPos & 0xFFF);
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.c;
            dynamic = this.f.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.f.values().stream()));
            Dynamic dynamic2 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (d section : this.b) {
                if (section == null) continue;
                list.add(section.a());
                dynamic2 = dynamic2.set(String.valueOf(section.a), dynamic2.createIntList(Arrays.stream(section.g.toIntArray())));
            }
            Dynamic dynamic3 = dynamic.emptyMap();
            dynamic3 = dynamic3.set("Sides", dynamic3.createByte((byte)this.a));
            dynamic3 = dynamic3.set("Indices", dynamic2);
            return dynamic.set("UpgradeData", dynamic3).set("Sections", dynamic3.createList(list.stream()));
        }
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction a = new Direction(AxisDirection.b, Axis.b);
        public static final /* enum */ Direction b = new Direction(AxisDirection.a, Axis.b);
        public static final /* enum */ Direction c = new Direction(AxisDirection.b, Axis.c);
        public static final /* enum */ Direction d = new Direction(AxisDirection.a, Axis.c);
        public static final /* enum */ Direction e = new Direction(AxisDirection.b, Axis.a);
        public static final /* enum */ Direction f = new Direction(AxisDirection.a, Axis.a);
        private final Axis g;
        private final AxisDirection h;
        private static final /* synthetic */ Direction[] i;

        public static Direction[] values() {
            return (Direction[])i.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }

        private Direction(AxisDirection direction, Axis axis) {
            this.g = axis;
            this.h = direction;
        }

        public AxisDirection a() {
            return this.h;
        }

        public Axis b() {
            return this.g;
        }

        private static /* synthetic */ Direction[] c() {
            return new Direction[]{a, b, c, d, e, f};
        }

        static {
            i = Direction.c();
        }

        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis a = new Axis();
            public static final /* enum */ Axis b = new Axis();
            public static final /* enum */ Axis c = new Axis();
            private static final /* synthetic */ Axis[] d;

            public static Axis[] values() {
                return (Axis[])d.clone();
            }

            public static Axis valueOf(String string) {
                return Enum.valueOf(Axis.class, string);
            }

            private static /* synthetic */ Axis[] a() {
                return new Axis[]{a, b, c};
            }

            static {
                d = Axis.a();
            }
        }

        public static final class AxisDirection
        extends Enum<AxisDirection> {
            public static final /* enum */ AxisDirection a = new AxisDirection(1);
            public static final /* enum */ AxisDirection b = new AxisDirection(-1);
            private final int c;
            private static final /* synthetic */ AxisDirection[] d;

            public static AxisDirection[] values() {
                return (AxisDirection[])d.clone();
            }

            public static AxisDirection valueOf(String string) {
                return Enum.valueOf(AxisDirection.class, string);
            }

            private AxisDirection(int offset) {
                this.c = offset;
            }

            public int a() {
                return this.c;
            }

            private static /* synthetic */ AxisDirection[] b() {
                return new AxisDirection[]{a, b};
            }

            static {
                d = AxisDirection.b();
            }
        }
    }

    static class a {
        private static final int a = 2048;
        private static final int b = 4;
        private final byte[] c;

        public a() {
            this.c = new byte[2048];
        }

        public a(byte[] contents) {
            this.c = contents;
            if (contents.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + contents.length);
            }
        }

        public int a(int x2, int y2, int z2) {
            int i2 = this.b(y2 << 8 | z2 << 4 | x2);
            if (this.a(y2 << 8 | z2 << 4 | x2)) {
                return this.c[i2] & 0xF;
            }
            return this.c[i2] >> 4 & 0xF;
        }

        private boolean a(int index) {
            return (index & 1) == 0;
        }

        private int b(int index) {
            return index >> 1;
        }
    }

    static class d {
        private final RegistryID<Dynamic<?>> b = RegistryID.c(32);
        private final List<Dynamic<?>> c;
        private final Dynamic<?> d;
        private final boolean e;
        final Int2ObjectMap<IntList> f = new Int2ObjectLinkedOpenHashMap();
        final IntList g = new IntArrayList();
        public final int a;
        private final Set<Dynamic<?>> h = Sets.newIdentityHashSet();
        private final int[] i = new int[4096];

        public d(Dynamic<?> section) {
            this.c = Lists.newArrayList();
            this.d = section;
            this.a = section.get("Y").asInt(0);
            this.e = section.get("Blocks").result().isPresent();
        }

        public Dynamic<?> a(int index) {
            if (index < 0 || index > 4095) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            Dynamic<?> dynamic = this.b.a(this.i[index]);
            return dynamic == null ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : dynamic;
        }

        public void a(int pos, Dynamic<?> dynamic) {
            if (this.h.add(dynamic)) {
                this.c.add("%%FILTER_ME%%".equals(ChunkConverterPalette.a(dynamic)) ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : dynamic);
            }
            this.i[pos] = ChunkConverterPalette.a(this.b, dynamic);
        }

        public int b(int sidesToUpgrade) {
            if (!this.e) {
                return sidesToUpgrade;
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)this.d.get("Blocks").asByteBufferOpt().result().get();
            a dataLayer = this.d.get("Data").asByteBufferOpt().map(byteBuffer -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(a::new);
            a dataLayer2 = this.d.get("Add").asByteBufferOpt().map(byteBuffer -> new a(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(a::new);
            this.h.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            ChunkConverterPalette.a(this.b, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            this.c.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            for (int i2 = 0; i2 < 4096; ++i2) {
                int j2 = i2 & 0xF;
                int k2 = i2 >> 8 & 0xF;
                int l2 = i2 >> 4 & 0xF;
                int m2 = dataLayer2.a(j2, k2, l2) << 12 | (byteBuffer2.get(i2) & 0xFF) << 4 | dataLayer.a(j2, k2, l2);
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b.get(m2 >> 4)) {
                    this.a(m2 >> 4, i2);
                }
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a.get(m2 >> 4)) {
                    int n2 = ChunkConverterPalette.a(j2 == 0, j2 == 15, l2 == 0, l2 == 15);
                    if (n2 == 0) {
                        this.g.add(i2);
                    } else {
                        sidesToUpgrade |= n2;
                    }
                }
                this.a(i2, DataConverterFlattenData.b(m2));
            }
            return sidesToUpgrade;
        }

        private void a(int section, int index) {
            IntList intList = (IntList)this.f.get(section);
            if (intList == null) {
                intList = new IntArrayList();
                this.f.put(section, (Object)intList);
            }
            intList.add(index);
        }

        public Dynamic<?> a() {
            Dynamic<?> dynamic = this.d;
            if (!this.e) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.c.stream()));
            int i2 = Math.max(4, DataFixUtils.ceillog2((int)this.h.size()));
            DataBitsPacked packedBitStorage = new DataBitsPacked(i2, 4096);
            for (int j2 = 0; j2 < this.i.length; ++j2) {
                packedBitStorage.a(j2, this.i[j2]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(packedBitStorage.a())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            dynamic = dynamic.remove("Add");
            return dynamic;
        }
    }

    static class c {
        static final BitSet a = new BitSet(256);
        static final BitSet b = new BitSet(256);
        static final Dynamic<?> c = ExtraDataFixUtils.a("minecraft:pumpkin");
        static final Dynamic<?> d = ExtraDataFixUtils.a("minecraft:podzol", Map.of("snowy", "true"));
        static final Dynamic<?> e = ExtraDataFixUtils.a("minecraft:grass_block", Map.of("snowy", "true"));
        static final Dynamic<?> f = ExtraDataFixUtils.a("minecraft:mycelium", Map.of("snowy", "true"));
        static final Dynamic<?> g = ExtraDataFixUtils.a("minecraft:sunflower", Map.of("half", "upper"));
        static final Dynamic<?> h = ExtraDataFixUtils.a("minecraft:lilac", Map.of("half", "upper"));
        static final Dynamic<?> i = ExtraDataFixUtils.a("minecraft:tall_grass", Map.of("half", "upper"));
        static final Dynamic<?> j = ExtraDataFixUtils.a("minecraft:large_fern", Map.of("half", "upper"));
        static final Dynamic<?> k = ExtraDataFixUtils.a("minecraft:rose_bush", Map.of("half", "upper"));
        static final Dynamic<?> l = ExtraDataFixUtils.a("minecraft:peony", Map.of("half", "upper"));
        static final Map<String, Dynamic<?>> m = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            map.put("minecraft:air0", ExtraDataFixUtils.a("minecraft:flower_pot"));
            map.put("minecraft:red_flower0", ExtraDataFixUtils.a("minecraft:potted_poppy"));
            map.put("minecraft:red_flower1", ExtraDataFixUtils.a("minecraft:potted_blue_orchid"));
            map.put("minecraft:red_flower2", ExtraDataFixUtils.a("minecraft:potted_allium"));
            map.put("minecraft:red_flower3", ExtraDataFixUtils.a("minecraft:potted_azure_bluet"));
            map.put("minecraft:red_flower4", ExtraDataFixUtils.a("minecraft:potted_red_tulip"));
            map.put("minecraft:red_flower5", ExtraDataFixUtils.a("minecraft:potted_orange_tulip"));
            map.put("minecraft:red_flower6", ExtraDataFixUtils.a("minecraft:potted_white_tulip"));
            map.put("minecraft:red_flower7", ExtraDataFixUtils.a("minecraft:potted_pink_tulip"));
            map.put("minecraft:red_flower8", ExtraDataFixUtils.a("minecraft:potted_oxeye_daisy"));
            map.put("minecraft:yellow_flower0", ExtraDataFixUtils.a("minecraft:potted_dandelion"));
            map.put("minecraft:sapling0", ExtraDataFixUtils.a("minecraft:potted_oak_sapling"));
            map.put("minecraft:sapling1", ExtraDataFixUtils.a("minecraft:potted_spruce_sapling"));
            map.put("minecraft:sapling2", ExtraDataFixUtils.a("minecraft:potted_birch_sapling"));
            map.put("minecraft:sapling3", ExtraDataFixUtils.a("minecraft:potted_jungle_sapling"));
            map.put("minecraft:sapling4", ExtraDataFixUtils.a("minecraft:potted_acacia_sapling"));
            map.put("minecraft:sapling5", ExtraDataFixUtils.a("minecraft:potted_dark_oak_sapling"));
            map.put("minecraft:red_mushroom0", ExtraDataFixUtils.a("minecraft:potted_red_mushroom"));
            map.put("minecraft:brown_mushroom0", ExtraDataFixUtils.a("minecraft:potted_brown_mushroom"));
            map.put("minecraft:deadbush0", ExtraDataFixUtils.a("minecraft:potted_dead_bush"));
            map.put("minecraft:tallgrass2", ExtraDataFixUtils.a("minecraft:potted_fern"));
            map.put("minecraft:cactus0", ExtraDataFixUtils.a("minecraft:potted_cactus"));
        });
        static final Map<String, Dynamic<?>> n = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 0, "skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 1, "wither_skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 2, "zombie", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 3, "player", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 4, "creeper", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, 5, "dragon", "head");
        });
        static final Map<String, Dynamic<?>> o = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "oak_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "iron_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "spruce_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "birch_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "jungle_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "acacia_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, "dark_oak_door");
        });
        static final Map<String, Dynamic<?>> p = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (int i2 = 0; i2 < 26; ++i2) {
                map.put("true" + i2, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "true", "note", String.valueOf(i2))));
                map.put("false" + i2, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "false", "note", String.valueOf(i2))));
            }
        });
        private static final Int2ObjectMap<String> q = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), map -> {
            map.put(0, (Object)"white");
            map.put(1, (Object)"orange");
            map.put(2, (Object)"magenta");
            map.put(3, (Object)"light_blue");
            map.put(4, (Object)"yellow");
            map.put(5, (Object)"lime");
            map.put(6, (Object)"pink");
            map.put(7, (Object)"gray");
            map.put(8, (Object)"light_gray");
            map.put(9, (Object)"cyan");
            map.put(10, (Object)"purple");
            map.put(11, (Object)"blue");
            map.put(12, (Object)"brown");
            map.put(13, (Object)"green");
            map.put(14, (Object)"red");
            map.put(15, (Object)"black");
        });
        static final Map<String, Dynamic<?>> r = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (Int2ObjectMap.Entry entry : q.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "red")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(map, entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Map<String, Dynamic<?>> s = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
            for (Int2ObjectMap.Entry entry : q.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "white")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b(map, 15 - entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Dynamic<?> t;

        private c() {
        }

        private static void a(Map<String, Dynamic<?>> map, int id, String entity, String type) {
            map.put(id + "north", ExtraDataFixUtils.a("minecraft:" + entity + "_wall_" + type, Map.of("facing", "north")));
            map.put(id + "east", ExtraDataFixUtils.a("minecraft:" + entity + "_wall_" + type, Map.of("facing", "east")));
            map.put(id + "south", ExtraDataFixUtils.a("minecraft:" + entity + "_wall_" + type, Map.of("facing", "south")));
            map.put(id + "west", ExtraDataFixUtils.a("minecraft:" + entity + "_wall_" + type, Map.of("facing", "west")));
            for (int i2 = 0; i2 < 16; ++i2) {
                map.put("" + id + i2, ExtraDataFixUtils.a("minecraft:" + entity + "_" + type, Map.of("rotation", String.valueOf(i2))));
            }
        }

        private static void a(Map<String, Dynamic<?>> map, String id) {
            String string = "minecraft:" + id;
            map.put("minecraft:" + id + "eastlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "eastlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "eastlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "eastlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "eastlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "eastlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "eastlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "eastlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "eastupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "eastupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "eastupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "eastupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "eastupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "eastupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "eastupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "eastupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "northlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "northlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "northlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "northlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "northlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "northlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "northlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "northlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "northupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "northupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "northupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "northupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "northupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "northupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "northupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "northupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "southlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "southlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "southlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "southlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "southlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "southlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "southlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "southlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "southupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "southupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "southupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "southupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "southupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "southupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "southupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "southupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "westlowerleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "westlowerleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "westlowerlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "westlowerlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "westlowerrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "westlowerrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "westlowerrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "westlowerrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "westupperleftfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "westupperleftfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "westupperlefttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "westupperlefttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            map.put("minecraft:" + id + "westupperrightfalsefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            map.put("minecraft:" + id + "westupperrightfalsetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            map.put("minecraft:" + id + "westupperrighttruefalse", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            map.put("minecraft:" + id + "westupperrighttruetrue", ExtraDataFixUtils.a(string, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
        }

        private static void a(Map<String, Dynamic<?>> map, int id, String color) {
            map.put("southfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "south", "occupied", "false", "part", "foot")));
            map.put("westfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "west", "occupied", "false", "part", "foot")));
            map.put("northfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "north", "occupied", "false", "part", "foot")));
            map.put("eastfalsefoot" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "east", "occupied", "false", "part", "foot")));
            map.put("southfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "south", "occupied", "false", "part", "head")));
            map.put("westfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "west", "occupied", "false", "part", "head")));
            map.put("northfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "north", "occupied", "false", "part", "head")));
            map.put("eastfalsehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "east", "occupied", "false", "part", "head")));
            map.put("southtruehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "south", "occupied", "true", "part", "head")));
            map.put("westtruehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "west", "occupied", "true", "part", "head")));
            map.put("northtruehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "north", "occupied", "true", "part", "head")));
            map.put("easttruehead" + id, ExtraDataFixUtils.a("minecraft:" + color + "_bed", Map.of("facing", "east", "occupied", "true", "part", "head")));
        }

        private static void b(Map<String, Dynamic<?>> map, int id, String color) {
            for (int i2 = 0; i2 < 16; ++i2) {
                map.put(i2 + "_" + id, ExtraDataFixUtils.a("minecraft:" + color + "_banner", Map.of("rotation", String.valueOf(i2))));
            }
            map.put("north_" + id, ExtraDataFixUtils.a("minecraft:" + color + "_wall_banner", Map.of("facing", "north")));
            map.put("south_" + id, ExtraDataFixUtils.a("minecraft:" + color + "_wall_banner", Map.of("facing", "south")));
            map.put("west_" + id, ExtraDataFixUtils.a("minecraft:" + color + "_wall_banner", Map.of("facing", "west")));
            map.put("east_" + id, ExtraDataFixUtils.a("minecraft:" + color + "_wall_banner", Map.of("facing", "east")));
        }

        static {
            b.set(2);
            b.set(3);
            b.set(110);
            b.set(140);
            b.set(144);
            b.set(25);
            b.set(86);
            b.set(26);
            b.set(176);
            b.set(177);
            b.set(175);
            b.set(64);
            b.set(71);
            b.set(193);
            b.set(194);
            b.set(195);
            b.set(196);
            b.set(197);
            a.set(54);
            a.set(146);
            a.set(25);
            a.set(26);
            a.set(51);
            a.set(53);
            a.set(67);
            a.set(108);
            a.set(109);
            a.set(114);
            a.set(128);
            a.set(134);
            a.set(135);
            a.set(136);
            a.set(156);
            a.set(163);
            a.set(164);
            a.set(180);
            a.set(203);
            a.set(55);
            a.set(85);
            a.set(113);
            a.set(188);
            a.set(189);
            a.set(190);
            a.set(191);
            a.set(192);
            a.set(93);
            a.set(94);
            a.set(101);
            a.set(102);
            a.set(160);
            a.set(106);
            a.set(107);
            a.set(183);
            a.set(184);
            a.set(185);
            a.set(186);
            a.set(187);
            a.set(132);
            a.set(139);
            a.set(199);
            t = ExtraDataFixUtils.a("minecraft:air");
        }
    }
}

