/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class DataConverterWorldGenSettingsBuilding
extends DataFix {
    private static final String a = "minecraft:village";
    private static final String b = "minecraft:desert_pyramid";
    private static final String c = "minecraft:igloo";
    private static final String d = "minecraft:jungle_pyramid";
    private static final String e = "minecraft:swamp_hut";
    private static final String f = "minecraft:pillager_outpost";
    private static final String g = "minecraft:endcity";
    private static final String h = "minecraft:mansion";
    private static final String i = "minecraft:monument";
    private static final ImmutableMap<String, a> j = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new a(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new a(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new a(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new a(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new a(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new a(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new a(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new a(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new a(80, 20, 10387319)).build();

    public DataConverterWorldGenSettingsBuilding(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(DataConverterTypes.M), worldGenSettingsTyped -> worldGenSettingsTyped.update(DSL.remainderFinder(), DataConverterWorldGenSettingsBuilding::a));
    }

    private static <T> Dynamic<T> a(long seed, DynamicLike<T> worldGenSettingsDynamic, Dynamic<T> settingsDynamic, Dynamic<T> biomeSourceDynamic) {
        return worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:noise")), (Object)((Object)worldGenSettingsDynamic.createString("biome_source")), biomeSourceDynamic, (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed)), (Object)((Object)worldGenSettingsDynamic.createString("settings")), settingsDynamic));
    }

    private static <T> Dynamic<T> a(Dynamic<T> worldGenSettingsDynamic, long seed, boolean legacyBiomeInitLayer, boolean largeBiomes) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)worldGenSettingsDynamic.createString("type"), (Object)worldGenSettingsDynamic.createString("minecraft:vanilla_layered")).put((Object)worldGenSettingsDynamic.createString("seed"), (Object)worldGenSettingsDynamic.createLong(seed)).put((Object)worldGenSettingsDynamic.createString("large_biomes"), (Object)worldGenSettingsDynamic.createBoolean(largeBiomes));
        if (legacyBiomeInitLayer) {
            builder.put((Object)worldGenSettingsDynamic.createString("legacy_biome_init_layer"), (Object)worldGenSettingsDynamic.createBoolean(legacyBiomeInitLayer));
        }
        return worldGenSettingsDynamic.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> a(Dynamic<T> worldGenSettingsDynamic) {
        Dynamic<T> dynamic12;
        DynamicOps dynamicOps = worldGenSettingsDynamic.getOps();
        long l2 = worldGenSettingsDynamic.get("RandomSeed").asLong(0L);
        Optional optional = worldGenSettingsDynamic.get("generatorName").asString().map(generatorName -> generatorName.toLowerCase(Locale.ROOT)).result();
        Optional optional2 = worldGenSettingsDynamic.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> {
            if (optional.equals(Optional.of("customized"))) {
                return worldGenSettingsDynamic.get("generatorOptions").asString().result();
            }
            return Optional.empty();
        });
        boolean bl = false;
        if (optional.equals(Optional.of("customized"))) {
            Dynamic<T> dynamic = DataConverterWorldGenSettingsBuilding.a(worldGenSettingsDynamic, l2);
        } else if (optional.isEmpty()) {
            Dynamic<T> dynamic2 = DataConverterWorldGenSettingsBuilding.a(worldGenSettingsDynamic, l2);
        } else {
            switch ((String)optional.get()) {
                case "flat": {
                    OptionalDynamic<T> optionalDynamic = worldGenSettingsDynamic.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> map = DataConverterWorldGenSettingsBuilding.a(dynamicOps, optionalDynamic);
                    Dynamic dynamic3 = worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:flat")), (Object)((Object)worldGenSettingsDynamic.createString("settings")), (Object)((Object)worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("structures")), (Object)((Object)worldGenSettingsDynamic.createMap(map)), (Object)((Object)worldGenSettingsDynamic.createString("layers")), (Object)((Object)optionalDynamic.get("layers").result().orElseGet(() -> worldGenSettingsDynamic.createList(Stream.of(worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(1)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:bedrock")))), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(2)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:dirt")))), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("height")), (Object)((Object)worldGenSettingsDynamic.createInt(1)), (Object)((Object)worldGenSettingsDynamic.createString("block")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:grass_block")))))))), (Object)((Object)worldGenSettingsDynamic.createString("biome")), (Object)((Object)worldGenSettingsDynamic.createString(optionalDynamic.get("biome").asString("minecraft:plains"))))))));
                    break;
                }
                case "debug_all_block_states": {
                    Dynamic dynamic4 = worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:debug"))));
                    break;
                }
                case "buffet": {
                    Dynamic dynamic10;
                    Dynamic dynamic7;
                    OptionalDynamic<T> optionalDynamic2 = worldGenSettingsDynamic.get("generatorOptions");
                    OptionalDynamic optionalDynamic3 = optionalDynamic2.get("chunk_generator");
                    Optional optional3 = optionalDynamic3.get("type").asString().result();
                    if (Objects.equals(optional3, Optional.of("minecraft:caves"))) {
                        Dynamic dynamic5 = worldGenSettingsDynamic.createString("minecraft:caves");
                        bl = true;
                    } else if (Objects.equals(optional3, Optional.of("minecraft:floating_islands"))) {
                        Dynamic dynamic6 = worldGenSettingsDynamic.createString("minecraft:floating_islands");
                    } else {
                        dynamic7 = worldGenSettingsDynamic.createString("minecraft:overworld");
                    }
                    Dynamic dynamic8 = optionalDynamic2.get("biome_source").result().orElseGet(() -> worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:fixed")))));
                    if (dynamic8.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String string = dynamic8.get("options").get("biomes").asStream().findFirst().flatMap(biomeDynamic -> biomeDynamic.asString().result()).orElse("minecraft:ocean");
                        Dynamic dynamic9 = dynamic8.remove("options").set("biome", worldGenSettingsDynamic.createString(string));
                    } else {
                        dynamic10 = dynamic8;
                    }
                    Dynamic<T> dynamic11 = DataConverterWorldGenSettingsBuilding.a(l2, worldGenSettingsDynamic, dynamic7, dynamic10);
                    break;
                }
                default: {
                    boolean bl2 = ((String)optional.get()).equals("default");
                    boolean bl3 = ((String)optional.get()).equals("default_1_1") || bl2 && worldGenSettingsDynamic.get("generatorVersion").asInt(0) == 0;
                    boolean bl4 = ((String)optional.get()).equals("amplified");
                    boolean bl5 = ((String)optional.get()).equals("largebiomes");
                    dynamic12 = DataConverterWorldGenSettingsBuilding.a(l2, worldGenSettingsDynamic, worldGenSettingsDynamic.createString(bl4 ? "minecraft:amplified" : "minecraft:overworld"), DataConverterWorldGenSettingsBuilding.a(worldGenSettingsDynamic, l2, bl3, bl5));
                }
            }
        }
        boolean bl6 = worldGenSettingsDynamic.get("MapFeatures").asBoolean(true);
        boolean bl7 = worldGenSettingsDynamic.get("BonusChest").asBoolean(false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(dynamicOps.createString("seed"), dynamicOps.createLong(l2));
        builder.put(dynamicOps.createString("generate_features"), dynamicOps.createBoolean(bl6));
        builder.put(dynamicOps.createString("bonus_chest"), dynamicOps.createBoolean(bl7));
        builder.put(dynamicOps.createString("dimensions"), DataConverterWorldGenSettingsBuilding.a(worldGenSettingsDynamic, l2, dynamic12, bl));
        optional2.ifPresent(legacyCustomOptions -> builder.put(dynamicOps.createString("legacy_custom_options"), dynamicOps.createString(legacyCustomOptions)));
        return new Dynamic<Object>(dynamicOps, dynamicOps.createMap((Map)builder.build()));
    }

    protected static <T> Dynamic<T> a(Dynamic<T> worldGenSettingsDynamic, long seed) {
        return DataConverterWorldGenSettingsBuilding.a(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:overworld"), DataConverterWorldGenSettingsBuilding.a(worldGenSettingsDynamic, seed, false, false));
    }

    protected static <T> T a(Dynamic<T> worldGenSettingsDynamic, long seed, Dynamic<T> generatorSettingsDynamic, boolean caves) {
        DynamicOps dynamicOps = worldGenSettingsDynamic.getOps();
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("minecraft:overworld"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:overworld" + (caves ? "_caves" : "")), (Object)dynamicOps.createString("generator"), generatorSettingsDynamic.getValue())), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createString("generator"), DataConverterWorldGenSettingsBuilding.a(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:nether"), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:multi_noise")), (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed)), (Object)((Object)worldGenSettingsDynamic.createString("preset")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:nether"))))).getValue())), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createString("generator"), DataConverterWorldGenSettingsBuilding.a(seed, worldGenSettingsDynamic, worldGenSettingsDynamic.createString("minecraft:end"), worldGenSettingsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)worldGenSettingsDynamic.createString("type")), (Object)((Object)worldGenSettingsDynamic.createString("minecraft:the_end")), (Object)((Object)worldGenSettingsDynamic.createString("seed")), (Object)((Object)worldGenSettingsDynamic.createLong(seed))))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> a(DynamicOps<T> worldGenSettingsDynamicOps, OptionalDynamic<T> generatorOptionsDynamic) {
        MutableInt mutableInt = new MutableInt(32);
        MutableInt mutableInt2 = new MutableInt(3);
        MutableInt mutableInt3 = new MutableInt(128);
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HashMap map = Maps.newHashMap();
        if (generatorOptionsDynamic.result().isEmpty()) {
            mutableBoolean.setTrue();
            map.put(a, (a)j.get((Object)a));
        }
        generatorOptionsDynamic.get("structures").flatMap(Dynamic::getMapValues).ifSuccess(map2 -> map2.forEach((oldStructureName, dynamic) -> dynamic.getMapValues().result().ifPresent(map2 -> map2.forEach((propertyName, spacing) -> {
            String string = oldStructureName.asString("");
            String string2 = propertyName.asString("");
            String string3 = spacing.asString("");
            if ("stronghold".equals(string)) {
                mutableBoolean.setTrue();
                switch (string2) {
                    case "distance": {
                        mutableInt.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt.getValue(), 1));
                        return;
                    }
                    case "spread": {
                        mutableInt2.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt2.getValue(), 1));
                        return;
                    }
                    case "count": {
                        mutableInt3.setValue(DataConverterWorldGenSettingsBuilding.a(string3, mutableInt3.getValue(), 1));
                        return;
                    }
                }
                return;
            }
            switch (string2) {
                case "distance": {
                    switch (string) {
                        case "village": {
                            DataConverterWorldGenSettingsBuilding.a(map, a, string3, 9);
                            return;
                        }
                        case "biome_1": {
                            DataConverterWorldGenSettingsBuilding.a(map, b, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, c, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, d, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, e, string3, 9);
                            DataConverterWorldGenSettingsBuilding.a(map, f, string3, 9);
                            return;
                        }
                        case "endcity": {
                            DataConverterWorldGenSettingsBuilding.a(map, g, string3, 1);
                            return;
                        }
                        case "mansion": {
                            DataConverterWorldGenSettingsBuilding.a(map, h, string3, 1);
                            return;
                        }
                    }
                    return;
                }
                case "separation": {
                    if ("oceanmonument".equals(string)) {
                        a structureFeatureConfiguration = map.getOrDefault(i, (a)j.get((Object)i));
                        int i2 = DataConverterWorldGenSettingsBuilding.a(string3, structureFeatureConfiguration.c, 1);
                        map.put(i, new a(i2, structureFeatureConfiguration.c, structureFeatureConfiguration.d));
                    }
                    return;
                }
                case "spacing": {
                    if ("oceanmonument".equals(string)) {
                        DataConverterWorldGenSettingsBuilding.a(map, i, string3, 1);
                    }
                    return;
                }
            }
        }))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)generatorOptionsDynamic.createString("structures"), (Object)generatorOptionsDynamic.createMap(map.entrySet().stream().collect(Collectors.toMap(entry -> generatorOptionsDynamic.createString((String)entry.getKey()), entry -> ((a)entry.getValue()).a(worldGenSettingsDynamicOps)))));
        if (mutableBoolean.isTrue()) {
            builder.put((Object)generatorOptionsDynamic.createString("stronghold"), (Object)generatorOptionsDynamic.createMap((Map)ImmutableMap.of((Object)((Object)generatorOptionsDynamic.createString("distance")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt.getValue().intValue())), (Object)((Object)generatorOptionsDynamic.createString("spread")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt2.getValue().intValue())), (Object)((Object)generatorOptionsDynamic.createString("count")), (Object)((Object)generatorOptionsDynamic.createInt(mutableInt3.getValue().intValue())))));
        }
        return builder.build();
    }

    private static int a(String string, int defaultValue) {
        return NumberUtils.toInt((String)string, (int)defaultValue);
    }

    private static int a(String string, int defaultValue, int minValue) {
        return Math.max(minValue, DataConverterWorldGenSettingsBuilding.a(string, defaultValue));
    }

    private static void a(Map<String, a> map, String structureId, String spacingStr, int minSpacing) {
        a structureFeatureConfiguration = map.getOrDefault(structureId, (a)j.get((Object)structureId));
        int i2 = DataConverterWorldGenSettingsBuilding.a(spacingStr, structureFeatureConfiguration.b, minSpacing);
        map.put(structureId, new a(i2, structureFeatureConfiguration.c, structureFeatureConfiguration.d));
    }

    static final class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.b), (App)Codec.INT.fieldOf("separation").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.c), (App)Codec.INT.fieldOf("salt").forGetter(structureFeatureConfiguration -> structureFeatureConfiguration.d)).apply((Applicative)instance, a::new));
        final int b;
        final int c;
        final int d;

        public a(int spacing, int separation, int salt) {
            this.b = spacing;
            this.c = separation;
            this.d = salt;
        }

        public <T> Dynamic<T> a(DynamicOps<T> dynamicOps) {
            return new Dynamic<Object>(dynamicOps, a.encodeStart(dynamicOps, (Object)this).result().orElse(dynamicOps.emptyMap()));
        }
    }
}

