/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class StructuresBecomeConfiguredFix
extends DataFix {
    private static final Logger a = LogUtils.getLogger();
    private static final Map<String, a> b = ImmutableMap.builder().put((Object)"mineshaft", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:pillager_outpost")).put((Object)"mansion", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:desert_pyramid")).put((Object)"igloo", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:igloo")).put((Object)"swamp_hut", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:swamp_hut")).put((Object)"stronghold", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:stronghold")).put((Object)"monument", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:monument")).put((Object)"fortress", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:fortress")).put((Object)"endcity", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:end_city")).put((Object)"buried_treasure", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:bastion_remnant")).build();

    public StructuresBecomeConfiguredFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        Type type2 = this.getInputSchema().getType(DataConverterTypes.c);
        return this.writeFixAndRead("StucturesToConfiguredStructures", type, type2, this::a);
    }

    private Dynamic<?> a(Dynamic<?> chunkDynamic) {
        return chunkDynamic.update("structures", structuresDynamic -> structuresDynamic.update("starts", startsDynamic -> this.a((Dynamic<?>)((Object)((Object)startsDynamic)), chunkDynamic)).update("References", referencesDynamic -> this.b((Dynamic<?>)((Object)((Object)referencesDynamic)), chunkDynamic)));
    }

    private Dynamic<?> a(Dynamic<?> startsDynamic, Dynamic<?> chunkDynamic) {
        Map<Dynamic, Dynamic> map = startsDynamic.getMapValues().result().orElse(Map.of());
        HashMap hashMap = Maps.newHashMap();
        map.forEach((structureId, startDynamic) -> {
            if (startDynamic.get("id").asString("INVALID").equals("INVALID")) {
                return;
            }
            Dynamic<?> dynamic2 = this.c((Dynamic<?>)((Object)structureId), chunkDynamic);
            if (dynamic2 == null) {
                a.warn("Encountered unknown structure in datafixer: " + structureId.asString("<missing key>"));
                return;
            }
            hashMap.computeIfAbsent(dynamic2, configuredStructureId -> startDynamic.set("id", dynamic2));
        });
        return chunkDynamic.createMap(hashMap);
    }

    private Dynamic<?> b(Dynamic<?> referencesDynamic, Dynamic<?> chunkDynamic) {
        Map<Dynamic, Dynamic> map = referencesDynamic.getMapValues().result().orElse(Map.of());
        HashMap hashMap = Maps.newHashMap();
        map.forEach((structureId, referenceDynamic2) -> {
            if (referenceDynamic2.asLongStream().count() == 0L) {
                return;
            }
            Dynamic<?> dynamic2 = this.c((Dynamic<?>)((Object)structureId), chunkDynamic);
            if (dynamic2 == null) {
                a.warn("Encountered unknown structure in datafixer: " + structureId.asString("<missing key>"));
                return;
            }
            hashMap.compute(dynamic2, (configuredStructureId, referenceDynamic) -> {
                if (referenceDynamic == null) {
                    return referenceDynamic2;
                }
                return referenceDynamic2.createLongList(LongStream.concat(referenceDynamic.asLongStream(), referenceDynamic2.asLongStream()));
            });
        });
        return chunkDynamic.createMap(hashMap);
    }

    @Nullable
    private Dynamic<?> c(Dynamic<?> structureIdDynamic, Dynamic<?> chunkDynamic) {
        Optional<String> optional;
        String string = structureIdDynamic.asString("UNKNOWN").toLowerCase(Locale.ROOT);
        a conversion = b.get(string);
        if (conversion == null) {
            return null;
        }
        String string2 = conversion.b;
        if (!conversion.a().isEmpty() && (optional = this.a(chunkDynamic, conversion)).isPresent()) {
            string2 = optional.get();
        }
        return chunkDynamic.createString(string2);
    }

    private Optional<String> a(Dynamic<?> chunkDynamic, a mappingForStructure) {
        Object2IntArrayMap object2IntArrayMap = new Object2IntArrayMap();
        chunkDynamic.get("sections").asList(Function.identity()).forEach(sectionDynamic -> sectionDynamic.get("biomes").get("palette").asList(Function.identity()).forEach(biomePaletteDynamic -> {
            String string = mappingForStructure.a().get(biomePaletteDynamic.asString(""));
            if (string != null) {
                object2IntArrayMap.mergeInt((Object)string, 1, Integer::sum);
            }
        }));
        return object2IntArrayMap.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
    }

    record a(Map<String, String> a, String b) {
        public static a a(String mapping) {
            return new a(Map.of(), mapping);
        }

        public static a a(Map<List<String>, String> biomeMapping, String fallback) {
            return new a(net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(biomeMapping), fallback);
        }

        private static Map<String, String> a(Map<List<String>, String> biomeMapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<List<String>, String> entry : biomeMapping.entrySet()) {
                entry.getKey().forEach(key -> builder.put(key, (Object)((String)entry.getValue())));
            }
            return builder.build();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this, object);
        }
    }
}

