/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class TrialSpawnerConfigInRegistryFix
extends DataConverterNamedEntity {
    private static final Logger a = LogUtils.getLogger();

    public TrialSpawnerConfigInRegistryFix(Schema outputSchema) {
        super(outputSchema, false, "TrialSpawnerConfigInRegistryFix", DataConverterTypes.s, "minecraft:trial_spawner");
    }

    public Dynamic<?> a(Dynamic<NBTBase> nbt) {
        Optional optional = nbt.get("normal_config").result();
        if (optional.isEmpty()) {
            return nbt;
        }
        Optional optional2 = nbt.get("ominous_config").result();
        if (optional2.isEmpty()) {
            return nbt;
        }
        MinecraftKey resourceLocation = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a.get(Pair.of((Object)((Object)((Dynamic)((Object)optional.get()))), (Object)((Object)((Dynamic)((Object)optional2.get())))));
        if (resourceLocation == null) {
            return nbt;
        }
        return nbt.set("normal_config", nbt.createString(resourceLocation.g("/normal").toString())).set("ominous_config", nbt.createString(resourceLocation.g("/ominous").toString()));
    }

    @Override
    @Override
    protected Typed<?> a(Typed<?> inputTyped) {
        return inputTyped.update(DSL.remainderFinder(), dynamic -> {
            DynamicOps dynamicOps = dynamic.getOps();
            Dynamic<?> dynamic2 = this.a(dynamic.convert(DynamicOpsNBT.a));
            return dynamic2.convert(dynamicOps);
        });
    }

    static final class a {
        public static final Map<Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>, MinecraftKey> a = new HashMap<Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>, MinecraftKey>();

        private a() {
        }

        private static void a(MinecraftKey id, String normal, String ominous) {
            try {
                NBTTagCompound compoundTag = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(normal);
                NBTTagCompound compoundTag2 = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(ominous);
                NBTTagCompound compoundTag3 = compoundTag.i().a(compoundTag2);
                NBTTagCompound compoundTag4 = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.b(compoundTag3.i());
                Dynamic<NBTBase> dynamic = net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag2)), id);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag3)), id);
                a.put((Pair<Dynamic<NBTBase>, Dynamic<NBTBase>>)Pair.of(dynamic, net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(compoundTag4)), id);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalStateException("Failed to parse NBT for " + String.valueOf(id), runtimeException);
            }
        }

        private static Dynamic<NBTBase> a(NBTTagCompound nbt) {
            return new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt);
        }

        private static NBTTagCompound a(String nbt) {
            try {
                return MojangsonParser.a(nbt);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new IllegalArgumentException("Failed to parse Trial Spawner NBT config: " + nbt, commandSyntaxException);
            }
        }

        private static NBTTagCompound b(NBTTagCompound nbt) {
            if (nbt.h("spawn_range") == 4) {
                nbt.r("spawn_range");
            }
            if (nbt.j("total_mobs") == 6.0f) {
                nbt.r("total_mobs");
            }
            if (nbt.j("simultaneous_mobs") == 2.0f) {
                nbt.r("simultaneous_mobs");
            }
            if (nbt.j("total_mobs_added_per_player") == 2.0f) {
                nbt.r("total_mobs_added_per_player");
            }
            if (nbt.j("simultaneous_mobs_added_per_player") == 1.0f) {
                nbt.r("simultaneous_mobs_added_per_player");
            }
            if (nbt.h("ticks_between_spawn") == 40) {
                nbt.r("ticks_between_spawn");
            }
            return nbt;
        }

        static {
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/breeze"), "{simultaneous_mobs: 1.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:breeze\"}}, weight: 1}], ticks_between_spawn: 20, total_mobs: 2.0f, total_mobs_added_per_player: 1.0f}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 2.0f, total_mobs: 4.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/husk"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:husk\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:husk\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/spider"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:spider\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/melee/zombie"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:zombie\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:zombie\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/poison_skeleton"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/skeleton"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/ranged/stray"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/poison_skeleton"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:bogged\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/skeleton"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {id: \"minecraft:skeleton\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/slow_ranged/stray"), "{simultaneous_mobs: 4.0f, simultaneous_mobs_added_per_player: 2.0f, spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}}, weight: 1}], ticks_between_spawn: 160}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}],spawn_potentials: [{data: {entity: {id: \"minecraft:stray\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_ranged\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/baby_zombie"), "{simultaneous_mobs: 2.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {IsBaby: 1b, id: \"minecraft:zombie\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], spawn_potentials: [{data: {entity: {IsBaby: 1b, id: \"minecraft:zombie\"}, equipment: {loot_table: \"minecraft:equipment/trial_chamber_melee\", slot_drop_chances: 0.0f}}, weight: 1}]}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/cave_spider"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:cave_spider\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/silverfish"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {id: \"minecraft:silverfish\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
            net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix$a.a(MinecraftKey.b("trial_chamber/small_melee/slime"), "{simultaneous_mobs: 3.0f, simultaneous_mobs_added_per_player: 0.5f, spawn_potentials: [{data: {entity: {Size: 1, id: \"minecraft:slime\"}}, weight: 3}, {data: {entity: {Size: 2, id: \"minecraft:slime\"}}, weight: 1}], ticks_between_spawn: 20}", "{loot_tables_to_eject: [{data: \"minecraft:spawners/ominous/trial_chamber/key\", weight: 3}, {data: \"minecraft:spawners/ominous/trial_chamber/consumables\", weight: 7}], simultaneous_mobs: 4.0f, total_mobs: 12.0f}");
        }
    }
}

