/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String b = "bytesPerSecond";
    private static final String c = "count";
    private static final String d = "durationNanosTotal";
    private static final String e = "totalBytes";
    private static final String f = "countPerSecond";
    final Gson a = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    private static void a(PacketIdentification packet, JsonObject json) {
        json.addProperty("protocolId", packet.b());
        json.addProperty("packetId", packet.c());
    }

    private static void a(ChunkIdentification chunk, JsonObject json) {
        json.addProperty("level", chunk.a());
        json.addProperty("dimension", chunk.b());
        json.addProperty("x", (Number)chunk.c());
        json.addProperty("z", (Number)chunk.d());
    }

    public String a(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("startedEpoch", (Number)profile.c().toEpochMilli());
        jsonObject.addProperty("endedEpoch", (Number)profile.d().toEpochMilli());
        jsonObject.addProperty("durationMs", (Number)profile.e().toMillis());
        Duration duration = profile.f();
        if (duration != null) {
            jsonObject.addProperty("worldGenDurationMs", (Number)duration.toMillis());
        }
        jsonObject.add("heap", this.a(profile.i()));
        jsonObject.add("cpuPercent", this.c(profile.h()));
        jsonObject.add("network", this.c(profile));
        jsonObject.add("fileIO", this.b(profile));
        jsonObject.add("serverTick", this.b(profile.g()));
        jsonObject.add("threadAllocation", this.a(profile.j()));
        jsonObject.add("chunkGen", this.a(profile.a()));
        return this.a.toJson((JsonElement)jsonObject);
    }

    private JsonElement a(GcHeapStat.a statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("allocationRateBytesPerSecond", (Number)statistics.e());
        jsonObject.addProperty("gcCount", (Number)statistics.d());
        jsonObject.addProperty("gcOverHeadPercent", (Number)Float.valueOf(statistics.a()));
        jsonObject.addProperty("gcTotalDurationMs", (Number)statistics.c().toMillis());
        return jsonObject;
    }

    private JsonElement a(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(d, (Number)statistics.stream().mapToDouble(pair -> ((TimedStatSummary)pair.getSecond()).f().toNanos()).sum());
        JsonArray jsonArray = SystemUtils.a(new JsonArray(), (? super T json) -> jsonObject.add("status", (JsonElement)json));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> pair2 : statistics) {
            TimedStatSummary timedStatSummary = (TimedStatSummary)pair2.getSecond();
            JsonObject jsonObject2 = SystemUtils.a(new JsonObject(), arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject2.addProperty("state", ((ChunkStatus)pair2.getFirst()).toString());
            jsonObject2.addProperty(c, (Number)timedStatSummary.d());
            jsonObject2.addProperty(d, (Number)timedStatSummary.f().toNanos());
            jsonObject2.addProperty("durationNanosAvg", (Number)(timedStatSummary.f().toNanos() / (long)timedStatSummary.d()));
            JsonObject jsonObject3 = SystemUtils.a(new JsonObject(), (? super T json) -> jsonObject2.add("durationNanosPercentiles", (JsonElement)json));
            timedStatSummary.e().forEach((quantile, value) -> jsonObject3.addProperty("p" + quantile, (Number)value));
            Function<ChunkGenStat, JsonElement> function = sample -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("durationNanos", (Number)sample.a().toNanos());
                jsonObject.addProperty("level", sample.e());
                jsonObject.addProperty("chunkPosX", (Number)sample.b().h);
                jsonObject.addProperty("chunkPosZ", (Number)sample.b().i);
                jsonObject.addProperty("worldPosX", (Number)sample.c().c());
                jsonObject.addProperty("worldPosZ", (Number)sample.c().d());
                return jsonObject;
            };
            jsonObject2.add("fastest", function.apply((ChunkGenStat)timedStatSummary.a()));
            jsonObject2.add("slowest", function.apply((ChunkGenStat)timedStatSummary.b()));
            jsonObject2.add("secondSlowest", (JsonElement)(timedStatSummary.c() != null ? function.apply((ChunkGenStat)timedStatSummary.c()) : JsonNull.INSTANCE));
        }
        return jsonObject;
    }

    private JsonElement a(ThreadAllocationStat.a statistics) {
        JsonArray jsonArray = new JsonArray();
        statistics.a().forEach((threadName, allocation) -> jsonArray.add((JsonElement)SystemUtils.a(new JsonObject(), (? super T json) -> {
            json.addProperty("thread", threadName);
            json.addProperty(b, (Number)allocation);
        })));
        return jsonArray;
    }

    private JsonElement b(List<TickTimeStat> samples) {
        if (samples.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        double[] ds = samples.stream().mapToDouble(sample -> (double)sample.b().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics doubleSummaryStatistics = DoubleStream.of(ds).summaryStatistics();
        jsonObject.addProperty("minMs", (Number)doubleSummaryStatistics.getMin());
        jsonObject.addProperty("averageMs", (Number)doubleSummaryStatistics.getAverage());
        jsonObject.addProperty("maxMs", (Number)doubleSummaryStatistics.getMax());
        Map<Integer, Double> map = Percentiles.a(ds);
        map.forEach((quantile, value) -> jsonObject.addProperty("p" + quantile, (Number)value));
        return jsonObject;
    }

    private JsonElement b(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("write", this.a(profile.o()));
        jsonObject.add("read", this.a(profile.p()));
        jsonObject.add("chunksRead", this.a(profile.n(), JfrResultJsonSerializer::a));
        jsonObject.add("chunksWritten", this.a(profile.m(), JfrResultJsonSerializer::a));
        return jsonObject;
    }

    private JsonElement a(FileIOStat.a statistics) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)statistics.a());
        jsonObject.addProperty(c, (Number)statistics.c());
        jsonObject.addProperty(b, (Number)statistics.b());
        jsonObject.addProperty(f, (Number)statistics.d());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.f().forEach(pair -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            jsonObject.addProperty("path", (String)pair.getFirst());
            jsonObject.addProperty(e, (Number)pair.getSecond());
        });
        return jsonObject;
    }

    private JsonElement c(JfrStatsResult profile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("sent", this.a(profile.l(), JfrResultJsonSerializer::a));
        jsonObject.add("received", this.a(profile.k(), JfrResultJsonSerializer::a));
        return jsonObject;
    }

    private <T> JsonElement a(IoSummary<T> statistics, BiConsumer<T, JsonObject> callback) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(e, (Number)statistics.d());
        jsonObject.addProperty(c, (Number)statistics.c());
        jsonObject.addProperty(b, (Number)statistics.b());
        jsonObject.addProperty(f, (Number)statistics.a());
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("topContributors", (JsonElement)jsonArray);
        statistics.e().forEach(topContributor -> {
            JsonObject jsonObject = new JsonObject();
            jsonArray.add((JsonElement)jsonObject);
            Object object = topContributor.getFirst();
            IoSummary.a countAndSize = (IoSummary.a)topContributor.getSecond();
            callback.accept(object, jsonObject);
            jsonObject.addProperty(e, (Number)countAndSize.c());
            jsonObject.addProperty(c, (Number)countAndSize.b());
            jsonObject.addProperty("averageSize", (Number)Float.valueOf(countAndSize.a()));
        });
        return jsonObject;
    }

    private JsonElement c(List<CpuLoadStat> samples) {
        JsonObject jsonObject = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> biFunction = (samplesx, valueGetter) -> {
            JsonObject jsonObject = new JsonObject();
            DoubleSummaryStatistics doubleSummaryStatistics = samplesx.stream().mapToDouble(valueGetter).summaryStatistics();
            jsonObject.addProperty("min", (Number)doubleSummaryStatistics.getMin());
            jsonObject.addProperty("average", (Number)doubleSummaryStatistics.getAverage());
            jsonObject.addProperty("max", (Number)doubleSummaryStatistics.getMax());
            return jsonObject;
        };
        jsonObject.add("jvm", (JsonElement)biFunction.apply(samples, CpuLoadStat::a));
        jsonObject.add("userJvm", (JsonElement)biFunction.apply(samples, CpuLoadStat::b));
        jsonObject.add("system", (JsonElement)biFunction.apply(samples, CpuLoadStat::c));
        return jsonObject;
    }
}

