/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedNormalInt
extends IntProvider {
    public static final MapCodec<ClampedNormalInt> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(provider -> Float.valueOf(provider.b)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(provider -> Float.valueOf(provider.f)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.g), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.h)).apply((Applicative)instance, ClampedNormalInt::new)).validate(provider -> {
        if (provider.h < provider.g) {
            return DataResult.error(() -> "Max must be larger than min: [" + clampedNormalInt.g + ", " + clampedNormalInt.h + "]");
        }
        return DataResult.success((Object)provider);
    });
    private final float b;
    private final float f;
    private final int g;
    private final int h;

    public static ClampedNormalInt a(float mean, float deviation, int min, int max) {
        return new ClampedNormalInt(mean, deviation, min, max);
    }

    private ClampedNormalInt(float mean, float deviation, int min, int max) {
        this.b = mean;
        this.f = deviation;
        this.g = min;
        this.h = max;
    }

    @Override
    @Override
    public int a(RandomSource random) {
        return ClampedNormalInt.a(random, this.b, this.f, this.g, this.h);
    }

    public static int a(RandomSource random, float mean, float deviation, float min, float max) {
        return (int)MathHelper.a(MathHelper.c(random, mean, deviation), min, max);
    }

    @Override
    @Override
    public int a() {
        return this.g;
    }

    @Override
    @Override
    public int b() {
        return this.h;
    }

    @Override
    @Override
    public IntProviderType<?> c() {
        return IntProviderType.f;
    }

    @Override
    public String toString() {
        return "normal(" + this.b + ", " + this.f + ") in [" + this.g + "-" + this.h + "]";
    }
}

