/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int b;
    public final NonNullList<ItemStack> c;
    @Nullable
    private List<IInventoryListener> d;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    @Nullable
    protected InventoryHolder bukkitOwner;
    @Nullable
    private Supplier<? extends InventoryHolder> bukkitOwnerCreator;

    @Override
    public List<ItemStack> getContents() {
        return this.c;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ao_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    @Override
    public InventoryHolder getOwner() {
        if (this.bukkitOwner == null && this.bukkitOwnerCreator != null) {
            this.bukkitOwner = this.bukkitOwnerCreator.get();
        }
        return this.bukkitOwner;
    }

    @Override
    public Location getLocation() {
        InventoryHolder inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return blockInventoryHolder.getBlock().getLocation();
        }
        inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return entity.getLocation();
        }
        return null;
    }

    public InventorySubcontainer(InventorySubcontainer original) {
        this(original.b);
        for (int slot = 0; slot < original.b; ++slot) {
            this.c.set(slot, original.c.get(slot).v());
        }
    }

    public InventorySubcontainer(int size) {
        this(size, null);
    }

    public InventorySubcontainer(Supplier<? extends InventoryHolder> bukkitOwnerCreator, int size) {
        this(size);
        this.bukkitOwnerCreator = bukkitOwnerCreator;
    }

    public InventorySubcontainer(int i2, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.b = i2;
        this.c = NonNullList.a(i2, ItemStack.j);
    }

    public InventorySubcontainer(ItemStack ... items) {
        this.b = items.length;
        this.c = NonNullList.a(ItemStack.j, items);
    }

    public void a(IInventoryListener listener) {
        if (this.d == null) {
            this.d = Lists.newArrayList();
        }
        this.d.add(listener);
    }

    public void b(IInventoryListener listener) {
        if (this.d != null) {
            this.d.remove(listener);
        }
    }

    @Override
    public ItemStack a(int slot) {
        return slot >= 0 && slot < this.c.size() ? this.c.get(slot) : ItemStack.j;
    }

    public List<ItemStack> f() {
        List<ItemStack> list = this.c.stream().filter(itemstack -> !itemstack.f()).collect(Collectors.toList());
        this.a();
        return list;
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemstack = ContainerUtil.a(this.c, slot, amount);
        if (!itemstack.f()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack a(Item item, int count) {
        ItemStack itemstack = new ItemStack(item, 0);
        for (int j2 = this.b - 1; j2 >= 0; --j2) {
            ItemStack itemstack1 = this.a(j2);
            if (!itemstack1.h().equals(item)) continue;
            int k2 = count - itemstack.L();
            ItemStack itemstack2 = itemstack1.a(k2);
            itemstack.g(itemstack2.L());
            if (itemstack.L() == count) break;
        }
        if (!itemstack.f()) {
            this.e();
        }
        return itemstack;
    }

    public ItemStack b(ItemStack stack) {
        if (stack.f()) {
            return ItemStack.j;
        }
        ItemStack itemstack1 = stack.v();
        this.e(itemstack1);
        if (itemstack1.f()) {
            return ItemStack.j;
        }
        this.d(itemstack1);
        return itemstack1.f() ? ItemStack.j : itemstack1;
    }

    public boolean c(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemstack1 : this.c) {
            if (!itemstack1.f() && (!ItemStack.c(itemstack1, stack) || itemstack1.L() >= itemstack1.k())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack b(int slot) {
        ItemStack itemstack = this.c.get(slot);
        if (itemstack.f()) {
            return ItemStack.j;
        }
        this.c.set(slot, ItemStack.j);
        return itemstack;
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.c.set(slot, stack);
        stack.f(this.e_(stack));
        this.e();
    }

    @Override
    public int b() {
        return this.b;
    }

    @Override
    public boolean c() {
        ItemStack itemstack;
        Iterator iterator = this.c.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).f());
        return false;
    }

    @Override
    public void e() {
        if (this.d != null) {
            for (IInventoryListener iinventorylistener : this.d) {
                iinventorylistener.a(this);
            }
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    public void a() {
        this.c.clear();
        this.e();
    }

    @Override
    public void fillStackedContents(StackedItemContents finder) {
        for (ItemStack itemstack : this.c) {
            finder.b(itemstack);
        }
    }

    public String toString() {
        return this.c.stream().filter(itemstack -> !itemstack.f()).collect(Collectors.toList()).toString();
    }

    private void d(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!itemstack1.f()) continue;
            this.a(i2, stack.g());
            return;
        }
    }

    private void e(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack itemstack1 = this.a(i2);
            if (!ItemStack.c(itemstack1, stack)) continue;
            this.a(stack, itemstack1);
            if (!stack.f()) continue;
            return;
        }
    }

    private void a(ItemStack source, ItemStack target) {
        int i2 = this.e_(target);
        int j2 = Math.min(source.L(), i2 - target.L());
        if (j2 > 0) {
            target.g(j2);
            source.h(j2);
            this.e();
        }
    }

    public void a(NBTTagList list, HolderLookup.a registries) {
        this.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ItemStack.a(registries, (NBTBase)list.a(i2)).ifPresent(this::b);
        }
    }

    public NBTTagList a(HolderLookup.a registries) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.b(); ++i2) {
            ItemStack itemstack = this.a(i2);
            if (itemstack.f()) continue;
            nbttaglist.add(itemstack.a(registries));
        }
        return nbttaglist;
    }

    public NonNullList<ItemStack> g() {
        return this.c;
    }
}

