/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class MobEffectList
implements FeatureElement {
    public static final Codec<Holder<MobEffectList>> a = BuiltInRegistries.d.r();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MobEffectList>> b = ByteBufCodecs.b(Registries.W);
    private static final int c = MathHelper.d(38.25f);
    public final Map<Holder<AttributeBase>, a> d = new Object2ObjectOpenHashMap();
    private final MobEffectInfo e;
    private final int f;
    private final Function<MobEffect, ParticleParam> g;
    @Nullable
    private String h;
    private int i;
    private Optional<SoundEffect> j = Optional.empty();
    private FeatureFlagSet k = FeatureFlags.h;

    protected MobEffectList(MobEffectInfo category, int color) {
        this.e = category;
        this.f = color;
        this.g = effect -> {
            int j2 = effect.f() ? c : 255;
            return ColorParticleOption.a(Particles.u, ARGB.c(j2, color));
        };
    }

    protected MobEffectList(MobEffectInfo category, int color, ParticleParam particleEffect) {
        this.e = category;
        this.f = color;
        this.g = effect -> particleEffect;
    }

    public int b() {
        return this.i;
    }

    public boolean a(WorldServer world, EntityLiving entity, int amplifier) {
        return true;
    }

    public void a(WorldServer world, @Nullable Entity effectEntity, @Nullable Entity attacker, EntityLiving target, int amplifier, double proximity) {
        this.a(world, target, amplifier);
    }

    public boolean a(int duration, int amplifier) {
        return false;
    }

    public void a(EntityLiving entity, int amplifier) {
    }

    public void b(EntityLiving entity, int amplifier) {
        this.j.ifPresent(sound -> entity.dW().a(null, entity.dB(), entity.dD(), entity.dH(), (SoundEffect)sound, entity.dn(), 1.0f, 1.0f));
    }

    public void a(WorldServer world, EntityLiving entity, int amplifier, Entity.RemovalReason reason) {
    }

    public void a(WorldServer world, EntityLiving entity, int amplifier, DamageSource source, float amount) {
    }

    public boolean a() {
        return false;
    }

    protected String c() {
        if (this.h == null) {
            this.h = SystemUtils.a("effect", BuiltInRegistries.d.b(this));
        }
        return this.h;
    }

    public String d() {
        return this.c();
    }

    public IChatBaseComponent e() {
        return IChatBaseComponent.c(this.d());
    }

    public MobEffectInfo f() {
        return this.e;
    }

    public int g() {
        return this.f;
    }

    public MobEffectList a(Holder<AttributeBase> attribute, MinecraftKey id, double amount, AttributeModifier.Operation operation) {
        this.d.put(attribute, new a(id, amount, operation));
        return this;
    }

    public MobEffectList a(int fadeTicks) {
        this.i = fadeTicks;
        return this;
    }

    public void a(int amplifier, BiConsumer<Holder<AttributeBase>, AttributeModifier> consumer) {
        this.d.forEach((attribute, attributeModifierCreator) -> consumer.accept((Holder<AttributeBase>)attribute, attributeModifierCreator.a(amplifier)));
    }

    public void a(AttributeMapBase attributeContainer) {
        for (Map.Entry<Holder<AttributeBase>, a> entry : this.d.entrySet()) {
            AttributeModifiable attributeInstance = attributeContainer.a(entry.getKey());
            if (attributeInstance == null) continue;
            attributeInstance.c(entry.getValue().a());
        }
    }

    public void a(AttributeMapBase attributeContainer, int amplifier) {
        for (Map.Entry<Holder<AttributeBase>, a> entry : this.d.entrySet()) {
            AttributeModifiable attributeInstance = attributeContainer.a(entry.getKey());
            if (attributeInstance == null) continue;
            attributeInstance.c(entry.getValue().a());
            attributeInstance.d(entry.getValue().a(amplifier));
        }
    }

    public boolean h() {
        return this.e == MobEffectInfo.a;
    }

    public ParticleParam a(MobEffect effect) {
        return this.g.apply(effect);
    }

    public MobEffectList a(SoundEffect sound) {
        this.j = Optional.of(sound);
        return this;
    }

    public MobEffectList a(FeatureFlag ... requiredFeatures) {
        this.k = FeatureFlags.f.a(requiredFeatures);
        return this;
    }

    @Override
    @Override
    public FeatureFlagSet i() {
        return this.k;
    }

    public record a(MinecraftKey a, double b, AttributeModifier.Operation c) {
        public AttributeModifier a(int amplifier) {
            return new AttributeModifier(this.a, this.b * (double)(amplifier + 1), this.c);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;amount;operation", "a", "b", "c"}, this, object);
        }
    }
}

