/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.InstantMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.FoodLevelChangeEvent;

class SaturationMobEffect
extends InstantMobEffect {
    protected SaturationMobEffect(MobEffectInfo category, int color) {
        super(category, color);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving entity, int amplifier) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            int oldFoodLevel = entityhuman.gt().a;
            FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityhuman, amplifier + 1 + oldFoodLevel);
            if (!event.isCancelled()) {
                entityhuman.gt().a(event.getFoodLevel() - oldFoodLevel, 1.0f);
            }
            ((CraftPlayer)entityhuman.getBukkitEntity()).sendHealthUpdate();
        }
        return true;
    }
}

