/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

class WeavingMobEffect
extends MobEffectList {
    private final ToIntFunction<RandomSource> c;

    protected WeavingMobEffect(MobEffectInfo category, int color, ToIntFunction<RandomSource> cobwebChanceFunction) {
        super(category, color, Particles.W);
        this.c = cobwebChanceFunction;
    }

    @Override
    public void a(WorldServer world, EntityLiving entity, int amplifier, Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.a && (entity instanceof EntityHuman || world.N().b(GameRules.c))) {
            this.spawnCobwebsRandomlyAround(world, entity.dZ(), entity.dw(), entity);
        }
    }

    private void spawnCobwebsRandomlyAround(WorldServer world, RandomSource random, BlockPosition pos, EntityLiving entity) {
        HashSet set = Sets.newHashSet();
        int i2 = this.c.applyAsInt(random);
        for (BlockPosition blockPos : BlockPosition.a(random, 15, pos, 1)) {
            BlockPosition blockPos2 = blockPos.e();
            if (set.contains(blockPos) || !world.a_(blockPos).v() || !world.a_(blockPos2).c((IBlockAccess)world, blockPos2, EnumDirection.b)) continue;
            set.add(blockPos.j());
            if (set.size() < i2) continue;
            break;
        }
        for (BlockPosition blockPos3 : set) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockPos3, Blocks.bz.m())) continue;
            world.a(blockPos3, Blocks.bz.m(), 3);
            world.c(3018, blockPos3, 0);
        }
    }
}

