/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    public static final int a = -1;
    private static final DataWatcherObject<Integer> p = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> s = DataWatcher.a(Display.class, DataWatcherRegistry.D);
    private static final DataWatcherObject<Vector3f> t = DataWatcher.a(Display.class, DataWatcherRegistry.D);
    private static final DataWatcherObject<Quaternionf> u = DataWatcher.a(Display.class, DataWatcherRegistry.E);
    private static final DataWatcherObject<Quaternionf> ay = DataWatcher.a(Display.class, DataWatcherRegistry.E);
    private static final DataWatcherObject<Byte> az = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aA = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aB = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aC = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aD = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aE = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aF = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aG = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aH = IntSet.of((int[])new int[]{s.a(), t.a(), u.a(), ay.a(), az.a(), aA.a(), aC.a(), aD.a()});
    private static final float aI = 0.0f;
    private static final float aJ = 1.0f;
    private static final int aK = -1;
    public static final String b = "teleport_duration";
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private long aL = Integer.MIN_VALUE;
    private int aM;
    private float aN;
    private AxisAlignedBB aO;
    private boolean aP = true;
    protected boolean n;
    private boolean aQ;
    private boolean aR;
    @Nullable
    private k aS;
    @Nullable
    private j aT;

    public Display(EntityTypes<?> type, World world) {
        super(type, world);
        this.ad = true;
        this.aO = this.cR();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (aF.equals(data) || aE.equals(data)) {
            this.E();
        }
        if (p.equals(data)) {
            this.aQ = true;
        }
        if (q.equals(data)) {
            this.aR = true;
        }
        if (aH.contains(data.a())) {
            this.n = true;
        }
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }

    public static Transformation a(DataWatcher dataTracker) {
        Vector3f vector3f = dataTracker.a(s);
        Quaternionf quaternionf = dataTracker.a(u);
        Vector3f vector3f2 = dataTracker.a(t);
        Quaternionf quaternionf2 = dataTracker.a(ay);
        return new Transformation(vector3f, quaternionf, vector3f2, quaternionf2);
    }

    @Override
    public void h() {
        Entity entity = this.dl();
        if (entity != null && entity.dR()) {
            this.ae();
        }
        if (this.dW().C) {
            if (this.aQ) {
                this.aQ = false;
                int i2 = this.t();
                this.aL = this.af + i2;
            }
            if (this.aR) {
                this.aR = false;
                this.aM = this.s();
            }
            if (this.n) {
                this.n = false;
                boolean bl = this.aM != 0;
                this.aS = bl && this.aS != null ? this.a(this.aS, this.aN) : this.F();
                this.a(bl, this.aN);
            }
            if (this.aT != null) {
                if (this.aT.a == 0) {
                    this.aT.a(this);
                    this.bz();
                    this.aT = null;
                } else {
                    this.aT.b(this);
                    --this.aT.a;
                    if (this.aT.a == 0) {
                        this.aT = null;
                    }
                }
            }
        }
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(r, 0);
        builder.a(p, 0);
        builder.a(q, 0);
        builder.a(s, new Vector3f());
        builder.a(t, new Vector3f(1.0f, 1.0f, 1.0f));
        builder.a(ay, new Quaternionf());
        builder.a(u, new Quaternionf());
        builder.a(az, BillboardConstraints.a.a());
        builder.a(aA, -1);
        builder.a(aB, Float.valueOf(1.0f));
        builder.a(aC, Float.valueOf(0.0f));
        builder.a(aD, Float.valueOf(1.0f));
        builder.a(aE, Float.valueOf(0.0f));
        builder.a(aF, Float.valueOf(0.0f));
        builder.a(aG, -1);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.e(e)) {
            Transformation.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(e)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((Transformation)pair.getFirst()));
        }
        if (nbt.b(c, 99)) {
            int i2 = nbt.h(c);
            this.b(i2);
        }
        if (nbt.b(d, 99)) {
            int j2 = nbt.h(d);
            this.c(j2);
        }
        if (nbt.b(b, 99)) {
            int k2 = nbt.h(b);
            this.d(MathHelper.a(k2, 0, 59));
        }
        if (nbt.b(f, 8)) {
            BillboardConstraints.e.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(f)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((BillboardConstraints)pair.getFirst()));
        }
        if (nbt.b(h, 99)) {
            this.b(nbt.j(h));
        }
        if (nbt.b(i, 99)) {
            this.c(nbt.j(i));
        }
        if (nbt.b(j, 99)) {
            this.x(nbt.j(j));
        }
        if (nbt.b(k, 99)) {
            this.y(nbt.j(k));
        }
        if (nbt.b(l, 99)) {
            this.z(nbt.j(l));
        }
        if (nbt.b(m, 99)) {
            this.l(nbt.h(m));
        }
        if (nbt.b(g, 10)) {
            Brightness.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(g)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(pair -> this.a((Brightness)pair.getFirst()));
        } else {
            this.a((Brightness)null);
        }
    }

    public void a(Transformation transformation) {
        this.al.a(s, transformation.d());
        this.al.a(u, transformation.e());
        this.al.a(t, transformation.f());
        this.al.a(ay, transformation.g());
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        Transformation.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)Display.a(this.al)).ifSuccess(transformations -> nbt.a(e, (NBTBase)transformations));
        BillboardConstraints.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.v()).ifSuccess(billboard -> nbt.a(f, (NBTBase)billboard));
        nbt.a(c, this.s());
        nbt.a(b, this.u());
        nbt.a(h, this.y());
        nbt.a(i, this.z());
        nbt.a(j, this.A());
        nbt.a(k, this.B());
        nbt.a(l, this.D());
        nbt.a(m, this.C());
        Brightness brightness = this.w();
        if (brightness != null) {
            Brightness.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)brightness).ifSuccess(brightnessx -> nbt.a(g, (NBTBase)brightnessx));
        }
    }

    @Override
    public void f_() {
        this.aT = null;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        int i2 = this.u();
        this.aT = new j(i2, x2, y2, z2, yaw, pitch);
    }

    @Override
    public double R_() {
        return this.aT != null ? this.aT.b : this.dB();
    }

    @Override
    public double S_() {
        return this.aT != null ? this.aT.c : this.dD();
    }

    @Override
    public double g_() {
        return this.aT != null ? this.aT.d : this.dH();
    }

    @Override
    public float r_() {
        return this.aT != null ? (float)this.aT.f : this.dO();
    }

    @Override
    public float h_() {
        return this.aT != null ? (float)this.aT.e : this.dM();
    }

    public AxisAlignedBB l() {
        return this.aO;
    }

    public boolean m() {
        return !this.aP;
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean s_() {
        return true;
    }

    @Nullable
    public k p() {
        return this.aS;
    }

    public void b(int interpolationDuration) {
        this.al.a(q, interpolationDuration);
    }

    public int s() {
        return this.al.a(q);
    }

    public void c(int startInterpolation) {
        this.al.a(p, startInterpolation, true);
    }

    public int t() {
        return this.al.a(p);
    }

    private void d(int teleportDuration) {
        this.al.a(r, teleportDuration);
    }

    private int u() {
        return this.al.a(r);
    }

    public void a(BillboardConstraints billboardMode) {
        this.al.a(az, billboardMode.a());
    }

    public BillboardConstraints v() {
        return BillboardConstraints.f.apply(this.al.a(az).byteValue());
    }

    public void a(@Nullable Brightness brightness) {
        this.al.a(aA, brightness != null ? brightness.a() : -1);
    }

    @Nullable
    public Brightness w() {
        int i2 = this.al.a(aA);
        return i2 != -1 ? Brightness.a(i2) : null;
    }

    private int x() {
        return this.al.a(aA);
    }

    public void b(float viewRange) {
        this.al.a(aB, Float.valueOf(viewRange));
    }

    public float y() {
        return this.al.a(aB).floatValue();
    }

    public void c(float shadowRadius) {
        this.al.a(aC, Float.valueOf(shadowRadius));
    }

    public float z() {
        return this.al.a(aC).floatValue();
    }

    public void x(float shadowStrength) {
        this.al.a(aD, Float.valueOf(shadowStrength));
    }

    public float A() {
        return this.al.a(aD).floatValue();
    }

    public void y(float width) {
        this.al.a(aE, Float.valueOf(width));
    }

    public float B() {
        return this.al.a(aE).floatValue();
    }

    public void z(float height) {
        this.al.a(aF, Float.valueOf(height));
    }

    public int C() {
        return this.al.a(aG);
    }

    public void l(int glowColorOverride) {
        this.al.a(aG, glowColorOverride);
    }

    public float a(float delta) {
        float h2;
        int i2 = this.aM;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f2 = (long)this.af - this.aL;
        float g2 = f2 + delta;
        this.aN = h2 = MathHelper.a(MathHelper.f(g2, 0.0f, i2), 0.0f, 1.0f);
        return h2;
    }

    public float D() {
        return this.al.a(aF).floatValue();
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        super.a_(x2, y2, z2);
        this.E();
    }

    private void E() {
        float f2 = this.B();
        float g2 = this.D();
        this.aP = f2 == 0.0f || g2 == 0.0f;
        float h2 = f2 / 2.0f;
        double d2 = this.dB();
        double e2 = this.dD();
        double i2 = this.dH();
        this.aO = new AxisAlignedBB(d2 - (double)h2, e2, i2 - (double)h2, d2 + (double)h2, e2 + (double)g2, i2 + (double)h2);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.y() * 64.0 * Display.cK());
    }

    @Override
    public int k_() {
        int i2 = this.C();
        return i2 != -1 ? i2 : super.k_();
    }

    private k F() {
        return new k(GenericInterpolator.constant(Display.a(this.al)), this.v(), this.x(), FloatInterpolator.constant(this.z()), FloatInterpolator.constant(this.A()), this.C());
    }

    private k a(k state, float lerpProgress) {
        Transformation transformation = state.a.get(lerpProgress);
        float f2 = state.d.get(lerpProgress);
        float g2 = state.e.get(lerpProgress);
        return new k(new m(transformation, Display.a(this.al)), this.v(), this.x(), new h(f2, this.z()), new h(g2, this.A()), this.C());
    }

    public record k(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    static class j {
        int a;
        final double b;
        final double c;
        final double d;
        final double e;
        final double f;

        j(int step, double x2, double y2, double z2, double yaw, double pitch) {
            this.a = step;
            this.b = x2;
            this.c = y2;
            this.d = z2;
            this.e = yaw;
            this.f = pitch;
        }

        void a(Entity entity) {
            entity.a_(this.b, this.c, this.d);
            entity.b((float)this.e, (float)this.f);
        }

        void b(Entity entity) {
            entity.a(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte index, String name) {
            this.h = name;
            this.g = index;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return delta -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return delta -> value;
        }

        public float get(float var1);
    }

    record m(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float f2) {
            return (double)f2 >= 1.0 ? this.b : this.a.a(this.b, f2);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float delta) {
            return MathHelper.h(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String ay = "line_width";
        private static final String az = "text_opacity";
        private static final String aA = "background";
        private static final String aB = "shadow";
        private static final String aC = "see_through";
        private static final String aD = "default_background";
        private static final String aE = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aF = -1;
        public static final int u = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> aG = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aH = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aI = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aJ = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aK = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet aL = IntSet.of((int[])new int[]{aG.a(), aH.a(), aI.a(), aJ.a(), aK.a()});
        @Nullable
        private CachedInfo aM;
        @Nullable
        private e aN;

        public TextDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(aG, IChatBaseComponent.i());
            builder.a(aH, 200);
            builder.a(aI, 0x40000000);
            builder.a(aJ, (byte)-1);
            builder.a(aK, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (aL.contains(data.a())) {
                this.n = true;
            }
        }

        public IChatBaseComponent t() {
            return this.al.a(aG);
        }

        public void a(IChatBaseComponent text) {
            this.al.a(aG, text);
        }

        @Override
        public int u() {
            return this.al.a(aH);
        }

        @Override
        private void b(int lineWidth) {
            this.al.a(aH, lineWidth);
        }

        public byte v() {
            return this.al.a(aJ);
        }

        public void c(byte textOpacity) {
            this.al.a(aJ, textOpacity);
        }

        public int w() {
            return this.al.a(aI);
        }

        @Override
        private void c(int background) {
            this.al.a(aI, background);
        }

        public byte x() {
            return this.al.a(aK);
        }

        public void d(byte flags) {
            this.al.a(aK, flags);
        }

        private static byte a(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            return nbt.q(nbtKey) ? (byte)(flags | flag) : flags;
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            if (nbt.b(ay, 99)) {
                this.b(nbt.h(ay));
            }
            if (nbt.b(az, 99)) {
                this.c(nbt.f(az));
            }
            if (nbt.b(aA, 99)) {
                this.c(nbt.h(aA));
            }
            byte b2 = TextDisplay.a((byte)0, nbt, aB, (byte)1);
            b2 = TextDisplay.a(b2, nbt, aC, (byte)2);
            b2 = TextDisplay.a(b2, nbt, aD, (byte)4);
            Optional<Align> optional = Align.d.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(aE)).result().map(Pair::getFirst);
            if (optional.isPresent()) {
                b2 = switch (optional.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> b2;
                    case 1 -> (byte)(b2 | 8);
                    case 2 -> (byte)(b2 | 0x10);
                };
            }
            this.d(b2);
            if (nbt.b(o, 8)) {
                String string = nbt.l(o);
                try {
                    World world;
                    IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(string, (HolderLookup.a)this.dY());
                    if (component != null && (world = this.dW()) instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        CommandListenerWrapper commandSourceStack = this.d(serverLevel).a(2);
                        IChatMutableComponent component2 = ChatComponentUtils.a(commandSourceStack, component, (Entity)this, 0);
                        this.a(component2);
                    } else {
                        this.a(IChatBaseComponent.i());
                    }
                }
                catch (Exception var9) {
                    o.warn("Failed to parse display entity text {}", (Object)string, (Object)var9);
                }
            }
        }

        private static void b(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            nbt.a(nbtKey, (flags & flag) != 0);
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, IChatBaseComponent.ChatSerializer.a(this.t(), (HolderLookup.a)this.dY()));
            nbt.a(ay, this.u());
            nbt.a(aA, this.w());
            nbt.a(az, this.v());
            byte b2 = this.x();
            TextDisplay.b(b2, nbt, aB, (byte)1);
            TextDisplay.b(b2, nbt, aC, (byte)2);
            TextDisplay.b(b2, nbt, aD, (byte)4);
            Align.d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)TextDisplay.a(b2)).ifSuccess(tag -> nbt.a(aE, (NBTBase)tag));
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.aN = shouldLerp && this.aN != null ? this.a(this.aN, lerpProgress) : this.y();
            this.aM = null;
        }

        @Nullable
        public e s() {
            return this.aN;
        }

        private e y() {
            return new e(this.t(), this.u(), IntInterpolator.constant(this.v()), IntInterpolator.constant(this.w()), this.x());
        }

        private e a(e data, float lerpProgress) {
            int i2 = data.d.get(lerpProgress);
            int j2 = data.c.get(lerpProgress);
            return new e(this.t(), this.u(), new i(j2, this.v()), new ColorInterpolator(i2, this.w()), this.x());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aM == null) {
                this.aM = this.aN != null ? splitter.split(this.aN.a(), this.aN.b()) : new CachedInfo(List.of(), 0);
            }
            return this.aM;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return MathHelper.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = SlotAccess.a(this::t, this::a);
        @Nullable
        private a t;

        public ItemDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(q, ItemStack.j);
            builder.a(r, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (q.equals(data) || r.equals(data)) {
                this.n = true;
            }
        }

        public ItemStack t() {
            return this.al.a(q);
        }

        public void a(ItemStack stack) {
            this.al.a(q, stack);
        }

        public void a(ItemDisplayContext transformationMode) {
            this.al.a(r, transformationMode.a());
        }

        public ItemDisplayContext u() {
            return ItemDisplayContext.k.apply(this.al.a(r).byteValue());
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            if (nbt.e(o)) {
                this.a(ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p(o)).orElse(ItemStack.j));
            } else {
                this.a(ItemStack.j);
            }
            if (nbt.b(p, 8)) {
                ItemDisplayContext.j.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(p)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)o).error(arg_0))).ifPresent(mode -> this.a((ItemDisplayContext)mode.getFirst()));
            }
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            if (!this.t().f()) {
                nbt.a(o, this.t().a(this.dY()));
            }
            ItemDisplayContext.j.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.u()).ifSuccess(nbtx -> nbt.a(p, (NBTBase)nbtx));
        }

        @Override
        public SlotAccess a_(int mappedIndex) {
            return mappedIndex == 0 ? this.s : SlotAccess.a;
        }

        @Nullable
        public a s() {
            return this.t;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            ItemStack itemStack = this.t();
            itemStack.a(this);
            this.t = new a(itemStack, this.u());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return delta -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return ARGB.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        @Nullable
        private a q;

        public BlockDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(p, Blocks.a.m());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (data.equals(p)) {
                this.n = true;
            }
        }

        public IBlockData t() {
            return this.al.a(p);
        }

        public void c(IBlockData state) {
            this.al.a(p, state);
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.c(GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p(o)));
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(o, GameProfileSerializer.a(this.t()));
        }

        @Nullable
        public a s() {
            return this.q;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.q = new a(this.t());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }
}

