/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ScoreHolder,
ChunkSystemEntity,
EntityTrackerEntity {
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    private static final Logger b = LogUtils.getLogger();
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int x = 0;
    public static final int y = 60;
    public static final int z = 300;
    public static final int A = 1024;
    public static final float B = 0.2f;
    public static final double C = 0.500001;
    public static final double D = 0.999999;
    public static final int E = 140;
    public static final int F = 40;
    public static final int G = 3;
    private static final AxisAlignedBB d = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double k = 0.014;
    private static final double l = 0.007;
    private static final double m = 0.0023333333333333335;
    public static final String H = "UUID";
    private static double n = 1.0;
    private final EntityTypes<?> o;
    private int p;
    public boolean I;
    public ImmutableList<Entity> q;
    protected int J;
    @javax.annotation.Nullable
    private Entity r;
    private net.minecraft.world.level.World s;
    public double K;
    public double L;
    public double M;
    private Vec3D t;
    private BlockPosition u;
    private ChunkCoordIntPair ay;
    private Vec3D az;
    private float aA;
    private float aB;
    public float N;
    public float O;
    private AxisAlignedBB aC;
    public boolean aD;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    protected Vec3D U;
    @javax.annotation.Nullable
    private RemovalReason aE;
    public static final float V = 0.6f;
    public static final float W = 1.8f;
    public float X;
    public float Y;
    public float Z;
    private float aF;
    public double aa;
    public double ab;
    public double ac;
    public boolean ad;
    private boolean aG;
    public final RandomSource ae;
    public int af;
    private int aH;
    public boolean ag;
    protected Object2DoubleMap<TagKey<FluidType>> ah;
    protected boolean ai;
    private final Set<TagKey<FluidType>> aI;
    public int aj;
    protected boolean ak;
    protected final DataWatcher al;
    protected static final DataWatcherObject<Byte> am = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int an = 0;
    private static final int aJ = 1;
    private static final int aK = 3;
    private static final int aL = 4;
    public static final int aM = 5;
    protected static final int ao = 6;
    protected static final int ap = 7;
    private static final DataWatcherObject<Integer> aN = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aO = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aP = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aq = DataWatcher.a(Entity.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Integer> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aT;
    private final VecDeltaCodec aU;
    public boolean ar;
    @javax.annotation.Nullable
    public PortalProcessor as;
    public int aV;
    private boolean aW;
    protected UUID at;
    protected String au;
    private boolean aX;
    private final Set<String> aY;
    private final double[] aZ;
    private long ba;
    private EntitySize bb;
    private float bc;
    public boolean av;
    public boolean aw;
    public Optional<BlockPosition> ax;
    private boolean bd;
    private float be;
    private int bf;
    public boolean bg;
    @javax.annotation.Nullable
    private IBlockData bh;
    private final List<b> bi;
    private final Set<IBlockData> bj;
    private final LongSet bk;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @javax.annotation.Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    private final int despawnTime;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private ChunkData chunkData;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private PlayerChunkMap.EntityTracker trackedEntity;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean y_() {
            return ((WorldServer)Entity.this.dW()).N().b(GameRules.p);
        }

        @Override
        public boolean z_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.s.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public float getBukkitYaw() {
        return this.aA;
    }

    public boolean isChunkLoaded() {
        return this.s.b((int)Math.floor(this.dB()) >> 4, (int)Math.floor(this.dH()) >> 4);
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.bb.a(x2, y2, z2);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x2) {
        this.sectionX = x2;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y2) {
        this.sectionY = y2;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z2) {
        this.sectionZ = z2;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.q.isEmpty()) {
            return false;
        }
        return this.F().anyMatch(entity -> entity instanceof EntityHuman);
    }

    private static float[] calculateStepHeights(AxisAlignedBB box, List<VoxelShape> voxels, List<AxisAlignedBB> aabbs, float stepHeight, float collidedY) {
        Object shape;
        int i2;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i2 = 0; i2 < len; ++i2) {
            double yUnoffset;
            double y2;
            float step;
            shape = voxels.get(i2);
            double[] yCoords = shape.moonrise$rootCoordinatesY();
            double yOffset = shape.moonrise$offsetY();
            double[] dArray = yCoords;
            int n2 = dArray.length;
            for (int i3 = 0; i3 < n2 && !((step = (float)((y2 = (yUnoffset = dArray[i3]) + yOffset) - box.b)) > stepHeight); ++i3) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i2 = 0; i2 < len; ++i2) {
            shape = aabbs.get(i2);
            float step1 = (float)(((AxisAlignedBB)shape).b - box.b);
            float step2 = (float)(((AxisAlignedBB)shape).e - box.b);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Override
    public final PlayerChunkMap.EntityTracker moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(PlayerChunkMap.EntityTracker trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.q);
        }
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World world) {
        this.p = c.incrementAndGet();
        this.despawnTime = type == EntityTypes.bS ? -1 : ((IntOr.Disabled)world.paperConfig().entities.spawning.despawnTime.getOrDefault(type, (Object)IntOr.Disabled.DISABLED)).or(-1);
        this.q = ImmutableList.of();
        this.az = Vec3D.c;
        this.aC = d;
        this.U = Vec3D.c;
        this.aF = 1.0f;
        this.ae = SHARED_RANDOM;
        this.aH = -this.do();
        this.ah = new Object2DoubleArrayMap(2);
        this.aI = new HashSet<TagKey<FluidType>>();
        this.ak = true;
        this.aT = EntityInLevelCallback.a;
        this.aU = new VecDeltaCodec();
        this.at = MathHelper.a(this.ae);
        this.au = this.at.toString();
        this.aY = Sets.newHashSet();
        this.aZ = new double[]{0.0, 0.0, 0.0};
        this.ax = Optional.empty();
        this.bd = false;
        this.bh = null;
        this.bi = new ArrayList<b>();
        this.bj = new ReferenceArraySet();
        this.bk = new LongOpenHashSet();
        this.o = type;
        this.s = world;
        this.bb = type.n();
        this.t = Vec3D.c;
        this.u = BlockPosition.c;
        this.ay = ChunkCoordIntPair.e;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        DataWatcher.a datawatcher_a = new DataWatcher.a(this);
        datawatcher_a.a(am, (byte)0);
        datawatcher_a.a(aN, this.cs());
        datawatcher_a.a(aP, false);
        datawatcher_a.a(aO, Optional.empty());
        datawatcher_a.a(aQ, false);
        datawatcher_a.a(aR, false);
        datawatcher_a.a(aq, EntityPose.a);
        datawatcher_a.a(aS, 0);
        this.a(datawatcher_a);
        this.al = datawatcher_a.a();
        this.a_(0.0, 0.0, 0.0);
        this.bc = this.bb.c();
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape = state.b((IBlockAccess)this.dW(), pos, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a(pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cR()), OperatorBoolean.i);
    }

    public int k_() {
        ScoreboardTeam scoreboardteam = this.cr();
        return scoreboardteam != null && scoreboardteam.n().f() != null ? scoreboardteam.n().f() : 0xFFFFFF;
    }

    public boolean aa_() {
        return false;
    }

    public final void ao() {
        if (this.ca()) {
            this.bP();
        }
        if (this.bZ()) {
            this.ae();
        }
    }

    public void f(double x2, double y2, double z2) {
        this.aU.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec ap() {
        return this.aU;
    }

    public EntityTypes<?> aq() {
        return this.o;
    }

    @Override
    public int ar() {
        return this.p;
    }

    public void e(int id) {
        this.p = id;
    }

    public Set<String> as() {
        return this.aY;
    }

    public boolean a(String tag) {
        return this.aY.size() >= 1024 ? false : this.aY.add(tag);
    }

    public boolean b(String tag) {
        return this.aY.remove(tag);
    }

    public void c(WorldServer world) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void at() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher au() {
        return this.al;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.al.packAll();
        if (list != null && to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.f.b(new PacketPlayOutEntityMetadata(this.ar(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(EntityPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            PlayerChunkMap.EntityTracker tracker;
            WorldServer world = (WorldServer)this.dW();
            PlayerChunkMap.EntityTracker entityTracker = tracker = world == null ? null : (PlayerChunkMap.EntityTracker)world.m().a.K.get(this.ar());
            if (tracker == null) {
                return;
            }
            EntityTrackerEntry serverEntity = tracker.b;
            ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
            serverEntity.a(player, list::add);
            player.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<DataWatcherObject<?>> keys, EntityPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (DataWatcherObject<?> key : keys) {
            DataWatcher.Item<?> synchedValue = this.al.b(key);
            values.add(synchedValue.e());
        }
        to.f.b(new PacketPlayOutEntityMetadata(this.p, values));
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).p == this.p : false;
    }

    public int hashCode() {
        return this.p;
    }

    public void a(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void av() {
    }

    public void b(RemovalReason reason) {
    }

    public void b(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.aw()) {
            return;
        }
        if (!this.generation) {
            this.s.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        }
        this.al.a(aq, pose);
    }

    public EntityPose aw() {
        return this.al.a(aq);
    }

    public boolean c(EntityPose pose) {
        return this.aw() == pose;
    }

    public boolean a(Entity entity, double radius) {
        return this.du().a((IPosition)entity.du(), radius);
    }

    public boolean a(Entity entity, double horizontalRadius, double verticalRadius) {
        double d2 = entity.dB() - this.dB();
        double d3 = entity.dD() - this.dD();
        double d4 = entity.dH() - this.dH();
        return MathHelper.e(d2, d4) < MathHelper.k(horizontalRadius) && MathHelper.k(d3) < MathHelper.k(verticalRadius);
    }

    public void b(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.s.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.v(yaw % 360.0f);
        this.w(pitch % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.a_(pos.a(), pos.b(), pos.c());
    }

    public void a_(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected AxisAlignedBB ax() {
        return this.bb.a(this.t);
    }

    protected void ay() {
        this.a_(this.t.d, this.t.e, this.t.f);
    }

    public void b(double cursorDeltaX, double cursorDeltaY) {
        float f2 = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.w(this.dO() + f2);
        this.v(this.dM() + f1);
        this.w(MathHelper.a(this.dO(), -90.0f, 90.0f));
        this.O += f2;
        this.N += f1;
        this.O = MathHelper.a(this.O, -90.0f, 90.0f);
        if (this.r != null) {
            this.r.k(this);
        }
    }

    public void h() {
        if (this.despawnTime >= 0 && this.af >= this.despawnTime) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
        this.az();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bL()) {
            this.bW();
        }
    }

    public void az() {
        WorldServer worldserver;
        Entity entity;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("entityBaseTick");
        if (this.ak && (entity = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)((Object)entity);
            neutralMob.tickInitialPersistentAnger(this.s);
        }
        this.bh = null;
        if (this.bZ() && this.dl().dR()) {
            this.ae();
        }
        if (this.J > 0) {
            --this.J;
        }
        if (this instanceof EntityPlayer) {
            this.bW();
        }
        if (this.bv()) {
            this.bw();
        }
        this.aw = this.av;
        this.av = false;
        this.bq();
        this.D();
        this.bp();
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            if (this.aH > 0) {
                if (this.bi()) {
                    this.h(this.aH - 4);
                    if (this.aH < 0) {
                        this.aH();
                    }
                } else {
                    if (this.aH % 20 == 0 && !this.bx()) {
                        this.a(worldserver, this.dX().d(), 1.0f);
                    }
                    this.h(this.aH - 1);
                }
                if (this.cu() > 0 && !this.freezeLocked) {
                    this.k(0);
                    this.dW().a((EntityHuman)null, 1009, this.u, 1);
                }
            }
        } else {
            this.aH();
        }
        if (this.bx()) {
            this.aE();
            this.Z *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.aA();
        if (!this.dW().C) {
            this.c(this.aH > 0);
        }
        this.ak = false;
        world = this.dW();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            if (this instanceof Leashable) {
                Leashable.a_(worldserver, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        gameprofilerfiller.c();
    }

    public void c(boolean onFire) {
        this.b(0, onFire || this.bg);
    }

    public void aA() {
        block5: {
            block4: {
                if (!this.s.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.dD() < (double)this.s.L_() + this.s.getWorld().getVoidDamageMinBuildHeightOffset()) break block4;
                if (this.s.getWorld().getEnvironment() != World.Environment.NETHER || !this.s.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dD() >= (double)v2)) break block5;
                Entity entity = this;
                if (!(entity instanceof EntityHuman)) break block4;
                EntityHuman player = (EntityHuman)entity;
                if (player.gj().a) break block5;
            }
            this.aI();
        }
    }

    public void aB() {
        this.aV = this.bX();
    }

    public void f(int portalCooldown) {
        this.aV = portalCooldown;
    }

    public int aC() {
        return this.aV;
    }

    public boolean aD() {
        return this.aV > 0;
    }

    protected void M() {
        if (this.aD()) {
            --this.aV;
        }
    }

    public void aE() {
        if (!this.bi()) {
            WorldServer worldserver;
            if (this instanceof EntityLiving && this.aH <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.s, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.s.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
            net.minecraft.world.level.World world = this.dW();
            if (world instanceof WorldServer && this.a(worldserver = (WorldServer)world, this.dX().e().directBlock(this.s, this.lastLavaContact), 4.0f) && this.aF() && !this.bb()) {
                worldserver.a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.ku, this.dn(), 0.4f, 2.0f + this.ae.i() * 0.4f);
            }
        }
    }

    protected boolean aF() {
        return true;
    }

    public final void d(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.g(MathHelper.d(f2 * 20.0f));
    }

    public void g(int ticks) {
        if (this.aH < ticks) {
            this.h(ticks);
        }
    }

    public void h(int fireTicks) {
        this.aH = fireTicks;
    }

    public int aG() {
        return this.aH;
    }

    public void aH() {
        this.h(0);
    }

    protected void aI() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean g(double offsetX, double offsetY, double offsetZ) {
        return this.b(this.cR().d(offsetX, offsetY, offsetZ));
    }

    private boolean b(AxisAlignedBB box) {
        return this.dW().a(this, box) && !this.dW().d(box);
    }

    public void d(boolean onGround) {
        this.aD = onGround;
        this.a(onGround, (Vec3D)null);
    }

    public void a(boolean onGround, boolean horizontalCollision, Vec3D movement) {
        this.aD = onGround;
        this.P = horizontalCollision;
        this.a(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.ax.isPresent() && this.ax.get().equals(pos);
    }

    protected void a(boolean onGround, @javax.annotation.Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB axisalignedbb = this.cR();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.s.h(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bd) {
                if (movement != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-movement.d, 0.0, -movement.f);
                    optional = this.s.h(this, axisalignedbb2);
                    this.ax = optional;
                }
            } else {
                this.ax = optional;
            }
            this.bd = optional.isEmpty();
        } else {
            this.bd = false;
            if (this.ax.isPresent()) {
                this.ax = Optional.empty();
            }
        }
    }

    public boolean aJ() {
        return this.aD;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType type, Vec3D movement) {
        Vec3D originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dB();
            this.moveStartY = this.dD();
            this.moveStartZ = this.dH();
            this.moveVector = movement;
        }
        try {
            if (this.ad) {
                this.a_(this.dB() + movement.d, this.dD() + movement.e, this.dH() + movement.f);
            } else {
                this.aG = this.bY();
                if (type == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.d(movement)).equals(Vec3D.c)) {
                        return;
                    }
                }
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a("move");
                if (this.U.h() > 1.0E-7) {
                    movement = movement.h(this.U);
                    this.U = Vec3D.c;
                    this.h(Vec3D.c);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && movement == this.dz() && type == EnumMoveType.a) {
                    this.h(Vec3D.c);
                    gameprofilerfiller.c();
                    return;
                }
                Vec3D vec3d1 = this.a(movement = this.a(movement, type));
                double d0 = vec3d1.h();
                if (d0 > 1.0E-7 || movement.h() - d0 < 1.0E-7) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    if (this.Z != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.dW().a(new RayTrace(this.du(), this.du().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).d() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.k();
                    }
                    this.a_(this.dB() + vec3d1.d, this.dD() + vec3d1.e, this.dH() + vec3d1.f);
                }
                gameprofilerfiller.c();
                gameprofilerfiller.a("rest");
                boolean flag = !MathHelper.b(movement.d, vec3d1.d);
                boolean flag1 = !MathHelper.b(movement.f, vec3d1.f);
                this.P = flag || flag1;
                this.Q = movement.e != vec3d1.e;
                this.R = this.Q && movement.e < 0.0;
                this.S = this.P ? this.c(vec3d1) : false;
                this.a(this.R, this.P, vec3d1);
                BlockPosition blockposition = this.aP();
                IBlockData iblockdata = this.dW().a_(blockposition);
                if (!this.dW().B_() || this.di()) {
                    this.a(vec3d1.e, this.aJ(), iblockdata, blockposition);
                }
                if (this.dR()) {
                    gameprofilerfiller.c();
                } else {
                    MovementEmission entity_movementemission;
                    if (this.P) {
                        Vec3D vec3d2 = this.dz();
                        this.n(flag ? 0.0 : vec3d2.d, vec3d2.e, flag1 ? 0.0 : vec3d2.f);
                    }
                    if (this.di()) {
                        Block block = iblockdata.b();
                        if (movement.e != vec3d1.e) {
                            block.a(this.dW(), this);
                        }
                    }
                    if (this.P && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.s.getWorld().getBlockAt(MathHelper.a(this.dB()), MathHelper.a(this.dD()), MathHelper.a(this.dH()));
                        if (movement.d > vec3d1.d) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.d < vec3d1.d) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.f > vec3d1.f) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.f < vec3d1.f) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl, CraftVector.toBukkit(originalMovement));
                            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if ((!this.dW().B_() || this.di()) && (entity_movementemission = this.bg()).a() && !this.bZ()) {
                        this.a(entity_movementemission, vec3d1, blockposition, iblockdata);
                    }
                    float f2 = this.aT();
                    this.h(this.dz().d(f2, 1.0, f2));
                    gameprofilerfiller.c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private void a(MovementEmission moveEffect, Vec3D movement, BlockPosition landingPos, IBlockData landingState) {
        float f2 = 0.6f;
        float f1 = (float)(movement.g() * (double)0.6f);
        float f22 = (float)(movement.i() * (double)0.6f);
        BlockPosition blockposition1 = this.aR();
        IBlockData iblockdata1 = this.dW().a_(blockposition1);
        boolean flag = this.c(iblockdata1);
        this.X += flag ? f1 : f22;
        this.Y += f1;
        if (this.X > this.aF && !iblockdata1.l()) {
            boolean flag1 = blockposition1.equals(landingPos);
            boolean flag2 = this.a(landingPos, landingState, moveEffect.c(), flag1, movement);
            if (!flag1) {
                flag2 |= this.a(blockposition1, iblockdata1, false, moveEffect.b(), movement);
            }
            if (flag2) {
                this.aF = this.aU();
            } else if (this.bj()) {
                this.aF = this.aU();
                if (moveEffect.c()) {
                    this.aY();
                }
                if (moveEffect.b()) {
                    this.a(GameEvent.Q);
                }
            }
        } else if (iblockdata1.l()) {
            this.aO();
        }
    }

    public void aK() {
        this.a(this.bC(), this.t);
    }

    public void a(Vec3D lastRenderPos, Vec3D pos) {
        if (this.aL()) {
            if (this.aJ()) {
                BlockPosition blockposition = this.aP();
                IBlockData iblockdata = this.dW().a_(blockposition);
                iblockdata.b().a(this.dW(), blockposition, iblockdata, this);
            }
            this.bi.add(new b(lastRenderPos, pos));
            this.a(this.bi, this.bj);
            boolean flag = Iterables.any(this.bj, iblockdata1 -> iblockdata1.a(TagsBlock.aN) || iblockdata1.a(Blocks.K));
            this.bi.clear();
            this.bj.clear();
            if (!flag && this.bL()) {
                if (this.aH <= 0) {
                    this.h(-this.do());
                }
                if (this.aG && (this.av || this.bl())) {
                    this.aM();
                }
            }
            if (this.bY() && (this.av || this.bl())) {
                this.h(-this.do());
            }
        }
    }

    protected boolean aL() {
        return !this.dR() && !this.ad;
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.aS) || state.a(Blocks.rk);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playSound, boolean emitEvent, Vec3D movement) {
        if (state.l()) {
            return false;
        }
        boolean flag2 = this.c(state);
        if ((this.aJ() || flag2 || this.ci() && movement.e == 0.0 || this.cq()) && !this.ck()) {
            if (playSound) {
                this.c(pos, state);
            }
            if (emitEvent) {
                this.dW().a(GameEvent.P, this.du(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean c(Vec3D adjustedMovement) {
        return false;
    }

    protected void aM() {
        this.a(SoundEffects.kz, 0.7f, 1.6f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    public void aN() {
        if (!this.dW().C && this.aG) {
            this.aM();
        }
        this.aH();
    }

    protected void aO() {
        if (this.ba()) {
            this.aZ();
            if (this.bg().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aP() {
        return this.e(0.2f);
    }

    public BlockPosition aQ() {
        return this.e(0.500001f);
    }

    public BlockPosition aR() {
        return this.e(1.0E-5f);
    }

    protected BlockPosition e(float offset) {
        if (this.ax.isPresent() && this.dW().getChunkIfLoadedImmediately(this.ax.get()) != null) {
            BlockPosition blockposition = this.ax.get();
            if (offset <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dW().a_(blockposition);
            return ((double)offset > 0.5 || !iblockdata.a(TagsBlock.U)) && !iblockdata.a(TagsBlock.N) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.t.e - (double)offset)) : blockposition;
        }
        int i2 = MathHelper.a(this.t.d);
        int j2 = MathHelper.a(this.t.e - (double)offset);
        int k2 = MathHelper.a(this.t.f);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aS() {
        float f2 = this.dW().a_(this.dw()).b().k();
        float f1 = this.dW().a_(this.aQ()).b().k();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aT() {
        IBlockData iblockdata = this.dW().a_(this.dw());
        float f2 = iblockdata.b().h();
        return !iblockdata.a(Blocks.J) && !iblockdata.a(Blocks.ny) ? ((double)f2 == 1.0 ? this.dW().a_(this.aQ()).b().h() : f2) : f2;
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D d(Vec3D movement) {
        if (movement.h() <= 1.0E-7) {
            return movement;
        }
        long i2 = this.dW().ac();
        if (i2 != this.ba) {
            Arrays.fill(this.aZ, 0.0);
            this.ba = i2;
        }
        if (movement.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, movement.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d0, 0.0, 0.0);
        }
        if (movement.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, movement.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d0, 0.0);
        }
        if (movement.f != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, movement.f);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis axis, double offsetFactor) {
        int i2 = axis.ordinal();
        double d1 = MathHelper.a(offsetFactor + this.aZ[i2], -0.51, 0.51);
        offsetFactor = d1 - this.aZ[i2];
        this.aZ[i2] = d1;
        return offsetFactor;
    }

    private Vec3D a(Vec3D movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3D collided;
        ArrayList<AxisAlignedBB> entityAABBs;
        AxisAlignedBB currentBox;
        block7: {
            block6: {
                double d2;
                boolean zZero;
                boolean xZero = movement.d == 0.0;
                boolean yZero = movement.e == 0.0;
                boolean bl = zZero = movement.f == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.cR();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AxisAlignedBB> potentialCollisionsBB = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB initialCollisionBox = xZero & zZero ? (movement.e < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.e) : CollisionUtil.cutUpwards(currentBox, movement.e)) : currentBox.b(movement);
                entityAABBs = new ArrayList<AxisAlignedBB>();
                CollisionUtil.getEntityHardCollisions(this.s, this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.s, this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.d != movement.d;
                boolean collidedY = collided.e != movement.e;
                boolean collidedZ = collided.f != movement.f;
                boolean bl2 = collidedDownwards = collidedY && movement.e < 0.0;
                if (!collidedDownwards && !this.aD || !collidedX && !collidedZ) break block6;
                stepHeight = this.dQ();
                if (!(d2 <= 0.0)) break block7;
            }
            return collided;
        }
        AxisAlignedBB collidedYBox = collidedDownwards ? currentBox.d(0.0, collided.e, 0.0) : currentBox;
        AxisAlignedBB stepRetrievalBox = collidedYBox.b(movement.d, stepHeight, movement.f);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.b(0.0, -1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AxisAlignedBB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.s, this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : Entity.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.e)) {
            Vec3D stepResult = CollisionUtil.performCollisions(new Vec3D(movement.d, step, movement.f), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.j() > collided.j())) continue;
            return stepResult.b(0.0, collidedYBox.b - currentBox.b, 0.0);
        }
        return collided;
    }

    private static float[] a(AxisAlignedBB collisionBox, List<VoxelShape> collisions, float f2, float stepHeight) {
        FloatArraySet floatarrayset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : collisions) {
            DoubleList doublelist = voxelshape.a(EnumDirection.EnumAxis.b);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f22 = (float)(d0 - collisionBox.b);
                if (!(f22 >= 0.0f) || f22 == stepHeight) continue;
                if (f22 > f2) continue block0;
                floatarrayset.add(f22);
            }
        }
        float[] afloat = floatarrayset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3D a(@javax.annotation.Nullable Entity entity, Vec3D movement, AxisAlignedBB entityBoundingBox, net.minecraft.world.level.World world, List<VoxelShape> collisions) {
        List<VoxelShape> list1 = Entity.a(entity, world, collisions, entityBoundingBox.b(movement));
        return Entity.a(movement, entityBoundingBox, list1);
    }

    private static List<VoxelShape> a(@javax.annotation.Nullable Entity entity, net.minecraft.world.level.World world, List<VoxelShape> regularCollisions, AxisAlignedBB movingEntityBoundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(regularCollisions.size() + 1));
        if (!regularCollisions.isEmpty()) {
            builder.addAll(regularCollisions);
        }
        WorldBorder worldborder = world.F_();
        boolean bl = flag = entity != null && worldborder.a(entity, movingEntityBoundingBox);
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.e(entity, movingEntityBoundingBox));
        return builder.build();
    }

    private static Vec3D a(Vec3D movement, AxisAlignedBB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.d;
        double d1 = movement.e;
        double d2 = movement.f;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aU() {
        return (int)this.X + 1;
    }

    protected SoundEffect aV() {
        return SoundEffects.kD;
    }

    protected SoundEffect aW() {
        return SoundEffects.kC;
    }

    protected SoundEffect aX() {
        return SoundEffects.kC;
    }

    public SoundEffect getSwimSound0() {
        return this.aV();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aW();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aX();
    }

    public void b(Vec3D oldPos, Vec3D newPos) {
        this.bi.add(new b(oldPos, newPos));
    }

    private void a(List<b> queuedCollisionChecks, Set<IBlockData> collidedBlocks) {
        if (this.aL()) {
            AxisAlignedBB axisalignedbb = this.cR().h(1.0E-5f);
            LongSet longset = this.bk;
            for (b entity_b : queuedCollisionChecks) {
                Vec3D vec3d = entity_b.a();
                Vec3D vec3d1 = entity_b.b();
                for (BlockPosition blockposition : IBlockAccess.a(vec3d, vec3d1, axisalignedbb)) {
                    if (!this.bL()) {
                        return;
                    }
                    IBlockData iblockdata = this.dW().a_(blockposition);
                    if (iblockdata.l() || !longset.add(blockposition.a())) continue;
                    try {
                        VoxelShape voxelshape = iblockdata.b(this.dW(), blockposition);
                        if (voxelshape != VoxelShapes.b() && !this.a(vec3d, vec3d1, blockposition, voxelshape)) continue;
                        iblockdata.a(this.dW(), blockposition, this);
                        this.a(iblockdata);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                        CrashReportSystemDetails.a(crashreportsystemdetails, this.dW(), blockposition, iblockdata);
                        CrashReportSystemDetails crashreportsystemdetails1 = crashreport.a("Entity being checked for collision");
                        this.a(crashreportsystemdetails1);
                        throw new ReportedException(crashreport);
                    }
                    collidedBlocks.add(iblockdata);
                }
            }
            longset.clear();
        }
    }

    private boolean a(Vec3D oldPos, Vec3D newPos, BlockPosition blockPos, VoxelShape shape) {
        AxisAlignedBB axisalignedbb = this.cR().c(this.cR().f().c(-1.0)).c(newPos);
        Vec3D vec3d2 = oldPos.d(axisalignedbb.g());
        return this.cR().a(vec3d2, shape.a(new Vec3D(blockPos)).e());
    }

    protected void a(IBlockData state) {
    }

    public BlockPosition a(WorldServer world, BlockPosition basePos) {
        BlockPosition blockposition1 = world.Y();
        Vec3D vec3d = blockposition1.b();
        int i2 = world.m(blockposition1).a(HeightMap.Type.f, blockposition1.u(), blockposition1.w()) + 1;
        return BlockPosition.a(vec3d.d, (double)i2, vec3d.f);
    }

    public void a(Holder<GameEvent> event, @javax.annotation.Nullable Entity entity) {
        this.dW().a(entity, event, this.t);
    }

    public void a(Holder<GameEvent> event) {
        this.a(event, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.m();
        }
    }

    protected void aY() {
        Entity entity = Objects.requireNonNullElse(this.cX(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.dz();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.d * vec3d.d * (double)0.2f + vec3d.e * vec3d.e + vec3d.f * vec3d.f * (double)0.2f) * f2);
        this.f(f1);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockposition1 = pos.d();
        IBlockData iblockdata = this.dW().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bp) && !iblockdata.a(TagsBlock.bq) ? pos : blockposition1;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundeffecttype = primaryState.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundeffecttype = state.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundeffecttype = state.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.bo) && this.af >= this.bf + 20;
    }

    private void m() {
        this.be *= (float)Math.pow(0.997, this.af - this.bf);
        this.be = Math.min(1.0f, this.be + 0.07f);
        float f2 = 0.5f + this.be * this.ae.i() * 1.2f;
        float f1 = 0.1f + this.be * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bf = this.af;
    }

    protected void f(float volume) {
        this.a(this.aV(), volume, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    protected void aZ() {
    }

    protected boolean ba() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.bb()) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), sound, this.dn(), volume, pitch);
        }
    }

    public void a(SoundEffect event) {
        if (!this.bb()) {
            this.a(event, 1.0f, 1.0f);
        }
    }

    public boolean bb() {
        return this.al.a(aQ);
    }

    public void e(boolean silent) {
        this.al.a(aQ, silent);
    }

    public boolean bc() {
        return this.al.a(aR);
    }

    public void f(boolean noGravity) {
        this.al.a(aR, noGravity);
    }

    protected double bd() {
        return 0.0;
    }

    public final double be() {
        return this.bc() ? 0.0 : this.bd();
    }

    protected void bf() {
        double d0 = this.be();
        if (d0 != 0.0) {
            this.h(this.dz().b(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission bg() {
        return MovementEmission.d;
    }

    public boolean bh() {
        return false;
    }

    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (onGround) {
            if (this.Z > 0.0f) {
                state.b().a(this.dW(), state, landedPosition, this, this.Z);
                this.dW().a(GameEvent.A, this.t, GameEvent.a.a(this, this.ax.map(blockposition1 -> this.dW().a_((BlockPosition)blockposition1)).orElse(state)));
            }
            this.k();
        } else if (heightDifference < 0.0) {
            this.Z -= (float)heightDifference;
        }
    }

    public boolean bi() {
        return this.aq().d();
    }

    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.o.a(TagsEntity.o)) {
            return false;
        }
        if (this.ca()) {
            for (Entity entity : this.cZ()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean bj() {
        return this.ag;
    }

    public boolean isInRain0() {
        BlockPosition blockposition = this.dw();
        return this.dW().r(blockposition) || this.dW().r(BlockPosition.a((double)blockposition.u(), this.cR().e, (double)blockposition.w()));
    }

    public boolean u() {
        return this.dx().a(Blocks.ny);
    }

    public boolean bk() {
        return this.bj() || this.isInRain0();
    }

    public boolean bl() {
        return this.bj() || this.isInRain0() || this.u();
    }

    public boolean bm() {
        return this.bj() || this.u();
    }

    public boolean bn() {
        return this.bm() || this.bx();
    }

    public boolean bo() {
        return this.ai && this.bj();
    }

    public void bp() {
        if (this.ck()) {
            this.i(this.cj() && this.bj() && !this.bZ());
        } else {
            this.i(this.cj() && this.bo() && !this.bZ() && this.dW().b_(this.u).a(TagsFluid.a));
        }
    }

    protected boolean bq() {
        this.ah.clear();
        this.br();
        double d0 = this.dW().G_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.bj() || flag;
    }

    void br() {
        AbstractBoat abstractboat;
        Entity entity = this.dl();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bo()) {
            this.ag = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ag && !this.ak) {
                this.bs();
            }
            this.k();
            this.ag = true;
            this.aH();
        } else {
            this.ag = false;
        }
    }

    private void D() {
        AbstractBoat abstractboat;
        this.ai = this.a(TagsFluid.a);
        this.aI.clear();
        double d0 = this.dF();
        Entity entity = this.dl();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bo() && abstractboat.cR().e >= d0 && abstractboat.cR().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dB(), d0, this.dH());
        Fluid fluid = this.dW().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a(this.dW(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aI;
            Objects.requireNonNull(this.aI);
            stream.forEach(set::add);
        }
    }

    protected void bs() {
        double d1;
        double d0;
        Entity entity = Objects.requireNonNullElse(this.cX(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.dz();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.d * vec3d.d * (double)0.2f + vec3d.e * vec3d.e + vec3d.f * vec3d.f * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aW(), f1, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        } else {
            this.a(this.aX(), f1, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dD());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bb.a() * 20.0f) {
            d0 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            this.dW().a(Particles.d, this.dB() + d0, (double)(f22 + 1.0f), this.dH() + d1, vec3d.d, vec3d.e - this.ae.j() * (double)0.2f, vec3d.f);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bb.a() * 20.0f) {
            d0 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.bb.a();
            this.dW().a(Particles.an, this.dB() + d0, (double)(f22 + 1.0f), this.dH() + d1, vec3d.d, vec3d.e, vec3d.f);
            ++i2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bt() {
        return this.dW().a_(this.aP());
    }

    public IBlockData bu() {
        return this.dW().a_(this.aR());
    }

    public boolean bv() {
        return this.cj() && !this.bj() && !this.aa_() && !this.ci() && !this.bx() && this.bL();
    }

    protected void bw() {
        BlockPosition blockposition = this.aP();
        IBlockData iblockdata = this.dW().a_(blockposition);
        if (iblockdata.o() != EnumRenderType.a) {
            Vec3D vec3d = this.dz();
            BlockPosition blockposition1 = this.dw();
            double d0 = this.dB() + (this.ae.j() - 0.5) * (double)this.bb.a();
            double d1 = this.dH() + (this.ae.j() - 0.5) * (double)this.bb.a();
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dW().a(new ParticleParamBlock(Particles.b, iblockdata), d0, this.dD() + 0.1, d1, vec3d.d * -4.0, 1.5, vec3d.f * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aI.contains(fluidTag);
    }

    public boolean bx() {
        return !this.ak && this.ah.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float speed, Vec3D movementInput) {
        Vec3D vec3d1 = Entity.a(movementInput, speed, this.dM());
        this.h(this.dz().e(vec3d1));
    }

    protected static Vec3D a(Vec3D movementInput, float speed, float yaw) {
        double d0 = movementInput.h();
        if (d0 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? movementInput.d() : movementInput).c((double)speed);
        float f2 = MathHelper.a(yaw * ((float)Math.PI / 180));
        float f3 = MathHelper.b(yaw * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.d * (double)f3 - vec3d1.f * (double)f2, vec3d1.e, vec3d1.f * (double)f3 + vec3d1.d * (double)f2);
    }

    @Deprecated
    public float by() {
        return this.dW().f(this.dA(), this.dG()) ? this.dW().x(BlockPosition.a(this.dB(), this.dF(), this.dH())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.h(x2, y2, z2);
        this.c(yaw, pitch);
    }

    public void c(float yaw, float pitch) {
        this.v(yaw % 360.0f);
        this.w(MathHelper.a(pitch, -90.0f, 90.0f) % 360.0f);
        this.N = this.dM();
        this.O = this.dO();
        this.q(yaw);
    }

    public void h(double x2, double y2, double z2) {
        double d3 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.K = d3;
        this.L = y2;
        this.M = d4;
        this.a_(d3, y2, d4);
        if (this.valid) {
            this.s.d((int)Math.floor(this.dB()) >> 4, (int)Math.floor(this.dH()) >> 4);
        }
    }

    public void e(Vec3D pos) {
        this.e(pos.d, pos.e, pos.f);
    }

    public void e(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dM(), this.dO());
    }

    public void a(BlockPosition pos, float yaw, float pitch) {
        this.b(pos.c(), yaw, pitch);
    }

    public void b(Vec3D pos, float yaw, float pitch) {
        this.b(pos.d, pos.e, pos.f, yaw, pitch);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.az = Vec3D.c;
        } else {
            this.preserveMotion = false;
        }
        this.o(x2, y2, z2);
        this.v(yaw);
        this.w(pitch);
        this.bz();
        this.ay();
        this.q(yaw);
    }

    public final void bz() {
        this.bA();
        this.bB();
    }

    public final void c(Vec3D pos, float yaw, float pitch) {
        this.j(pos);
        this.f(yaw, pitch);
    }

    protected void bA() {
        this.j(this.t);
    }

    public void bB() {
        this.f(this.dM(), this.dO());
    }

    private void j(Vec3D pos) {
        this.K = this.aa = pos.d;
        this.L = this.ab = pos.e;
        this.M = this.ac = pos.f;
    }

    private void f(float prevYaw, float prevPitch) {
        this.N = prevYaw;
        this.O = prevPitch;
    }

    public final Vec3D bC() {
        return new Vec3D(this.aa, this.ab, this.ac);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dB() - entity.dB());
        float f1 = (float)(this.dD() - entity.dD());
        float f22 = (float)(this.dH() - entity.dH());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double x2, double y2, double z2) {
        double d3 = this.dB() - x2;
        double d4 = this.dD() - y2;
        double d5 = this.dH() - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double g(Entity entity) {
        return this.f(entity.du());
    }

    public double f(Vec3D vector) {
        double d0 = this.dB() - vector.d;
        double d1 = this.dD() - vector.e;
        double d2 = this.dH() - vector.f;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void a_(EntityHuman player) {
    }

    public void h(Entity entity) {
        if (!(this.z(entity) || entity.ad || this.ad)) {
            double d1;
            if (this.s.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d0 = entity.dB() - this.dB();
            double d2 = MathHelper.a(d0, d1 = entity.dH() - this.dH());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.ca() && this.bI()) {
                    this.j(-d0, 0.0, -d1);
                }
                if (!entity.ca() && entity.bI()) {
                    entity.j(d0, 0.0, d1);
                }
            }
        }
    }

    public void g(Vec3D velocity) {
        this.j(velocity.d, velocity.e, velocity.f);
    }

    public void j(double deltaX, double deltaY, double deltaZ) {
        this.push(deltaX, deltaY, deltaZ, null);
    }

    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(deltaX, deltaY, deltaZ);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.h(this.dz().b(delta.getX(), delta.getY(), delta.getZ()));
        this.ar = true;
    }

    protected void bD() {
        this.T = true;
    }

    @Deprecated
    public final void a(DamageSource source, float amount) {
        net.minecraft.world.level.World world = this.s;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, source, amount);
        }
    }

    @Deprecated
    public final boolean b(DamageSource source, float amount) {
        net.minecraft.world.level.World world = this.s;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return this.a(worldserver, source, amount);
        }
        return this.b(source);
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource source) {
        return false;
    }

    public final Vec3D g(float tickDelta) {
        return this.d(this.h(tickDelta), this.i(tickDelta));
    }

    public EnumDirection bE() {
        return EnumDirection.a(this.g(1.0f));
    }

    public float h(float tickDelta) {
        return this.j(tickDelta);
    }

    public float i(float tickDelta) {
        return this.k(tickDelta);
    }

    public float j(float tickDelta) {
        return tickDelta == 1.0f ? this.dO() : MathHelper.h(tickDelta, this.O, this.dO());
    }

    public float k(float tickDelta) {
        return tickDelta == 1.0f ? this.dM() : MathHelper.i(tickDelta, this.N, this.dM());
    }

    public final Vec3D d(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f2);
        float f7 = MathHelper.a(f2);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D l(float tickDelta) {
        return this.e(this.h(tickDelta), this.i(tickDelta));
    }

    protected final Vec3D e(float pitch, float yaw) {
        return this.d(pitch - 90.0f, yaw);
    }

    public final Vec3D bF() {
        return new Vec3D(this.dB(), this.dF(), this.dH());
    }

    public final Vec3D m(float tickDelta) {
        double d0 = MathHelper.d((double)tickDelta, this.K, this.dB());
        double d1 = MathHelper.d((double)tickDelta, this.L, this.dD()) + (double)this.cS();
        double d2 = MathHelper.d((double)tickDelta, this.M, this.dH());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D n(float tickDelta) {
        return this.m(tickDelta);
    }

    public final Vec3D o(float delta) {
        double d0 = MathHelper.d((double)delta, this.K, this.dB());
        double d1 = MathHelper.d((double)delta, this.L, this.dD());
        double d2 = MathHelper.d((double)delta, this.M, this.dH());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3D vec3d = this.m(tickDelta);
        Vec3D vec3d1 = this.g(tickDelta);
        Vec3D vec3d2 = vec3d.b(vec3d1.d * maxDistance, vec3d1.e * maxDistance, vec3d1.f * maxDistance);
        return this.dW().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bG() {
        return this.bL() && this.bH();
    }

    public boolean bH() {
        return false;
    }

    public boolean bI() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bI();
    }

    public void a(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean k(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.dB() - cameraX;
        double d4 = this.dD() - cameraY;
        double d5 = this.dH() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double distance) {
        double d1 = this.cR().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * n) * d1;
    }

    public boolean d(NBTTagCompound nbt) {
        return this.saveAsPassenger(nbt, true);
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (this.aE != null && !this.aE.b()) {
            return false;
        }
        String s2 = this.bK();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.a(v, s2);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean serializeEntity(NBTTagCompound compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.cZ());
        this.q = ImmutableList.of();
        boolean result = this.e(compound);
        this.q = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean e(NBTTagCompound nbt) {
        return this.bZ() ? false : this.d(nbt);
    }

    public NBTTagCompound f(NBTTagCompound nbt) {
        return this.saveWithoutId(nbt, true);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound, boolean includeAll) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (includeAll) {
                if (this.r != null) {
                    nbttagcompound.a("Pos", this.a(new double[]{this.r.dB(), this.dD(), this.r.dH()}));
                } else {
                    nbttagcompound.a("Pos", this.a(new double[]{this.dB(), this.dD(), this.dH()}));
                }
            }
            Vec3D vec3d = this.dz();
            nbttagcompound.a("Motion", this.a(new double[]{vec3d.d, vec3d.e, vec3d.f}));
            if (Float.isNaN(this.aA)) {
                this.aA = 0.0f;
            }
            if (Float.isNaN(this.aB)) {
                this.aB = 0.0f;
            }
            nbttagcompound.a("Rotation", this.a(new float[]{this.dM(), this.dO()}));
            nbttagcompound.a("FallDistance", this.Z);
            nbttagcompound.a("Fire", (short)this.aH);
            nbttagcompound.a("Air", (short)this.ct());
            nbttagcompound.a("OnGround", this.aJ());
            nbttagcompound.a("Invulnerable", this.aW);
            nbttagcompound.a("PortalCooldown", this.aV);
            if (includeAll) {
                nbttagcompound.a(H, this.cG());
                nbttagcompound.a("WorldUUIDLeast", ((WorldServer)this.s).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.a("WorldUUIDMost", ((WorldServer)this.s).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.a("Bukkit.MaxAirSupply", this.cs());
            }
            nbttagcompound.a("Spigot.ticksLived", this.af);
            IChatBaseComponent ichatbasecomponent = this.an();
            if (ichatbasecomponent != null) {
                nbttagcompound.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent, (HolderLookup.a)this.dY()));
            }
            if (this.cL()) {
                nbttagcompound.a("CustomNameVisible", this.cL());
            }
            if (this.bb()) {
                nbttagcompound.a("Silent", this.bb());
            }
            if (this.bc()) {
                nbttagcompound.a("NoGravity", this.bc());
            }
            if (this.aX) {
                nbttagcompound.a("Glowing", true);
            }
            if ((i2 = this.cu()) > 0) {
                nbttagcompound.a("TicksFrozen", this.cu());
            }
            if (this.bg) {
                nbttagcompound.a("HasVisualFire", this.bg);
            }
            if (!this.aY.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.aY) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbttagcompound.a("Tags", nbttaglist);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.ca()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cZ()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new NBTTagCompound(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.a(w, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.s != null ? this.s.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbttagcompound.a("Paper.OriginWorld", originWorld);
                }
                nbttagcompound.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                nbttagcompound.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbttagcompound.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbttagcompound.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbttagcompound.a("Paper.FreezeLock", true);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbt) {
        try {
            NBTTagList originTag;
            NBTTagList nbttaglist = nbt.c("Pos", 6);
            NBTTagList nbttaglist1 = nbt.c("Motion", 6);
            NBTTagList nbttaglist2 = nbt.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.n(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            this.ar = true;
            double d3 = 3.0000512E7;
            this.o(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.v(nbttaglist2.i(0));
            this.w(nbttaglist2.i(1));
            this.bz();
            this.q(this.dM());
            this.r(this.dM());
            this.Z = nbt.j("FallDistance");
            this.aH = nbt.g("Fire");
            if (nbt.e("Air")) {
                this.j(nbt.g("Air"));
            }
            this.aD = nbt.q("OnGround");
            this.aW = nbt.q("Invulnerable");
            this.aV = nbt.h("PortalCooldown");
            if (nbt.b(H)) {
                this.at = nbt.a(H);
                this.au = this.at.toString();
            }
            if (!Double.isFinite(this.dB()) || !Double.isFinite(this.dD()) || !Double.isFinite(this.dH())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dM()) || !Double.isFinite(this.dO())) throw new IllegalStateException("Entity has invalid rotation");
            this.ay();
            this.b(this.dM(), this.dO());
            if (nbt.b("CustomName", 8)) {
                String s2 = nbt.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2, (HolderLookup.a)this.dY()));
                }
                catch (Exception exception) {
                    b.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.p(nbt.q("CustomNameVisible"));
            this.e(nbt.q("Silent"));
            this.f(nbt.q("NoGravity"));
            this.j(nbt.q("Glowing"));
            this.k(nbt.h("TicksFrozen"));
            this.bg = nbt.q("HasVisualFire");
            if (nbt.b("Tags", 9)) {
                this.aY.clear();
                NBTTagList nbttaglist3 = nbt.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.aY.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbt);
            if (this.bJ()) {
                this.ay();
            }
            if (this instanceof EntityLiving) {
                this.af = nbt.h("Spigot.ticksLived");
            }
            this.persist = !nbt.e("Bukkit.persist") || nbt.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbt.e("Bukkit.visibleByDefault") || nbt.q("Bukkit.visibleByDefault");
            if (nbt.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.h("Bukkit.MaxAirSupply");
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.e("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.q("Bukkit.invisible");
                this.k(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.e("Paper.OriginWorld")) {
                    originWorld = nbt.a("Paper.OriginWorld");
                } else if (this.s != null) {
                    originWorld = this.s.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = nbt.q("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.q("Paper.FromNetherPortal");
            if (nbt.e("Paper.SpawnReason")) {
                String spawnReasonName = nbt.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    b.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !nbt.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (!nbt.e("Paper.FreezeLock")) return;
            this.freezeLocked = nbt.q("Paper.FreezeLock");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bJ() {
        return true;
    }

    @javax.annotation.Nullable
    public final String bK() {
        EntityTypes<?> entitytypes = this.aq();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        this.b(nbttagcompound);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public EntityItem a(WorldServer world, IMaterial item) {
        return this.a(world, item, 0);
    }

    @javax.annotation.Nullable
    public EntityItem a(WorldServer world, IMaterial item, int offsetY) {
        return this.a(world, new ItemStack(item), (float)offsetY);
    }

    @javax.annotation.Nullable
    public EntityItem a(WorldServer world, ItemStack stack) {
        return this.a(world, stack, 0.0f);
    }

    @javax.annotation.Nullable
    public EntityItem a(WorldServer world, ItemStack stack, float yOffset) {
        return this.spawnAtLocation(world, stack, yOffset, null);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(WorldServer world, ItemStack stack, float yOffset, @javax.annotation.Nullable Consumer<? super EntityItem> delayedAddConsumer) {
        if (stack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(new DefaultDrop(stack, itemStack -> {
                EntityItem itemEntity = new EntityItem(this.s, this.dB(), this.dD() + (double)yOffset, this.dH(), (ItemStack)itemStack);
                itemEntity.s();
                this.s.b(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        EntityItem entityitem = new EntityItem(world, this.dB(), this.dD() + (double)yOffset, this.dH(), stack.v());
        stack.e(0);
        entityitem.s();
        return this.spawnAtLocation(world, entityitem);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(WorldServer world, EntityItem entityitem) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        world.b(entityitem);
        return entityitem;
    }

    public boolean bL() {
        return !this.dR();
    }

    public boolean bM() {
        if (this.ad) {
            return false;
        }
        double reducedWith = this.bb.a() * 0.8f;
        AxisAlignedBB boundingBox = AxisAlignedBB.a(this.bF(), reducedWith, 1.0E-6, reducedWith);
        net.minecraft.world.level.World world = this.s;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = MathHelper.a(boundingBox.b);
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.a(boundingBox.d);
        int maxBlockY = MathHelper.a(boundingBox.e);
        int maxBlockZ = MathHelper.a(boundingBox.f);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        IChunkProvider chunkSource = world.R();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, true).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                IBlockData blockState = blocks.a(currX | currZ << 4 | currY << 8);
                                if (blockState.moonrise$emptyCollisionShape() || !blockState.j(world, mutablePos) || (collisionShape = blockState.g(world, mutablePos)).c()) continue;
                                AxisAlignedBB toCollide = boundingBox.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        Entity entity;
        if (this.bL() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.A() == player) {
                if (!this.dW().B_()) {
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fV());
                    if (event.isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.A()));
                        return EnumInteractionResult.e;
                    }
                    leashable.a(true, event.isDropLeash());
                    this.a(GameEvent.r, (Entity)player);
                }
                return EnumInteractionResult.a;
            }
            ItemStack itemstack = player.b(hand);
            if (itemstack.a(Items.vA) && leashable.Q_()) {
                if (!this.dW().B_()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.A()));
                        player.cd.b();
                        return EnumInteractionResult.e;
                    }
                    leashable.b((Entity)player, true);
                }
                itemstack.h(1);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean i(Entity other) {
        return other.bN() && !this.z(other);
    }

    public boolean bN() {
        return false;
    }

    public void r() {
        this.h(Vec3D.c);
        this.h();
        if (this.bZ()) {
            this.dl().j(this);
        }
    }

    public final void j(Entity passenger) {
        if (this.y(passenger)) {
            this.a(passenger, Entity::a_);
        }
    }

    protected void a(Entity passenger, MoveFunction positionUpdater) {
        Vec3D vec3d = this.m(passenger);
        Vec3D vec3d1 = passenger.l(this);
        positionUpdater.accept(passenger, vec3d.d - vec3d1.d, vec3d.e - vec3d1.e, vec3d.f - vec3d1.f);
    }

    public void k(Entity passenger) {
    }

    public Vec3D l(Entity vehicle) {
        return this.dt().b(EntityAttachment.b, 0, this.aA);
    }

    public Vec3D m(Entity passenger) {
        return this.du().e(this.a(passenger, this.bb, 1.0f));
    }

    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return Entity.a(this, passenger, dimensions.d());
    }

    protected static Vec3D a(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int i2 = vehicle.cZ().indexOf(passenger);
        return attachments.c(EntityAttachment.a, i2, vehicle.aA);
    }

    public boolean n(Entity entity) {
        return this.a(entity, false);
    }

    public boolean bO() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force) {
        EntityMountEvent event;
        if (entity == this.r || entity.s != this.s) {
            return false;
        }
        if (!entity.bR()) {
            return false;
        }
        if (!(force || this.dW().B_() || entity.o.b())) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.r != null) {
            if (entity1.r == this) {
                return false;
            }
            entity1 = entity1.r;
        }
        if (!(force || this.o(entity) && entity.r(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.bZ()) {
            this.ae();
        }
        this.b(EntityPose.a);
        this.r = entity;
        this.r.p(this);
        entity.F().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.U.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean o(Entity entity) {
        return !this.cd() && this.J <= 0;
    }

    public void bP() {
        for (int i2 = this.q.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.q.get(i2)).ae();
        }
    }

    public void bQ() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.r != null) {
            Entity entity = this.r;
            this.r = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.r = entity;
            }
        }
    }

    public void ae() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void p(Entity passenger) {
        if (passenger.dl() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.q.isEmpty()) {
            this.q = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.q);
            if (!this.dW().C && passenger instanceof EntityHuman && !(this.da() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.q = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, passenger);
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.dl() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.q = this.q.size() == 1 && this.q.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.q.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.J = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean r(Entity passenger) {
        return this.q.isEmpty();
    }

    protected boolean bR() {
        return true;
    }

    public void f_() {
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.a_(x2, y2, z2);
        this.b(yaw, pitch);
    }

    public double R_() {
        return this.dB();
    }

    public double S_() {
        return this.dD();
    }

    public double g_() {
        return this.dH();
    }

    public float r_() {
        return this.dO();
    }

    public float h_() {
        return this.dM();
    }

    public void a(float yaw, int interpolationSteps) {
        this.q(yaw);
    }

    public float bS() {
        return 0.0f;
    }

    public Vec3D bT() {
        return this.d(this.dO(), this.dM());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        boolean flag = entityhuman.fa().a(item) && !entityhuman.eZ().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fy().e() : entityhuman.fy();
        return this.d(0.0f, this.dM() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F bU() {
        return new Vec2F(this.dO(), this.dM());
    }

    public Vec3D bV() {
        return Vec3D.a(this.bU());
    }

    public void a(Portal portal, BlockPosition pos) {
        if (this.aD()) {
            this.aB();
        } else if (this.as != null && this.as.a(portal)) {
            if (!this.as.e()) {
                this.as.a(pos.j());
                this.as.a(true);
            }
        } else {
            this.as = new PortalProcessor(portal, pos.j());
        }
    }

    protected void bW() {
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.M();
            if (this.as != null) {
                if (this.as.a(worldserver, this, this.o(false))) {
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a("portal");
                    this.aB();
                    TeleportTransition teleporttransition = this.as.a(worldserver, this);
                    if (teleporttransition != null) {
                        WorldServer worldserver1 = teleporttransition.b();
                        if (this instanceof EntityPlayer || worldserver1 != null && (worldserver1.ah() == worldserver.ah() || this.a((net.minecraft.world.level.World)worldserver, worldserver1))) {
                            this.b(teleporttransition);
                        }
                    }
                    gameprofilerfiller.c();
                } else if (this.as.b()) {
                    this.as = null;
                }
            }
        }
    }

    public int bX() {
        Entity entity = this.da();
        return entity instanceof EntityPlayer ? entity.bX() : 300;
    }

    public void l(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte status) {
        switch (status) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void p(float yaw) {
    }

    public boolean bY() {
        boolean flag = this.dW() != null && this.dW().C;
        return !this.bi() && (this.aH > 0 || flag && this.i(0));
    }

    public boolean bZ() {
        return this.dl() != null;
    }

    public boolean ca() {
        return !this.q.isEmpty();
    }

    public boolean cb() {
        return this.aq().a(TagsEntity.p);
    }

    public boolean cc() {
        return !this.aq().a(TagsEntity.q);
    }

    public void g(boolean sneaking) {
        this.b(1, sneaking);
    }

    public boolean cd() {
        return this.i(1);
    }

    public boolean ce() {
        return this.cd();
    }

    public boolean cf() {
        return this.cd();
    }

    public boolean cg() {
        return this.cd();
    }

    public boolean ch() {
        return this.cd();
    }

    public boolean ci() {
        return this.c(EntityPose.f);
    }

    public boolean cj() {
        return this.i(3);
    }

    public void h(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean ck() {
        return this.i(4);
    }

    public boolean cl() {
        return this.c(EntityPose.d);
    }

    public boolean cm() {
        return this.cl() && !this.bj();
    }

    public void i(boolean swimming) {
        if (this.valid && this.ck() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean cn() {
        return this.aX;
    }

    public final void j(boolean glowing) {
        this.aX = glowing;
        this.b(6, this.co());
    }

    public boolean co() {
        return this.dW().B_() ? this.i(6) : this.aX;
    }

    public boolean cp() {
        return this.i(5);
    }

    public boolean d(EntityHuman player) {
        if (player.aa_()) {
            return false;
        }
        ScoreboardTeam scoreboardteam = this.cr();
        return scoreboardteam != null && player != null && player.cr() == scoreboardteam && scoreboardteam.i() ? false : this.cp();
    }

    public boolean cq() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
    }

    @javax.annotation.Nullable
    public ScoreboardTeam cr() {
        if (!this.dW().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.dW().Q().e(this.cI());
    }

    public final boolean s(@javax.annotation.Nullable Entity other) {
        return other == null ? false : this == other || this.t(other) || other.t(this);
    }

    protected boolean t(Entity other) {
        return this.a(other.cr());
    }

    public boolean a(@javax.annotation.Nullable ScoreboardTeamBase team) {
        return this.cr() != null ? this.cr().a(team) : false;
    }

    public void k(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int index) {
        return (this.al.a(am) & 1 << index) != 0;
    }

    public void b(int index, boolean value) {
        byte b0 = this.al.a(am);
        if (value) {
            this.al.a(am, (byte)(b0 | 1 << index));
        } else {
            this.al.a(am, (byte)(b0 & ~(1 << index)));
        }
    }

    public int cs() {
        return this.maxAirTicks;
    }

    public int ct() {
        return this.al.a(aN);
    }

    public void j(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.ct() != air) {
            this.al.markDirty(aN);
            return;
        }
        this.al.a(aN, event.getAmount());
    }

    public int cu() {
        return this.al.a(aS);
    }

    public void k(int frozenTicks) {
        this.al.a(aS, frozenTicks);
    }

    public float cv() {
        int i2 = this.cx();
        return (float)Math.min(this.cu(), i2) / (float)i2;
    }

    public boolean cw() {
        return this.cu() >= this.cx();
    }

    public int cx() {
        return 140;
    }

    public void a(WorldServer world, EntityLightning lightning) {
        this.h(this.aH + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aH == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.aH - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bi()) {
            return;
        }
        if (!this.a(world, this.dX().c().customEventDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void l(boolean drag) {
        Vec3D vec3d = this.dz();
        double d0 = drag ? Math.max(-0.9, vec3d.e - 0.03) : Math.min(1.8, vec3d.e + 0.1);
        this.n(vec3d.d, d0, vec3d.f);
    }

    public void m(boolean drag) {
        Vec3D vec3d = this.dz();
        double d0 = drag ? Math.max(-0.3, vec3d.e - 0.03) : Math.min(0.7, vec3d.e + 0.06);
        this.n(vec3d.d, d0, vec3d.f);
        this.k();
    }

    public boolean a(WorldServer world, EntityLiving other) {
        return true;
    }

    public void cy() {
        if (this.dz().b() > -0.5 && this.Z > 1.0f) {
            this.Z = 1.0f;
        }
    }

    public void k() {
        this.Z = 0.0f;
    }

    protected void m(double x2, double y2, double z2) {
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        Vec3D vec3d = new Vec3D(x2 - (double)blockposition.u(), y2 - (double)blockposition.v(), z2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.dW().a_(blockposition_mutableblockposition).m(this.dW(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d2 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.ae.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dz().c(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec3d1.e, vec3d1.f);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.n(vec3d1.d, f1 * f2, vec3d1.f);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.n(vec3d1.d, vec3d1.e, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D multiplier) {
        this.k();
        this.U = multiplier;
    }

    private static IChatBaseComponent a(IChatBaseComponent textComponent) {
        IChatMutableComponent ichatmutablecomponent = textComponent.e().b(textComponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : textComponent.c()) {
            ichatmutablecomponent.b(Entity.a(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent al() {
        IChatBaseComponent ichatbasecomponent = this.an();
        return ichatbasecomponent != null ? Entity.a(ichatbasecomponent) : this.cz();
    }

    protected IChatBaseComponent cz() {
        return this.o.h();
    }

    public boolean u(Entity entity) {
        return this == entity;
    }

    public float cA() {
        return 0.0f;
    }

    public void q(float headYaw) {
    }

    public void r(float bodyYaw) {
    }

    public boolean cB() {
        return true;
    }

    public boolean v(Entity attacker) {
        return false;
    }

    public String toString() {
        String s2 = this.dW() == null ? "~NULL~" : this.dW().toString();
        return this.aE != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.al().getString(), this.p, this.at, s2, this.dB(), this.dD(), this.dH(), this.dy(), this.af, this.valid, this.aE}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.al().getString(), this.p, this.at, s2, this.dB(), this.dD(), this.dH(), this.dy(), this.af, this.valid);
    }

    public final boolean d(DamageSource damageSource) {
        return this.dR() || this.aW && !damageSource.a(DamageTypeTags.d) && !damageSource.h() || damageSource.a(DamageTypeTags.i) && this.bi() || damageSource.a(DamageTypeTags.m) && this.aq().a(TagsEntity.o);
    }

    public boolean cC() {
        return this.aW;
    }

    public void n(boolean invulnerable) {
        this.aW = invulnerable;
    }

    public void w(Entity entity) {
        this.b(entity.dB(), entity.dD(), entity.dH(), entity.dM(), entity.dO());
    }

    public void x(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound nbttagcompound = original.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.aV = original.aV;
        this.as = original.as;
    }

    @javax.annotation.Nullable
    public Entity b(TeleportTransition teleportTarget) {
        net.minecraft.world.level.World world = this.dW();
        if (!(this.bL() && this.valid || teleportTarget.b() == world)) {
            b.warn("Illegal Entity Teleport " + String.valueOf(this) + " to " + String.valueOf(teleportTarget.b()) + ":" + String.valueOf(teleportTarget.c()), new Throwable());
            return null;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.dR()) {
                boolean flag;
                EntityTeleportEvent teleEvent;
                TileEntity tileEntity;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTarget), teleportTarget.i());
                Vec3D velocity = absolutePosition.b();
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (World)teleportTarget.b().getWorld(), absolutePosition.c(), absolutePosition.d());
                if (this.as != null && this.as.a((BlockEndGateway)Blocks.la) && (tileEntity = this.s.c_(this.as.c())) instanceof TileEntityEndGateway) {
                    TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleportTarget = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch(), teleportTarget.g(), teleportTarget.h(), Set.of(), teleportTarget.j(), teleportTarget.cause());
                    velocity = Vec3D.c;
                }
                if (this.as != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), bukkitEntity.getVelocity(), CraftVector.toBukkit(velocity));
                    event.callEvent();
                    if (!(event.isCancelled() || event.getTo() == null || event.getTo().equals((Object)event.getFrom()) && event.getAfter().equals((Object)event.getBefore()))) {
                        to = event.getTo().clone();
                        velocity = CraftVector.toNMS(event.getAfter());
                        teleportTarget = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), velocity, to.getYaw(), to.getPitch(), teleportTarget.g(), teleportTarget.h(), Set.of(), teleportTarget.j(), teleportTarget.cause());
                    }
                }
                if (this.dR()) {
                    return null;
                }
                WorldServer worldserver1 = teleportTarget.b();
                boolean bl = flag = worldserver1.ah() != worldserver.ah();
                if (!teleportTarget.h()) {
                    this.ae();
                }
                if (flag) {
                    return this.b(worldserver1, teleportTarget);
                }
                return this.a(worldserver, teleportTarget);
            }
        }
        return null;
    }

    private Entity a(WorldServer world, TeleportTransition teleportTarget) {
        for (Entity entity : this.cZ()) {
            entity.b(this.a(teleportTarget, entity));
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleportTarget), teleportTarget.i());
        if (!teleportTarget.h()) {
            this.a(teleportTarget);
        }
        teleportTarget.j().onTransition(this);
        gameprofilerfiller.c();
        return this;
    }

    private Entity b(WorldServer world, TeleportTransition teleportTarget) {
        Entity entity2;
        List<Entity> list = this.cZ();
        ArrayList<Entity> list1 = new ArrayList<Entity>(list.size());
        this.bP();
        for (Entity entity2 : list) {
            Entity entity1 = entity2.b(this.a(teleportTarget, entity2));
            if (entity1 == null) continue;
            list1.add(entity1);
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportCrossDimension");
        entity2 = this.aq().a(world, EntitySpawnReason.s);
        if (entity2 == null) {
            gameprofilerfiller.c();
            return null;
        }
        Entity entity3 = this;
        if (entity3 instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity3);
            leashable.a(true, true);
        }
        entity2.x(this);
        this.cD();
        entity2.a(PositionMoveRotation.a(teleportTarget), teleportTarget.i());
        if (this.inWorld) {
            world.d(entity2);
        }
        for (Entity entity2 : list1) {
            entity2.a(entity2, true);
        }
        world.i();
        teleportTarget.j().onTransition(entity2);
        gameprofilerfiller.c();
        return entity2;
    }

    private TeleportTransition a(TeleportTransition teleportTarget, Entity passenger) {
        float f2 = teleportTarget.e() + (teleportTarget.i().contains((Object)Relative.d) ? 0.0f : passenger.dM() - this.dM());
        float f1 = teleportTarget.f() + (teleportTarget.i().contains((Object)Relative.e) ? 0.0f : passenger.dO() - this.dO());
        Vec3D vec3d = passenger.du().d(this.du());
        Vec3D vec3d1 = teleportTarget.c().b(teleportTarget.i().contains((Object)Relative.a) ? 0.0 : vec3d.a(), teleportTarget.i().contains((Object)Relative.b) ? 0.0 : vec3d.b(), teleportTarget.i().contains((Object)Relative.c) ? 0.0 : vec3d.c());
        return teleportTarget.a(vec3d1).a(f2, f1).a();
    }

    private void a(TeleportTransition teleportTarget) {
        EntityLiving entityliving = this.cX();
        for (Entity entity : this.dd()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityliving != null && entityplayer.ar() == entityliving.ar()) {
                entityplayer.f.b(PacketPlayOutEntityTeleport.a(this.ar(), PositionMoveRotation.a(teleportTarget), teleportTarget.i(), this.aD));
                continue;
            }
            entityplayer.f.b(PacketPlayOutEntityTeleport.a(this.ar(), PositionMoveRotation.a(this), Set.of(), this.aD));
        }
    }

    public void a(PositionMoveRotation pos, Set<Relative> flags) {
        PositionMoveRotation positionmoverotation1 = PositionMoveRotation.a(this);
        PositionMoveRotation positionmoverotation2 = PositionMoveRotation.a(positionmoverotation1, pos, flags);
        this.o(positionmoverotation2.a().d, positionmoverotation2.a().e, positionmoverotation2.a().f);
        this.v(positionmoverotation2.c());
        this.q(positionmoverotation2.c());
        this.w(positionmoverotation2.d());
        this.ay();
        this.bz();
        this.h(positionmoverotation2.b());
        this.bi.clear();
    }

    public void a(float yaw, float pitch) {
        this.v(yaw);
        this.q(yaw);
        this.w(pitch);
        this.bB();
    }

    public void f(BlockPosition pos) {
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.m().a(TicketType.e, new ChunkCoordIntPair(pos), 3, pos);
        }
    }

    protected void cD() {
        Leashable leashable;
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).P_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            leashable.a(true, event.isDropLeash());
        }
    }

    public Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return BlockPortalShape.a(portalRect, portalAxis, this.du(), this.a(this.aw()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> PortalType.END_GATEWAY;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bL()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean o(boolean allowVehicles) {
        return (allowVehicles || !this.bZ()) && this.bL();
    }

    public boolean a(net.minecraft.world.level.World from, net.minecraft.world.level.World to) {
        if (!this.bL() || !this.valid) {
            return false;
        }
        if (from.ah() == net.minecraft.world.level.World.k && to.ah() == net.minecraft.world.level.World.i) {
            for (Entity entity : this.cZ()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return max;
    }

    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cE() {
        return 3;
    }

    public boolean s_() {
        return false;
    }

    public void a(CrashReportSystemDetails section) {
        section.a("Entity Type", () -> {
            String s2 = String.valueOf(EntityTypes.a(this.aq()));
            return s2 + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.a("Entity ID", this.p);
        section.a("Entity Name", () -> this.al().getString());
        section.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dB(), this.dD(), this.dH()));
        section.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dW(), MathHelper.a(this.dB()), MathHelper.a(this.dD()), MathHelper.a(this.dH())));
        Vec3D vec3d = this.dz();
        section.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.d, vec3d.e, vec3d.f));
        section.a("Entity's Passengers", () -> this.cZ().toString());
        section.a("Entity's Vehicle", () -> String.valueOf(this.dl()));
    }

    public boolean cF() {
        return this.bY() && !this.aa_();
    }

    public void a_(UUID uuid) {
        this.at = uuid;
        this.au = this.at.toString();
    }

    @Override
    public UUID cG() {
        return this.at;
    }

    public String cH() {
        return this.au;
    }

    @Override
    public String cI() {
        return this.au;
    }

    public boolean cJ() {
        return true;
    }

    public static double cK() {
        return n;
    }

    public static void b(double value) {
        n = value;
    }

    @Override
    public IChatBaseComponent p_() {
        return ScoreboardTeam.a(this.cr(), this.al()).a(chatmodifier -> chatmodifier.a(this.cQ()).a(this.cH()));
    }

    public void b(@javax.annotation.Nullable IChatBaseComponent name) {
        this.al.a(aO, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public IChatBaseComponent an() {
        return this.al.a(aO).orElse(null);
    }

    @Override
    public boolean l_() {
        return this.al.a(aO).isPresent();
    }

    public void p(boolean visible) {
        this.al.a(aP, visible);
    }

    public boolean cL() {
        return this.al.a(aP);
    }

    public final boolean a(WorldServer world, double destX, double destY, double destZ, Set<Relative> flags, float yaw, float pitch, boolean resetCamera) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, resetCamera, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        float f22 = MathHelper.a(f1, -90.0f, 90.0f);
        Entity entity = this.b(new TeleportTransition(worldserver, new Vec3D(d0, d1, d2), Vec3D.c, f2, f22, set, TeleportTransition.a, cause));
        return entity != null;
    }

    public void a(double destX, double destY, double destZ) {
        this.c(destX, destY, destZ);
    }

    public void c(double destX, double destY, double destZ) {
        if (this.dW() instanceof WorldServer) {
            this.b(destX, destY, destZ, this.dM(), this.dO());
            this.E();
        }
    }

    private void E() {
        this.db().forEach(entity -> {
            for (Entity entity1 : entity.q) {
                entity.a(entity1, Entity::e);
            }
        });
    }

    public void d(double offsetX, double offsetY, double offsetZ) {
        this.c(this.dB() + offsetX, this.dD() + offsetY, this.dH() + offsetZ);
    }

    public boolean cM() {
        return this.cL();
    }

    @Override
    public void a(List<DataWatcher.c<?>> entries) {
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (aq.equals(data)) {
            this.m_();
        }
    }

    @Deprecated
    protected void cN() {
        EntitySize entitysize;
        EntityPose entitypose = this.aw();
        this.bb = entitysize = this.a(entitypose);
        this.bc = entitysize.c();
    }

    public void m_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bb;
        EntityPose entitypose = this.aw();
        this.bb = entitysize1 = this.a(entitypose);
        this.bc = entitysize1.c();
        this.ay();
        boolean bl = flag = entitysize1.a() <= 4.0f && entitysize1.b() <= 4.0f;
        if (!(this.s.C || this.ak || this.ad || !flag || !(entitysize1.a() > entitysize.a()) && !(entitysize1.b() > entitysize.b()) || this instanceof EntityHuman)) {
            this.a(entitysize);
        }
    }

    public boolean a(EntitySize previous) {
        VoxelShape voxelshape1;
        Optional<Vec3D> optional1;
        double d1;
        double d0;
        EntitySize entitysize1 = this.a(this.aw());
        Vec3D vec3d = this.du().b(0.0, (double)previous.b() / 2.0, 0.0);
        VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0 = (double)Math.max(0.0f, entitysize1.a() - previous.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.b() - previous.b()) + 1.0E-6, d0));
        Optional<Vec3D> optional = this.s.a(this, voxelshape, vec3d, (double)entitysize1.a(), (double)entitysize1.b(), (double)entitysize1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-entitysize1.b()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.a() > previous.a() && entitysize1.b() > previous.b() && (optional1 = this.s.a(this, voxelshape1 = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, 1.0E-6, d0)), vec3d, (double)entitysize1.a(), (double)previous.b(), (double)entitysize1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-previous.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection cO() {
        return EnumDirection.a(this.dM());
    }

    public EnumDirection cP() {
        return this.cO();
    }

    protected ChatHoverable cQ() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.aq(), this.cG(), this.al()));
    }

    public boolean a(EntityPlayer spectator) {
        return true;
    }

    @Override
    public final AxisAlignedBB cR() {
        return this.aC;
    }

    public final void a(AxisAlignedBB boundingBox) {
        double minX = boundingBox.a;
        double minY = boundingBox.b;
        double minZ = boundingBox.c;
        double maxX = boundingBox.d;
        double maxY = boundingBox.e;
        double maxZ = boundingBox.f;
        double len = boundingBox.d - boundingBox.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.e - boundingBox.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.f - boundingBox.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aC = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float d(EntityPose pose) {
        return this.a(pose).c();
    }

    public final float cS() {
        return this.bc;
    }

    public Vec3D s(float tickDelta) {
        return this.cT();
    }

    protected Vec3D cT() {
        return new Vec3D(0.0, this.cS(), this.dr() * 0.4f);
    }

    public SlotAccess a_(int mappedIndex) {
        return SlotAccess.a;
    }

    public net.minecraft.world.level.World cU() {
        return this.dW();
    }

    @javax.annotation.Nullable
    public MinecraftServer cV() {
        return this.dW().p();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer player) {
    }

    public void e(EntityPlayer player) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation rotation) {
        float f2 = MathHelper.h(this.dM());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror mirror) {
        float f2 = MathHelper.h(this.dM());
        switch (mirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cW() {
        return false;
    }

    public ProjectileDeflection a(IProjectile projectile) {
        return this.aq().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @javax.annotation.Nullable
    public EntityLiving cX() {
        return null;
    }

    public final boolean cY() {
        return this.cX() != null;
    }

    public final List<Entity> cZ() {
        return this.q;
    }

    @javax.annotation.Nullable
    public Entity da() {
        return this.q.isEmpty() ? null : (Entity)this.q.get(0);
    }

    public boolean y(Entity passenger) {
        return this.q.contains((Object)passenger);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.q.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> F() {
        if (this.q.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.q.stream().flatMap(Entity::db);
    }

    public Stream<Entity> db() {
        if (this.q.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.F());
    }

    public Stream<Entity> dc() {
        if (this.q.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.q.stream().flatMap(Entity::dc), Stream.of(this));
    }

    public Iterable<Entity> dd() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.q.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.q);
        return ret;
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.F().iterator();
    }

    public int de() {
        return (int)this.F().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean df() {
        if (this.q.isEmpty()) {
            return false;
        }
        return this.de() == 1;
    }

    public Entity dg() {
        Entity entity = this;
        while (entity.bZ()) {
            entity = entity.dl();
        }
        return entity;
    }

    public boolean z(Entity entity) {
        return this.dg() == entity.dg();
    }

    public boolean A(Entity passenger) {
        if (!passenger.bZ()) {
            return false;
        }
        Entity entity1 = passenger.dl();
        return entity1 == this ? true : this.A(entity1);
    }

    public boolean dh() {
        Entity entity = this;
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman.c();
        }
        return this.di();
    }

    public boolean di() {
        EntityLiving entityliving = this.cX();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.c();
        }
        return this.dk();
    }

    public boolean dj() {
        EntityLiving entityliving = this.cX();
        return entityliving != null && entityliving.dj();
    }

    public boolean dk() {
        return !this.dW().C;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(passengerYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.b(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dB(), this.cR().e, this.dH());
    }

    @javax.annotation.Nullable
    public Entity dl() {
        return this.r;
    }

    @javax.annotation.Nullable
    public Entity dm() {
        return this.r != null && this.r.cX() == this ? this.r : null;
    }

    public EnumPistonReaction n_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dn() {
        return SoundCategory.g;
    }

    public int do() {
        return 1;
    }

    public CommandListenerWrapper d(WorldServer world) {
        return new CommandListenerWrapper(this.commandSource, this.du(), this.bU(), world, 0, this.al().getString(), this.p_(), world.p(), this);
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        Vec3D vec3d1 = anchorPoint.a(this);
        double d0 = target.d - vec3d1.d;
        double d1 = target.e - vec3d1.e;
        double d2 = target.f - vec3d1.f;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.w(MathHelper.h((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.v(MathHelper.h((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.q(this.dM());
        this.O = this.dO();
        this.N = this.dM();
    }

    public float t(float delta) {
        return MathHelper.h(delta, this.N, this.aA);
    }

    public boolean a(TagKey<FluidType> fluid, double flowScale) {
        if (this.dp()) {
            return false;
        }
        AxisAlignedBB boundingBox = this.cR().h(0.001);
        net.minecraft.world.level.World world = this.s;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = Math.max(minSection << 4, MathHelper.a(boundingBox.b));
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.c(boundingBox.d) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, MathHelper.c(boundingBox.e) - 1);
        int maxBlockZ = MathHelper.c(boundingBox.f) - 1;
        boolean isPushable = this.cJ();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        Vec3D pushVector = Vec3D.c;
        double totalPushes = 0.0;
        double maxHeightDiff = 0.0;
        boolean inFluid = false;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = world.R();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                Fluid fluidState = blocks.a(currX | currZ << 4 | currY << 8).y();
                                if (fluidState.c() || !fluidState.a(fluid)) continue;
                                mutablePos.d(currX | currChunkX << 4, currY | currChunkY << 4, currZ | currChunkZ << 4);
                                double height = (float)mutablePos.v() + fluidState.a(world, mutablePos);
                                double diff = height - boundingBox.b;
                                if (diff < 0.0) continue;
                                inFluid = true;
                                maxHeightDiff = Math.max(maxHeightDiff, diff);
                                if (!isPushable) continue;
                                totalPushes += 1.0;
                                Vec3D flow = fluidState.c(world, mutablePos);
                                pushVector = diff < 0.4 ? pushVector.e(flow.c(diff)) : pushVector.e(flow);
                            }
                        }
                    }
                }
            }
        }
        this.ah.put(fluid, maxHeightDiff);
        if (pushVector.h() == 0.0) {
            return inFluid;
        }
        pushVector = pushVector.c(1.0 / totalPushes);
        Vec3D currMovement = this.dz();
        if (!(this instanceof EntityHuman)) {
            pushVector = pushVector.d();
        }
        pushVector = pushVector.c(flowScale);
        if (Math.abs(currMovement.d) < 0.003 && Math.abs(currMovement.f) < 0.003 && pushVector.g() < 0.0045000000000000005) {
            pushVector = pushVector.d().c(0.0045000000000000005);
        }
        this.h(currMovement.e(pushVector));
        return true;
    }

    public boolean dp() {
        AxisAlignedBB axisalignedbb = this.cR().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dW().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> fluid) {
        return this.ah.getDouble(fluid);
    }

    public double dq() {
        return (double)this.cS() < 0.4 ? 0.0 : 0.4;
    }

    public final float dr() {
        return this.bb.a();
    }

    public final float ds() {
        return this.bb.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity(this, entityTrackerEntry);
    }

    public EntitySize a(EntityPose pose) {
        return this.o.n();
    }

    public final EntityAttachments dt() {
        return this.bb.d();
    }

    public Vec3D du() {
        return this.t;
    }

    public Vec3D dv() {
        return this.du();
    }

    @Override
    public BlockPosition dw() {
        return this.u;
    }

    public IBlockData dx() {
        if (this.bh == null) {
            this.bh = this.dW().a_(this.dw());
        }
        return this.bh;
    }

    public ChunkCoordIntPair dy() {
        return this.ay;
    }

    public Vec3D dz() {
        return this.az;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void h(Vec3D velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.az = velocity;
        }
    }

    public void i(Vec3D velocity) {
        this.h(this.dz().e(velocity));
    }

    public void n(double x2, double y2, double z2) {
        this.h(new Vec3D(x2, y2, z2));
    }

    public final int dA() {
        return this.u.u();
    }

    public final double dB() {
        return this.t.d;
    }

    public double c(double widthScale) {
        return this.t.d + (double)this.dr() * widthScale;
    }

    public double d(double widthScale) {
        return this.c((2.0 * this.ae.j() - 1.0) * widthScale);
    }

    public final int dC() {
        return this.u.v();
    }

    public final double dD() {
        return this.t.e;
    }

    public double e(double heightScale) {
        return this.t.e + (double)this.ds() * heightScale;
    }

    public double dE() {
        return this.e(this.ae.j());
    }

    public double dF() {
        return this.t.e + (double)this.bc;
    }

    public final int dG() {
        return this.u.w();
    }

    public final double dH() {
        return this.t.f;
    }

    public double f(double widthScale) {
        return this.t.f + (double)this.dr() * widthScale;
    }

    public double g(double widthScale) {
        return this.f((2.0 * this.ae.j() - 1.0) * widthScale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        b.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.t, entityInfo, new Throwable()});
        return false;
    }

    public final void o(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            b.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3D(x2, y2, z2)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.t.d != x2 || this.t.e != y2 || this.t.f != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.t = new Vec3D(x2, y2, z2);
            }
            int i2 = MathHelper.a(x2);
            int j2 = MathHelper.a(y2);
            int k2 = MathHelper.a(z2);
            if (i2 != this.u.u() || j2 != this.u.v() || k2 != this.u.w()) {
                this.u = new BlockPosition(i2, j2, k2);
                this.bh = null;
                if (SectionPosition.a(i2) != this.ay.h || SectionPosition.a(k2) != this.ay.i) {
                    this.ay = new ChunkCoordIntPair(this.u);
                }
            }
            this.aT.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.t.d != x2 || this.t.e != y2 || this.t.f != z2)) {
            this.a(this.ax());
        }
    }

    public void dI() {
    }

    public Vec3D u(float delta) {
        return this.o(delta).b(0.0, (double)this.bc * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int i2 = packet.b();
        double d0 = packet.g();
        double d1 = packet.h();
        double d2 = packet.i();
        this.f(d0, d1, d2);
        this.b(d0, d1, d2, packet.n(), packet.m());
        this.e(i2);
        this.a_(packet.e());
    }

    @javax.annotation.Nullable
    public ItemStack dJ() {
        return null;
    }

    public void q(boolean inPowderSnow) {
        this.av = inPowderSnow;
    }

    public boolean dK() {
        return !this.aq().a(TagsEntity.k);
    }

    public boolean dL() {
        return (this.av || this.aw) && this.dK();
    }

    public float dM() {
        return this.aA;
    }

    public float dN() {
        return this.dM();
    }

    public void v(float yaw) {
        if (!Float.isFinite(yaw)) {
            SystemUtils.b("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.aA = yaw;
        }
    }

    public float dO() {
        return this.aB;
    }

    public void w(float pitch) {
        if (!Float.isFinite(pitch)) {
            SystemUtils.b("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.aB = Math.clamp(pitch % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean dP() {
        return false;
    }

    public float dQ() {
        return 0.0f;
    }

    public void b_(@javax.annotation.Nullable Entity entity) {
    }

    public final boolean dR() {
        return this.aE != null;
    }

    @javax.annotation.Nullable
    public RemovalReason dS() {
        return this.aE;
    }

    @Override
    public final void c(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.s.moonrise$getEntityLookup().canRemoveEntity(this)) {
            b.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.aE != null;
        if (this.aE == null) {
            this.aE = entity_removalreason;
        }
        if (this.aE.a()) {
            this.ae();
        }
        if (this.aE != RemovalReason.c) {
            this.cZ().forEach(Entity::ae);
        }
        this.aT.a(entity_removalreason);
        this.b(entity_removalreason);
        if (!(this instanceof EntityPlayer) && entity_removalreason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void dT() {
        this.aE = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void a(EntityInLevelCallback changeListener) {
        this.aT = changeListener;
    }

    @Override
    public boolean dU() {
        return this.aE != null && !this.aE.b() ? false : (this.bZ() ? false : !this.ca() || !this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean dV() {
        return false;
    }

    public boolean c(WorldServer world, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World dW() {
        return this.s;
    }

    public void a(net.minecraft.world.level.World world) {
        this.s = world;
    }

    public DamageSources dX() {
        return this.dW().aj();
    }

    public IRegistryCustom dY() {
        return this.dW().K_();
    }

    protected void a(int step, double x2, double y2, double z2, double yaw, double pitch) {
        double d5 = 1.0 / (double)step;
        double d6 = MathHelper.d(d5, this.dB(), x2);
        double d7 = MathHelper.d(d5, this.dD(), y2);
        double d8 = MathHelper.d(d5, this.dH(), z2);
        float f2 = (float)MathHelper.e(d5, (double)this.dM(), yaw);
        float f1 = (float)MathHelper.d(d5, (double)this.dO(), pitch);
        this.a_(d6, d7, d8);
        this.b(f2, f1);
    }

    public RandomSource dZ() {
        return this.ae;
    }

    public Vec3D ah() {
        EntityLiving entityliving = this.cX();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.bL()) {
                return entityhuman.ah();
            }
        }
        return this.dz();
    }

    @javax.annotation.Nullable
    public ItemStack ea() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> eb() {
        return this.o.k();
    }

    public static int nextEntityId() {
        return c.incrementAndGet();
    }

    public boolean isTicking() {
        return ((WorldServer)this.s).f(this.dw());
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    private record b(Vec3D a, Vec3D b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "from;to", "a", "b"}, this, o2);
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @javax.annotation.Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.h(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends ThreadUnsafeRandom {
        private boolean locked = false;

        public RandomRandomSource() {
            this(RandomSupport.a());
        }

        public RandomRandomSource(long seed) {
            super(seed);
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                b.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.b(seed);
                this.locked = true;
            }
        }
    }
}

