/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 5;
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float h = 32.0f;
    private static final float i = 0.5f;
    private static final float j = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public PotionContents k = PotionContents.a;
    private final Map<Entity, Integer> l = Maps.newHashMap();
    private int m = 600;
    public int n = 20;
    public int o = 20;
    public int p;
    public float q;
    public float r;
    @Nullable
    private EntityLiving s;
    @Nullable
    public UUID t;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.ad = true;
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.d, world);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, Float.valueOf(3.0f));
        builder.a(f, false);
        builder.a(g, ColorParticleOption.a(Particles.u, -1));
    }

    public void a(float radius) {
        if (!this.dW().C) {
            this.au().a(e, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void m_() {
        double d0 = this.dB();
        double d1 = this.dD();
        double d2 = this.dH();
        super.m_();
        this.a_(d0, d1, d2);
    }

    public float c() {
        return this.au().a(e).floatValue();
    }

    public void a(PotionContents potionContentsComponent) {
        this.k = potionContentsComponent;
        this.s();
    }

    public void s() {
        ParticleParam particleparam = this.al.a(g);
        if (particleparam instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleparam;
            int i2 = this.k.equals(PotionContents.a) ? 0 : this.k.b();
            this.al.a(g, ColorParticleOption.a(colorparticleoption.a(), ARGB.f(i2)));
        }
    }

    public void a(MobEffect effect) {
        this.a(this.k.a(effect));
    }

    public ParticleParam e() {
        return this.au().a(g);
    }

    public void a(ParticleParam particle) {
        this.au().a(g, particle);
    }

    protected void a(boolean waiting) {
        this.au().a(f, waiting);
    }

    public boolean f() {
        return this.au().a(f);
    }

    public int g() {
        return this.m;
    }

    public void a(int duration) {
        this.m = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.af >= this.n + this.m) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void h() {
        super.h();
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver);
        } else {
            this.t();
        }
    }

    private void t() {
        boolean flag = this.f();
        float f2 = this.c();
        if (!flag || !this.ae.h()) {
            float f1;
            int i2;
            ParticleParam particleparam = this.e();
            if (flag) {
                i2 = 2;
                f1 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * f2 * f2);
                f1 = f2;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                float f22 = this.ae.i() * ((float)Math.PI * 2);
                float f3 = MathHelper.c(this.ae.i()) * f1;
                double d0 = this.dB() + (double)(MathHelper.b(f22) * f3);
                double d1 = this.dD();
                double d2 = this.dH() + (double)(MathHelper.a(f22) * f3);
                if (particleparam.a() == Particles.u) {
                    if (flag && this.ae.h()) {
                        this.dW().b(ColorParticleOption.a(Particles.u, -1), d0, d1, d2, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.dW().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                if (flag) {
                    this.dW().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                this.dW().b(particleparam, d0, d1, d2, (0.5 - this.ae.j()) * 0.15, 0.01f, (0.5 - this.ae.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer world) {
        if (this.af >= this.n + this.m) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag1;
            boolean flag = this.f();
            boolean bl = flag1 = this.af < this.n;
            if (flag != flag1) {
                this.a(flag1);
            }
            if (!flag1) {
                float f2 = this.c();
                if (this.r != 0.0f) {
                    if ((f2 += this.r) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.af % 5 == 0) {
                    this.l.entrySet().removeIf(entry -> this.af >= (Integer)entry.getValue());
                    if (!this.k.c()) {
                        this.l.clear();
                    } else {
                        ArrayList list = Lists.newArrayList();
                        if (this.k.e().isPresent()) {
                            for (MobEffect mobeffect : this.k.e().get().a().a()) {
                                list.add(new MobEffect(mobeffect.c(), mobeffect.a(i2 -> i2 / 4), mobeffect.e(), mobeffect.f(), mobeffect.g()));
                            }
                        }
                        list.addAll(this.k.d());
                        List<EntityLiving> list1 = this.dW().a(EntityLiving.class, this.cR());
                        if (!list1.isEmpty()) {
                            Iterator<EntityLiving> iterator1 = list1.iterator();
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            while (iterator1.hasNext()) {
                                double d1;
                                double d0;
                                double d2;
                                EntityLiving entityliving = iterator1.next();
                                if (this.l.containsKey(entityliving) || !entityliving.fL()) continue;
                                Stream stream = list.stream();
                                Objects.requireNonNull(entityliving);
                                if (stream.noneMatch(entityliving::b) || !((d2 = (d0 = entityliving.dB() - this.dB()) * d0 + (d1 = entityliving.dH() - this.dH()) * d1) <= (double)(f2 * f2))) continue;
                                entities.add((LivingEntity)entityliving.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                                    this.l.put(entityliving, this.af + this.o);
                                    for (MobEffect mobeffect1 : list) {
                                        if (mobeffect1.c().a().a()) {
                                            mobeffect1.c().a().a(world, this, this.n(), entityliving, mobeffect1.e(), 0.5);
                                            continue;
                                        }
                                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.q != 0.0f) {
                                        if ((f2 += this.q) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(f2);
                                    }
                                    if (this.p == 0) continue;
                                    this.m += this.p;
                                    if (this.m > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.q;
    }

    public void b(float radiusOnUse) {
        this.q = radiusOnUse;
    }

    public float j() {
        return this.r;
    }

    public void c(float radiusGrowth) {
        this.r = radiusGrowth;
    }

    public int l() {
        return this.p;
    }

    public void b(int durationOnUse) {
        this.p = durationOnUse;
    }

    public int m() {
        return this.n;
    }

    public void c(int waitTime) {
        this.n = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.s = owner;
        this.t = owner == null ? null : owner.cG();
    }

    @Nullable
    public EntityLiving n() {
        Entity entity;
        if (this.s == null && this.t != null && this.dW() instanceof WorldServer && (entity = ((WorldServer)this.dW()).a(this.t)) instanceof EntityLiving) {
            this.s = (EntityLiving)entity;
        }
        return this.s;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.af = nbt.h("Age");
        this.m = nbt.h("Duration");
        this.n = nbt.h("WaitTime");
        this.o = nbt.h("ReapplicationDelay");
        this.p = nbt.h("DurationOnUse");
        this.q = nbt.j("RadiusOnUse");
        this.r = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.t = nbt.a("Owner");
        }
        RegistryOps<NBTBase> registryops = this.dY().a(DynamicOpsNBT.a);
        if (nbt.b("Particle", 10)) {
            Particles.bh.parse(registryops, (Object)nbt.c("Particle")).resultOrPartial(s2 -> c.warn("Failed to parse area effect cloud particle options: '{}'", s2)).ifPresent(this::a);
        }
        if (nbt.e("potion_contents")) {
            PotionContents.b.parse(registryops, (Object)nbt.c("potion_contents")).resultOrPartial(s2 -> c.warn("Failed to parse area effect cloud potions: '{}'", s2)).ifPresent(this::a);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.af);
        nbt.a("Duration", this.m);
        nbt.a("WaitTime", this.n);
        nbt.a("ReapplicationDelay", this.o);
        nbt.a("DurationOnUse", this.p);
        nbt.a("RadiusOnUse", this.q);
        nbt.a("RadiusPerTick", this.r);
        nbt.a("Radius", this.c());
        RegistryOps<NBTBase> registryops = this.dY().a(DynamicOpsNBT.a);
        nbt.a("Particle", (NBTBase)Particles.bh.encodeStart(registryops, (Object)this.e()).getOrThrow());
        if (this.t != null) {
            nbt.a("Owner", this.t);
        }
        if (!this.k.equals(PotionContents.a)) {
            NBTBase nbtbase = (NBTBase)PotionContents.b.encodeStart(registryops, (Object)this.k).getOrThrow();
            nbt.a("potion_contents", nbtbase);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (e.equals(data)) {
            this.m_();
        }
        super.a(data);
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }
}

