/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int a = 6000;
    private static final int b = 20;
    private static final int c = 8;
    private static final int d = 40;
    private static final double e = 0.5;
    private int f;
    private int g = 5;
    public int h;
    public int i = 1;
    private EntityHuman j;
    @Nullable
    public UUID sourceEntityId;
    @Nullable
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound tag) {
        if (!tag.b("Paper.ExpData", 10)) {
            return;
        }
        NBTTagCompound comp = tag.p("Paper.ExpData");
        if (comp.b("source")) {
            this.sourceEntityId = comp.a("source");
        }
        if (comp.b("trigger")) {
            this.triggerEntityId = comp.a("trigger");
        }
        if (comp.e("reason")) {
            String reason = comp.l("reason");
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.dW().getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        }
    }

    private void savePaperNBT(NBTTagCompound tag) {
        NBTTagCompound comp = new NBTTagCompound();
        if (this.sourceEntityId != null) {
            comp.a("source", this.sourceEntityId);
        }
        if (this.triggerEntityId != null) {
            comp.a("trigger", this.triggerEntityId);
        }
        if (this.spawnReason != null && this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            comp.a("reason", this.spawnReason.name());
        }
        tag.a("Paper.ExpData", comp);
    }

    @DoNotUse
    @Deprecated
    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount) {
        this(world, x2, y2, z2, amount, null, null);
    }

    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        this(world, x2, y2, z2, amount, reason, triggerId, null);
    }

    public EntityExperienceOrb(World world, double x2, double y2, double z2, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.W, world);
        this.sourceEntityId = sourceId != null ? sourceId.cG() : null;
        this.triggerEntityId = triggerId != null ? triggerId.cG() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.a_(x2, y2, z2);
        this.v((float)(this.ae.j() * 360.0));
        this.n((this.ae.j() * (double)0.2f - (double)0.1f) * 2.0, this.ae.j() * 0.2 * 2.0, (this.ae.j() * (double)0.2f - (double)0.1f) * 2.0);
        this.h = amount;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> type, World world) {
        super(type, world);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected double bd() {
        return 0.03;
    }

    @Override
    public void h() {
        Vec3D vec3d;
        double d0;
        super.h();
        EntityHuman prevTarget = this.j;
        this.K = this.dB();
        this.L = this.dD();
        this.M = this.dH();
        if (this.a(TagsFluid.a)) {
            this.s();
        } else {
            this.bf();
        }
        if (this.dW().b_(this.dw()).a(TagsFluid.b)) {
            this.n((this.ae.i() - this.ae.i()) * 0.2f, 0.2f, (this.ae.i() - this.ae.i()) * 0.2f);
        }
        if (!this.dW().b(this.cR())) {
            this.m(this.dB(), (this.cR().b + this.cR().e) / 2.0, this.dH());
        }
        if (this.af % 20 == 1) {
            this.p();
        }
        if (this.j != null && (this.j.aa_() || this.j.eF())) {
            this.j = null;
        }
        boolean cancelled = false;
        if (this.j != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.j, this.j != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.j = prevTarget;
            } else {
                EntityHuman entityHuman = this.j = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.j != null && !cancelled && (d0 = (vec3d = new Vec3D(this.j.dB() - this.dB(), this.j.dD() + (double)this.j.cS() / 2.0 - this.dD(), this.j.dH() - this.dH())).h()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.h(this.dz().e(vec3d.d().c(d1 * d1 * 0.1)));
        }
        this.a(EnumMoveType.a, this.dz());
        this.aK();
        float f2 = 0.98f;
        if (this.aJ()) {
            f2 = this.dW().a_(this.aQ()).b().g() * 0.98f;
        }
        this.h(this.dz().d(f2, 0.98, f2));
        if (this.aJ()) {
            this.h(this.dz().d(1.0, -0.9, 1.0));
        }
        ++this.f;
        if (this.f >= 6000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aQ() {
        return this.e(0.999999f);
    }

    private void p() {
        if (this.j == null || this.j.g(this) > 64.0) {
            this.j = this.dW().a((Entity)this, 8.0);
        }
        if (this.dW() instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.dW().a(EntityTypeTest.a(EntityExperienceOrb.class), this.cR().g(0.5), this::a);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.b(entityexperienceorb);
            }
        }
    }

    public static void a(WorldServer world, Vec3D pos, int amount) {
        EntityExperienceOrb.award(world, pos, amount, null, null, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId) {
        EntityExperienceOrb.award(world, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer world, Vec3D pos, int amount, ExperienceOrb.SpawnReason reason, Entity triggerId, Entity sourceId) {
        while (amount > 0) {
            int j2 = EntityExperienceOrb.b(amount);
            amount -= j2;
            if (EntityExperienceOrb.b(world, pos, j2)) continue;
            world.b(new EntityExperienceOrb(world, pos.a(), pos.b(), pos.c(), j2, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer world, Vec3D pos, int amount) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int j2 = world.H_().a(40);
        List<EntityExperienceOrb> list = world.a(EntityTypeTest.a(EntityExperienceOrb.class), axisalignedbb, (? super T entityexperienceorb) -> EntityExperienceOrb.a(entityexperienceorb, j2, amount));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.i;
            entityexperienceorb2.f = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb other) {
        return other != this && EntityExperienceOrb.a(other, this.ar(), this.h);
    }

    private static boolean a(EntityExperienceOrb orb, int seed, int amount) {
        return !orb.dR() && (orb.ar() - seed) % 40 == 0 && orb.h == amount;
    }

    private void b(EntityExperienceOrb other) {
        if (!new ExperienceOrbMergeEvent((ExperienceOrb)this.getBukkitEntity(), (ExperienceOrb)other.getBukkitEntity()).callEvent()) {
            return;
        }
        this.i += other.i;
        this.f = Math.min(this.f, other.f);
        other.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void s() {
        Vec3D vec3d = this.dz();
        this.n(vec3d.d * (double)0.99f, Math.min(vec3d.e + (double)5.0E-4f, (double)0.06f), vec3d.f * (double)0.99f);
    }

    @Override
    protected void bs() {
    }

    @Override
    public final boolean b(DamageSource source) {
        return !this.d(source);
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.d(source)) {
            return false;
        }
        this.bD();
        this.g = (int)((float)this.g - amount);
        if (this.g <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", (short)this.g);
        nbt.a("Age", (short)this.f);
        nbt.a("Value", this.h);
        nbt.a("Count", this.i);
        this.savePaperNBT(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.g = nbt.g("Health");
        this.f = nbt.g("Age");
        this.h = nbt.h("Value");
        this.i = Math.max(nbt.h("Count"), 1);
        this.loadPaperNBT(nbt);
    }

    @Override
    public void a_(EntityHuman player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            if (player.ci == 0 && new PlayerPickupExperienceEvent((Player)entityplayer.getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
                player.ci = CraftEventFactory.callPlayerXpCooldownEvent(player, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                player.a((Entity)this, 1);
                int i2 = this.a(entityplayer, this.h);
                if (i2 > 0) {
                    player.d(CraftEventFactory.callPlayerExpChangeEvent(player, this).getAmount());
                }
                --this.i;
                if (this.i == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int a(EntityPlayer player, int amount) {
        Optional<EnchantedItemInUse> optional = EnchantmentManager.a(EnchantmentEffectComponents.z, (EntityLiving)player, ItemStack::n);
        if (optional.isPresent()) {
            int l2;
            ItemStack itemstack = optional.get().a();
            int j2 = EnchantmentManager.c(player.y(), itemstack, amount);
            int k2 = Math.min(j2, itemstack.o());
            int consumedExperience = k2 > 0 ? k2 * amount / j2 : 0;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemstack, optional.get().b(), k2, consumedExperience);
            k2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return amount;
            }
            itemstack.b(itemstack.o() - k2);
            if (k2 > 0 && (l2 = amount - k2 * amount / j2) > 0) {
                return this.a(player, l2);
            }
            return 0;
        }
        return amount;
    }

    public int l() {
        return this.h;
    }

    public int m() {
        return this.h >= 2477 ? 10 : (this.h >= 1237 ? 9 : (this.h >= 617 ? 8 : (this.h >= 307 ? 7 : (this.h >= 149 ? 6 : (this.h >= 73 ? 5 : (this.h >= 37 ? 4 : (this.h >= 17 ? 3 : (this.h >= 7 ? 2 : (this.h >= 3 ? 1 : 0)))))))));
    }

    public static int b(int value) {
        if (value > 162670129) {
            return value - 100000;
        }
        if (value > 81335063) {
            return 81335063;
        }
        if (value > 40667527) {
            return 40667527;
        }
        if (value > 20333759) {
            return 20333759;
        }
        if (value > 10166857) {
            return 10166857;
        }
        if (value > 5083423) {
            return 5083423;
        }
        if (value > 2541701) {
            return 2541701;
        }
        if (value > 1270849) {
            return 1270849;
        }
        if (value > 635413) {
            return 635413;
        }
        if (value > 317701) {
            return 317701;
        }
        if (value > 158849) {
            return 158849;
        }
        if (value > 79423) {
            return 79423;
        }
        if (value > 39709) {
            return 39709;
        }
        if (value > 19853) {
            return 19853;
        }
        if (value > 9923) {
            return 9923;
        }
        if (value > 4957) {
            return 4957;
        }
        return value >= 2477 ? 2477 : (value >= 1237 ? 1237 : (value >= 617 ? 617 : (value >= 307 ? 307 : (value >= 149 ? 149 : (value >= 73 ? 73 : (value >= 37 ? 37 : (value >= 17 ? 17 : (value >= 7 ? 7 : (value >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntityExperienceOrb(this, entityTrackerEntry);
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.i;
    }
}

