/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int h = 1;
    private static final BaseBlockPosition bY = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> bZ = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float i = 0.15f;
    public static final float j = 0.55f;
    public static final float k = 0.5f;
    public static final float bH = 0.25f;
    public static final float bI = 0.085f;
    public static final float bJ = 1.0f;
    public static final int bK = 2;
    public static final int bL = 2;
    private static final double ca = Math.sqrt(2.04f) - (double)0.6f;
    protected static final MinecraftKey bM = MinecraftKey.b("random_spawn_bonus");
    public int bN;
    protected int bO;
    protected ControllerLook bP;
    protected ControllerMove bQ;
    protected ControllerJump bR;
    private final EntityAIBodyControl cb;
    protected NavigationAbstract bS;
    public PathfinderGoalSelector bT;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bU;
    @Nullable
    private EntityLiving cc;
    private final EntitySenses cd;
    private final NonNullList<ItemStack> ce = NonNullList.a(2, ItemStack.j);
    public final float[] bV = new float[2];
    private final NonNullList<ItemStack> cf = NonNullList.a(4, ItemStack.j);
    public final float[] bW = new float[4];
    private ItemStack cg = ItemStack.j;
    protected float bX;
    private boolean ch;
    private boolean ci;
    private final Map<PathType, Float> cj = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> ck = Optional.empty();
    public long cl;
    @Nullable
    private Leashable.a cm;
    private BlockPosition cn = BlockPosition.c;
    private float co = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        this.bT = new PathfinderGoalSelector();
        this.bU = new PathfinderGoalSelector();
        this.bP = new ControllerLook(this);
        this.bQ = new ControllerMove(this);
        this.bR = new ControllerJump(this);
        this.cb = this.G();
        this.bS = this.b(world);
        this.cd = new EntitySenses(this);
        Arrays.fill(this.bW, 0.085f);
        Arrays.fill(this.bV, 0.085f);
        this.bX = 0.085f;
        if (world instanceof WorldServer) {
            this.B();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.ci = persistenceRequired;
    }

    protected void B() {
    }

    public static AttributeProvider.Builder C() {
        return EntityLiving.ee().a(GenericAttributes.m, 16.0);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean D() {
        return false;
    }

    public float a(PathType nodeType) {
        EntityInsentient entityinsentient1;
        Entity entity = this.dm();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).D() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.cj.get((Object)nodeType);
        return ofloat == null ? nodeType.a() : ofloat.floatValue();
    }

    public void a(PathType nodeType, float penalty) {
        this.cj.put(nodeType, Float.valueOf(penalty));
    }

    public void E() {
    }

    public void F() {
    }

    protected EntityAIBodyControl G() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook H() {
        return this.bP;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.bT.inactiveTick()) {
            this.bT.a();
        }
        if (this.bU.inactiveTick()) {
            this.bU.a();
        }
    }

    public ControllerMove I() {
        Entity entity = this.dm();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.I();
        }
        return this.bQ;
    }

    public ControllerJump J() {
        return this.bR;
    }

    public NavigationAbstract L() {
        Entity entity = this.dm();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.L();
        }
        return this.bS;
    }

    @Override
    @Nullable
    public EntityLiving cX() {
        Entity entity = this.da();
        if (!this.gb() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.cc()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses N() {
        return this.cd;
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.cc;
    }

    @Nullable
    protected final EntityLiving O() {
        return this.ec().c(MemoryModuleType.o).orElse(null);
    }

    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.O_() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.O_() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.O_().bL() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dW().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.cc = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.ae;
    }

    public boolean a(ItemProjectileWeapon weapon) {
        return false;
    }

    public void P() {
        ((Entity)this).a(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    public int Q() {
        return 80;
    }

    public void R() {
        this.b(this.u());
    }

    @Override
    public void az() {
        super.az();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("mobBaseTick");
        if (this.bL() && this.ae.a(1000) < this.bN++) {
            this.m();
            this.R();
        }
        gameprofilerfiller.c();
    }

    @Override
    protected void f(DamageSource damageSource) {
        this.m();
        super.f(damageSource);
    }

    private void m() {
        this.bN = -this.Q();
    }

    @Override
    protected int e(WorldServer world) {
        if (this.bO > 0) {
            int j2;
            int i2 = this.bO;
            for (j2 = 0; j2 < this.cf.size(); ++j2) {
                if (this.cf.get(j2).f() || !(this.bW[j2] <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            for (j2 = 0; j2 < this.ce.size(); ++j2) {
                if (this.ce.get(j2).f() || !(this.bV[j2] <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            if (!this.cg.f() && this.bX <= 1.0f) {
                i2 += 1 + this.ae.a(3);
            }
            return i2;
        }
        return this.bO;
    }

    public void S() {
        if (this.dW().C) {
            this.eW();
        } else {
            this.dW().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 20) {
            this.S();
        } else {
            super.b(status);
        }
    }

    @Override
    public void h() {
        super.h();
        if (!this.dW().C && this.af % 5 == 0) {
            this.T();
        }
    }

    protected void T() {
        boolean flag = !(this.cX() instanceof EntityInsentient);
        boolean flag1 = !(this.dl() instanceof AbstractBoat);
        this.bT.a(PathfinderGoal.Type.a, flag);
        this.bT.a(PathfinderGoal.Type.c, flag && flag1);
        this.bT.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected float g(float bodyRotation, float headRotation) {
        this.cb.a();
        return headRotation;
    }

    @Nullable
    protected SoundEffect u() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.u();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CanPickUpLoot", this.fN());
        nbt.a("PersistenceRequired", this.ci);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.cf) {
            if (!itemstack.f()) {
                nbttaglist.add(itemstack.a(this.dY()));
                continue;
            }
            nbttaglist.add(new NBTTagCompound());
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (float f2 : this.bW) {
            nbttaglist1.add(NBTTagFloat.a(f2));
        }
        nbt.a("ArmorDropChances", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (ItemStack itemstack1 : this.ce) {
            if (!itemstack1.f()) {
                nbttaglist2.add(itemstack1.a(this.dY()));
                continue;
            }
            nbttaglist2.add(new NBTTagCompound());
        }
        nbt.a("HandItems", nbttaglist2);
        NBTTagList nbttaglist3 = new NBTTagList();
        for (float f1 : this.bV) {
            nbttaglist3.add(NBTTagFloat.a(f1));
        }
        nbt.a("HandDropChances", nbttaglist3);
        if (!this.cg.f()) {
            nbt.a("body_armor_item", this.cg.a(this.dY()));
            nbt.a("body_armor_drop_chance", this.bX);
        }
        this.a(nbt, this.cm);
        nbt.a("LeftHanded", this.gc());
        if (this.ck.isPresent()) {
            nbt.a("DeathLootTable", this.ck.get().a().toString());
            if (this.cl != 0L) {
                nbt.a("DeathLootTableSeed", this.cl);
            }
        }
        if (this.gb()) {
            nbt.a("NoAI", this.gb());
        }
        nbt.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        boolean data;
        super.a(nbt);
        if (nbt.b("CanPickUpLoot", 99)) {
            data = nbt.q("CanPickUpLoot");
            if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
                this.a_(data);
            }
        }
        data = nbt.q("PersistenceRequired");
        if (EntityInsentient.isLevelAtLeast(nbt, 1) || data) {
            this.ci = data;
        }
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.cf.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.cf.set(i2, ItemStack.a((HolderLookup.a)this.dY(), nbttagcompound1));
            }
        }
        if (nbt.b("ArmorDropChances", 9)) {
            nbttaglist = nbt.c("ArmorDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bW[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.ce.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.ce.set(i2, ItemStack.a((HolderLookup.a)this.dY(), nbttagcompound1));
            }
        }
        if (nbt.b("HandDropChances", 9)) {
            nbttaglist = nbt.c("HandDropChances", 5);
            for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
                this.bV[i2] = nbttaglist.i(i2);
            }
        }
        if (nbt.b("body_armor_item", 10)) {
            this.cg = ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("body_armor_item")).orElse(ItemStack.j);
            this.bX = nbt.j("body_armor_drop_chance");
        } else {
            this.cg = ItemStack.j;
        }
        this.cm = this.c(nbt);
        this.v(nbt.q("LeftHanded"));
        if (nbt.b("DeathLootTable", 8)) {
            this.ck = Optional.ofNullable(MinecraftKey.c(nbt.l("DeathLootTable"))).map(rs -> ResourceKey.a(Registries.bg, rs));
            this.cl = nbt.i("DeathLootTableSeed");
        }
        this.u(nbt.q("NoAI"));
        if (nbt.e("Bukkit.Aware")) {
            this.aware = nbt.q("Bukkit.Aware");
        }
    }

    @Override
    protected void b(WorldServer world, DamageSource damageSource, boolean causedByPlayer) {
        super.b(world, damageSource, causedByPlayer);
        this.ck = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> eb() {
        return this.ck.isPresent() ? this.ck : super.eb();
    }

    @Override
    public long eH() {
        return this.cl;
    }

    public void G(float forwardSpeed) {
        this.bq = forwardSpeed;
    }

    public void H(float upwardSpeed) {
        this.bp = upwardSpeed;
    }

    public void I(float sidewaysSpeed) {
        this.bo = sidewaysSpeed;
    }

    @Override
    public void C(float movementSpeed) {
        super.C(movementSpeed);
        this.G(movementSpeed);
    }

    public void U() {
        this.L().o();
        this.I(0.0f);
        this.H(0.0f);
        this.C(0.0f);
    }

    @Override
    public void d_() {
        super.d_();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("looting");
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.fN() && this.bL() && !this.be && worldserver.N().b(GameRules.c)) {
                BaseBlockPosition baseblockposition = this.V();
                List<EntityItem> list = this.dW().a(EntityItem.class, this.cR().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()));
                for (EntityItem entityitem : list) {
                    if (entityitem.dR() || entityitem.l().f() || entityitem.v() || !this.c(worldserver, entityitem.l()) || !entityitem.canMobPickup) continue;
                    this.a(worldserver, entityitem);
                }
            }
        }
        gameprofilerfiller.c();
    }

    protected BaseBlockPosition V() {
        return bY;
    }

    protected void a(WorldServer world, EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.l();
        ItemStack itemstack1 = this.equipItemIfPossible(world, itemstack.v(), itemEntity);
        if (!itemstack1.f()) {
            this.a(itemEntity);
            this.a((Entity)itemEntity, itemstack1.L());
            itemstack.h(itemstack1.L());
            if (itemstack.f()) {
                itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer world, ItemStack stack) {
        return this.equipItemIfPossible(world, stack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer worldserver, ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.f(itemstack);
        ItemStack itemstack1 = this.a(enumitemslot);
        boolean flag = this.a(itemstack, itemstack1, enumitemslot);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.a(enumitemslot);
            flag = itemstack1.f();
        }
        boolean bl = canPickup = flag && this.g(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.h(enumitemslot);
            if (!itemstack1.f() && (double)Math.max(this.ae.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.a(worldserver, itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.a(itemstack);
            this.b(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.j;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.g(slot);
        this.ci = true;
    }

    public void g(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                this.bV[slot.b()] = 2.0f;
                break;
            }
            case b: {
                this.bW[slot.b()] = 2.0f;
                break;
            }
            case c: {
                this.bX = 2.0f;
            }
        }
    }

    protected boolean a(ItemStack newStack, ItemStack oldStack, EnumItemSlot slot) {
        if (oldStack.f()) {
            return true;
        }
        if (newStack.h() instanceof ItemSword) {
            double d1;
            if (!(oldStack.h() instanceof ItemSword)) {
                return true;
            }
            double d0 = this.a(newStack, GenericAttributes.c, slot);
            return d0 != (d1 = this.a(oldStack, GenericAttributes.c, slot)) ? d0 > d1 : this.b(newStack, oldStack);
        }
        if (newStack.h() instanceof ItemBow && oldStack.h() instanceof ItemBow) {
            return this.b(newStack, oldStack);
        }
        if (newStack.h() instanceof ItemCrossbow && oldStack.h() instanceof ItemCrossbow) {
            return this.b(newStack, oldStack);
        }
        if (newStack.h() instanceof ItemArmor) {
            if (EnchantmentManager.a(oldStack, EnchantmentEffectComponents.E)) {
                return false;
            }
            if (!(oldStack.h() instanceof ItemArmor)) {
                return true;
            }
            double d0 = this.a(newStack, GenericAttributes.a, slot);
            double d1 = this.a(oldStack, GenericAttributes.a, slot);
            double d2 = this.a(newStack, GenericAttributes.b, slot);
            double d3 = this.a(oldStack, GenericAttributes.b, slot);
            return d0 != d1 ? d0 > d1 : (d2 != d3 ? d2 > d3 : this.b(newStack, oldStack));
        }
        if (newStack.h() instanceof ItemTool) {
            if (oldStack.h() instanceof ItemBlock) {
                return true;
            }
            if (oldStack.h() instanceof ItemTool) {
                double d1;
                double d0 = this.a(newStack, GenericAttributes.c, slot);
                if (d0 != (d1 = this.a(oldStack, GenericAttributes.c, slot))) {
                    return d0 > d1;
                }
                return this.b(newStack, oldStack);
            }
        }
        return false;
    }

    private double a(ItemStack stack, Holder<AttributeBase> attribute, EnumItemSlot slot) {
        double d0 = this.eY().b(attribute) ? this.i(attribute) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = stack.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemattributemodifiers.a(d0, slot);
    }

    public boolean b(ItemStack newStack, ItemStack oldStack) {
        return newStack.o() < oldStack.o() ? true : EntityInsentient.j(newStack) && !EntityInsentient.j(oldStack);
    }

    private static boolean j(ItemStack stack) {
        DataComponentMap datacomponentmap = stack.a();
        int i2 = datacomponentmap.d();
        return i2 > 1 || i2 == 1 && !datacomponentmap.b(DataComponents.e);
    }

    public boolean g(ItemStack stack) {
        return true;
    }

    public boolean c(WorldServer world, ItemStack stack) {
        return this.g(stack);
    }

    public boolean h(double distanceSquared) {
        return true;
    }

    public boolean W() {
        return this.bZ();
    }

    protected boolean X() {
        return false;
    }

    @Override
    public void dI() {
        if (this.dW().al() == EnumDifficulty.a && this.X()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.aj() && !this.W()) {
            EntityHuman entityhuman = this.dW().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (entityhuman != null) {
                WorldConfiguration.Entities.Spawning.DespawnRangePair despawnRangePair = this.dW().paperConfig().entities.spawning.despawnRanges.get(this.aq().f());
                DespawnRange.Shape shape = this.dW().paperConfig().entities.spawning.despawnRangeShape;
                double dy = Math.abs(entityhuman.dD() - this.dD());
                double dySqr = Math.pow(dy, 2.0);
                double dxSqr = Math.pow(entityhuman.dB() - this.dB(), 2.0);
                double dzSqr = Math.pow(entityhuman.dH() - this.dH(), 2.0);
                double distanceSquared = dxSqr + dzSqr + dySqr;
                if (despawnRangePair.hard().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy) && this.h(distanceSquared)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                if (despawnRangePair.soft().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy)) {
                    if (this.bf > 600 && this.ae.a(800) == 0 && this.h(distanceSquared)) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    }
                } else {
                    this.bf = 0;
                }
            }
        } else {
            this.bf = 0;
        }
    }

    @Override
    protected final void fu() {
        ++this.bf;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.b()) {
                    this.goalFloat.a();
                }
                this.J().b();
            }
            return;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("sensing");
        this.cd.a();
        gameprofilerfiller.c();
        int i2 = this.af + this.ar();
        if (i2 % 2 != 0 && this.af > 1) {
            gameprofilerfiller.a("targetSelector");
            this.bU.a(false);
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bT.a(false);
            gameprofilerfiller.c();
        } else {
            gameprofilerfiller.a("targetSelector");
            this.bU.a();
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bT.a();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("navigation");
        this.bS.c();
        gameprofilerfiller.c();
        gameprofilerfiller.a("mob tick");
        this.a((WorldServer)this.dW());
        gameprofilerfiller.c();
        gameprofilerfiller.a("controls");
        gameprofilerfiller.a("move");
        this.bQ.a();
        gameprofilerfiller.b("look");
        this.bP.a();
        gameprofilerfiller.b("jump");
        this.bR.b();
        gameprofilerfiller.c();
        gameprofilerfiller.c();
        this.Y();
    }

    protected void Y() {
        PacketDebug.a(this.dW(), this, this.bT);
    }

    protected void a(WorldServer world) {
    }

    public int Z() {
        return 40;
    }

    public int aa() {
        return 75;
    }

    protected void ab() {
        float f2 = this.aa();
        float f1 = this.cA();
        float f22 = MathHelper.h(this.aX - f1);
        float f3 = MathHelper.a(MathHelper.h(this.aX - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.q(f4);
    }

    public int ac() {
        return 10;
    }

    public void a(Entity targetEntity, float maxYawChange, float maxPitchChange) {
        double d2;
        double d0 = targetEntity.dB() - this.dB();
        double d1 = targetEntity.dH() - this.dH();
        if (targetEntity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)targetEntity;
            d2 = entityliving.dF() - this.dF();
        } else {
            d2 = (targetEntity.cR().b + targetEntity.cR().e) / 2.0 - this.dF();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.w(this.a(this.dO(), f3, maxPitchChange));
        this.v(this.a(this.dM(), f2, maxYawChange));
    }

    private float a(float from, float to, float max) {
        float f3 = MathHelper.h(to - from);
        if (f3 > max) {
            f3 = max;
        }
        if (f3 < -max) {
            f3 = -max;
        }
        return from + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockposition1 = pos.e();
        return EntitySpawnReason.a(spawnReason) || world.a_(blockposition1).a((IBlockAccess)world, blockposition1, type);
    }

    public boolean a(GeneratorAccess world, EntitySpawnReason spawnReason) {
        return true;
    }

    public boolean a(IWorldReader world) {
        return !world.d(this.cR()) && world.f(this);
    }

    public int ad() {
        return 4;
    }

    public boolean q(int count) {
        return false;
    }

    @Override
    public int cE() {
        if (this.O_() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eE() - this.eS() * 0.33f);
        if ((i2 -= (3 - this.dW().al().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    @Override
    public Iterable<ItemStack> fc() {
        return this.ce;
    }

    @Override
    public Iterable<ItemStack> fb() {
        return this.cf;
    }

    public ItemStack af() {
        return this.cg;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    public boolean ag() {
        return !this.a(EnumItemSlot.g).f();
    }

    public void h(ItemStack stack) {
        this.b(EnumItemSlot.g, stack);
    }

    @Override
    public Iterable<ItemStack> fd() {
        return this.cg.f() ? this.cf : Iterables.concat(this.cf, List.of(this.cg));
    }

    @Override
    public ItemStack a(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.ce.get(slot.b());
            case EnumItemSlot.Function.b -> this.cf.get(slot.b());
            case EnumItemSlot.Function.c -> this.cg;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.c(stack);
        switch (slot.a()) {
            case a: {
                this.onEquipItem(slot, this.ce.set(slot.b(), stack), stack, silent);
                break;
            }
            case b: {
                this.onEquipItem(slot, this.cf.set(slot.b(), stack), stack, silent);
                break;
            }
            case c: {
                ItemStack itemstack1 = this.cg;
                this.cg = stack;
                this.onEquipItem(slot, itemstack1, stack, silent);
            }
        }
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        super.a(world, source, causedByPlayer);
        for (EnumItemSlot enumitemslot : EnumItemSlot.i) {
            if (this.shouldSkipLoot(enumitemslot)) continue;
            ItemStack itemstack = this.a(enumitemslot);
            float f2 = this.h(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = f2 > 1.0f;
            Entity entity = source.d();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world1 = this.dW();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    f2 = EnchantmentManager.a(worldserver1, entityliving, source, f2);
                }
            }
            if (itemstack.f() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D) || !causedByPlayer && !flag1 || !(this.ae.i() < f2)) continue;
            if (!flag1 && itemstack.m()) {
                itemstack.b(itemstack.p() - this.ae.a(1 + this.ae.a(Math.max(itemstack.p() - 3, 1))));
            }
            this.a(world, itemstack);
            if (this.clearEquipmentSlots) {
                this.a(enumitemslot, ItemStack.j);
                continue;
            }
            this.clearedEquipmentSlots.add(enumitemslot);
        }
    }

    public float h(EnumItemSlot slot) {
        return switch (slot.a()) {
            case EnumItemSlot.Function.a -> this.bV[slot.b()];
            case EnumItemSlot.Function.b -> this.bW[slot.b()];
            case EnumItemSlot.Function.c -> this.bX;
            default -> throw new MatchException(null, null);
        };
    }

    public void b(WorldServer world) {
        this.a(world, (ItemStack itemstack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer world, Predicate<ItemStack> dropPredicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.i) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            if (!dropPredicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            double d0 = this.h(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.a(enumitemslot, ItemStack.j);
            this.a(world, itemstack);
        }
        return set;
    }

    private LootParams g(WorldServer world) {
        return new LootParams.a(world).a(LootContextParameters.f, this.du()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmentTable) {
        this.a(equipmentTable.a(), equipmentTable.b());
    }

    public void a(ResourceKey<LootTable> lootTable, Map<EnumItemSlot, Float> slotDropChances) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(lootTable, this.g(worldserver), slotDropChances);
        }
    }

    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.15f * localDifficulty.d()) {
            float f2;
            int i2 = random.a(2);
            float f3 = f2 = this.dW().al() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            if (random.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : bZ) {
                Item item;
                ItemStack itemstack = this.a(enumitemslot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemstack.f() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot equipmentSlot, int equipmentLevel) {
        switch (equipmentSlot) {
            case f: {
                if (equipmentLevel == 0) {
                    return Items.pU;
                }
                if (equipmentLevel == 1) {
                    return Items.qk;
                }
                if (equipmentLevel == 2) {
                    return Items.pY;
                }
                if (equipmentLevel == 3) {
                    return Items.qc;
                }
                if (equipmentLevel == 4) {
                    return Items.qg;
                }
            }
            case e: {
                if (equipmentLevel == 0) {
                    return Items.pV;
                }
                if (equipmentLevel == 1) {
                    return Items.ql;
                }
                if (equipmentLevel == 2) {
                    return Items.pZ;
                }
                if (equipmentLevel == 3) {
                    return Items.qd;
                }
                if (equipmentLevel == 4) {
                    return Items.qh;
                }
            }
            case d: {
                if (equipmentLevel == 0) {
                    return Items.pW;
                }
                if (equipmentLevel == 1) {
                    return Items.qm;
                }
                if (equipmentLevel == 2) {
                    return Items.qa;
                }
                if (equipmentLevel == 3) {
                    return Items.qe;
                }
                if (equipmentLevel == 4) {
                    return Items.qi;
                }
            }
            case c: {
                if (equipmentLevel == 0) {
                    return Items.pX;
                }
                if (equipmentLevel == 1) {
                    return Items.qn;
                }
                if (equipmentLevel == 2) {
                    return Items.qb;
                }
                if (equipmentLevel == 3) {
                    return Items.qf;
                }
                if (equipmentLevel != 4) break;
                return Items.qj;
            }
        }
        return null;
    }

    protected void a(WorldAccess world, RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.b(world, random, localDifficulty);
        for (EnumItemSlot enumitemslot : EnumItemSlot.i) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(world, random, enumitemslot, localDifficulty);
        }
    }

    protected void b(WorldAccess world, RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(world, EnumItemSlot.a, random, 0.25f, localDifficulty);
    }

    protected void a(WorldAccess world, RandomSource random, EnumItemSlot slot, DifficultyDamageScaler localDifficulty) {
        this.a(world, slot, random, 0.5f, localDifficulty);
    }

    private void a(WorldAccess world, EnumItemSlot slot, RandomSource random, float power, DifficultyDamageScaler localDifficulty) {
        ItemStack itemstack = this.a(slot);
        if (!itemstack.f() && random.i() < power * localDifficulty.d()) {
            EnchantmentManager.a(itemstack, world.K_(), VanillaEnchantmentProviders.a, localDifficulty, random);
            this.a(slot, itemstack);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.g(GenericAttributes.m));
        if (!attributemodifiable.b(bM)) {
            attributemodifiable.d(new AttributeModifier(bM, randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(randomsource.i() < 0.05f);
        return entityData;
    }

    public void ai() {
        this.ci = true;
    }

    @Override
    public void a(EnumItemSlot slot, float dropChance) {
        switch (slot.a()) {
            case a: {
                this.bV[slot.b()] = dropChance;
                break;
            }
            case b: {
                this.bW[slot.b()] = dropChance;
                break;
            }
            case c: {
                this.bX = dropChance;
            }
        }
    }

    @Override
    public boolean fN() {
        return this.ch;
    }

    public void a_(boolean canPickUpLoot) {
        this.ch = canPickUpLoot;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return this.fN();
    }

    public boolean aj() {
        return this.ci;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bL()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult enuminteractionresult = this.c(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.a(player, hand);
        if (enuminteractionresult1 != EnumInteractionResult.e) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.b(player, hand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return enuminteractionresult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.vB) && (enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.h() instanceof ItemMonsterEgg) {
            if (this.dW() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.h();
                Optional<EntityInsentient> optional = itemmonsteregg.a(player, this, this.aq(), (WorldServer)this.dW(), this.du(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(player, (EntityInsentient)entityinsentient));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean ak() {
        return this.a(this.dw());
    }

    public boolean a(BlockPosition pos) {
        return this.co == -1.0f ? true : this.cn.j(pos) < (double)(this.co * this.co);
    }

    public void a(BlockPosition target, int range) {
        this.cn = target;
        this.co = range;
    }

    public BlockPosition fX() {
        return this.cn;
    }

    public float fY() {
        return this.co;
    }

    public void fZ() {
        this.co = -1.0f;
    }

    public boolean ga() {
        return this.co != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams context, EntitySpawnReason reason, ConversionParams.a<T> finalizer) {
        return this.convertTo(entityType, context, reason, finalizer, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return (T)this.convertTo(entitytypes, conversionparams, entityspawnreason, (T e2) -> {
            conversionparams_a.finalizeConversion(e2);
            return true;
        }, transformReason, spawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.CancellingAfterConversion<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dR()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dW(), EntitySpawnReason.i);
        if (t0 == null) {
            return null;
        }
        conversionparams.a().a(this, t0, conversionparams);
        if (!conversionparams_a.finalizeConversionOrCancel(t0)) {
            return null;
        }
        World world = this.dW();
        if (transformReason == null) {
            return (T)t0;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.addFreshEntity(t0, spawnReason);
        }
        if (conversionparams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)t0;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams context, ConversionParams.a<T> finalizer) {
        return this.convertTo(entityType, context, finalizer, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return (T)this.convertTo(entitytypes, conversionparams, (T e2) -> {
            conversionparams_a.finalizeConversion(e2);
            return true;
        }, transformReason, spawnReason);
    }

    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.CancellingAfterConversion<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.convertTo(entitytypes, conversionparams, EntitySpawnReason.i, conversionparams_a, transformReason, spawnReason);
    }

    @Override
    @Nullable
    public Leashable.a T_() {
        return this.cm;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.cm = leashData;
    }

    @Override
    public void a(boolean sendPacket, boolean dropItem) {
        Leashable.super.a(sendPacket, dropItem);
        if (this.T_() == null) {
            this.fZ();
        }
    }

    @Override
    public void z() {
        Leashable.super.z();
        this.bT.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean y() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag1 = super.a(entity, force);
        if (flag1 && this.P_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag1;
            }
            this.a(true, event.isDropLeash());
        }
        return flag1;
    }

    @Override
    public boolean dk() {
        return super.dk() && !this.gb();
    }

    public void u(boolean aiDisabled) {
        byte b0 = this.al.a(a);
        this.al.a(a, aiDisabled ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void v(boolean leftHanded) {
        byte b0 = this.al.a(a);
        this.al.a(a, leftHanded ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void w(boolean attacking) {
        byte b0 = this.al.a(a);
        this.al.a(a, attacking ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean gb() {
        return (this.al.a(a) & 1) != 0;
    }

    public boolean gc() {
        return (this.al.a(a) & 2) != 0;
    }

    public boolean gd() {
        return (this.al.a(a) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fy() {
        return this.gc() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean i(EntityLiving entity) {
        return this.ge().c(entity.eL());
    }

    protected AxisAlignedBB ge() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.dl();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.cR();
            AxisAlignedBB axisalignedbb2 = this.cR();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.cR();
        }
        return axisalignedbb.c(ca, 0.0, ca);
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        boolean flag;
        float f2 = (float)this.h(GenericAttributes.c);
        ItemStack itemstack = this.ea();
        DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.dX().b(this));
        f2 = EnchantmentManager.a(world, itemstack, target, damagesource, f2);
        if (flag = target.a(world, damagesource, f2 += itemstack.h().a(target, f2, damagesource))) {
            EntityLiving entityliving;
            float f1 = this.a(target, damagesource);
            if (f1 > 0.0f && target instanceof EntityLiving) {
                entityliving = (EntityLiving)target;
                entityliving.knockback(f1 * 0.5f, MathHelper.a(this.dM() * ((float)Math.PI / 180)), -MathHelper.b(this.dM() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                this.h(this.dz().d(0.6, 1.0, 0.6));
            }
            if (target instanceof EntityLiving) {
                entityliving = (EntityLiving)target;
                itemstack.a(entityliving, (EntityLiving)this);
            }
            EnchantmentManager.a(world, target, damagesource);
            this.B(target);
            this.gf();
        }
        return flag;
    }

    protected void gf() {
    }

    public boolean gg() {
        if (this.dW().U() && !this.dW().C) {
            boolean flag;
            float f2 = this.by();
            BlockPosition blockposition = BlockPosition.a(this.dB(), this.dF(), this.dH());
            boolean bl = flag = this.bl() || this.av || this.aw;
            if (f2 > 0.5f && this.ae.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dW().h(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        if (this.L().q()) {
            super.c(fluid);
        } else {
            this.h(this.dz().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gh() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.ec().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bT.a(predicate);
    }

    @Override
    protected void cD() {
        super.cD();
        this.fe().forEach(itemstack -> {
            if (!itemstack.f()) {
                itemstack.e(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack dJ() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.aq());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }

    @Override
    protected void f(Holder<AttributeBase> attribute) {
        super.f(attribute);
        if (attribute.a(GenericAttributes.m) || attribute.a(GenericAttributes.E)) {
            this.L().g();
        }
    }

    @VisibleForTesting
    public float[] gi() {
        return this.bV;
    }

    @VisibleForTesting
    public float[] gj() {
        return this.bW;
    }
}

