/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityLightning
extends Entity {
    private static final int b = 2;
    private static final double c = 3.0;
    private static final double d = 15.0;
    public int e = 2;
    public long a;
    public int f;
    public boolean g;
    @Nullable
    private EntityPlayer h;
    private final Set<Entity> i = Sets.newHashSet();
    private int j;
    public boolean isEffect;

    public EntityLightning(EntityTypes<? extends EntityLightning> type, World world) {
        super(type, world);
        this.a = this.ae.g();
        this.f = this.ae.a(3) + 1;
    }

    public void a(boolean cosmetic) {
        this.g = cosmetic;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.d;
    }

    @Nullable
    public EntityPlayer l() {
        return this.h;
    }

    public void b(@Nullable EntityPlayer channeler) {
        this.h = channeler;
    }

    private void s() {
        BlockPosition blockposition = this.t();
        IBlockData iblockdata = this.dW().a_(blockposition);
        if (iblockdata.a(Blocks.sN)) {
            ((LightningRodBlock)iblockdata.b()).e(iblockdata, this.dW(), blockposition);
        }
    }

    @Override
    public void h() {
        List<Entity> list;
        super.h();
        if (!this.isEffect && this.e == 2) {
            if (this.dW().B_()) {
                this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.oo, SoundCategory.d, 10000.0f, 0.8f + this.ae.i() * 0.2f, false);
                this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.on, SoundCategory.d, 2.0f, 0.5f + this.ae.i() * 0.2f, false);
            } else {
                EnumDifficulty enumdifficulty = this.dW().al();
                if (enumdifficulty == EnumDifficulty.c || enumdifficulty == EnumDifficulty.d) {
                    this.b(4);
                }
                this.s();
                EntityLightning.clearCopperOnLightningStrike(this.dW(), this.t(), this);
                this.a(GameEvent.G);
            }
        }
        --this.e;
        if (this.e < 0) {
            if (this.f == 0) {
                if (this.dW() instanceof WorldServer) {
                    list = this.dW().a((Entity)this, new AxisAlignedBB(this.dB() - 15.0, this.dD() - 15.0, this.dH() - 15.0, this.dB() + 15.0, this.dD() + 6.0 + 15.0, this.dH() + 15.0), (? super Entity entity) -> entity.bL() && !this.i.contains(entity));
                    for (EntityPlayer entityplayer2 : ((WorldServer)this.dW()).a((? super EntityPlayer entityplayer) -> entityplayer.f(this) < 256.0f)) {
                        CriterionTriggers.V.a(entityplayer2, this, list);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            } else if (this.e < -this.ae.a(10)) {
                --this.f;
                this.e = 1;
                this.a = this.ae.g();
                this.b(0);
            }
        }
        if (this.e >= 0 && !this.isEffect) {
            if (!(this.dW() instanceof WorldServer)) {
                this.dW().c(2);
            } else if (!this.g) {
                list = this.dW().a((Entity)this, new AxisAlignedBB(this.dB() - 3.0, this.dD() - 3.0, this.dH() - 3.0, this.dB() + 3.0, this.dD() + 6.0 + 3.0, this.dH() + 3.0), Entity::bL);
                for (Entity entity2 : list) {
                    entity2.a((WorldServer)this.dW(), this);
                }
                this.i.addAll(list);
                if (this.h != null) {
                    CriterionTriggers.F.a(this.h, list);
                }
            }
        }
    }

    private BlockPosition t() {
        Vec3D vec3d = this.du();
        return BlockPosition.a(vec3d.d, vec3d.e - 1.0E-6, vec3d.f);
    }

    private void b(int spreadAttempts) {
        WorldServer worldserver;
        World world;
        if (!this.g && !this.isEffect && (world = this.dW()) instanceof WorldServer && (worldserver = (WorldServer)world).N().b(GameRules.b)) {
            BlockPosition blockposition = this.dw();
            IBlockData iblockdata = BlockFireAbstract.a(this.dW(), blockposition);
            if (this.dW().a_(blockposition).l() && iblockdata.a((IWorldReader)this.dW(), blockposition) && !this.g && !CraftEventFactory.callBlockIgniteEvent(this.dW(), blockposition, this).isCancelled()) {
                this.dW().b(blockposition, iblockdata);
                ++this.j;
            }
            for (int j2 = 0; j2 < spreadAttempts; ++j2) {
                BlockPosition blockposition1 = blockposition.b(this.ae.a(3) - 1, this.ae.a(3) - 1, this.ae.a(3) - 1);
                iblockdata = BlockFireAbstract.a(this.dW(), blockposition1);
                if (!this.dW().a_(blockposition1).l() || !iblockdata.a((IWorldReader)this.dW(), blockposition1) || this.g || CraftEventFactory.callBlockIgniteEvent(this.dW(), blockposition1, this).isCancelled()) continue;
                this.dW().b(blockposition1, iblockdata);
                ++this.j;
            }
            return;
        }
    }

    private static void clearCopperOnLightningStrike(World world, BlockPosition pos, Entity lightning) {
        IBlockData iblockdata1;
        BlockPosition blockposition1;
        IBlockData iblockdata = world.a_(pos);
        if (iblockdata.a(Blocks.sN)) {
            blockposition1 = pos.a(iblockdata.c(BlockDirectional.a).g());
            iblockdata1 = world.a_(blockposition1);
        } else {
            blockposition1 = pos;
            iblockdata1 = iblockdata;
        }
        if (iblockdata1.b() instanceof WeatheringCopper) {
            IBlockData newBlock = WeatheringCopper.c(world.a_(blockposition1));
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1, newBlock)) {
                world.b(blockposition1, newBlock);
            }
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
            int i2 = world.A.a(3) + 3;
            for (int j2 = 0; j2 < i2; ++j2) {
                int k2 = world.A.a(8) + 1;
                EntityLightning.randomWalkCleaningCopper(world, blockposition1, blockposition_mutableblockposition, k2, lightning);
            }
        }
    }

    private static void randomWalkCleaningCopper(World world, BlockPosition pos, BlockPosition.MutableBlockPosition mutablePos, int count, Entity lightning) {
        Optional<BlockPosition> optional;
        mutablePos.g(pos);
        for (int j2 = 0; j2 < count && !(optional = EntityLightning.randomStepCleaningCopper(world, mutablePos, lightning)).isEmpty(); ++j2) {
            mutablePos.g(optional.get());
        }
    }

    private static Optional<BlockPosition> randomStepCleaningCopper(World world, BlockPosition pos, Entity lightning) {
        BlockPosition blockposition1;
        IBlockData iblockdata;
        Iterator<BlockPosition> iterator = BlockPosition.a(world.A, 10, pos, 1).iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!((iblockdata = world.a_(blockposition1 = iterator.next())).b() instanceof WeatheringCopper));
        BlockPosition blockposition1Final = blockposition1;
        WeatheringCopper.b(iblockdata).ifPresent(iblockdata1 -> {
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1Final, iblockdata1)) {
                world.b(blockposition1Final, (IBlockData)iblockdata1);
            }
        });
        world.c(3002, blockposition1, -1);
        return Optional.of(blockposition1);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0 * EntityLightning.cK();
        return distance < d1 * d1;
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void a(NBTTagCompound nbt) {
    }

    @Override
    protected void b(NBTTagCompound nbt) {
    }

    public int m() {
        return this.j;
    }

    public Stream<Entity> p() {
        return this.i.stream().filter(Entity::bL);
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }
}

