/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemShield;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R2.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier k = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int l = 2;
    public static final int m = 4;
    public static final int n = 98;
    public static final int o = 100;
    public static final int p = 105;
    public static final int q = 6;
    public static final int r = 100;
    private static final int bH = 40;
    public static final double s = 0.003;
    public static final double t = 0.08;
    public static final int u = 20;
    private static final int bI = 10;
    private static final int bJ = 2;
    public static final float ay = 0.42f;
    private static final double bK = 128.0;
    protected static final int az = 1;
    protected static final int aA = 2;
    public static final int aB = 4;
    protected static final DataWatcherObject<Byte> aC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> bL = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> bM = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> bN = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bO = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bP = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bQ = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int bR = 15;
    protected static final EntitySize aD = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float aE = 0.5f;
    public static final float aF = 0.5f;
    public static final String aG = "attributes";
    public static final Predicate<EntityLiving> aH = entityliving -> {
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            ItemStack itemstack = entityhuman.a(EnumItemSlot.f);
            return !itemstack.a(TagsItem.co);
        }
        return true;
    };
    private final AttributeMapBase bS;
    public CombatTracker bT = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> bU = Maps.newHashMap();
    private final NonNullList<ItemStack> bV;
    private final NonNullList<ItemStack> bW;
    private ItemStack bX;
    public boolean aI;
    private boolean bY;
    public EnumHand aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public int aO;
    public int aP;
    public float aQ;
    public float aR;
    protected int aS;
    public final WalkAnimationState aT;
    public int aU;
    public final float aV;
    public final float aW;
    public float aX;
    public float aY;
    public float aZ;
    public float ba;
    public final ElytraAnimationState bb;
    @Nullable
    public EntityHuman bc;
    public int bd;
    protected boolean be;
    protected int bf;
    protected float bg;
    protected float bh;
    protected float bi;
    protected float bj;
    protected float bk;
    protected int bl;
    public float bm;
    public boolean bn;
    public float bo;
    public float bp;
    public float bq;
    protected int br;
    protected double bs;
    protected double bt;
    protected double bu;
    protected double bv;
    protected double bw;
    protected double bx;
    protected int by;
    public boolean bZ;
    @Nullable
    public EntityLiving ca;
    public int cb;
    @Nullable
    private EntityLiving cc;
    private int cd;
    private float ce;
    private int cf;
    private float cg;
    protected ItemStack bz;
    public int bA;
    protected int bB;
    private BlockPosition ch;
    private Optional<BlockPosition> ci;
    @Nullable
    private DamageSource cj;
    private long ck;
    protected int bC;
    protected float bD;
    @Nullable
    protected ItemStack bE;
    private float cl;
    private float cm;
    protected BehaviorController<?> bF;
    protected boolean cn;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> co;
    protected float bG;
    public int expToDrop;
    public ArrayList<Entity.DefaultDrop> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;
    public int shieldBlockingDelay;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    @Override
    public float getBukkitYaw() {
        return this.cA();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bf;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World world) {
        super(type, world);
        this.shieldBlockingDelay = this.dW().paperConfig().misc.shieldBlockingDelay;
        this.bV = NonNullList.a(2, ItemStack.j);
        this.bW = NonNullList.a(4, ItemStack.j);
        this.bX = ItemStack.j;
        this.bY = false;
        this.aT = new WalkAnimationState();
        this.aU = 20;
        this.bb = new ElytraAnimationState(this);
        this.bZ = true;
        this.bz = ItemStack.j;
        this.ci = Optional.empty();
        this.co = new EnumMap(EnumItemSlot.class);
        this.bG = 1.0f;
        this.bS = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.bS);
        this.al.a(bL, Float.valueOf((float)this.g(GenericAttributes.s).g()));
        this.I = true;
        this.aW = (float)((Math.random() + 1.0) * (double)0.01f);
        this.ay();
        this.aV = (float)Math.random() * 12398.0f;
        this.v((float)(Math.random() * 6.2831854820251465));
        this.aZ = this.dM();
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bF = this.a(new Dynamic<NBTBase>(dynamicopsnbt, (NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap())))));
    }

    public BehaviorController<?> ec() {
        return this.bF;
    }

    protected BehaviorController.b<?> ed() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ed().a(dynamic);
    }

    @Override
    public void c(WorldServer world) {
        this.a(world, this.dX().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(aC, (byte)0);
        builder.a(bM, List.of());
        builder.a(bN, false);
        builder.a(bO, 0);
        builder.a(bP, 0);
        builder.a(bL, Float.valueOf(1.0f));
        builder.a(bQ, Optional.empty());
    }

    public static AttributeProvider.Builder ee() {
        return AttributeProvider.a().a(GenericAttributes.s).a(GenericAttributes.p).a(GenericAttributes.v).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.r).a(GenericAttributes.B).a(GenericAttributes.y).a(GenericAttributes.n).a(GenericAttributes.x).a(GenericAttributes.k).a(GenericAttributes.o).a(GenericAttributes.w).a(GenericAttributes.h).a(GenericAttributes.i).a(GenericAttributes.F).a(GenericAttributes.u).a(GenericAttributes.d);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        net.minecraft.world.level.World world;
        if (!this.bj()) {
            this.br();
        }
        if ((world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (onGround && this.Z > 0.0f) {
                this.b(worldserver, landedPosition);
                double d1 = this.h(GenericAttributes.x);
                if ((double)this.Z > d1 && !state.l()) {
                    double d2 = this.dB();
                    double d3 = this.dD();
                    double d4 = this.dH();
                    BlockPosition blockposition1 = this.dw();
                    if (landedPosition.u() != blockposition1.u() || landedPosition.w() != blockposition1.w()) {
                        double d5 = d2 - (double)landedPosition.u() - 0.5;
                        double d6 = d4 - (double)landedPosition.w() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)landedPosition.u() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)landedPosition.w() + 0.5 + d6 / d7 * 0.5;
                    }
                    float f2 = MathHelper.c((double)this.Z - d1);
                    double d8 = Math.min((double)(0.2f + f2 / 15.0f), 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        worldserver.sendParticles((EntityPlayer)this, new ParticleParamBlock(Particles.b, state), d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f, false);
                    } else {
                        worldserver.a(new ParticleParamBlock(Particles.b, state), d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    }
                }
            }
        }
        super.a(heightDifference, onGround, state, landedPosition);
        if (onGround) {
            this.ci = Optional.empty();
        }
    }

    public final boolean ef() {
        return this.aq().a(TagsEntity.m);
    }

    public float a(float tickDelta) {
        return MathHelper.h(tickDelta, this.cm, this.cl);
    }

    public boolean eg() {
        return this.dz().b() < (double)1.0E-5f && this.bn();
    }

    @Override
    public void az() {
        net.minecraft.world.level.World world;
        this.aQ = this.aR;
        if (this.ak) {
            this.fP().ifPresent(this::a);
        }
        if ((world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EnchantmentManager.b(worldserver, this);
        }
        super.az();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("livingEntityBaseTick");
        if (this.bi() || this.dW().C) {
            this.aH();
        }
        if (this.bL()) {
            double d0;
            WorldServer worldserver1;
            boolean flag = this instanceof EntityHuman;
            net.minecraft.world.level.World world1 = this.dW();
            if (world1 instanceof WorldServer) {
                double d1;
                worldserver1 = (WorldServer)world1;
                if (this.bM()) {
                    this.a(worldserver1, this.dX().g(), 1.0f);
                } else if (flag && !this.dW().F_().a(this.cR()) && (d1 = this.dW().F_().a(this) + this.dW().F_().n()) < 0.0 && (d0 = this.dW().F_().o()) > 0.0) {
                    this.a(worldserver1, this.dX().x(), (float)Math.max(1, MathHelper.a(-d1 * d0)));
                }
            }
            if (((Entity)this).a(TagsFluid.a) && !this.dW().a_(BlockPosition.a(this.dB(), this.dF(), this.dH())).a(Blocks.ny)) {
                boolean flag1;
                boolean bl = flag1 = !this.ef() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gj().a);
                if (flag1) {
                    this.j(this.l(this.ct()));
                    if (this.ct() == -20) {
                        this.j(0);
                        Vec3D vec3d = this.dz();
                        for (int i2 = 0; i2 < 8; ++i2) {
                            d0 = this.ae.j() - this.ae.j();
                            double d2 = this.ae.j() - this.ae.j();
                            double d3 = this.ae.j() - this.ae.j();
                            this.dW().a(Particles.d, this.dB() + d0, this.dD() + d2, this.dH() + d3, vec3d.d, vec3d.e, vec3d.f);
                        }
                        this.a(this.dX().i(), 2.0f);
                    }
                }
                if (!this.dW().C && this.bZ() && this.dl() != null && this.dl().cb()) {
                    this.ae();
                }
            } else if (this.ct() < this.cs()) {
                this.j(this.m(this.ct()));
            }
            world1 = this.dW();
            if (world1 instanceof WorldServer) {
                worldserver1 = (WorldServer)world1;
                BlockPosition blockposition = this.dw();
                if (!com.google.common.base.Objects.equal((Object)this.ch, (Object)blockposition)) {
                    this.ch = blockposition;
                    this.b(worldserver1, blockposition);
                }
            }
        }
        if (this.bL() && (this.bl() || this.av)) {
            this.aN();
        }
        if (this.aN > 0) {
            --this.aN;
        }
        if (this.aj > 0 && !(this instanceof EntityPlayer)) {
            --this.aj;
        }
        if (this.eF() && this.dW().h(this)) {
            this.em();
        }
        if (this.bd > 0) {
            --this.bd;
        } else {
            this.bc = null;
        }
        if (this.cc != null && !this.cc.bL()) {
            this.cc = null;
        }
        if (this.ca != null) {
            if (!this.ca.bL()) {
                this.a((EntityLiving)null);
            } else if (this.af - this.cb > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ew();
        this.bj = this.bi;
        this.aY = this.aX;
        this.ba = this.aZ;
        this.N = this.dM();
        this.O = this.dO();
        gameprofilerfiller.c();
    }

    @Override
    protected float aT() {
        return MathHelper.h((float)this.h(GenericAttributes.u), super.aT(), 1.0f);
    }

    protected void eh() {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (attributemodifiable != null && attributemodifiable.a(c) != null) {
            attributemodifiable.c(c);
        }
    }

    protected void ei() {
        int i2;
        if (!this.bt().l() && (i2 = this.cu()) > 0) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cv();
            attributemodifiable.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer world, BlockPosition pos) {
        EnchantmentManager.a(world, this);
    }

    public boolean e_() {
        return false;
    }

    public float ej() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float ek() {
        AttributeMapBase attributemapbase = this.eY();
        return attributemapbase == null ? 1.0f : this.b((float)attributemapbase.c(GenericAttributes.y));
    }

    protected float b(float scale) {
        return scale;
    }

    protected boolean el() {
        return true;
    }

    protected void em() {
        ++this.aP;
        if (this.aP >= 20 && !this.dW().B_() && !this.dR()) {
            this.dW().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean en() {
        return !this.e_();
    }

    protected boolean eo() {
        return !this.e_();
    }

    protected int l(int air) {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.w);
        double d0 = attributemodifiable != null ? attributemodifiable.g() : 0.0;
        return d0 > 0.0 && this.ae.j() >= 1.0 / (d0 + 1.0) ? air : air - 1;
    }

    protected int m(int air) {
        return Math.min(air + 4, this.cs());
    }

    public final int a(WorldServer world, @Nullable Entity attacker) {
        return EnchantmentManager.a(world, attacker, (Entity)this, this.e(world));
    }

    protected int e(WorldServer world) {
        return 0;
    }

    protected boolean ep() {
        return false;
    }

    @Nullable
    public EntityLiving eq() {
        return this.ca;
    }

    @Override
    public EntityLiving am() {
        return this.eq();
    }

    public int er() {
        return this.cb;
    }

    public void c(@Nullable EntityHuman attacking) {
        this.bc = attacking;
        this.bd = this.af;
    }

    public void a(@Nullable EntityLiving attacker) {
        this.ca = attacker;
        this.cb = this.af;
    }

    @Nullable
    public EntityLiving es() {
        return this.cc;
    }

    public int et() {
        return this.cd;
    }

    public void B(Entity target) {
        this.cc = target instanceof EntityLiving ? (EntityLiving)target : null;
        this.cd = this.af;
    }

    public int eu() {
        return this.bf;
    }

    public void n(int despawnCounter) {
        this.bf = despawnCounter;
    }

    public boolean ev() {
        return !this.frictionState.toBooleanOrElse(!this.bY);
    }

    public void r(boolean noDrag) {
        this.bY = noDrag;
    }

    protected boolean b(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldStack, ItemStack newStack) {
        this.onEquipItem(slot, oldStack, newStack, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!this.dW().B_() && !this.aa_()) {
            boolean flag;
            boolean bl = flag = itemstack1.f() && itemstack.f();
            if (!(flag || ItemStack.c(itemstack, itemstack1) || this.ak)) {
                Equippable equippable = itemstack1.a(DataComponents.D);
                if (!this.bb() && equippable != null && enumitemslot == equippable.a() && !silent) {
                    this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), equippable.b(), this.dn(), 1.0f, 1.0f, this.ae.g());
                }
                if (this.b(enumitemslot)) {
                    ((Entity)this).a(equippable != null ? GameEvent.v : GameEvent.S);
                }
            }
        }
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        net.minecraft.world.level.World world;
        if ((entity_removalreason == Entity.RemovalReason.a || entity_removalreason == Entity.RemovalReason.b) && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.bF.a();
    }

    protected void a(WorldServer world, Entity.RemovalReason reason) {
        for (MobEffect mobeffect : this.eB()) {
            mobeffect.a(world, this, reason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bU.clear();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", this.eE());
        nbt.a("HurtTime", (short)this.aN);
        nbt.a("HurtByTimestamp", this.cb);
        nbt.a("DeathTime", (short)this.aP);
        nbt.a("AbsorptionAmount", this.fw());
        nbt.a(aG, this.eY().d());
        if (!this.bU.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.bU.values()) {
                nbttaglist.add(mobeffect.j());
            }
            nbt.a(b, nbttaglist);
        }
        nbt.a("FallFlying", this.fJ());
        this.fP().ifPresent(blockposition -> {
            nbt.a("SleepingX", blockposition.u());
            nbt.a("SleepingY", blockposition.v());
            nbt.a("SleepingZ", blockposition.w());
        });
        DataResult<NBTBase> dataresult = this.bF.a(DynamicOpsNBT.a);
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("Brain", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        float absorptionAmount = nbt.j("AbsorptionAmount");
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.F(absorptionAmount);
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                a.error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (nbt.b(aG, 9) && this.dW() != null && !this.dW().C) {
            this.eY().a(nbt.c(aG, 10));
        }
        if (nbt.b(b, 9)) {
            NBTTagList nbttaglist = nbt.c(b, 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(i2);
                MobEffect mobeffect = MobEffect.a(nbttagcompound1);
                if (mobeffect == null) continue;
                this.bU.put(mobeffect.c(), mobeffect);
            }
        }
        if (nbt.e("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbt.c("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.g(GenericAttributes.s).a(((NBTTagFloat)nbtbase).j());
            } else if (nbtbase.b() == 3) {
                this.g(GenericAttributes.s).a(((NBTTagInt)nbtbase).j());
            }
        }
        if (nbt.b("Health", 99)) {
            this.x(nbt.j("Health"));
        }
        this.aN = nbt.g("HurtTime");
        this.aP = nbt.g("DeathTime");
        this.cb = nbt.h("HurtByTimestamp");
        if (nbt.b("Team", 8)) {
            boolean flag;
            String s2 = nbt.l("Team");
            Scoreboard scoreboard = this.dW().Q();
            ScoreboardTeam scoreboardteam = scoreboard.b(s2);
            if (!this.dW().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                scoreboardteam = null;
            }
            boolean bl = flag = scoreboardteam != null && scoreboard.a(this.cH(), scoreboardteam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)s2);
            }
        }
        if (nbt.q("FallFlying")) {
            this.b(7, true);
        }
        if (nbt.b("SleepingX", 99) && nbt.b("SleepingY", 99) && nbt.b("SleepingZ", 99)) {
            BlockPosition blockposition = new BlockPosition(nbt.h("SleepingX"), nbt.h("SleepingY"), nbt.h("SleepingZ"));
            if (this.du().c(blockposition.u(), blockposition.v(), blockposition.w()) < 256.0) {
                this.g(blockposition);
                this.al.a(Entity.aq, EntityPose.c);
                if (!this.ak) {
                    this.a(blockposition);
                }
            }
        }
        if (nbt.b("Brain", 10)) {
            this.bF = this.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Brain")));
        }
    }

    protected void ew() {
        List<ParticleParam> list;
        Iterator<Holder<MobEffectList>> iterator = this.bU.keySet().iterator();
        this.isTickingEffects = true;
        try {
            while (iterator.hasNext()) {
                Holder<MobEffectList> holder = iterator.next();
                MobEffect mobeffect = this.bU.get(holder);
                if (!mobeffect.a(this, () -> this.a(mobeffect, true, (Entity)null))) {
                    EntityPotionEffectEvent event;
                    if (this.dW().C || (event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION)).isCancelled()) continue;
                    iterator.remove();
                    this.c(List.of(mobeffect));
                    continue;
                }
                if (mobeffect.d() % 600 != 0) continue;
                this.a(mobeffect, false, (Entity)null);
            }
        }
        catch (ConcurrentModificationException holder) {
            // empty catch block
        }
        this.isTickingEffects = false;
        for (ProcessableEffect e2 : this.effectsToProcess) {
            if (e2.effect != null) {
                this.addEffect(e2.effect, e2.cause);
                continue;
            }
            this.removeEffect(e2.type, e2.cause);
        }
        this.effectsToProcess.clear();
        if (this.bZ) {
            if (!this.dW().C) {
                this.K();
                this.u();
            }
            this.bZ = false;
        }
        if (!(list = this.al.a(bM)).isEmpty()) {
            int j2;
            boolean flag = this.al.a(bN);
            int i2 = this.cp() ? 15 : 4;
            int n2 = j2 = flag ? 5 : 1;
            if (this.ae.a(i2 * j2) == 0) {
                this.dW().a(SystemUtils.a(list, this.ae), this.d(0.5), this.dE(), this.g(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void K() {
        if (this.bU.isEmpty()) {
            this.ez();
            this.k(false);
        } else {
            this.k(this.b(MobEffects.n));
            this.m();
        }
    }

    private void m() {
        List<ParticleParam> list = this.bU.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.al.a(bM, list);
        this.al.a(bN, EntityLiving.d(this.bU.values()));
    }

    private void u() {
        boolean flag = this.co();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double C(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.cg()) {
            d0 *= 0.8;
        }
        if (this.cp()) {
            float f2 = this.ff();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.aq();
            if (entitytypes == EntityTypes.bf && itemstack.a(Items.vb) || entitytypes == EntityTypes.bO && itemstack.a(Items.ve) || entitytypes == EntityTypes.aS && itemstack.a(Items.vh) || entitytypes == EntityTypes.aT && itemstack.a(Items.vh) || entitytypes == EntityTypes.F && itemstack.a(Items.vf)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving target) {
        return target instanceof EntityHuman && this.dW().al() == EnumDifficulty.a ? false : target.ex();
    }

    public boolean ex() {
        return !this.cC() && this.ey();
    }

    public boolean ey() {
        return !this.aa_() && this.bL();
    }

    public static boolean d(Collection<MobEffect> effects) {
        MobEffect mobeffect;
        Iterator<MobEffect> iterator = effects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(mobeffect = iterator.next()).g() || mobeffect.f());
        return false;
    }

    protected void ez() {
        this.al.a(bM, List.of());
    }

    public boolean eA() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dW().C) {
            return false;
        }
        if (this.bU.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.bU.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eB() {
        return this.bU.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eC() {
        return this.bU;
    }

    public boolean b(Holder<MobEffectList> effect) {
        return this.bU.containsKey(effect);
    }

    @Nullable
    public MobEffect c(Holder<MobEffectList> effect) {
        return this.bU.get(effect);
    }

    public final boolean a(MobEffect effect) {
        return this.b(effect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect effect, @Nullable Entity source) {
        return this.addEffect(effect, source, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, entity, cause, true);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.b(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bU.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobeffect1 == null) {
            this.bU.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
            mobeffect.b(this);
        } else if (override) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean b(MobEffect effect) {
        return this.aq().a(TagsEntity.G) ? !effect.a(MobEffects.M) : (this.aq().a(TagsEntity.F) ? !effect.a(MobEffects.L) : (!this.aq().a(TagsEntity.w) ? true : !effect.a(MobEffects.j) && !effect.a(MobEffects.s)));
    }

    public void c(MobEffect effect, @Nullable Entity source) {
        if (this.b(effect)) {
            MobEffect mobeffect1 = this.bU.put(effect.c(), effect);
            if (mobeffect1 == null) {
                this.a(effect, source);
            } else {
                effect.d(mobeffect1);
                this.a(effect, true, source);
            }
        }
    }

    public boolean eD() {
        return this.aq().a(TagsEntity.x);
    }

    @Nullable
    public MobEffect d(Holder<MobEffectList> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.bU.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bU.remove(holder);
    }

    public boolean e(Holder<MobEffectList> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.c(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void a(MobEffect effect, @Nullable Entity source) {
        this.bZ = true;
        if (!this.dW().C) {
            effect.c().a().a(this.eY(), effect.e());
            this.c(effect);
        }
    }

    public void c(MobEffect effect) {
        for (Entity entity : this.cZ()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.f.b(new PacketPlayOutEntityEffect(this.ar(), effect, false));
        }
    }

    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable Entity source) {
        this.bZ = true;
        if (reapplyEffect && !this.dW().C) {
            MobEffectList mobeffectlist = effect.c().a();
            mobeffectlist.a(this.eY());
            mobeffectlist.a(this.eY(), effect.e());
            this.B();
        }
        if (!this.dW().C) {
            this.c(effect);
        }
    }

    protected void c(Collection<MobEffect> effects) {
        this.bZ = true;
        if (!this.dW().C) {
            for (MobEffect mobeffect : effects) {
                mobeffect.c().a().a(this.eY());
                for (Entity entity : this.cZ()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.f.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobeffect.c()));
                }
            }
            this.B();
        }
    }

    private void B() {
        Set<AttributeModifiable> set = this.eY().b();
        for (AttributeModifiable attributemodifiable : set) {
            this.f(attributemodifiable.a());
        }
        set.clear();
    }

    protected void f(Holder<AttributeBase> attribute) {
        if (attribute.a(GenericAttributes.s)) {
            float f2 = this.eS();
            if (this.eE() > f2) {
                this.x(f2);
            }
        } else if (attribute.a(GenericAttributes.r)) {
            float f3 = this.eT();
            if (this.fw() > f3) {
                this.E(f3);
            }
        }
    }

    public void c(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(f2, regainReason, false);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float f1 = this.eE();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason, isFastRegen);
            if (this.valid) {
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eE() + event.getAmount()));
            }
        }
    }

    public float eE() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.al.a(bL).floatValue();
    }

    public void x(float health) {
        if (Float.isNaN(health)) {
            health = this.eS();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cI() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.al.a(bL, Float.valueOf(MathHelper.a(health, 0.0f, this.eS())));
    }

    public boolean eF() {
        return this.eE() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        EntityPlayer entityplayer;
        boolean flag2;
        float f1;
        if (this.a(world, source)) {
            return false;
        }
        if (this.dR() || this.be || this.eE() <= 0.0f) {
            return false;
        }
        if (source.a(DamageTypeTags.i) && this.b(MobEffects.l)) {
            return false;
        }
        if (this.fR()) {
            this.fS();
        }
        this.bf = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        float originalAmount = f1 = amount;
        boolean flag = amount > 0.0f && this.g(source);
        float f2 = 0.0f;
        this.aT.a(1.5f);
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.aj > (float)this.aU / 2.0f && !source.a(DamageTypeTags.e)) {
            if (amount <= this.bm) {
                return false;
            }
            event = this.handleEntityDamage(source, amount, this.bm);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(world, source, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.bm = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(source, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(world, source, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.bm = amount;
            this.aj = this.aU;
            this.aN = this.aO = 10;
        }
        Entity entity1 = source.d();
        if (entity1 != null) {
            EntityWolf entitywolf;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity1;
                if (!(source.a(DamageTypeTags.q) || source.a(DamageTypes.I) && this.aq().a(TagsEntity.E))) {
                    this.a(entityliving1);
                }
            }
            if (entity1 instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity1;
                this.bd = 100;
                this.bc = entityhuman;
            } else if (entity1 instanceof EntityWolf && (entitywolf = (EntityWolf)entity1).p()) {
                EntityHuman entityhuman1;
                this.bd = 100;
                EntityLiving entityliving2 = entitywolf.ah_();
                this.bc = entityliving2 instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving2) : null;
            }
        }
        if (flag1) {
            if (flag) {
                world.a((Entity)this, (byte)29);
            } else {
                world.a((Entity)this, source);
            }
            if (!source.a(DamageTypeTags.r) && !flag) {
                this.bD();
            }
            if (!source.a(DamageTypeTags.z)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity2 = source.c();
                if (entity2 instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity2;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.a_(this, source);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (source.i() != null) {
                    d0 = source.i().a() - this.dB();
                    d1 = source.i().c() - this.dH();
                }
                if (Math.abs(d0) > 200.0) {
                    d0 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d0, d1, entity1, entity1 == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.eF()) {
            if (!this.h(source)) {
                this.silentDeath = !flag1;
                this.a(source);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.f(source);
        }
        boolean bl = flag2 = !flag;
        if (flag2) {
            this.cj = source;
            this.ck = this.dW().ac();
            for (MobEffect mobeffect : this.eB()) {
                mobeffect.a(world, this, source, amount);
            }
        }
        if (this instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)this;
            CriterionTriggers.i.a(entityplayer, source, f1, amount, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                entityplayer.a(StatisticList.K, Math.round(f2 * 10.0f));
            }
        }
        if (entity1 instanceof EntityPlayer) {
            entityplayer = (EntityPlayer)entity1;
            CriterionTriggers.h.a(entityplayer, this, source, f1, amount, flag);
        }
        return flag2;
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void d(EntityLiving attacker) {
        attacker.e(this);
    }

    protected void e(EntityLiving target) {
        target.knockback(0.5, target.dB() - this.dB(), target.dH() - this.dH(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean h(DamageSource source) {
        if (source.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        EnumHand[] aenumhand = EnumHand.values();
        int i2 = aenumhand.length;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.j;
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumHand enumhand = aenumhand[j2];
            itemstack1 = this.b(enumhand);
            deathprotection = itemstack1.a(DataComponents.H);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.f() && itemstack != null) {
                itemstack1.h(1);
            }
            if (deathprotection == null) {
                deathprotection = DeathProtection.c;
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(itemstack.h()));
                CriterionTriggers.C.a(entityplayer, itemstack);
                ((Entity)this).a(GameEvent.C);
            }
            this.x(1.0f);
            deathprotection.a(itemstack, this);
            this.dW().a((Entity)this, (byte)35);
        }
        return deathprotection != null;
    }

    @Nullable
    public DamageSource eG() {
        if (this.dW().ac() - this.ck > 40L) {
            this.cj = null;
        }
        return this.cj;
    }

    protected void f(DamageSource damageSource) {
        this.b(this.e(damageSource));
    }

    public void b(@Nullable SoundEffect sound) {
        if (sound != null) {
            this.a(sound, this.fg(), this.fh());
        }
    }

    public boolean g(DamageSource source) {
        Vec3D vec3d;
        EntityArrow entityarrow;
        Entity entity = source.c();
        boolean flag = false;
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).z() > 0) {
            flag = true;
        }
        ItemStack itemstack = this.fH();
        if (!source.a(DamageTypeTags.c) && itemstack != null && itemstack.h() instanceof ItemShield && !flag && (vec3d = source.i()) != null) {
            Vec3D vec3d1 = this.d(0.0f, this.cA());
            Vec3D vec3d2 = vec3d.a(this.du());
            vec3d2 = new Vec3D(vec3d2.d, 0.0, vec3d2.f).d();
            return vec3d2.b(vec3d1) < 0.0;
        }
        return false;
    }

    private void g(ItemStack stack) {
        if (!stack.f()) {
            if (!this.bb()) {
                this.dW().a(this.dB(), this.dD(), this.dH(), stack.M(), this.dn(), 0.8f, 0.8f + this.dW().A.i() * 0.4f, false);
            }
            this.b(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dR() && !this.be) {
            Entity entity = damageSource.d();
            EntityLiving entityliving = this.eR();
            this.be = true;
            net.minecraft.world.level.World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(worldserver, damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.j);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fR()) {
                        this.fS();
                    }
                    if (!this.dW().C && this.l_() && SpigotConfig.logNamedDeaths) {
                        a.info("Named entity {} died: {}", (Object)this, (Object)this.eQ().a().getString());
                    }
                    this.eQ().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.dW(), this);
                    }
                    ((Entity)this).a(GameEvent.p);
                } else {
                    this.be = false;
                    this.x((float)deathEvent.getReviveHealth());
                }
                this.f(entityliving);
            }
            if (this.be) {
                this.dW().a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void f(@Nullable EntityLiving adversary) {
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            boolean flag = false;
            if (this.be && adversary instanceof EntityWither) {
                if (worldserver.N().b(GameRules.c)) {
                    BlockPosition blockposition = this.dw();
                    IBlockData iblockdata = Blocks.ck.m();
                    if (this.dW().a_(blockposition).l() && iblockdata.a((IWorldReader)this.dW(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.dW(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.dW(), this.dB(), this.dD(), this.dH(), new ItemStack(Items.dD));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dW().b(entityitem);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(WorldServer world, DamageSource damageSource) {
        boolean flag = this.bd > 0;
        this.f(world);
        if (this.eo() && world.N().b(GameRules.f)) {
            this.b(world, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(world, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            EntityLiving entityliving = this.eR();
            if (this.bl >= 0 && entityliving != null) {
                entityliving.a((Entity)this, this.bl, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList();
        this.b(world, damageSource.d());
        return deathEvent;
    }

    protected void f(WorldServer world) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(WorldServer worldserver, @Nullable Entity entity) {
        if (!this.eJ() && (this.ep() || this.bd > 0 && this.en() && worldserver.N().b(GameRules.f))) {
            return this.a(worldserver, entity);
        }
        return 0;
    }

    protected void b(WorldServer world, @Nullable Entity attacker) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.award(world, this.du(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, attacker, this);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
    }

    public long eH() {
        return 0L;
    }

    protected float a(Entity target, DamageSource damageSource) {
        float f2 = (float)this.h(GenericAttributes.d);
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.d(worldserver, this.ea(), target, damageSource, f2);
        }
        return f2;
    }

    protected void b(WorldServer world, DamageSource damageSource, boolean causedByPlayer) {
        Optional<ResourceKey<LootTable>> optional = this.eb();
        if (!optional.isEmpty()) {
            LootTable loottable = world.p().bc().b(optional.get());
            LootParams.a lootparams_a = new LootParams.a(world).a(LootContextParameters.a, this).a(LootContextParameters.f, this.du()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c());
            if (causedByPlayer && this.bc != null) {
                lootparams_a = lootparams_a.a(LootContextParameters.b, this.bc).a(this.bc.gF());
            }
            LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
            loottable.a(lootparams, this.eH(), (ItemStack itemstack) -> this.a(world, (ItemStack)itemstack));
        }
    }

    public boolean a(WorldServer world, ResourceKey<LootTable> lootTableKey, BiConsumer<WorldServer, ItemStack> lootConsumer) {
        return this.a(world, lootTableKey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.du()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), lootConsumer);
    }

    protected void a(WorldServer world, ResourceKey<LootTable> lootTableKey, ItemStack tool, BiConsumer<WorldServer, ItemStack> lootConsumer) {
        this.a(world, lootTableKey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.du()).a(LootContextParameters.a, this).a(LootContextParameters.i, tool).a(LootContextParameterSets.s), lootConsumer);
    }

    protected boolean a(WorldServer world, ResourceKey<LootTable> lootTableKey, Function<LootParams.a, LootParams> lootContextParametersFactory, BiConsumer<WorldServer, ItemStack> lootConsumer) {
        LootParams lootparams;
        LootTable loottable = world.p().bc().b(lootTableKey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams = lootContextParametersFactory.apply(new LootParams.a(world)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> lootConsumer.accept(world, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void p(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        d0 *= 1.0 - this.h(GenericAttributes.p);
        Vec3D vec3d = this.dz();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().c(d0);
        Vec3D finalVelocity = new Vec3D(vec3d.d / 2.0 - vec3d1.d, this.aJ() ? Math.min(0.4, vec3d.e / 2.0 + d0) : vec3d.e, vec3d.f / 2.0 - vec3d1.f);
        Vec3D diff = finalVelocity.d(vec3d);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, cause, d0, diff);
        if (event.isCancelled()) {
            return;
        }
        this.ar = true;
        this.h(vec3d.b(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void a(double deltaX, double deltaZ) {
    }

    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.kA;
    }

    @Nullable
    public SoundEffect o_() {
        return SoundEffects.kv;
    }

    private SoundEffect q(int distance) {
        return distance > 4 ? this.eM().b() : this.eM().a();
    }

    public void eI() {
        this.cn = true;
    }

    public boolean eJ() {
        return this.cn;
    }

    public float eK() {
        return 0.0f;
    }

    protected AxisAlignedBB eL() {
        AxisAlignedBB axisalignedbb = this.cR();
        Entity entity = this.dl();
        if (entity != null) {
            Vec3D vec3d = entity.m(this);
            return axisalignedbb.b(Math.max(vec3d.e, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot slot) {
        return (Map)this.co.computeIfAbsent(slot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public a eM() {
        return new a(SoundEffects.kB, SoundEffects.kt);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.e(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.o_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> eN() {
        return this.ci;
    }

    public boolean q_() {
        if (this.aa_()) {
            return false;
        }
        BlockPosition blockposition = this.dw();
        IBlockData iblockdata = this.dx();
        if (iblockdata.a(TagsBlock.aS)) {
            this.ci = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.ci = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        if (!state.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.dW().a_(pos.e());
        return iblockdata1.a(Blocks.cX) && iblockdata1.c(BlockLadder.b) == state.c(BlockFacingHorizontal.aF);
    }

    @Override
    public boolean bL() {
        return !this.dR() && this.eE() > 0.0f && !this.be;
    }

    public boolean a(EntityLiving entity, double d0, boolean flag, boolean visualShape, Predicate<EntityLiving> predicate, DoubleSupplier ... entityYChecks) {
        if (!predicate.test(entity)) {
            return false;
        }
        Vec3D vec3d = entity.g(1.0f).d();
        DoubleSupplier[] adoublesupplier1 = entityYChecks;
        int i2 = entityYChecks.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            DoubleSupplier doublesupplier = adoublesupplier1[j2];
            Vec3D vec3d1 = new Vec3D(this.dB() - entity.dB(), doublesupplier.getAsDouble() - entity.dF(), this.dH() - entity.dH());
            double d1 = vec3d1.g();
            vec3d1 = vec3d1.d();
            double d2 = vec3d.b(vec3d1);
            double d3 = flag ? d1 : 1.0;
            if (!(d2 > 1.0 - d0 / d3)) continue;
            return entity.a(this, visualShape ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, doublesupplier);
        }
        return false;
    }

    @Override
    public int cE() {
        return this.y(0.0f);
    }

    protected final int y(float health) {
        return MathHelper.d(health + 3.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.f(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.dW(), damageSource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.eO();
            return true;
        }
        return flag;
    }

    protected int f(float fallDistance, float damageMultiplier) {
        if (this.aq().a(TagsEntity.o)) {
            return 0;
        }
        float f2 = (float)this.h(GenericAttributes.x);
        float f3 = fallDistance - f2;
        return MathHelper.c((double)(f3 * damageMultiplier) * this.h(GenericAttributes.k));
    }

    protected void eO() {
        if (!this.bb()) {
            int i2 = MathHelper.a(this.dB());
            int j2 = MathHelper.a(this.dD() - (double)0.2f);
            int k2 = MathHelper.a(this.dH());
            IBlockData iblockdata = this.dW().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.l()) {
                SoundEffectType soundeffecttype = iblockdata.A();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void p(float yaw) {
        this.aN = this.aO = 10;
    }

    public int eP() {
        return MathHelper.a(this.h(GenericAttributes.a));
    }

    protected void c(DamageSource source, float amount) {
    }

    protected void d(DamageSource source, float amount) {
    }

    protected void z(float amount) {
    }

    protected void a(DamageSource source, float amount, EnumItemSlot ... slots) {
        if (amount > 0.0f) {
            int i2 = (int)Math.max(1.0f, amount / 4.0f);
            EnumItemSlot[] aenumitemslot1 = slots;
            int j2 = slots.length;
            for (int k2 = 0; k2 < j2; ++k2) {
                EnumItemSlot enumitemslot = aenumitemslot1[k2];
                ItemStack itemstack = this.a(enumitemslot);
                Equippable equippable = itemstack.a(DataComponents.D);
                if (equippable == null || !equippable.h() || !itemstack.m() || !itemstack.a(source)) continue;
                itemstack.a(i2, this, enumitemslot);
            }
        }
    }

    protected float e(DamageSource source, float amount) {
        if (!source.a(DamageTypeTags.b)) {
            amount = CombatMath.a(this, amount, source, this.eP(), (float)this.h(GenericAttributes.b));
        }
        return amount;
    }

    protected float f(DamageSource source, float amount) {
        float f4;
        if (source.a(DamageTypeTags.f)) {
            return amount;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (source.a(DamageTypeTags.h)) {
            return amount;
        }
        net.minecraft.world.level.World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.b(worldserver, this, source);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            amount = CombatMath.a(amount, f4);
        }
        return amount;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2, float invulnerabilityRelatedLastDamage) {
        float originalDamage = f2;
        com.google.common.base.Function invulnerabilityReductionEquation = d2 -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (d2 < (double)invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)f2)).floatValue();
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.aq().a(TagsEntity.l)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)(f2 += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(EntityLiving.this.g(damagesource) ? f2 : 0.0);
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.b(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.c(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fw(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.a(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.d() instanceof EntityHuman) {
                if (damagesource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damagesource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.H(0.0f)).callEvent()) {
                        player.gD();
                    }
                } else {
                    ((EntityHuman)damagesource.d()).gD();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.c(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.z((float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
                Entity entity2 = damagesource.c();
                if (!damagesource.a(DamageTypeTags.j) && entity2 instanceof EntityLiving && entity2.g(this) <= 40000.0) {
                    this.d((EntityLiving)entity2);
                }
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fw() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                this.eQ().a(damagesource, f2);
                this.x(this.eE() - f2);
                if (!human) {
                    this.E(this.fw() - f2);
                }
                ((Entity)this).a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, originalDamage, f2, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, originalDamage, f2, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker eQ() {
        return this.bT;
    }

    @Nullable
    public EntityLiving eR() {
        return this.bc != null ? this.bc : (this.ca != null ? this.ca : null);
    }

    public final float eS() {
        return (float)this.h(GenericAttributes.s);
    }

    public final float eT() {
        return (float)this.h(GenericAttributes.r);
    }

    public final int eU() {
        return this.al.a(bO);
    }

    public final void o(int stuckArrowCount) {
        this.setArrowCount(stuckArrowCount, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eU(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.al.a(bO, event.getNewAmount());
    }

    public final int eV() {
        return this.al.a(bP);
    }

    public final void p(int stingerCount) {
        this.al.a(bP, stingerCount);
    }

    private int C() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.b(MobEffects.d) ? 6 + (1 + this.c(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean fromServerPlayer) {
        if (!this.aI || this.aK >= this.C() / 2 || this.aK < 0) {
            this.aK = -1;
            this.aI = true;
            this.aJ = hand;
            if (this.dW() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.dW()).m();
                if (fromServerPlayer) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aT.a(1.5f);
        this.aj = 20;
        this.aN = this.aO = 10;
        SoundEffect soundeffect = this.e(damageSource);
        if (soundeffect != null) {
            this.a(soundeffect, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
        }
        this.cj = damageSource;
        this.ck = this.dW().ac();
    }

    @Override
    public void b(byte status) {
        switch (status) {
            case 3: {
                SoundEffect soundeffect = this.o_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.dX().p());
                break;
            }
            case 29: {
                this.a(SoundEffects.wX, 1.0f, 0.8f + this.dW().A.i() * 0.4f);
                break;
            }
            case 30: {
                this.a(SoundEffects.wY, 0.8f, 0.8f + this.dW().A.i() * 0.4f);
                break;
            }
            case 46: {
                boolean flag = true;
                for (int i2 = 0; i2 < 128; ++i2) {
                    double d0 = (double)i2 / 127.0;
                    float f2 = (this.ae.i() - 0.5f) * 0.2f;
                    float f1 = (this.ae.i() - 0.5f) * 0.2f;
                    float f22 = (this.ae.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.K, this.dB()) + (this.ae.j() - 0.5) * (double)this.dr() * 2.0;
                    double d2 = MathHelper.d(d0, this.L, this.dD()) + this.ae.j() * (double)this.ds();
                    double d3 = MathHelper.d(d0, this.M, this.dH()) + (this.ae.j() - 0.5) * (double)this.dr() * 2.0;
                    this.dW().a(Particles.ad, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                return;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.D();
                break;
            }
            case 60: {
                this.eW();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            default: {
                super.b(status);
            }
        }
    }

    public void eW() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            double d3 = 10.0;
            this.dW().a(Particles.ac, this.d(1.0) - d0 * 10.0, this.dE() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void D() {
        ItemStack itemstack = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aI() {
        this.a(this.dX().o(), this.dW().getWorld().getVoidDamageAmount());
    }

    protected void eX() {
        int i2 = this.C();
        if (this.aI) {
            ++this.aK;
            if (this.aK >= i2) {
                this.aK = 0;
                this.aI = false;
            }
        } else {
            this.aK = 0;
        }
        this.aR = (float)this.aK / (float)i2;
    }

    @Nullable
    public AttributeModifiable g(Holder<AttributeBase> attribute) {
        return this.eY().a(attribute);
    }

    public double h(Holder<AttributeBase> attribute) {
        return this.eY().c(attribute);
    }

    public double i(Holder<AttributeBase> attribute) {
        return this.eY().d(attribute);
    }

    public AttributeMapBase eY() {
        return this.bS;
    }

    public ItemStack eZ() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fa() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack a(EnumMainHand arm) {
        return this.fy() == arm ? this.eZ() : this.fa();
    }

    @Override
    @Nonnull
    public ItemStack ea() {
        return this.eZ();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.eZ()) || predicate.test(this.fa());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean d(EnumItemSlot slot) {
        return !this.a(slot).f();
    }

    public boolean e(EnumItemSlot slot) {
        return false;
    }

    public abstract Iterable<ItemStack> fb();

    public abstract ItemStack a(EnumItemSlot var1);

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.a(enumitemslot, itemstack);
    }

    public abstract void a(EnumItemSlot var1, ItemStack var2);

    public Iterable<ItemStack> fc() {
        return List.of();
    }

    public Iterable<ItemStack> fd() {
        return this.fb();
    }

    public Iterable<ItemStack> fe() {
        return Iterables.concat(this.fc(), this.fd());
    }

    protected void c(ItemStack stack) {
        stack.h().l(stack);
    }

    public float ff() {
        Iterable<ItemStack> iterable = this.fb();
        int i2 = 0;
        int j2 = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.f()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void h(boolean sprinting) {
        super.h(sprinting);
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        attributemodifiable.c(k.b());
        if (sprinting) {
            attributemodifiable.b(k);
        }
    }

    public float fg() {
        return 1.0f;
    }

    public float fh() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 1.5f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    protected boolean fi() {
        return this.eF();
    }

    @Override
    public void h(Entity entity) {
        if (!this.fR()) {
            super.h(entity);
        }
    }

    private void c(Entity vehicle) {
        Vec3D vec3d;
        if (this.dR()) {
            vec3d = this.du();
        } else if (!vehicle.dR() && !this.dW().a_(vehicle.dw()).a(TagsBlock.aM)) {
            vec3d = vehicle.b(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.dD(), vehicle.dD());
            vec3d = new Vec3D(this.dB(), d0, this.dH());
            boolean bl = flag = this.dr() <= 4.0f && this.ds() <= 4.0f;
            if (flag) {
                double d1 = (double)this.ds() / 2.0;
                Vec3D vec3d1 = vec3d.b(0.0, d1, 0.0);
                VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, this.dr(), this.ds(), this.dr()));
                vec3d = this.dW().a((Entity)this, voxelshape, vec3d1, (double)this.dr(), (double)this.ds(), (double)this.dr()).map(vec3d2 -> vec3d2.b(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.a(vec3d.d, vec3d.e, vec3d.f);
    }

    @Override
    public boolean cM() {
        return this.cL();
    }

    protected float fj() {
        return this.A(1.0f);
    }

    protected float A(float strength) {
        return (float)this.h(GenericAttributes.o) * strength * this.aS() + this.fk();
    }

    public float fk() {
        return this.b(MobEffects.h) ? 0.1f * ((float)this.c(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void s() {
        float f2 = this.fj();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.dz();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof EntityHuman) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.n(vec3d.d, Math.max((double)f2, vec3d.e), vec3d.f);
            if (this.cj()) {
                float f1 = this.dM() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.i(new Vec3D((double)(-MathHelper.a(f1)) * 0.2, 0.0, (double)MathHelper.b(f1) * 0.2));
                }
            }
            this.ar = true;
        }
    }

    protected void fl() {
        this.h(this.dz().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluid) {
        this.h(this.dz().b(0.0, 0.04f, 0.0));
    }

    protected float fm() {
        return 0.8f;
    }

    public boolean a(Fluid state) {
        return false;
    }

    @Override
    protected double bd() {
        return this.h(GenericAttributes.n);
    }

    protected double fn() {
        boolean flag = this.dz().e <= 0.0;
        return flag && this.b(MobEffects.B) ? Math.min(this.be(), 0.01) : this.be();
    }

    public void a_(Vec3D movementInput) {
        if (this.di()) {
            Fluid fluid = this.dW().b_(this.dw());
            if ((this.bj() || this.bx()) && this.el() && !this.a(fluid)) {
                this.l(movementInput);
            } else if (this.fJ()) {
                this.E();
            } else {
                this.k(movementInput);
            }
        }
    }

    private void k(Vec3D movementInput) {
        BlockPosition blockposition = this.aQ();
        float f2 = this.aJ() ? this.dW().a_(blockposition).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3d1 = this.a(movementInput, f2);
        double d0 = vec3d1.e;
        MobEffect mobeffect = this.c(MobEffects.y);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.e) * 0.2) : (this.dW().C && !this.dW().B(blockposition) ? (this.dD() > (double)this.dW().L_() ? -0.1 : 0.0) : (d0 -= this.fn()));
        if (this.ev()) {
            this.n(vec3d1.d, d0, vec3d1.f);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.n(vec3d1.d * (double)f1, d0 * (double)f22, vec3d1.f * (double)f1);
        }
    }

    private void l(Vec3D movementInput) {
        Vec3D vec3d1;
        boolean flag = this.dz().e <= 0.0;
        double d0 = this.dD();
        double d1 = this.fn();
        if (this.bj()) {
            float f2 = this.cj() ? 0.9f : this.fm();
            float f1 = 0.02f;
            float f22 = (float)this.h(GenericAttributes.F);
            if (!this.aJ()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fp() - f1) * f22;
            }
            if (this.b(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, movementInput);
            this.a(EnumMoveType.a, this.dz());
            Vec3D vec3d2 = this.dz();
            if (this.P && this.q_()) {
                vec3d2 = new Vec3D(vec3d2.d, 0.2, vec3d2.f);
            }
            vec3d2 = vec3d2.d(f2, 0.8f, f2);
            this.h(this.a(d1, flag, vec3d2));
        } else {
            this.a(0.02f, movementInput);
            this.a(EnumMoveType.a, this.dz());
            if (this.b(TagsFluid.b) <= this.dq()) {
                this.h(this.dz().d(0.5, 0.8f, 0.5));
                vec3d1 = this.a(d1, flag, this.dz());
                this.h(vec3d1);
            } else {
                this.h(this.dz().c(0.5));
            }
            if (d1 != 0.0) {
                this.h(this.dz().b(0.0, -d1 / 4.0, 0.0));
            }
        }
        vec3d1 = this.dz();
        if (this.P && this.g(vec3d1.d, vec3d1.e + (double)0.6f - this.dD() + d0, vec3d1.f)) {
            this.n(vec3d1.d, 0.3f, vec3d1.f);
        }
    }

    private void E() {
        Vec3D vec3d = this.dz();
        double d0 = vec3d.i();
        this.h(this.m(vec3d));
        this.a(EnumMoveType.a, this.dz());
        if (!this.dW().C) {
            double d1 = this.dz().i();
            this.c(d0, d1);
        }
    }

    private Vec3D m(Vec3D oldVelocity) {
        double d4;
        Vec3D vec3d1 = this.bT();
        float f2 = this.dO() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.d * vec3d1.d + vec3d1.f * vec3d1.f);
        double d1 = oldVelocity.i();
        double d2 = this.fn();
        double d3 = MathHelper.k(Math.cos(f2));
        oldVelocity = oldVelocity.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (oldVelocity.e < 0.0 && d0 > 0.0) {
            d4 = oldVelocity.e * -0.1 * d3;
            oldVelocity = oldVelocity.b(vec3d1.d * d4 / d0, d4, vec3d1.f * d4 / d0);
        }
        if (f2 < 0.0f && d0 > 0.0) {
            d4 = d1 * (double)(-MathHelper.a(f2)) * 0.04;
            oldVelocity = oldVelocity.b(-vec3d1.d * d4 / d0, d4 * 3.2, -vec3d1.f * d4 / d0);
        }
        if (d0 > 0.0) {
            oldVelocity = oldVelocity.b((vec3d1.d / d0 * d1 - oldVelocity.d) * 0.1, 0.0, (vec3d1.f / d0 * d1 - oldVelocity.f) * 0.1);
        }
        return oldVelocity.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double oldSpeed, double newSpeed) {
        double d2;
        float f2;
        if (this.P && (f2 = (float)((d2 = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.dX().n(), f2);
        }
    }

    private void c(EntityHuman controllingPlayer, Vec3D movementInput) {
        Vec3D vec3d1 = this.b(controllingPlayer, movementInput);
        this.a(controllingPlayer, vec3d1);
        if (this.di()) {
            this.C(this.e(controllingPlayer));
            this.a_(vec3d1);
        } else {
            this.h(Vec3D.c);
        }
    }

    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
    }

    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return movementInput;
    }

    protected float e(EntityHuman controllingPlayer) {
        return this.fp();
    }

    public void s(boolean flutter) {
        float f2 = (float)MathHelper.g(this.dB() - this.K, flutter ? this.dD() - this.L : 0.0, this.dH() - this.M);
        if (!this.bZ() && this.bL()) {
            this.B(f2);
        } else {
            this.aT.a();
        }
    }

    protected void B(float posDelta) {
        float f1 = Math.min(posDelta * 4.0f, 1.0f);
        this.aT.a(f1, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D a(Vec3D movementInput, float slipperiness) {
        this.a(this.G(slipperiness), movementInput);
        this.h(this.n(this.dz()));
        this.a(EnumMoveType.a, this.dz());
        Vec3D vec3d1 = this.dz();
        if ((this.P || this.bn) && (this.q_() || this.dx().a(Blocks.rk) && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
        }
        return vec3d1;
    }

    public Vec3D a(double gravity, boolean falling, Vec3D motion) {
        if (gravity != 0.0 && !this.cj()) {
            double d1 = falling && Math.abs(motion.e - 0.005) >= 0.003 && Math.abs(motion.e - gravity / 16.0) < 0.003 ? -0.003 : motion.e - gravity / 16.0;
            return new Vec3D(motion.d, d1, motion.f);
        }
        return motion;
    }

    private Vec3D n(Vec3D motion) {
        if (this.q_()) {
            this.k();
            float f2 = 0.15f;
            double d0 = MathHelper.a(motion.d, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(motion.f, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(motion.e, (double)-0.15f);
            if (d2 < 0.0 && !this.dx().a(Blocks.on) && this.fI() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            motion = new Vec3D(d0, d2, d1);
        }
        return motion;
    }

    private float G(float slipperiness) {
        return this.aJ() ? this.fp() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.fo();
    }

    protected float fo() {
        return this.cX() instanceof EntityHuman ? this.fp() * 0.1f : 0.02f;
    }

    public float fp() {
        return this.ce;
    }

    public void C(float movementSpeed) {
        this.ce = movementSpeed;
    }

    public boolean c(WorldServer world, Entity target) {
        this.B(target);
        return false;
    }

    @Override
    public void h() {
        float f4;
        super.h();
        this.H();
        this.I();
        if (!this.dW().C) {
            int j2;
            int i2 = this.eU();
            if (i2 > 0) {
                if (this.aL <= 0) {
                    this.aL = 20 * (30 - i2);
                }
                --this.aL;
                if (this.aL <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.eV()) > 0) {
                if (this.aM <= 0) {
                    this.aM = 20 * (30 - j2);
                }
                --this.aM;
                if (this.aM <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.af % 20 == 0) {
                this.eQ().c();
            }
            if (this.fR() && !this.J()) {
                this.fS();
            }
        }
        if (!this.dR()) {
            this.d_();
        }
        double d0 = this.dB() - this.K;
        double d1 = this.dH() - this.M;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aX;
        float f22 = 0.0f;
        this.bg = this.bh;
        float f3 = 0.0f;
        if (f2 > 0.0025000002f) {
            f3 = 1.0f;
            f22 = (float)Math.sqrt(f2) * 3.0f;
            float f5 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            f4 = MathHelper.e(MathHelper.h(this.dM()) - f5);
            f1 = 95.0f < f4 && f4 < 265.0f ? f5 - 180.0f : f5;
        }
        if (this.aR > 0.0f) {
            f1 = this.dM();
        }
        if (!this.aJ()) {
            f3 = 0.0f;
        }
        this.bh += (f3 - this.bh) * 0.3f;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("headTurn");
        f22 = this.g(f1, f22);
        gameprofilerfiller.c();
        gameprofilerfiller.a("rangeChecks");
        this.N += (float)Math.round((this.dM() - this.N) / 360.0f) * 360.0f;
        this.aY += (float)Math.round((this.aX - this.aY) / 360.0f) * 360.0f;
        this.O += (float)Math.round((this.dO() - this.O) / 360.0f) * 360.0f;
        this.ba += (float)Math.round((this.aZ - this.ba) / 360.0f) * 360.0f;
        gameprofilerfiller.c();
        this.bi += f22;
        this.bB = this.fJ() ? ++this.bB : 0;
        if (this.fR()) {
            this.w(0.0f);
        }
        this.B();
        f4 = this.ek();
        if (f4 != this.bG) {
            this.bG = f4;
            this.m_();
        }
        this.bb.a();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.G();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> G() {
        ItemStack itemstack;
        Map map = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.i) {
            ItemStack itemstack2;
            ItemStack oldEquipment = itemstack2 = (switch (enumItemSlot.a()) {
                case EnumItemSlot.Function.a -> this.h(enumItemSlot);
                case EnumItemSlot.Function.b -> this.g(enumItemSlot);
                case EnumItemSlot.Function.c -> this.bX;
                default -> throw new MatchException(null, null);
            });
            ItemStack newEquipment = itemstack = this.a(enumItemSlot);
            if (!this.a(itemstack2, itemstack)) continue;
            if (this instanceof EntityPlayer && enumItemSlot.a() == EnumItemSlot.Function.b) {
                org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(oldEquipment);
                org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(newEquipment);
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumItemSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumItemSlot, itemstack);
            AttributeMapBase attributemapbase = this.eY();
            if (itemstack2.f()) continue;
            this.a(itemstack2, enumItemSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                itemstack = (ItemStack)entry.getValue();
                if (itemstack.f() || itemstack.q()) continue;
                itemstack.a(enumitemslot1, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    AttributeModifiable attributemodifiable = this.bS.a((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.c(attributemodifier.b());
                        attributemodifiable.b((AttributeModifier)attributemodifier);
                    }
                });
                net.minecraft.world.level.World world = this.dW();
                if (!(world instanceof WorldServer)) continue;
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, itemstack, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean a(ItemStack stack, ItemStack stack2) {
        return !ItemStack.a(stack2, stack);
    }

    private void a(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ItemStack itemstack = equipmentChanges.get(EnumItemSlot.a);
        ItemStack itemstack1 = equipmentChanges.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.h(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.h(EnumItemSlot.a))) {
            ((WorldServer)this.dW()).m().b(this, new PacketPlayOutEntityStatus(this, 55));
            equipmentChanges.remove(EnumItemSlot.a);
            equipmentChanges.remove(EnumItemSlot.b);
            this.c(EnumItemSlot.a, itemstack.v());
            this.c(EnumItemSlot.b, itemstack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipmentChanges) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipmentChanges.size());
        equipmentChanges.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.v();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            switch (enumitemslot.a()) {
                case a: {
                    this.c((EnumItemSlot)enumitemslot, itemstack1);
                    break;
                }
                case b: {
                    this.b((EnumItemSlot)enumitemslot, itemstack1);
                    break;
                }
                case c: {
                    this.bX = itemstack1;
                }
            }
        });
        ((WorldServer)this.dW()).m().b(this, new PacketPlayOutEntityEquipment(this.ar(), list, true));
    }

    private ItemStack g(EnumItemSlot slot) {
        return this.bW.get(slot.b());
    }

    private void b(EnumItemSlot slot, ItemStack armor) {
        this.bW.set(slot.b(), armor);
    }

    private ItemStack h(EnumItemSlot slot) {
        return this.bV.get(slot.b());
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        this.bV.set(slot.b(), stack);
    }

    protected float g(float bodyRotation, float headRotation) {
        boolean flag;
        float f2 = MathHelper.h(bodyRotation - this.aX);
        this.aX += f2 * 0.3f;
        float f3 = MathHelper.h(this.dM() - this.aX);
        float f4 = this.fq();
        if (Math.abs(f3) > f4) {
            this.aX += f3 - (float)MathHelper.j((double)f3) * f4;
        }
        boolean bl = flag = f3 < -90.0f || f3 >= 90.0f;
        if (flag) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    protected float fq() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.cf > 0) {
            --this.cf;
        }
        if (this.br > 0) {
            this.a(this.br, this.bs, this.bt, this.bu, this.bv, this.bw);
            --this.br;
        } else if (!this.dk()) {
            this.h(this.dz().c(0.98));
        }
        if (this.by > 0) {
            this.a(this.by, this.bx);
            --this.by;
        }
        vec3d = this.dz();
        d0 = vec3d.d;
        d1 = vec3d.e;
        d2 = vec3d.f;
        if (Math.abs(vec3d.d) < 0.003) {
            d0 = 0.0;
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.f) < 0.003) {
            d2 = 0.0;
        }
        this.n(d0, d1, d2);
        gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("ai");
        if (this.fi()) {
            this.bn = false;
            this.bo = 0.0f;
            this.bq = 0.0f;
        } else if (this.dk()) {
            gameprofilerfiller.a("newAi");
            this.fu();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("jump");
        if (this.bn && this.el()) {
            d3 = this.bx() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bj() != false && d3 > 0.0;
            d4 = this.dq();
            if (flag && (!this.aJ() || d3 > d4)) {
                this.c(TagsFluid.a);
            } else if (this.bx() && (!this.aJ() || d3 > d4)) {
                this.c(TagsFluid.b);
            } else if ((this.aJ() || flag && d3 <= d4) && this.cf == 0) {
                if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                    this.s();
                    this.cf = 10;
                } else {
                    this.t(false);
                }
            }
        } else {
            this.cf = 0;
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("travel");
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        if (this.fJ()) {
            this.fs();
        }
        axisalignedbb = this.cR();
        vec3d1 = new Vec3D(this.bo, this.bp, this.bq);
        if (this.b(MobEffects.B) || this.b(MobEffects.y)) {
            this.k();
        }
        if (!((entityliving = this.cX()) instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bL()) {
            this.c(entityhuman, vec3d1);
        } else lbl-1000:
        // 2 sources

        {
            this.a_(vec3d1);
        }
        if (!this.dW().B_() || this.di()) {
            this.aK();
        }
        this.s(this instanceof EntityBird);
        gameprofilerfiller.c();
        gameprofilerfiller.a("freezing");
        if (!(this.dW().C || this.eF() || this.freezeLocked)) {
            i = this.cu();
            if (this.av && this.dK()) {
                this.k(Math.min(this.cx(), i + 1));
            } else {
                this.k(Math.max(0, i - 2));
            }
        }
        this.eh();
        this.ei();
        world = this.dW();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            if (this.af % 40 == 0 && this.cw() && this.dK()) {
                this.a(worldserver, this.dX().v(), 1.0f);
            }
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("push");
        if (this.bC > 0) {
            --this.bC;
            this.a(axisalignedbb, this.cR());
        }
        this.o();
        gameprofilerfiller.c();
        if (((WorldServer)this.dW()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.K != this.dB() || this.L != this.dD() || this.M != this.dH() || this.N != this.dM() || this.O != this.dO())) {
            from = new Location((World)this.dW().getWorld(), this.K, this.L, this.M, this.N, this.O);
            to = new Location((World)this.dW().getWorld(), this.dB(), this.dD(), this.dH(), this.dM(), this.dO());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if ((world = this.dW()) instanceof WorldServer) {
            worldserver = (WorldServer)world;
            if (this.fr() && this.bl()) {
                this.a(worldserver, this.dX().i(), 1.0f);
            }
        }
    }

    public boolean fr() {
        return false;
    }

    protected void fs() {
        this.cy();
        if (!this.dW().C) {
            if (!this.ft()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bB + 1;
            if (i2 % 10 == 0) {
                int j2 = i2 / 10;
                if (j2 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.i.stream().filter(enumitemslot -> EntityLiving.b(this.a((EnumItemSlot)enumitemslot), enumitemslot)).toList();
                    EnumItemSlot enumitemslot2 = SystemUtils.a(list, this.ae);
                    this.a(enumitemslot2).a(1, this, enumitemslot2);
                }
                ((Entity)this).a(GameEvent.n);
            }
        }
    }

    protected boolean ft() {
        if (!(this.aJ() || this.bZ() || this.b(MobEffects.y))) {
            EnumItemSlot enumitemslot;
            Iterator<EnumItemSlot> iterator = EnumItemSlot.i.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!EntityLiving.b(this.a(enumitemslot = iterator.next()), enumitemslot));
            return true;
        }
        return false;
    }

    protected void fu() {
    }

    protected void o() {
        net.minecraft.world.level.World world = this.dW();
        if (!(world instanceof WorldServer)) {
            this.dW().a(EntityTypeTest.a(EntityHuman.class), this.cR(), IEntitySelector.a(this)).forEach(this::D);
        } else {
            WorldServer worldserver = (WorldServer)world;
            if (!this.bI()) {
                return;
            }
            ScoreboardTeam team = this.cr();
            if (team != null && ((ScoreboardTeamBase)team).l() == ScoreboardTeamBase.EnumTeamPush.b) {
                return;
            }
            int i2 = worldserver.N().c(GameRules.v);
            if (i2 <= 0 && this.dW().paperConfig().collisions.maxEntityCollisions <= 0) {
                return;
            }
            List<Entity> list = this.dW().a((Entity)this, this.cR(), IEntitySelector.pushable(this, this.dW().paperConfig().collisions.fixClimbingBypassingCrammingRule));
            if (!list.isEmpty()) {
                if (i2 > 0 && list.size() > i2 - 1 && this.ae.a(4) == 0) {
                    int j2 = 0;
                    for (Entity entity : list) {
                        if (entity.bZ()) continue;
                        ++j2;
                    }
                    if (j2 > i2 - 1) {
                        this.a(worldserver, this.dX().h(), 6.0f);
                    }
                }
                Iterator<Entity> iterator1 = list.iterator();
                this.numCollisions = Math.max(0, this.numCollisions - this.dW().paperConfig().collisions.maxEntityCollisions);
                while (iterator1.hasNext() && this.numCollisions < this.dW().paperConfig().collisions.maxEntityCollisions) {
                    Entity entity1 = iterator1.next();
                    ++entity1.numCollisions;
                    ++this.numCollisions;
                    this.D(entity1);
                }
            }
        }
    }

    protected void a(AxisAlignedBB a2, AxisAlignedBB b2) {
        AxisAlignedBB axisalignedbb2 = a2.b(b2);
        List<Entity> list = this.dW().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.g((EntityLiving)entity);
                this.bC = 0;
                this.h(this.dz().c(-0.2));
                break;
            }
        } else if (this.P) {
            this.bC = 0;
        }
        if (!this.dW().C && this.bC <= 0) {
            this.c(4, false);
            this.bD = 0.0f;
            this.bE = null;
        }
    }

    protected void D(Entity entity) {
        entity.h(this);
    }

    protected void g(EntityLiving target) {
    }

    public boolean fv() {
        return (this.al.a(aC) & 4) != 0;
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity entity = this.dl();
        super.stopRiding(suppressCancellation);
        if (entity != null && entity != this.dl() && !this.dW().C && entity.valid) {
            this.c(entity);
        }
    }

    @Override
    public void r() {
        super.r();
        this.bg = this.bh;
        this.bh = 0.0f;
        this.k();
    }

    @Override
    public void f_() {
        this.br = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.bs = x2;
        this.bt = y2;
        this.bu = z2;
        this.bv = yaw;
        this.bw = pitch;
        this.br = interpolationSteps;
    }

    @Override
    public double R_() {
        return this.br > 0 ? this.bs : this.dB();
    }

    @Override
    public double S_() {
        return this.br > 0 ? this.bt : this.dD();
    }

    @Override
    public double g_() {
        return this.br > 0 ? this.bu : this.dH();
    }

    @Override
    public float r_() {
        return this.br > 0 ? (float)this.bw : this.dO();
    }

    @Override
    public float h_() {
        return this.br > 0 ? (float)this.bv : this.dM();
    }

    @Override
    public void a(float yaw, int interpolationSteps) {
        this.bx = yaw;
        this.by = interpolationSteps;
    }

    public void t(boolean jumping) {
        this.bn = jumping;
    }

    public void a(EntityItem item) {
        EntityHuman entity;
        EntityHuman entityHuman = entity = item.k != null ? this.dW().getGlobalPlayerByUUID(item.k) : null;
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)entity, item.l(), this);
        }
    }

    public void a(Entity item, int count) {
        if (!item.dR() && !this.dW().C && (item instanceof EntityItem || item instanceof EntityArrow || item instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dW()).m().a(this, new PacketPlayOutCollect(item.ar(), this.ar(), count));
        }
    }

    public boolean E(Entity entity) {
        RayTrace.BlockCollisionOption raytrace_blockcollisionoption = RayTrace.BlockCollisionOption.a;
        RayTrace.FluidCollisionOption raytrace_fluidcollisionoption = RayTrace.FluidCollisionOption.a;
        Objects.requireNonNull(entity);
        return this.a(entity, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, entity::dF);
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption shapeType, RayTrace.FluidCollisionOption fluidHandling, DoubleSupplier entityY) {
        if (entity.dW() != this.dW()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dB(), this.dF(), this.dH());
        Vec3D vec3d1 = new Vec3D(entity.dB(), entityY.getAsDouble(), entity.dH());
        return vec3d1.g(vec3d) > 16384.0 ? false : this.dW().a(new RayTrace(vec3d, vec3d1, shapeType, fluidHandling, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float i(float tickDelta) {
        return tickDelta == 1.0f ? this.aZ : MathHelper.i(tickDelta, this.ba, this.aZ);
    }

    public float D(float tickDelta) {
        float f1 = this.aR - this.aQ;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aQ + f1 * tickDelta;
    }

    @Override
    public boolean bH() {
        return !this.dR() && this.collides;
    }

    @Override
    public boolean bI() {
        return this.isCollidable(this.dW().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bL() && !this.aa_() && (ignoreClimbing || !this.q_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bI() && this.collides != this.collidableExemptions.contains(entity.cG());
    }

    @Override
    public float cA() {
        return this.aZ;
    }

    @Override
    public void q(float headYaw) {
        this.aZ = headYaw;
    }

    @Override
    public void r(float bodyYaw) {
        this.aX = bodyYaw;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.j(super.a(portalAxis, portalRect));
    }

    public static Vec3D j(Vec3D pos) {
        return new Vec3D(pos.d, pos.e, 0.0);
    }

    public float fw() {
        return this.cg;
    }

    public final void E(float absorptionAmount) {
        this.F(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.eT()) : 0.0f);
    }

    protected void F(float absorptionAmount) {
        this.cg = absorptionAmount;
    }

    public void i_() {
    }

    public void j_() {
    }

    protected void fx() {
        this.bZ = true;
    }

    public abstract EnumMainHand fy();

    public boolean fz() {
        return (this.al.a(aC) & 1) > 0;
    }

    public EnumHand fA() {
        return (this.al.a(aC) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(aC), serverPlayer);
    }

    private void H() {
        if (this.fz()) {
            if (ItemStack.b(this.b(this.fA()), this.bz)) {
                this.bz = this.b(this.fA());
                this.a(this.bz);
            } else {
                this.fF();
            }
        }
    }

    protected void a(ItemStack stack) {
        boolean shouldLagCompensate;
        stack.b(this.dW(), this, this.fC());
        boolean bl = shouldLagCompensate = this.bz.b(DataComponents.w) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.bA != 0 && !shouldLagCompensate || this.dW().C || stack.x())) {
            this.bA = 0;
            this.w();
        }
    }

    private void I() {
        this.cm = this.cl;
        this.cl = this.cl() ? Math.min(1.0f, this.cl + 0.09f) : Math.max(0.0f, this.cl - 0.09f);
    }

    public void c(int mask, boolean value) {
        int j2 = this.al.a(aC).byteValue();
        j2 = value ? (j2 |= mask) : (j2 &= ~mask);
        this.al.a(aC, (byte)j2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemstack = this.b(hand);
        if (!itemstack.f() && !this.fz() || forceUpdate) {
            this.bz = itemstack;
            this.bA = this.totalEatTimeTicks = itemstack.a(this);
            this.eatStartTime = System.nanoTime();
            if (!this.dW().C) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                ((Entity)this).a(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bQ.equals(data)) {
            if (this.dW().C) {
                this.fP().ifPresent(this::a);
            }
        } else if (aC.equals(data) && this.dW().C) {
            if (this.fz() && this.bz.f()) {
                this.bz = this.b(this.fA());
                if (!this.bz.f()) {
                    this.bA = this.bz.a(this);
                }
            } else if (!this.fz() && !this.bz.f()) {
                this.bz = ItemStack.j;
                this.totalEatTimeTicks = 0;
                this.bA = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.ba = this.aZ;
        this.aY = this.aX = this.aZ;
    }

    @Override
    public float t(float delta) {
        return MathHelper.h(delta, this.aY, this.aX);
    }

    public void b(ItemStack stack, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dO() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dM() * ((float)Math.PI / 180));
            double d0 = (double)(-this.ae.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.ae.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dO() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dM() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dB(), this.dF(), this.dH());
            this.dW().a(new ParticleParamItem(Particles.S, stack), vec3d1.d, vec3d1.e, vec3d1.f, vec3d.d, vec3d.e + 0.05, vec3d.f);
        }
    }

    public void w() {
        if (!this.dW().C || this.fz()) {
            EnumHand enumhand = this.fA();
            if (!this.bz.equals(this.b(enumhand))) {
                this.fE();
            } else if (!this.bz.f() && this.fz()) {
                ItemStack itemstack;
                this.startUsingItem(this.fA(), true);
                PlayerItemConsumeEvent event = null;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bz);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bz.a(DataComponents.x);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.bz);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        this.fF();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bz.a(this.dW(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dW(), this);
                } else {
                    itemstack = this.bz.a(this.dW(), this);
                }
                ItemStack defaultReplacement = itemstack;
                if (event != null && event.getReplacement() != null) {
                    itemstack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemstack != this.bz) {
                    this.a(enumhand, itemstack);
                }
                this.fF();
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).getBukkitEntity().updateInventory();
                }
            }
        }
    }

    public void b(ItemStack stack) {
    }

    public ItemStack fB() {
        return this.bz;
    }

    public int fC() {
        return this.bA;
    }

    public int fD() {
        return this.fz() ? this.bz.a(this) - this.fC() : 0;
    }

    public void fE() {
        if (!this.bz.f()) {
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bz.asBukkitMirror(), this.fD()).callEvent();
            }
            this.bz.a(this.dW(), this, this.fC());
            if (this.bz.x()) {
                this.H();
            }
        }
        this.fF();
    }

    public void fF() {
        if (!this.dW().C) {
            boolean flag = this.fz();
            this.c(1, false);
            if (flag) {
                ((Entity)this).a(GameEvent.C);
            }
        }
        this.bz = ItemStack.j;
        this.totalEatTimeTicks = 0;
        this.bA = 0;
        this.eatStartTime = -1L;
    }

    public boolean fG() {
        return this.fH() != null;
    }

    @Nullable
    public ItemStack fH() {
        if (this.fz() && !this.bz.f()) {
            net.minecraft.world.item.Item item = this.bz.h();
            return item.b(this.bz) != ItemUseAnimation.d ? null : (item.a(this.bz, this) - this.bA < this.getShieldBlockingDelay() ? null : this.bz);
        }
        return null;
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dB(), this.dD() + (double)this.cS(), this.dH());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.d + dir.getX(), start.e + dir.getY(), start.f + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.dW().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.m(1.0f);
        Vec3D direction = this.bT();
        Vec3D end = start.b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance);
        List<Entity> entityList = this.dW().a((Entity)this, this.cR().b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bH));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bS();
            AxisAlignedBB aabb = entity.cR().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public int getShieldBlockingDelay() {
        return this.shieldBlockingDelay;
    }

    public void setShieldBlockingDelay(int shieldBlockingDelay) {
        this.shieldBlockingDelay = shieldBlockingDelay;
    }

    public boolean fI() {
        return this.cd();
    }

    public boolean fJ() {
        return this.i(7);
    }

    @Override
    public boolean cl() {
        return super.cl() || !this.fJ() && this.c(EntityPose.b);
    }

    public int fK() {
        return this.bB;
    }

    public boolean b(double x2, double y2, double z2, boolean particleEffects) {
        return this.randomTeleport(x2, y2, z2, particleEffects, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dB();
        double d4 = this.dD();
        double d5 = this.dH();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.dW();
        if (world.B(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.L_()) {
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.cR())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dW().getWorld(), d3, d4, d5), new Location((World)this.dW().getWorld(), d0, d6, d2));
                        this.dW().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.c(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).f.teleport(d0, d6, d2, this.dM(), this.dO(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.L().o();
        return Optional.of(true);
    }

    public boolean fL() {
        return !this.eF();
    }

    public boolean fM() {
        return true;
    }

    public void a(BlockPosition songPosition, boolean playing) {
    }

    public boolean fN() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aD : this.e(pose).a(this.ek());
    }

    protected EntitySize e(EntityPose pose) {
        return this.aq().n().a(this.ej());
    }

    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize entitysize = this.a(pose);
        return new AxisAlignedBB(-entitysize.a() / 2.0f, 0.0, -entitysize.a() / 2.0f, entitysize.a() / 2.0f, entitysize.b(), entitysize.a() / 2.0f);
    }

    protected boolean g(EntityPose pose) {
        AxisAlignedBB axisalignedbb = this.a(pose).a(this.du());
        return this.dW().b(this, axisalignedbb);
    }

    @Override
    public boolean o(boolean allowVehicles) {
        return super.o(allowVehicles) && !this.fR();
    }

    public Optional<BlockPosition> fP() {
        return this.al.a(bQ);
    }

    public void g(BlockPosition pos) {
        this.al.a(bQ, Optional.of(pos));
    }

    public void fQ() {
        this.al.a(bQ, Optional.empty());
    }

    public boolean fR() {
        return this.fP().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData iblockdata;
        if (this.bZ()) {
            this.ae();
        }
        if ((iblockdata = this.dW().a_(pos)).b() instanceof BlockBed) {
            this.dW().a(pos, (IBlockData)iblockdata.b(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.h(Vec3D.c);
        this.ar = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean J() {
        return this.fP().map(blockposition -> this.dW().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fS() {
        Optional<BlockPosition> optional = this.fP();
        net.minecraft.world.level.World world = this.dW();
        Objects.requireNonNull(world);
        optional.filter(world::B).ifPresent(blockposition -> {
            IBlockData iblockdata = this.dW().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = iblockdata.c(BlockFacingHorizontal.aF);
                this.dW().a((BlockPosition)blockposition, (IBlockData)iblockdata.b(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.aq(), (ICollisionAccess)this.dW(), blockposition, enumdirection, this.dM()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.d();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
                this.a_(vec3d.d, vec3d.e, vec3d.f);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3d = this.du();
        this.b(EntityPose.a);
        this.a_(vec3d.d, vec3d.e, vec3d.f);
        this.fQ();
    }

    @Nullable
    public EnumDirection fT() {
        BlockPosition blockposition = this.fP().orElse(null);
        return blockposition != null ? BlockBed.a(this.dW(), blockposition) : null;
    }

    @Override
    public boolean bM() {
        return !this.fR() && super.bM();
    }

    public ItemStack d(ItemStack stack) {
        return ItemStack.j;
    }

    public static byte i(EnumItemSlot slot) {
        return switch (slot) {
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            default -> throw new MatchException(null, null);
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        this.dW().a((Entity)this, EntityLiving.i(slot));
        this.a(this.a(slot), slot, this.bS);
    }

    private void a(ItemStack removedEquipment, EnumItemSlot slot, AttributeMapBase container) {
        removedEquipment.a(slot, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
            AttributeModifiable attributemodifiable = container.a((Holder<AttributeBase>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.e((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentManager.a(removedEquipment, this, slot);
    }

    public static EnumItemSlot d(EnumHand hand) {
        return hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b;
    }

    public final boolean e(ItemStack stack) {
        if (this.bL() && !this.aa_()) {
            Equippable equippable = stack.a(DataComponents.D);
            if (equippable != null && equippable.f()) {
                EnumItemSlot enumitemslot = equippable.a();
                return this.e(enumitemslot) && equippable.a(this.aq()) ? this.a(enumitemslot).f() && this.f(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot slot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack stack) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && this.e(equippable.a()) ? equippable.a() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack stack, EnumItemSlot slot) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable == null ? slot == EnumItemSlot.a && this.e(EnumItemSlot.a) : slot == equippable.a() && this.e(equippable.a()) && equippable.a(this.aq());
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, (ItemStack itemstack) -> itemstack.f() || entity.f((ItemStack)itemstack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int slotId) {
        return slotId == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (slotId == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (slotId == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (slotId == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (slotId == 98 ? EnumItemSlot.a : (slotId == 99 ? EnumItemSlot.b : (slotId == 105 ? EnumItemSlot.g : null))))));
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        EnumItemSlot enumitemslot = EntityLiving.r(mappedIndex);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(mappedIndex);
    }

    @Override
    public boolean dK() {
        if (this.aa_()) {
            return false;
        }
        boolean flag = !this.a(EnumItemSlot.f).a(TagsItem.bs) && !this.a(EnumItemSlot.e).a(TagsItem.bs) && !this.a(EnumItemSlot.d).a(TagsItem.bs) && !this.a(EnumItemSlot.c).a(TagsItem.bs) && !this.a(EnumItemSlot.g).a(TagsItem.bs);
        return flag && super.dK();
    }

    @Override
    public boolean co() {
        return !this.dW().B_() && this.b(MobEffects.x) || super.co();
    }

    @Override
    public float dN() {
        return this.aX;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double d0 = packet.g();
        double d1 = packet.h();
        double d2 = packet.i();
        float f2 = packet.n();
        float f1 = packet.m();
        this.f(d0, d1, d2);
        this.aX = packet.o();
        this.aZ = packet.o();
        this.aY = this.aX;
        this.ba = this.aZ;
        this.e(packet.b());
        this.a_(packet.e());
        this.a(d0, d1, d2, f2, f1);
        this.n(packet.j(), packet.k(), packet.l());
    }

    public boolean fU() {
        return this.ea().h() instanceof ItemAxe;
    }

    @Override
    public float dQ() {
        float f2 = (float)this.h(GenericAttributes.B);
        return this.cX() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D m(Entity passenger) {
        return this.du().e(this.a(passenger, this.a(this.aw()), this.ek() * this.ej()));
    }

    protected void a(int headTrackingIncrements, double serverHeadYaw) {
        this.aZ = (float)MathHelper.e(1.0 / (double)headTrackingIncrements, (double)this.aZ, serverHeadYaw);
    }

    @Override
    public void g(int ticks) {
        super.g(MathHelper.c((double)ticks * this.h(GenericAttributes.h)));
    }

    public boolean fV() {
        return false;
    }

    public boolean a(WorldServer world, DamageSource source) {
        return this.d(source) || EnchantmentManager.a(world, this, source);
    }

    public static boolean b(ItemStack stack, EnumItemSlot slot) {
        if (!stack.b(DataComponents.F)) {
            return false;
        }
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && slot == equippable.a() && !stack.r();
    }

    @VisibleForTesting
    public int fW() {
        return this.bd;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

