/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int bZ = 144;
    private static final int cd = 2;
    private static final int ce = 3;
    private static final int cf = 1;
    protected static final DataWatcherObject<Byte> ca = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> cb = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.r);
    private boolean cg;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, (byte)0);
        builder.a(cb, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.ab_() != null) {
            nbt.a("Owner", this.ab_());
        }
        nbt.a("Sitting", this.cg);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        UUID uuid;
        super.a(nbt);
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cV(), s2);
        }
        if (uuid != null) {
            try {
                this.b(uuid);
                this.b(true, false);
            }
            catch (Throwable throwable) {
                this.b(false, true);
            }
        }
        this.cg = nbt.q("Sitting");
        this.setInSittingPose(this.cg, false);
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (this.x()) {
            if (distance > (float)this.dW().paperConfig().misc.maxLeashDistance.or(10.0)) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
                if (!event.callEvent()) {
                    return false;
                }
                this.a(true, event.isDropLeash());
            }
            return false;
        }
        return super.a(leashHolder, distance);
    }

    protected void x(boolean positive) {
        ParticleType particletype = Particles.Q;
        if (!positive) {
            particletype = Particles.af;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            this.dW().a(particletype, this.d(1.0), this.dE() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.x(true);
        } else if (status == 6) {
            this.x(false);
        } else {
            super.b(status);
        }
    }

    public boolean p() {
        return (this.al.a(ca) & 4) != 0;
    }

    public void b(boolean tamed, boolean updateAttributes) {
        byte b0 = this.al.a(ca);
        if (tamed) {
            this.al.a(ca, (byte)(b0 | 4));
        } else {
            this.al.a(ca, (byte)(b0 & 0xFFFFFFFB));
        }
        if (updateAttributes) {
            this.t();
        }
    }

    protected void t() {
    }

    public boolean x() {
        return (this.al.a(ca) & 1) != 0;
    }

    public void y(boolean inSittingPose) {
        this.setInSittingPose(inSittingPose, true);
    }

    public void setInSittingPose(boolean inSittingPose, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), inSittingPose).callEvent()) {
            return;
        }
        byte b0 = this.al.a(ca);
        if (inSittingPose) {
            this.al.a(ca, (byte)(b0 | 1));
        } else {
            this.al.a(ca, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID ab_() {
        return this.al.a(cb).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.al.a(cb, Optional.ofNullable(uuid));
    }

    public void a(EntityHuman player) {
        this.b(true, true);
        this.b(player.cG());
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            CriterionTriggers.y.a(entityplayer, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return this.j(target) ? false : super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.ah_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeam cr() {
        EntityLiving entityliving;
        if (this.p() && (entityliving = this.ah_()) != null) {
            return entityliving.cr();
        }
        return super.cr();
    }

    @Override
    protected boolean t(Entity other) {
        if (this.p()) {
            EntityLiving entityliving = this.ah_();
            if (other == entityliving) {
                return true;
            }
            if (entityliving != null) {
                return entityliving.t(other);
            }
        }
        return super.t(other);
    }

    @Override
    public void a(DamageSource damageSource) {
        EntityLiving entityliving;
        WorldServer worldserver;
        World world = this.dW();
        if (world instanceof WorldServer && (worldserver = (WorldServer)world).N().b(GameRules.n) && (entityliving = this.ah_()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityliving;
            TameableDeathMessageEvent event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eQ().a()));
            if (event.callEvent()) {
                entityplayer.a(PaperAdventure.asVanilla(event.deathMessage()));
            }
        }
        super.a(damageSource);
    }

    public boolean go() {
        return this.cg;
    }

    public void z(boolean sitting) {
        this.cg = sitting;
    }

    public void gp() {
        EntityLiving entityliving = this.ah_();
        if (entityliving != null) {
            this.h(entityliving.dw());
        }
    }

    public boolean gq() {
        EntityLiving entityliving = this.ah_();
        return entityliving != null && this.g((Entity)this.ah_()) >= 144.0;
    }

    private void h(BlockPosition pos) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int j2 = this.ae.a(-3, 3);
            int k2 = this.ae.a(-3, 3);
            if (Math.abs(j2) < 2 && Math.abs(k2) < 2) continue;
            int l2 = this.ae.a(-1, 1);
            if (!this.a(pos.u() + j2, pos.v() + l2, pos.w() + k2)) continue;
            return;
        }
    }

    private boolean a(int x2, int y2, int z2) {
        if (!this.i(new BlockPosition(x2, y2, z2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)x2 + 0.5, y2, (double)z2 + 0.5);
        if (event.isCancelled() || event.getTo() == null) {
            return false;
        }
        Location to = event.getTo();
        this.b(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.bS.o();
        return true;
    }

    private boolean i(BlockPosition pos) {
        PathType pathtype = PathfinderNormal.b(this, pos);
        if (pathtype != PathType.c) {
            return false;
        }
        IBlockData iblockdata = this.dW().a_(pos.e());
        if (!this.gs() && iblockdata.b() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockposition1 = pos.b(this.dw());
        return this.dW().a((Entity)this, this.cR().a(blockposition1));
    }

    public final boolean gr() {
        return this.go() || this.bZ() || this.q() || this.ah_() != null && this.ah_().aa_();
    }

    protected boolean gs() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double d0, TagKey tagkey) {
            super((EntityCreature)EntityTameableAnimal.this, d0, tagkey);
        }

        public a(double d0) {
            super(EntityTameableAnimal.this, d0);
        }

        @Override
        public void a() {
            if (!EntityTameableAnimal.this.gr() && EntityTameableAnimal.this.gq()) {
                EntityTameableAnimal.this.gp();
            }
            super.a();
        }
    }
}

