/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.creaking.CreakingTransient;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger bV = LogUtils.getLogger();
    private final Holder.c<EntityTypes<?>> bW = BuiltInRegistries.f.f(this);
    private static final float bX = 1.3964844f;
    private static final int bY = 10;
    public static final EntityTypes<EntityBoat> a = EntityTypes.a("acacia_boat", Builder.a(EntityTypes.a(() -> Items.ow), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> b = EntityTypes.a("acacia_chest_boat", Builder.a(EntityTypes.b(() -> Items.ox), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Allay> c = EntityTypes.a("allay", Builder.a(Allay::new, EnumCreatureType.b).a(0.35f, 0.6f).b(0.36f).c(0.04f).a(8).b(2));
    public static final EntityTypes<EntityAreaEffectCloud> d = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).e().c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<Armadillo> e = EntityTypes.a("armadillo", Builder.a(Armadillo::new, EnumCreatureType.b).a(0.7f, 0.65f).b(0.26f).a(10));
    public static final EntityTypes<EntityArmorStand> f = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).b(1.7775f).a(10));
    public static final EntityTypes<EntityTippedArrow> g = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<Axolotl> h = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).b(0.2751f).a(10));
    public static final EntityTypes<ChestRaft> i = EntityTypes.a("bamboo_chest_raft", Builder.a(EntityTypes.d(() -> Items.oH), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Raft> j = EntityTypes.a("bamboo_raft", Builder.a(EntityTypes.c(() -> Items.oG), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBat> k = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).b(0.45f).a(5));
    public static final EntityTypes<EntityBee> l = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).b(0.3f).a(8));
    public static final EntityTypes<EntityBoat> m = EntityTypes.a("birch_boat", Builder.a(EntityTypes.a(() -> Items.os), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> n = EntityTypes.a("birch_chest_boat", Builder.a(EntityTypes.b(() -> Items.ot), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBlaze> o = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<Display.BlockDisplay> p = EntityTypes.a("block_display", Builder.a(Display.BlockDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<Bogged> q = EntityTypes.a("bogged", Builder.a(Bogged::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<Breeze> r = EntityTypes.a("breeze", Builder.a(Breeze::new, EnumCreatureType.a).a(0.6f, 1.77f).b(1.3452f).a(10));
    public static final EntityTypes<BreezeWindCharge> s = EntityTypes.a("breeze_wind_charge", Builder.a(BreezeWindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<Camel> t = EntityTypes.a("camel", Builder.a(Camel::new, EnumCreatureType.b).a(1.7f, 2.375f).b(2.275f).a(10));
    public static final EntityTypes<EntityCat> u = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.35f).a(new float[]{0.5125f}).a(8));
    public static final EntityTypes<EntityCaveSpider> v = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).b(0.45f).a(8));
    public static final EntityTypes<EntityBoat> w = EntityTypes.a("cherry_boat", Builder.a(EntityTypes.a(() -> Items.oy), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> x = EntityTypes.a("cherry_chest_boat", Builder.a(EntityTypes.b(() -> Items.oz), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityMinecartChest> y = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityChicken> z = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).b(0.644f).a(new Vec3D[]{new Vec3D(0.0, 0.7, -0.1)}).a(10));
    public static final EntityTypes<EntityCod> A = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).b(0.195f).a(4));
    public static final EntityTypes<EntityMinecartCommandBlock> B = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityCow> C = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<Creaking> D = EntityTypes.a("creaking", Builder.a(Creaking::new, EnumCreatureType.a).c().a(0.9f, 2.7f).b(2.3f).a(8).a(FeatureFlags.b));
    public static final EntityTypes<CreakingTransient> E = EntityTypes.a("creaking_transient", Builder.a(CreakingTransient::new, EnumCreatureType.a).b().a().c().a(0.9f, 2.7f).b(2.3f).a(8).a(FeatureFlags.b));
    public static final EntityTypes<EntityCreeper> F = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityBoat> G = EntityTypes.a("dark_oak_boat", Builder.a(EntityTypes.a(() -> Items.oA), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> H = EntityTypes.a("dark_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oB), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityDolphin> I = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f).b(0.3f));
    public static final EntityTypes<EntityHorseDonkey> J = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).b(1.425f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityDragonFireball> K = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> L = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityEgg> M = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityGuardianElder> N = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).b(0.99875f).a(new float[]{2.350625f}).a(10));
    public static final EntityTypes<EntityEnderman> O = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).b(2.55f).a(new float[]{2.80625f}).a(8));
    public static final EntityTypes<EntityEndermite> P = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntityEnderDragon> Q = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(new float[]{3.0f}).a(10));
    public static final EntityTypes<EntityEnderPearl> R = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderCrystal> S = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).e().c().a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEvoker> T = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityEvokerFangs> U = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).e().a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityThrownExpBottle> V = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityExperienceOrb> W = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> X = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> Y = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).e().a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityLargeFireball> Z = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityFireworks> aa = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> ab = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.6375, -0.25)}).a(8).a(Blocks.oD));
    public static final EntityTypes<Frog> ac = EntityTypes.a("frog", Builder.a(Frog::new, EnumCreatureType.b).a(0.5f, 0.5f).a(new Vec3D[]{new Vec3D(0.0, 0.375, -0.25)}).a(10));
    public static final EntityTypes<EntityMinecartFurnace> ad = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityGhast> ae = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).b(2.6f).a(new float[]{4.0625f}).c(0.5f).a(10));
    public static final EntityTypes<EntityGiantZombie> af = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).b(10.44f).c(-3.75f).a(10));
    public static final EntityTypes<GlowItemFrame> ag = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> ah = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).b(0.4f).a(10));
    public static final EntityTypes<Goat> ai = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityGuardian> aj = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).b(0.425f).a(new float[]{0.975f}).a(8));
    public static final EntityTypes<EntityHoglin> ak = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityMinecartHopper> al = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityHorse> am = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.44375f}).a(10));
    public static final EntityTypes<EntityZombieHusk> an = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.075f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> ao = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<Interaction> ap = EntityTypes.a("interaction", Builder.a(Interaction::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10));
    public static final EntityTypes<EntityIronGolem> aq = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> ar = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).e().a(0.25f, 0.25f).b(0.2125f).a(6).b(20));
    public static final EntityTypes<Display.ItemDisplay> as = EntityTypes.a("item_display", Builder.a(Display.ItemDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityItemFrame> at = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> au = EntityTypes.a("jungle_boat", Builder.a(EntityTypes.a(() -> Items.ou), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> av = EntityTypes.a("jungle_chest_boat", Builder.a(EntityTypes.b(() -> Items.ov), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityLeash> aw = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).e().b().a(0.375f, 0.5f).b(0.0625f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> ax = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).e().b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> ay = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityLlamaSpit> az = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> aA = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(0.52f, 0.52f).b(0.325f).a(4.0f).a(8));
    public static final EntityTypes<EntityBoat> aB = EntityTypes.a("mangrove_boat", Builder.a(EntityTypes.a(() -> Items.oE), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aC = EntityTypes.a("mangrove_chest_boat", Builder.a(EntityTypes.b(() -> Items.oF), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Marker> aD = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> aE = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityMushroomCow> aF = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<EntityHorseMule> aG = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.2125f}).a(8));
    public static final EntityTypes<EntityBoat> aH = EntityTypes.a("oak_boat", Builder.a(EntityTypes.a(() -> Items.oo), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aI = EntityTypes.a("oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.op), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityOcelot> aJ = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(new float[]{0.6375f}).a(10));
    public static final EntityTypes<OminousItemSpawner> aK = EntityTypes.a("ominous_item_spawner", Builder.a(OminousItemSpawner::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(8));
    public static final EntityTypes<EntityPainting> aL = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> aM = EntityTypes.a("pale_oak_boat", Builder.a(EntityTypes.a(() -> Items.oC), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10).a(FeatureFlags.b));
    public static final EntityTypes<ChestBoat> aN = EntityTypes.a("pale_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oD), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10).a(FeatureFlags.b));
    public static final EntityTypes<EntityPanda> aO = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> aP = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).b(0.54f).a(new float[]{0.4625f}).a(8));
    public static final EntityTypes<EntityPhantom> aQ = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).b(0.175f).a(new float[]{0.3375f}).c(-0.125f).a(8));
    public static final EntityTypes<EntityPig> aR = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(new float[]{0.86875f}).a(10));
    public static final EntityTypes<EntityPiglin> aS = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPiglinBrute> aT = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPillager> aU = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityPolarBear> aV = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.rk).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<EntityPotion> aW = EntityTypes.a("potion", Builder.a(EntityPotion::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPufferFish> aX = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).b(0.455f).a(4));
    public static final EntityTypes<EntityRabbit> aY = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> aZ = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(new Vec3D[]{new Vec3D(0.0, 2.2625, -0.0625)}).a(10));
    public static final EntityTypes<EntitySalmon> ba = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntitySheep> bb = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).b(1.235f).a(new float[]{1.2375f}).a(10));
    public static final EntityTypes<EntityShulker> bc = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).b(0.5f).a(10));
    public static final EntityTypes<EntityShulkerBullet> bd = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> be = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntitySkeleton> bf = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> bg = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntitySlime> bh = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(0.52f, 0.52f).b(0.325f).a(4.0f).a(10));
    public static final EntityTypes<EntitySmallFireball> bi = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<Sniffer> bj = EntityTypes.a("sniffer", Builder.a(Sniffer::new, EnumCreatureType.b).a(1.9f, 1.75f).b(1.05f).a(new float[]{2.09375f}).d(2.05f).a(10));
    public static final EntityTypes<EntitySnowball> bk = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntitySnowman> bl = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.rk).a(0.7f, 1.9f).b(1.7f).a(8));
    public static final EntityTypes<EntityMinecartMobSpawner> bm = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntitySpectralArrow> bn = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntitySpider> bo = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).b(0.65f).a(new float[]{0.765f}).a(8));
    public static final EntityTypes<EntityBoat> bp = EntityTypes.a("spruce_boat", Builder.a(EntityTypes.a(() -> Items.oq), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> bq = EntityTypes.a("spruce_chest_boat", Builder.a(EntityTypes.b(() -> Items.or), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntitySquid> br = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).b(0.4f).a(8));
    public static final EntityTypes<EntitySkeletonStray> bs = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(Blocks.rk).a(8));
    public static final EntityTypes<EntityStrider> bt = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<Tadpole> bu = EntityTypes.a("tadpole", Builder.a(Tadpole::new, EnumCreatureType.b).a(0.4f, 0.3f).b(0.19500001f).a(10));
    public static final EntityTypes<Display.TextDisplay> bv = EntityTypes.a("text_display", Builder.a(Display.TextDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityTNTPrimed> bw = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).e().c().a(0.98f, 0.98f).b(0.15f).a(10).b(10));
    public static final EntityTypes<EntityMinecartTNT> bx = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityLlamaTrader> by = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityThrownTrident> bz = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntityTropicalFish> bA = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntityTurtle> bB = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.55625, -0.25)}).a(10));
    public static final EntityTypes<EntityVex> bC = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).b(0.51875f).a(new float[]{0.7375f}).c(0.04f).a(8));
    public static final EntityTypes<EntityVillager> bD = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<EntityVindicator> bE = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityVillagerTrader> bF = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<Warden> bG = EntityTypes.a("warden", Builder.a(Warden::new, EnumCreatureType.a).a(0.9f, 2.9f).a(new float[]{3.15f}).a(EntityAttachment.d, 0.0f, 1.6f, 0.0f).a(16).c());
    public static final EntityTypes<WindCharge> bH = EntityTypes.a("wind_charge", Builder.a(WindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<EntityWitch> bI = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.62f).a(new float[]{2.2625f}).a(8));
    public static final EntityTypes<EntityWither> bJ = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.ck).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> bK = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.ck).a(0.7f, 2.4f).b(2.1f).c(-0.875f).a(8));
    public static final EntityTypes<EntityWitherSkull> bL = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bM = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).b(0.68f).a(new Vec3D[]{new Vec3D(0.0, 0.81875, -0.0625)}).a(10));
    public static final EntityTypes<EntityZoglin> bN = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityZombie> bO = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseZombie> bP = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntityZombieVillager> bQ = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.125f}).c(-0.7f).b(1.74f).a(8));
    public static final EntityTypes<EntityPigZombie> bR = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHuman> bS = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).b(1.62f).a(EntityHuman.bV).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bT = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).e().b().a().a(0.25f, 0.25f).a(4).b(5));
    private final b<T> bZ;
    private final EnumCreatureType ca;
    private final ImmutableSet<Block> cb;
    private final boolean cc;
    private final boolean cd;
    private final boolean ce;
    private final boolean cf;
    private final int cg;
    private final int ch;
    private final String ci;
    @Nullable
    private IChatBaseComponent cj;
    private final Optional<ResourceKey<LootTable>> ck;
    private final EntitySize cl;
    private final float cm;
    private final FeatureFlagSet cn;

    private static <T extends Entity> EntityTypes<T> a(ResourceKey<EntityTypes<?>> key, Builder<T> type) {
        return IRegistry.a(BuiltInRegistries.f, key, type.a(key));
    }

    private static ResourceKey<EntityTypes<?>> b(String id) {
        return ResourceKey.a(Registries.z, MinecraftKey.b(id));
    }

    private static <T extends Entity> EntityTypes<T> a(String id, Builder type) {
        return EntityTypes.a(EntityTypes.b(id), type);
    }

    public static MinecraftKey a(EntityTypes<?> type) {
        return BuiltInRegistries.f.b(type);
    }

    public static Optional<EntityTypes<?>> a(String id) {
        return BuiltInRegistries.f.b(MinecraftKey.c(id));
    }

    public EntityTypes(b<T> factory, EnumCreatureType spawnGroup, boolean saveable, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, ImmutableSet<Block> canSpawnInside, EntitySize dimensions, float spawnBoxScale, int maxTrackDistance, int trackTickInterval, String translationKey, Optional<ResourceKey<LootTable>> lootTable, FeatureFlagSet requiredFeatures) {
        this.bZ = factory;
        this.ca = spawnGroup;
        this.cf = spawnableFarFromPlayer;
        this.cc = saveable;
        this.cd = summonable;
        this.ce = fireImmune;
        this.cb = canSpawnInside;
        this.cl = dimensions;
        this.cm = spawnBoxScale;
        this.cg = maxTrackDistance;
        this.ch = trackTickInterval;
        this.ci = translationKey;
        this.ck = lootTable;
        this.cn = requiredFeatures;
    }

    @Nullable
    public T a(WorldServer world, @Nullable ItemStack stack, @Nullable EntityHuman player, BlockPosition pos, EntitySpawnReason spawnReason, boolean alignPosition, boolean invertY) {
        return this.spawn(world, stack, player, pos, spawnReason, alignPosition, invertY, spawnReason == EntitySpawnReason.o ? CreatureSpawnEvent.SpawnReason.DISPENSE_EGG : CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        Consumer<Entity> consumer = itemstack != null ? EntityTypes.a(worldserver, itemstack, entityhuman) : entity -> {};
        return (T)this.spawn(worldserver, consumer, blockposition, entityspawnreason, flag, flag1, spawnReason);
    }

    public static <T extends Entity> Consumer<T> a(World world, ItemStack stack, @Nullable EntityHuman player) {
        return EntityTypes.a((T entity) -> {}, world, stack, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> chained, World world, ItemStack stack, @Nullable EntityHuman player) {
        return EntityTypes.b(EntityTypes.a(chained, stack), world, stack, player);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> chained, ItemStack stack) {
        IChatBaseComponent ichatbasecomponent = stack.a(DataComponents.g);
        return ichatbasecomponent != null ? chained.andThen(entity -> entity.b(ichatbasecomponent)) : chained;
    }

    public static <T extends Entity> Consumer<T> b(Consumer<T> chained, World world, ItemStack stack, @Nullable EntityHuman player) {
        CustomData customdata = stack.a(DataComponents.W, CustomData.a);
        return !customdata.b() ? chained.andThen(entity -> {
            try {
                EntityTypes.a(world, player, entity, customdata);
            }
            catch (Throwable t2) {
                bV.warn("Error loading spawn egg NBT", t2);
            }
        }) : chained;
    }

    @Nullable
    public T a(WorldServer world, BlockPosition pos, EntitySpawnReason reason) {
        return this.spawn(world, pos, reason, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, BlockPosition blockposition, EntitySpawnReason entityspawnreason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.spawn(worldserver, null, blockposition, entityspawnreason, false, false, spawnReason);
    }

    @Nullable
    public T a(WorldServer world, @Nullable Consumer<T> afterConsumer, BlockPosition pos, EntitySpawnReason reason, boolean alignPosition, boolean invertY) {
        return this.spawn(world, afterConsumer, pos, reason, alignPosition, invertY, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(worldserver, blockposition), CraftEntityType.minecraftToBukkit(this), spawnReason);
        if (!event.callEvent()) {
            return null;
        }
        T t0 = this.b(worldserver, consumer, blockposition, entityspawnreason, flag, flag1);
        if (t0 != null) {
            worldserver.addFreshEntityWithPassengers((Entity)t0, spawnReason);
            return (T)(!((Entity)t0).dR() ? t0 : null);
        }
        return t0;
    }

    @Nullable
    public T b(WorldServer world, @Nullable Consumer<T> afterConsumer, BlockPosition pos, EntitySpawnReason reason, boolean alignPosition, boolean invertY) {
        double d0;
        T t0 = this.a(world, reason);
        if (t0 == null) {
            return null;
        }
        if (alignPosition) {
            ((Entity)t0).a_((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5);
            d0 = EntityTypes.a((IWorldReader)world, pos, invertY, ((Entity)t0).cR());
        } else {
            d0 = 0.0;
        }
        ((Entity)t0).b((double)pos.u() + 0.5, (double)pos.v() + d0, (double)pos.w() + 0.5, MathHelper.h(world.A.i() * 360.0f), 0.0f);
        if (t0 instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)t0;
            entityinsentient.aZ = entityinsentient.dM();
            entityinsentient.aX = entityinsentient.dM();
            entityinsentient.a((WorldAccess)world, world.d_(entityinsentient.dw()), reason, (GroupDataEntity)null);
            entityinsentient.R();
        }
        if (afterConsumer != null) {
            afterConsumer.accept(t0);
        }
        return t0;
    }

    protected static double a(IWorldReader world, BlockPosition pos, boolean invertY, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(pos);
        if (invertY) {
            axisalignedbb1 = axisalignedbb1.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> iterable = world.d(null, axisalignedbb1);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, boundingBox, iterable, invertY ? -2.0 : -1.0);
    }

    public static void a(World world, @Nullable EntityHuman player, @Nullable Entity entity, CustomData nbt) {
        MinecraftServer minecraftserver = world.p();
        if (minecraftserver != null && entity != null && (world.C || !entity.cW() || player != null && minecraftserver.ag().f(player.gh()))) {
            if (player == null || !player.getBukkitEntity().hasPermission("minecraft.nbt.place")) {
                nbt = nbt.a((NBTTagCompound compound) -> {
                    for (ArgumentNBTKey.g tag : world.paperConfig().entities.spawning.filteredEntityTagNbtPaths) {
                        tag.c((NBTBase)compound);
                    }
                });
            }
            nbt.a(entity);
        }
    }

    public boolean b() {
        return this.cc;
    }

    public boolean c() {
        return this.cd;
    }

    public boolean d() {
        return this.ce;
    }

    public boolean e() {
        return this.cf;
    }

    public EnumCreatureType f() {
        return this.ca;
    }

    public String g() {
        return this.ci;
    }

    public IChatBaseComponent h() {
        if (this.cj == null) {
            this.cj = IChatBaseComponent.c(this.g());
        }
        return this.cj;
    }

    public String toString() {
        return this.g();
    }

    public String j() {
        int i2 = this.g().lastIndexOf(46);
        return i2 == -1 ? this.g() : this.g().substring(i2 + 1);
    }

    public Optional<ResourceKey<LootTable>> k() {
        return this.ck;
    }

    public float l() {
        return this.cl.a();
    }

    public float m() {
        return this.cl.b();
    }

    @Override
    public FeatureFlagSet i() {
        return this.cn;
    }

    @Nullable
    public T a(World world, EntitySpawnReason reason) {
        return !this.a(world.J()) ? null : (T)this.bZ.create(this, world);
    }

    public static Optional<Entity> a(NBTTagCompound nbt, World world, EntitySpawnReason reason) {
        return EntityTypes.create(nbt, world, reason, false);
    }

    public static Optional<Entity> create(NBTTagCompound nbt, World world, EntitySpawnReason reason, boolean generation) {
        return SystemUtils.a(EntityTypes.a(nbt).map(entitytypes -> entitytypes.a(world, reason)), (T entity) -> {
            if (generation) {
                entity.generation = true;
            }
            entity.g(nbt);
        }, () -> bV.warn("Skipping Entity with id {}", (Object)nbt.l("id")));
    }

    public AxisAlignedBB a(double x2, double y2, double z2) {
        float f2 = this.cm * this.l() / 2.0f;
        float f1 = this.cm * this.m();
        return new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)f1, z2 + (double)f2);
    }

    @Override
    public boolean a(IBlockData state) {
        return this.cb.contains((Object)state.b()) ? false : (!this.ce && PathfinderAbstract.a(state) ? true : state.a(Blocks.ck) || state.a(Blocks.oD) || state.a(Blocks.ed) || state.a(Blocks.rk));
    }

    public EntitySize n() {
        return this.cl;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound nbt) {
        return BuiltInRegistries.f.b(MinecraftKey.c(nbt.l("id")));
    }

    @Nullable
    public static Entity a(NBTTagCompound nbt, World world, EntitySpawnReason reason, Function<Entity, Entity> entityProcessor) {
        return EntityTypes.b(nbt, world, reason).map(entityProcessor).map(entity -> {
            if (nbt.b("Passengers", 9)) {
                NBTTagList nbttaglist = nbt.c("Passengers", 10);
                for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                    Entity entity1 = EntityTypes.a(nbttaglist.a(i2), world, reason, entityProcessor);
                    if (entity1 == null) continue;
                    entity1.a((Entity)entity, true);
                }
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(final List<? extends NBTBase> entityNbtList, final World world, final EntitySpawnReason reason) {
        final Spliterator<? extends NBTBase> spliterator = entityNbtList.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){
            final Map<EntityTypes<?>, Integer> loadedEntityCounts = new HashMap();

            @Override
            public boolean tryAdvance(Consumer<? super Entity> consumer) {
                return spliterator.tryAdvance((? super T nbtbase) -> EntityTypes.a((NBTTagCompound)nbtbase, world, reason, entity -> {
                    EntityTypes<?> entityType = entity.aq();
                    int saveLimit = world2.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                    if (saveLimit > -1) {
                        if (this.loadedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                            return null;
                        }
                        this.loadedEntityCounts.merge(entityType, 1, Integer::sum);
                    }
                    consumer.accept((Entity)entity);
                    return entity;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return entityNbtList.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> b(NBTTagCompound nbt, World world, EntitySpawnReason reason) {
        try {
            return EntityTypes.a(nbt, world, reason);
        }
        catch (RuntimeException runtimeexception) {
            bV.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int o() {
        return this.cg;
    }

    public int p() {
        return this.ch;
    }

    public boolean q() {
        return this != bS && this != az && this != bJ && this != k && this != at && this != ag && this != aw && this != aL && this != S && this != U;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tag) {
        return this.bW.a(tag);
    }

    @Override
    public boolean a(HolderSet<EntityTypes<?>> entityTypeEntryList) {
        return entityTypeEntryList.a(this.bW);
    }

    @Override
    @Nullable
    public T a(Entity obj) {
        return (T)(obj.aq() == this ? obj : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> r() {
        return this.bW;
    }

    private static b<EntityBoat> a(Supplier<Item> itemSupplier) {
        return (entitytypes, world) -> new EntityBoat(entitytypes, world, itemSupplier);
    }

    private static b<ChestBoat> b(Supplier<Item> itemSupplier) {
        return (entitytypes, world) -> new ChestBoat(entitytypes, world, itemSupplier);
    }

    private static b<Raft> c(Supplier<Item> itemSupplier) {
        return (entitytypes, world) -> new Raft(entitytypes, world, itemSupplier);
    }

    private static b<ChestRaft> d(Supplier<Item> itemSupplier) {
        return (entitytypes, world) -> new ChestRaft(entitytypes, world, itemSupplier);
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);
        private float k = 1.0f;
        private EntityAttachments.a l = EntityAttachments.a();
        private FeatureFlagSet m = FeatureFlags.h;
        private DependantName<EntityTypes<?>, Optional<ResourceKey<LootTable>>> n = resourcekey -> Optional.of(ResourceKey.a(Registries.bg, resourcekey.a().f("entities/")));
        private DependantName<EntityTypes<?>, String> o = resourcekey -> SystemUtils.a("entity", resourcekey.a());

        private Builder(b<T> factory, EnumCreatureType spawnGroup) {
            this.a = factory;
            this.b = spawnGroup;
            this.g = spawnGroup == EnumCreatureType.b || spawnGroup == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b factory, EnumCreatureType spawnGroup) {
            return new Builder<T>(factory, spawnGroup);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType spawnGroup) {
            return new Builder<Entity>((entitytypes, world) -> null, spawnGroup);
        }

        public Builder<T> a(float width, float height) {
            this.j = EntitySize.b(width, height);
            return this;
        }

        public Builder<T> a(float spawnBoxScale) {
            this.k = spawnBoxScale;
            return this;
        }

        public Builder<T> b(float eyeHeight) {
            this.j = this.j.b(eyeHeight);
            return this;
        }

        public Builder<T> a(float ... offsetYs) {
            float[] afloat1 = offsetYs;
            int i2 = offsetYs.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                float f2 = afloat1[j2];
                this.l = this.l.a(EntityAttachment.a, 0.0f, f2, 0.0f);
            }
            return this;
        }

        public Builder<T> a(Vec3D ... passengerAttachments) {
            Vec3D[] avec3d1 = passengerAttachments;
            int i2 = passengerAttachments.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d = avec3d1[j2];
                this.l = this.l.a(EntityAttachment.a, vec3d);
            }
            return this;
        }

        public Builder<T> a(Vec3D vehicleAttachment) {
            return this.a(EntityAttachment.b, vehicleAttachment);
        }

        public Builder<T> c(float offsetY) {
            return this.a(EntityAttachment.b, 0.0f, -offsetY, 0.0f);
        }

        public Builder<T> d(float offsetY) {
            return this.a(EntityAttachment.c, 0.0f, offsetY, 0.0f);
        }

        public Builder<T> a(EntityAttachment type, float offsetX, float offsetY, float offsetZ) {
            this.l = this.l.a(type, offsetX, offsetY, offsetZ);
            return this;
        }

        public Builder<T> a(EntityAttachment type, Vec3D offset) {
            this.l = this.l.a(type, offset);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... blocks) {
            this.c = ImmutableSet.copyOf((Object[])blocks);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int maxTrackingRange) {
            this.h = maxTrackingRange;
            return this;
        }

        public Builder<T> b(int trackingTickInterval) {
            this.i = trackingTickInterval;
            return this;
        }

        public Builder<T> a(FeatureFlag ... features) {
            this.m = FeatureFlags.f.a(features);
            return this;
        }

        public Builder<T> e() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public EntityTypes<T> a(ResourceKey<EntityTypes<?>> registryKey) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.A, registryKey.a().toString());
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j.a(this.l), this.k, this.h, this.i, this.o.get(registryKey), this.n.get(registryKey), this.m);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

