/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public final class IEntitySelector {
    public static final Predicate<Entity> a = Entity::bL;
    public static final Predicate<Entity> b = entity -> entity.bL() && entity instanceof EntityLiving;
    public static final Predicate<Entity> c = entity -> entity.bL() && !entity.ca() && !entity.bZ();
    public static final Predicate<Entity> d = entity -> entity instanceof IInventory && entity.bL();
    public static final Predicate<Entity> e = entity -> !(entity instanceof EntityHuman) || !entity.aa_() && !((EntityHuman)entity).b();
    public static final Predicate<Entity> f = entity -> !entity.aa_();
    public static final Predicate<Entity> g = f.and(Entity::bN);
    public static final Predicate<Entity> h = f.and(Entity::bH);
    public static Predicate<EntityHuman> IS_INSOMNIAC = player -> {
        EntityPlayer serverPlayer = (EntityPlayer)player;
        int playerInsomniaTicks = serverPlayer.dW().paperConfig().entities.behavior.playerInsomniaStartTicks;
        if (playerInsomniaTicks <= 0) {
            return false;
        }
        return MathHelper.a(serverPlayer.I().a(StatisticList.i.b(StatisticList.n)), 1, Integer.MAX_VALUE) >= playerInsomniaTicks;
    };
    public static final Predicate<Entity> PLAYER_AFFECTS_SPAWNING = entity -> {
        if (entity.aa_()) return false;
        if (!entity.bL()) return false;
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (!player.affectsSpawning) return false;
        return true;
    };

    private IEntitySelector() {
    }

    public static Predicate<Entity> a(double x2, double y2, double z2, double max) {
        double d4 = max * max;
        return entity -> entity != null && entity.i(x2, y2, z2) <= d4;
    }

    public static Predicate<Entity> a(Entity entity) {
        return IEntitySelector.pushable(entity, false);
    }

    public static Predicate<Entity> pushable(Entity entity, boolean ignoreClimbing) {
        ScoreboardTeam scoreboardteam = entity.cr();
        ScoreboardTeamBase.EnumTeamPush scoreboardteambase_enumteampush = scoreboardteam == null ? ScoreboardTeamBase.EnumTeamPush.a : scoreboardteam.l();
        return scoreboardteambase_enumteampush == ScoreboardTeamBase.EnumTeamPush.b ? Predicates.alwaysFalse() : f.and(entity1 -> {
            boolean flag;
            ScoreboardTeamBase.EnumTeamPush scoreboardteambase_enumteampush1;
            if (!(entity1.isCollidable(ignoreClimbing) && entity1.canCollideWithBukkit(entity) && entity.canCollideWithBukkit((Entity)entity1))) {
                return false;
            }
            if (entity1 instanceof EntityHuman && entity instanceof EntityHuman && !GlobalConfiguration.get().collisions.enablePlayerCollisions) {
                return false;
            }
            ScoreboardTeam scoreboardteam1 = entity1.cr();
            ScoreboardTeamBase.EnumTeamPush enumTeamPush = scoreboardteambase_enumteampush1 = scoreboardteam1 == null ? ScoreboardTeamBase.EnumTeamPush.a : scoreboardteam1.l();
            if (scoreboardteambase_enumteampush1 == ScoreboardTeamBase.EnumTeamPush.b) {
                return false;
            }
            boolean bl = flag = scoreboardteam != null && scoreboardteam.a(scoreboardteam1);
            return (scoreboardteambase_enumteampush == ScoreboardTeamBase.EnumTeamPush.d || scoreboardteambase_enumteampush1 == ScoreboardTeamBase.EnumTeamPush.d) && flag ? false : scoreboardteambase_enumteampush != ScoreboardTeamBase.EnumTeamPush.c && scoreboardteambase_enumteampush1 != ScoreboardTeamBase.EnumTeamPush.c || flag;
        });
    }

    public static Predicate<Entity> b(Entity entity) {
        return entity1 -> {
            while (entity1.bZ()) {
                if ((entity1 = entity1.dl()) != entity) continue;
                return false;
            }
            return true;
        };
    }
}

