/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String o_ = "leash";
    public static final double p_ = 10.0;
    public static final double q_ = 6.0;

    @Nullable
    public a T_();

    public void a(@Nullable a var1);

    default public boolean P_() {
        return this.T_() != null && this.T_().a != null;
    }

    default public boolean q() {
        return this.T_() != null;
    }

    default public boolean Q_() {
        return this.y() && !this.P_();
    }

    default public boolean y() {
        return true;
    }

    default public void e_(int unresolvedLeashHolderId) {
        this.a(new a(unresolvedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    @Nullable
    default public a c(NBTTagCompound nbt) {
        Either either;
        if (nbt.b(o_, 10)) {
            NBTTagCompound leashTag = nbt.p(o_);
            if (!leashTag.b("UUID")) {
                return null;
            }
            return new a(Either.left(leashTag.a("UUID")));
        }
        if (nbt.b(o_, 11) && (either = (Either)GameProfileSerializer.a(nbt, o_).map(Either::right).orElse(null)) != null) {
            return new a(either);
        }
        return null;
    }

    default public void a(NBTTagCompound nbt, @Nullable a leashData) {
        if (leashData != null) {
            Either<UUID, BlockPosition> either = leashData.b;
            Entity entity = leashData.a;
            if (entity != null && entity.pluginRemoved) {
                return;
            }
            if (entity instanceof EntityLeash) {
                EntityLeash entityleash = (EntityLeash)entity;
                either = Either.right(entityleash.p());
            } else if (leashData.a != null) {
                either = Either.left(leashData.a.cG());
            }
            if (either != null) {
                nbt.a(o_, either.map(uuid -> {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.a("UUID", (UUID)uuid);
                    return nbttagcompound1;
                }, GameProfileSerializer::a));
            }
        }
    }

    private static <E extends Entity> void a(E entity, a leashData) {
        World world;
        if (leashData.b != null && (world = entity.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<UUID> optional = leashData.b.left();
            Optional<BlockPosition> optional1 = leashData.b.right();
            if (optional.isPresent()) {
                Entity entity1 = worldserver.a(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, (Entity)EntityLeash.a(worldserver, optional1.get()), true);
                return;
            }
            if (entity.af > 100) {
                entity.forceDrops = true;
                entity.a(worldserver, Items.vA);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a((a)null);
            }
        }
    }

    default public void a(boolean sendPacket, boolean dropItem) {
        Leashable.a((Entity)((Object)this), sendPacket, dropItem);
    }

    private static <E extends Entity> void a(E entity, boolean sendPacket, boolean dropItem) {
        a leashable_a = ((Leashable)((Object)entity)).T_();
        if (leashable_a != null && leashable_a.a != null) {
            ((Leashable)((Object)entity)).a((a)null);
            World world = entity.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.a(worldserver, Items.vA);
                    entity.forceDrops = false;
                }
                if (sendPacket) {
                    worldserver.m().b(entity, new PacketPlayOutAttachEntity(entity, null));
                }
            }
        }
    }

    public static <E extends Entity> void a_(WorldServer world, E entity) {
        a leashable_a = ((Leashable)((Object)entity)).T_();
        if (leashable_a != null && leashable_a.b != null) {
            Leashable.a(entity, leashable_a);
        }
        if (leashable_a != null && leashable_a.a != null) {
            Entity entity1;
            if (!entity.bL() || !leashable_a.a.bL()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.bL() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, world.N().b(GameRules.i) && !entity.pluginRemoved);
                event.callEvent();
                Leashable.a(entity, true, event.isDropLeash());
            }
            if ((entity1 = ((Leashable)((Object)entity)).A()) != null && entity1.dW() == entity.dW()) {
                float f2 = entity.f(entity1);
                if (!((Leashable)((Object)entity)).a(entity1, f2)) {
                    return;
                }
                if ((double)f2 > entity.dW().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).z();
                } else if ((double)f2 > 6.0) {
                    ((Leashable)((Object)entity)).b(entity1, f2);
                    entity.cy();
                } else {
                    ((Leashable)((Object)entity)).a(entity1);
                }
            }
        }
    }

    default public boolean a(Entity leashHolder, float distance) {
        return true;
    }

    default public void z() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        this.a(true, dropLeash);
    }

    default public void a(Entity entity) {
    }

    default public void b(Entity leashHolder, float distance) {
        Leashable.a((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, float distance) {
        double d0 = (leashHolder.dB() - entity.dB()) / (double)distance;
        double d1 = (leashHolder.dD() - entity.dD()) / (double)distance;
        double d2 = (leashHolder.dH() - entity.dH()) / (double)distance;
        entity.h(entity.dz().b(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
    }

    default public void b(Entity leashHolder, boolean sendPacket) {
        Leashable.a((Entity)((Object)this), leashHolder, sendPacket);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean sendPacket) {
        World world;
        a leashable_a = ((Leashable)((Object)entity)).T_();
        if (leashable_a == null) {
            leashable_a = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashable_a);
        } else {
            leashable_a.a(leashHolder);
        }
        if (sendPacket && (world = entity.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.m().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.bZ()) {
            entity.ae();
        }
    }

    @Nullable
    default public Entity A() {
        return Leashable.b((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity b(E entity) {
        Entity entity1;
        a leashable_a = ((Leashable)((Object)entity)).T_();
        if (leashable_a == null) {
            return null;
        }
        if (leashable_a.c != 0 && entity.dW().C && (entity1 = entity.dW().a(leashable_a.c)) instanceof Entity) {
            leashable_a.a(entity1);
        }
        return leashable_a.a;
    }

    public static final class a {
        int c;
        @Nullable
        public Entity a;
        @Nullable
        public Either<UUID, BlockPosition> b;

        a(Either<UUID, BlockPosition> unresolvedLeashData) {
            this.b = unresolvedLeashData;
        }

        a(Entity leashHolder) {
            this.a = leashHolder;
        }

        a(int unresolvedLeashHolderId) {
            this.c = unresolvedLeashHolderId;
        }

        public void a(Entity leashHolder) {
            this.a = leashHolder;
            this.b = null;
            this.c = 0;
        }
    }
}

