/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetSet {
    public static <E extends EntityInsentient> BehaviorControl<E> a(b<E> targetGetter) {
        return BehaviorAttackTargetSet.a((worldserver, entityinsentient) -> true, targetGetter);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a(a<E> condition, b<E> targetGetter) {
        return BehaviorBuilder.a((BehaviorBuilder.b<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.c(MemoryModuleType.o), behaviorbuilder_b.a(MemoryModuleType.E)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i2) -> {
            if (!condition.test(worldserver, entityinsentient)) {
                return false;
            }
            Optional<EntityLiving> optional = targetGetter.get(worldserver, entityinsentient);
            if (optional.isEmpty()) {
                return false;
            }
            EntityLiving entityliving = optional.get();
            if (!entityinsentient.c(entityliving)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryaccessor.b();
                return true;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryaccessor.a(entityliving);
            memoryaccessor1.b();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface a<E> {
        public boolean test(WorldServer var1, E var2);
    }

    @FunctionalInterface
    public static interface b<E> {
        public Optional<? extends EntityLiving> get(WorldServer var1, E var2);
    }
}

