/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.phys.Vec3D;

public class RandomPositionGenerator {
    private static final int a = 10;

    public static BlockPosition a(RandomSource random, int horizontalRange, int verticalRange) {
        int i2 = random.a(2 * horizontalRange + 1) - horizontalRange;
        int j2 = random.a(2 * verticalRange + 1) - verticalRange;
        int k2 = random.a(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPosition(i2, j2, k2);
    }

    @Nullable
    public static BlockPosition a(RandomSource random, int horizontalRange, int verticalRange, int startHeight, double directionX, double directionZ, double angleRange) {
        double d2 = MathHelper.d(directionZ, directionX) - 1.5707963705062866;
        double e2 = d2 + (double)(2.0f * random.i() - 1.0f) * angleRange;
        double f2 = Math.sqrt(random.j()) * (double)MathHelper.g * (double)horizontalRange;
        double g2 = -f2 * Math.sin(e2);
        double h2 = f2 * Math.cos(e2);
        if (Math.abs(g2) > (double)horizontalRange || Math.abs(h2) > (double)horizontalRange) {
            return null;
        }
        int i2 = random.a(2 * verticalRange + 1) - verticalRange + startHeight;
        return BlockPosition.a(g2, (double)i2, h2);
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int maxY, Predicate<BlockPosition> condition) {
        if (condition.test(pos)) {
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.b);
            while (mutableBlockPos.v() <= maxY && condition.test(mutableBlockPos)) {
                mutableBlockPos.c(EnumDirection.b);
            }
            return mutableBlockPos.j();
        }
        return pos;
    }

    @VisibleForTesting
    public static BlockPosition a(BlockPosition pos, int extraAbove, int max, Predicate<BlockPosition> condition) {
        if (extraAbove < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + extraAbove + ", expected >= 0");
        }
        if (condition.test(pos)) {
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.b);
            while (mutableBlockPos.v() <= max && condition.test(mutableBlockPos)) {
                mutableBlockPos.c(EnumDirection.b);
            }
            int i2 = mutableBlockPos.v();
            while (mutableBlockPos.v() <= max && mutableBlockPos.v() - i2 < extraAbove) {
                mutableBlockPos.c(EnumDirection.b);
                if (!condition.test(mutableBlockPos)) continue;
                mutableBlockPos.c(EnumDirection.a);
                break;
            }
            return mutableBlockPos.j();
        }
        return pos;
    }

    @Nullable
    public static Vec3D a(EntityCreature entity, Supplier<BlockPosition> factory) {
        return RandomPositionGenerator.a(factory, entity::c);
    }

    @Nullable
    public static Vec3D a(Supplier<BlockPosition> factory, ToDoubleFunction<BlockPosition> scorer) {
        double d2 = Double.NEGATIVE_INFINITY;
        BlockPosition blockPos = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            double e2;
            BlockPosition blockPos2 = factory.get();
            if (blockPos2 == null || !((e2 = scorer.applyAsDouble(blockPos2)) > d2)) continue;
            d2 = e2;
            blockPos = blockPos2;
        }
        return blockPos != null ? Vec3D.c(blockPos) : null;
    }

    public static BlockPosition a(EntityCreature entity, int horizontalRange, RandomSource random, BlockPosition fuzz) {
        int i2 = fuzz.u();
        int j2 = fuzz.w();
        if (entity.ga() && horizontalRange > 1) {
            BlockPosition blockPos = entity.fX();
            i2 = entity.dB() > (double)blockPos.u() ? (i2 -= random.a(horizontalRange / 2)) : (i2 += random.a(horizontalRange / 2));
            j2 = entity.dH() > (double)blockPos.w() ? (j2 -= random.a(horizontalRange / 2)) : (j2 += random.a(horizontalRange / 2));
        }
        return BlockPosition.a((double)i2 + entity.dB(), (double)fuzz.v() + entity.dD(), (double)j2 + entity.dH());
    }
}

