/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.PoiAccess;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileSection;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class VillagePlace
extends RegionFileSection<VillagePlaceSection, VillagePlaceSection.a>
implements ChunkSystemPoiManager {
    public static final int a = 6;
    public static final int b = 1;
    private final a d;
    private final LongSet e = new LongOpenHashSet();
    private final WorldServer world;
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    private static final int POI_DATA_SOURCE = 7;

    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    private void updateDistanceTracking(long section) {
        if (this.g(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Override
    public Optional<VillagePlaceSection> c(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        PoiChunk ret = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    @Override
    public Optional<VillagePlaceSection> d(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection(this.world) && chunkY <= WorldUtil.getMaxSection(this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    protected VillagePlaceSection getOrCreate(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final WorldServer moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            long sectionPos = SectionPosition.b(chunkX, sectionY, chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            VillagePlaceSection section = poiChunk.getSection(sectionY);
            if (section == null || section.moonrise$isEmpty()) continue;
            this.b(SectionPosition.b(chunkX, sectionY, chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(IChunkAccess chunk) {
        int chunkX = chunk.f().h;
        int chunkZ = chunk.f().i;
        int minY = WorldUtil.getMinSection(chunk);
        int maxY = WorldUtil.getMaxSection(chunk);
        ChunkSection[] sections = chunk.d();
        for (int section = minY; section <= maxY; ++section) {
            this.a(SectionPosition.a(chunkX, section, chunkZ), sections[section - minY]);
        }
    }

    public VillagePlace(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync, IRegistryCustom registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        super(new SimpleRegionStorage(storageKey, directory, dataFixer, dsync, DataFixTypes.q), VillagePlaceSection.a.a, VillagePlaceSection::a, VillagePlaceSection.a::a, VillagePlaceSection::new, registryManager, errorHandler, world);
        this.d = new a();
        this.world = (WorldServer)world;
    }

    public void a(BlockPosition pos, Holder<VillagePlaceType> type) {
        this.getOrCreate(SectionPosition.c(pos)).a(pos, type);
    }

    public void a(BlockPosition pos) {
        this.d(SectionPosition.c(pos)).ifPresent(poiSet -> poiSet.a(pos));
    }

    public long a(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.c(typePredicate, pos, radius, occupationStatus).count();
    }

    public boolean a(ResourceKey<VillagePlaceType> type, BlockPosition pos) {
        return this.a(pos, (Holder<VillagePlaceType> entry) -> entry.a(type));
    }

    public Stream<VillagePlaceRecord> b(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        int i2 = Math.floorDiv(radius, 16) + 1;
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(pos), i2).flatMap(chunkPos -> this.a(typePredicate, (ChunkCoordIntPair)chunkPos, occupationStatus)).filter(poi -> {
            BlockPosition blockPos2 = poi.g();
            return Math.abs(blockPos2.u() - pos.u()) <= radius && Math.abs(blockPos2.w() - pos.w()) <= radius;
        });
    }

    public Stream<VillagePlaceRecord> c(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        int i2 = radius * radius;
        return this.b(typePredicate, pos, radius, occupationStatus).filter(poi -> poi.g().j(pos) <= (double)i2);
    }

    @VisibleForDebug
    public Stream<VillagePlaceRecord> a(Predicate<Holder<VillagePlaceType>> typePredicate, ChunkCoordIntPair chunkPos, Occupancy occupationStatus) {
        return IntStream.rangeClosed(this.c.ao(), this.c.ap()).boxed().map(coord -> this.d(SectionPosition.a(chunkPos, (int)coord).s())).filter(Optional::isPresent).flatMap(poiSet -> ((VillagePlaceSection)poiSet.get()).a(typePredicate, occupationStatus));
    }

    public Stream<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.c(typePredicate, pos, radius, occupationStatus).map(VillagePlaceRecord::g).filter(posPredicate);
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> b(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.c(typePredicate, pos, radius, occupationStatus).filter(poi -> posPredicate.test(poi.g())).map(poi -> Pair.of(poi.h(), (Object)poi.g()));
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> c(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.b(typePredicate, posPredicate, pos, radius, occupationStatus).sorted(Comparator.comparingDouble(pair -> ((BlockPosition)pair.getSecond()).j(pos)));
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition ret = PoiAccess.findAnyPoiPosition(this, typePredicate, posPredicate, pos, radius, occupationStatus, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, null, pos, radius, radius * radius, occupationStatus, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> e(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return Optional.ofNullable(PoiAccess.findClosestPoiDataTypeAndPosition(this, typePredicate, null, pos, radius, radius * radius, occupationStatus, false));
    }

    public Optional<BlockPosition> e(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, posPredicate, pos, radius, radius * radius, occupationStatus, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, BiPredicate<Holder<VillagePlaceType>, BlockPosition> posPredicate, BlockPosition pos, int radius) {
        VillagePlaceRecord closest = PoiAccess.findClosestPoiDataRecord(this, typePredicate, posPredicate, pos, radius, (double)(radius * radius), Occupancy.a, false);
        return Optional.ofNullable(closest).map(poi -> {
            poi.c();
            return poi.g();
        });
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> positionPredicate, Occupancy occupationStatus, BlockPosition pos, int radius, RandomSource random) {
        ArrayList<VillagePlaceRecord> list = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findAnyPoiRecords(this, typePredicate, positionPredicate, pos, radius, occupationStatus, false, Integer.MAX_VALUE, list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((VillagePlaceRecord)list.get(random.a(list.size()))).g());
    }

    public boolean b(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.c(pos)).orElseThrow(() -> SystemUtils.b(new IllegalStateException("POI never registered at " + String.valueOf(pos))));
    }

    public boolean a(BlockPosition pos, Predicate<Holder<VillagePlaceType>> predicate) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.a(pos, predicate)).orElse(false);
    }

    public Optional<Holder<VillagePlaceType>> c(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).flatMap(poiSet -> poiSet.d(pos));
    }

    @Deprecated
    @VisibleForDebug
    public int d(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.b(pos)).orElse(0);
    }

    public int a(SectionPosition pos) {
        this.villageDistanceTracker.propagateUpdates();
        return VillagePlace.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(pos)));
    }

    boolean g(long pos) {
        Optional<VillagePlaceSection> optional = this.c(pos);
        return optional != null && optional.map(poiSet -> poiSet.a((Holder<VillagePlaceType> entry) -> entry.a(PoiTypeTags.b), Occupancy.b).findAny().isPresent()).orElse(false) != false;
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Override
    public void a(long pos) {
        int chunkZ;
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(pos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(pos);
    }

    @Override
    protected void b(long pos) {
        this.updateDistanceTracking(pos);
    }

    public void a(SectionPosition sectionPos, ChunkSection chunkSection) {
        SystemUtils.a(this.d(sectionPos.s()), (T poiSet) -> poiSet.a((BiConsumer<BlockPosition, Holder<VillagePlaceType>> populator) -> {
            if (VillagePlace.a(chunkSection)) {
                this.a(chunkSection, sectionPos, (BiConsumer<BlockPosition, Holder<VillagePlaceType>>)populator);
            }
        }), () -> {
            if (VillagePlace.a(chunkSection)) {
                VillagePlaceSection poiSection = this.getOrCreate(sectionPos.s());
                this.a(chunkSection, sectionPos, poiSection::a);
            }
        });
    }

    private static boolean a(ChunkSection chunkSection) {
        return chunkSection.a(PoiTypes::b);
    }

    private void a(ChunkSection chunkSection, SectionPosition sectionPos, BiConsumer<BlockPosition, Holder<VillagePlaceType>> populator) {
        sectionPos.t().forEach(pos -> {
            IBlockData blockState = chunkSection.a(SectionPosition.b(pos.u()), SectionPosition.b(pos.v()), SectionPosition.b(pos.w()));
            PoiTypes.a(blockState).ifPresent(poiType -> populator.accept((BlockPosition)pos, (Holder<VillagePlaceType>)poiType));
        });
    }

    public void a(IWorldReader world, BlockPosition pos, int radius) {
        SectionPosition.a(new ChunkCoordIntPair(pos), Math.floorDiv(radius, 16), this.c.ao(), this.c.ap()).map(sectionPos -> Pair.of((Object)sectionPos, this.d(sectionPos.s()))).filter(pair -> ((Optional)pair.getSecond()).map(VillagePlaceSection::b).orElse(false) == false).map(pair -> ((SectionPosition)pair.getFirst()).r()).forEach(chunkPos -> world.a(chunkPos.h, chunkPos.i, ChunkStatus.c));
    }

    final class a
    extends LightEngineGraphSection {
        private final Long2ByteMap b;

        protected a() {
            super(7, 16, 256);
            this.b = new Long2ByteOpenHashMap();
            this.b.defaultReturnValue((byte)7);
        }

        @Override
        protected int b(long id) {
            return VillagePlace.this.g(id) ? 0 : 7;
        }

        @Override
        protected int c(long id) {
            return this.b.get(id);
        }

        @Override
        protected void a(long id, int level) {
            if (level > 6) {
                this.b.remove(id);
            } else {
                this.b.put(id, (byte)level);
            }
        }

        public void a() {
            super.b(Integer.MAX_VALUE);
        }
    }

    public static final class Occupancy
    extends Enum<Occupancy> {
        public static final /* enum */ Occupancy a = new Occupancy(VillagePlaceRecord::e);
        public static final /* enum */ Occupancy b = new Occupancy(VillagePlaceRecord::f);
        public static final /* enum */ Occupancy c = new Occupancy(poi -> true);
        private final Predicate<? super VillagePlaceRecord> d;
        private static final /* synthetic */ Occupancy[] e;

        public static Occupancy[] values() {
            return (Occupancy[])e.clone();
        }

        public static Occupancy valueOf(String name) {
            return Enum.valueOf(Occupancy.class, name);
        }

        private Occupancy(Predicate<? super VillagePlaceRecord> predicate) {
            this.d = predicate;
        }

        public Predicate<? super VillagePlaceRecord> a() {
            return this.d;
        }

        private static /* synthetic */ Occupancy[] b() {
            return new Occupancy[]{a, b, c};
        }

        static {
            e = Occupancy.b();
        }
    }
}

