/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cc = 6000;
    public int bZ;
    @Nullable
    public UUID ca;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gt() {
        return EntityInsentient.C().a(GenericAttributes.E, 10.0);
    }

    @Override
    protected void a(WorldServer world) {
        if (this.Z_() != 0) {
            this.bZ = 0;
        }
        super.a(world);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.Z_() != 0) {
            this.bZ = 0;
        }
        if (this.bZ > 0) {
            --this.bZ;
            if (this.bZ % 10 == 0) {
                double d0 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d2 = this.ae.k() * 0.02;
                this.dW().a(Particles.Q, this.d(1.0), this.dE() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gz();
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.e()).a(Blocks.i) ? 10.0f : world.w(pos);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.bZ);
        if (this.ca != null) {
            nbt.a("LoveCause", this.ca);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bZ = nbt.h("InLove");
        this.ca = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EntitySpawnReason.b(spawnReason) || EntityAnimal.a(world, pos);
        return world.a_(pos.e()).a(TagsBlock.bY) && flag;
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int Q() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected int e(WorldServer world) {
        return 1 + this.ae.a(3);
    }

    public abstract boolean j(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.j(itemstack)) {
            int i2 = this.Z_();
            if (!this.dW().C && i2 == 0 && this.gv()) {
                ItemStack breedCopy = itemstack.v();
                this.a(player, hand, itemstack);
                this.setInLove(player, breedCopy);
                this.gu();
                return EnumInteractionResult.b;
            }
            if (this.e_()) {
                this.a(player, hand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                this.gu();
                return EnumInteractionResult.a;
            }
            if (this.dW().C) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(player, hand);
    }

    protected void gu() {
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        int i2 = stack.L();
        UseRemainder useremainder = stack.a(DataComponents.y);
        stack.a(1, (EntityLiving)player);
        if (useremainder != null) {
            boolean flag = player.fV();
            Objects.requireNonNull(player);
            ItemStack itemstack1 = useremainder.a(stack, i2, flag, player::b);
            player.a(hand, itemstack1);
        }
    }

    public boolean gv() {
        return this.bZ <= 0;
    }

    @Deprecated
    @DoNotUse
    public void f(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.bZ = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.ca = player.cG();
        }
        this.dW().a((Entity)this, (byte)18);
    }

    public void r(int loveTicks) {
        this.bZ = loveTicks;
    }

    public int gw() {
        return this.bZ;
    }

    @Nullable
    public EntityPlayer gx() {
        if (this.ca == null) {
            return null;
        }
        EntityHuman entityhuman = this.dW().b(this.ca);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gy() {
        return this.bZ > 0;
    }

    public void gz() {
        this.bZ = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.gy() && other.gy());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dB(), this.dD(), this.dH(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gx()).or(() -> Optional.ofNullable(other.gx())).orElse(null);
            int experience = this.dZ().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(world, other, entityageable, experience);
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer world, EntityAnimal other, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(world, other, baby, this.dZ().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        EntityPlayer entityplayer = this.gx();
        if (entityplayer == null) {
            entityplayer = entityanimal.gx();
        }
        if (entityplayer != null) {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.p.a(entityplayer, this, entityanimal, entityageable);
        }
        this.c_(6000);
        entityanimal.c_(6000);
        this.gz();
        entityanimal.gz();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.N().b(GameRules.f) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dB(), this.dD(), this.dH(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
        }
    }

    @Override
    public void b(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d2 = this.ae.k() * 0.02;
                this.dW().a(Particles.Q, this.d(1.0), this.dE() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(status);
        }
    }
}

