/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bZ = 120.32113f;
    public static final int ca = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cj = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> ck = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int cl = 2;
    private static final int cm = 4;
    private static final int cn = 8;
    private static final int co = 1200;
    private static final int cp = 600;
    private static final int cq = 3600;
    private static final int cr = 4;
    private static final int cs = 10;
    private static final int ct = 10;
    private static final int cu = 18;
    private static final int cv = 48;
    private static final int cw = 2;
    private static final int cx = 24;
    private static final int cy = 16;
    private static final int cz = 16;
    private static final int cC = 20;
    public static final String cb = "CropsGrownSincePollination";
    public static final String cd = "CannotEnterHiveTicks";
    public static final String ce = "TicksSincePollination";
    public static final String cf = "HasStung";
    public static final String cg = "HasNectar";
    public static final String ch = "flower_pos";
    public static final String ci = "hive_pos";
    private static final UniformInt cD = TimeRange.a(20, 39);
    @Nullable
    private UUID cE;
    private float cF;
    private float cG;
    private int cH;
    public int cI;
    public int cJ;
    public int cK;
    private static final int cL = 200;
    int cM;
    private static final int cN = 200;
    private static final int cO = 20;
    private static final int cP = 60;
    int cQ;
    @Nullable
    BlockPosition cR;
    @Nullable
    public BlockPosition cS;
    k cT;
    e cU;
    private f cV;
    private int cW;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cQ = MathHelper.a(this.ae, 20, 60);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.dD() <= (double)EntityBee.this.dW().L_()) {
                    this.d.f(false);
                }
                super.a();
            }
        }
        this.bQ = new BeeFlyingMoveControl(this, 20, true);
        this.bP = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.x, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cj, (byte)0);
        builder.a(ck, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).l() ? 10.0f : 0.0f;
    }

    @Override
    protected void B() {
        this.bT.a(0, new b(this, 1.4f, true));
        this.bT.a(1, new d());
        this.bT.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.ao), false));
        this.bT.a(3, new n());
        this.bT.a(3, new m());
        this.cT = new k();
        this.bT.a(4, this.cT);
        this.bT.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bT.a(5, new i());
        this.cU = new e();
        this.bT.a(5, this.cU);
        this.cV = new f();
        this.bT.a(6, this.cV);
        this.bT.a(7, new g());
        this.bT.a(8, new l());
        this.bT.a(9, new PathfinderGoalFloat(this));
        this.bU.a(1, new h(this).a(new Class[0]));
        this.bU.a(2, new c(this));
        this.bU.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        this.addAdditionalSaveData(nbt, true);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        super.b(nbttagcompound);
        if (includeAll && this.gq()) {
            nbttagcompound.a(ci, GameProfileSerializer.a(this.gr()));
        }
        if (includeAll && this.t()) {
            nbttagcompound.a(ch, GameProfileSerializer.a(this.p()));
        }
        nbttagcompound.a(cg, this.gA());
        nbttagcompound.a(cf, this.gB());
        nbttagcompound.a(ce, this.cI);
        nbttagcompound.a(cd, this.cJ);
        nbttagcompound.a(cb, this.cK);
        this.a_(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q(cg));
        this.y(nbt.q(cf));
        this.cI = nbt.h(ce);
        this.cJ = nbt.h(cd);
        this.cK = nbt.h(cb);
        this.cS = GameProfileSerializer.a(nbt, ci).orElse(null);
        this.cR = GameProfileSerializer.a(nbt, ch).orElse(null);
        this.a(this.dW(), nbt);
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        DamageSource damagesource = this.dX().a(this);
        boolean flag = target.a(world, damagesource, (float)((int)this.h(GenericAttributes.c)));
        if (flag) {
            EnchantmentManager.a(world, target, damagesource);
            if (target instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)target;
                entityliving.p(entityliving.eV() + 1);
                int b0 = 0;
                if (this.dW().al() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.dW().al() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    entityliving.addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.y(true);
            this.af_();
            this.a(SoundEffects.bS, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void h() {
        super.h();
        if (this.gA() && this.gL() < 10 && this.ae.i() < 0.05f) {
            for (int i2 = 0; i2 < this.ae.a(2) + 1; ++i2) {
                this.a(this.dW(), this.dB() - (double)0.3f, this.dB() + (double)0.3f, this.dH() - (double)0.3f, this.dH() + (double)0.3f, this.e(0.5), Particles.az);
            }
        }
        this.gJ();
    }

    private void a(World world, double lastX, double x2, double lastZ, double z2, double y2, ParticleParam effect) {
        world.a(effect, MathHelper.d(world.A.j(), lastX, x2), y2, MathHelper.d(world.A.j(), lastZ, z2), 0.0, 0.0, 0.0);
    }

    void j(BlockPosition pos) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(pos);
        int b0 = 0;
        BlockPosition blockposition1 = this.dw();
        int i2 = (int)vec3d.e - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(pos);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bS.b(0.5f);
            this.bS.a(vec3d1.d, vec3d1.e, vec3d1.f, 1.0);
        }
    }

    @Nullable
    public BlockPosition p() {
        return this.cR;
    }

    public boolean t() {
        return this.cR != null;
    }

    public void h(BlockPosition flowerPos) {
        this.cR = flowerPos;
    }

    @VisibleForDebug
    public int x() {
        return Math.max(this.cU.d, this.cV.d);
    }

    @VisibleForDebug
    public List<BlockPosition> go() {
        return this.cU.f;
    }

    private boolean gF() {
        return this.cI > 3600;
    }

    void gG() {
        this.cS = null;
        this.cM = 200;
    }

    void gH() {
        this.cR = null;
        this.cQ = MathHelper.a(this.ae, 20, 60);
    }

    boolean gI() {
        if (this.cJ <= 0 && !this.cT.l() && !this.gB() && this.O_() == null) {
            boolean flag = this.gF() || EntityBee.c(this.dW()) || this.gA();
            return flag && !this.gK();
        }
        return false;
    }

    public static boolean c(World world) {
        return world.G_().g() && (world.V() || world.af());
    }

    public void s(int cannotEnterHiveTicks) {
        this.cJ = cannotEnterHiveTicks;
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.cG, this.cF);
    }

    private void gJ() {
        this.cG = this.cF;
        this.cF = this.gQ() ? Math.min(1.0f, this.cF + 0.2f) : Math.max(0.0f, this.cF - 0.24f);
    }

    @Override
    protected void a(WorldServer world) {
        boolean flag = this.gB();
        this.cW = this.bm() ? ++this.cW : 0;
        if (this.cW > 20) {
            this.a(world, this.dX().i(), 1.0f);
        }
        if (flag) {
            ++this.cH;
            if (this.cH % 5 == 0 && this.ae.a(MathHelper.a(1200 - this.cH, 1, 1200)) == 0) {
                this.a(world, this.dX().p(), this.eE());
            }
        }
        if (!this.gA()) {
            ++this.cI;
        }
        this.a(world, false);
    }

    public void gp() {
        this.cI = 0;
    }

    private boolean gK() {
        TileEntityBeehive tileentitybeehive = this.gO();
        return tileentitybeehive != null && tileentitybeehive.b();
    }

    @Override
    public int a() {
        return this.al.a(ck);
    }

    @Override
    public void a(int angerTime) {
        this.al.a(ck, angerTime);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cE;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cE = angryAt;
    }

    @Override
    public void c() {
        this.a(cD.a(this.ae));
    }

    private boolean k(BlockPosition pos) {
        TileEntity tileentity = this.dW().c_(pos);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).d() : false;
    }

    @VisibleForDebug
    public boolean gq() {
        return this.cS != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition gr() {
        return this.cS;
    }

    @VisibleForDebug
    public PathfinderGoalSelector gs() {
        return this.bT;
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    int gL() {
        return this.cK;
    }

    private void gM() {
        this.cK = 0;
    }

    void gN() {
        ++this.cK;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dW().C) {
            if (this.cJ > 0) {
                --this.cJ;
            }
            if (this.cM > 0) {
                --this.cM;
            }
            if (this.cQ > 0) {
                --this.cQ;
            }
            boolean flag = this.ad_() && !this.gB() && this.O_() != null && this.O_().g((Entity)this) < 4.0;
            this.z(flag);
            if (this.af % 20 == 0 && !this.gP()) {
                this.cS = null;
            }
        }
    }

    @Nullable
    TileEntityBeehive gO() {
        if (this.cS != null && !this.l(this.cS) && this.dW().getChunkIfLoadedImmediately(this.cS.u() >> 4, this.cS.w() >> 4) != null) {
            return this.dW().a(this.cS, TileEntityTypes.I).orElse(null);
        }
        return null;
    }

    boolean gP() {
        return this.gO() != null;
    }

    public boolean gA() {
        return this.t(8);
    }

    public void x(boolean hasNectar) {
        if (hasNectar) {
            this.gp();
        }
        this.d(8, hasNectar);
    }

    public boolean gB() {
        return this.t(4);
    }

    public void y(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean gQ() {
        return this.t(2);
    }

    public void z(boolean nearTarget) {
        nearTarget = this.rollingOverride.toBooleanOrElse(nearTarget);
        this.d(2, nearTarget);
    }

    boolean l(BlockPosition pos) {
        return !this.b(pos, 48);
    }

    private void d(int bit, boolean value) {
        if (value) {
            this.al.a(cj, (byte)(this.al.a(cj) | bit));
        } else {
            this.al.a(cj, (byte)(this.al.a(cj) & ~bit));
        }
    }

    private boolean t(int location) {
        return (this.al.a(cj) & location) != 0;
    }

    public static AttributeProvider.Builder gC() {
        return EntityAnimal.gt().a(GenericAttributes.s, 10.0).a(GenericAttributes.l, 0.6f).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.e()).l();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cT.l()) {
                    super.c();
                }
            }
        };
        navigationflying.b(false);
        navigationflying.a(false);
        navigationflying.c(true);
        navigationflying.a(48.0f);
        return navigationflying;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ao);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected SoundEffect u() {
        return null;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.bP;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.bO;
    }

    @Override
    public float fg() {
        return 0.4f;
    }

    @Nullable
    public EntityBee b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.l.a(world, EntitySpawnReason.e);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean ba() {
        return this.gD() && this.af % ca == 0;
    }

    @Override
    public boolean gD() {
        return !this.aJ();
    }

    public void gE() {
        this.x(false);
        this.gM();
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.a(world, source)) {
            return false;
        }
        boolean result = super.a(world, source, amount);
        if (!result) {
            return result;
        }
        this.cT.m();
        return result;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        this.h(this.dz().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dr() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.dw(), (double)distance);
    }

    public void i(BlockPosition pos) {
        this.cS = pos;
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            if (!EntityBee.this.ad_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cT.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.ad_() && !EntityBee.this.gB();
        }

        @Override
        public boolean c() {
            return super.c() && EntityBee.this.ad_() && !EntityBee.this.gB();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            TileEntityBeehive tileentitybeehive;
            if (EntityBee.this.cS != null && EntityBee.this.gI() && EntityBee.this.cS.a(EntityBee.this.du(), 2.0) && (tileentitybeehive = EntityBee.this.gO()) != null) {
                if (!tileentitybeehive.d()) {
                    return true;
                }
                EntityBee.this.cS = null;
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            TileEntityBeehive tileentitybeehive = EntityBee.this.gO();
            if (tileentitybeehive != null) {
                tileentitybeehive.a(EntityBee.this);
            }
        }
    }

    private class n
    extends a {
        private final int c;
        private long d;

        n() {
            this.c = MathHelper.a(EntityBee.this.ae, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.cS != null && EntityBee.this.dW().p(EntityBee.this.cS) && !EntityBee.this.gP()) {
                EntityBee.this.gG();
            }
            this.d = EntityBee.this.dW().ac();
        }

        @Override
        public boolean h() {
            return EntityBee.this.dW().ac() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }
    }

    private class m
    extends a {
        private final int c;
        private long d;

        m() {
            this.c = MathHelper.a(EntityBee.this.ae, 20, 40);
            this.d = -1L;
        }

        @Override
        public void d() {
            if (EntityBee.this.cR != null && EntityBee.this.dW().p(EntityBee.this.cR) && !this.a(EntityBee.this.cR)) {
                EntityBee.this.gH();
            }
            this.d = EntityBee.this.dW().ac();
        }

        @Override
        public boolean h() {
            return EntityBee.this.dW().ac() > this.d + (long)this.c;
        }

        @Override
        public boolean i() {
            return false;
        }

        private boolean a(BlockPosition pos) {
            return EntityBee.this.dW().a_(pos).a(TagsBlock.W);
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private final Predicate<IBlockData> d;
        private static final double e = 0.1;
        private static final int f = 25;
        private static final float g = 0.35f;
        private static final float h = 0.6f;
        private static final float i = 0.33333334f;
        private static final int j = 5;
        private int k;
        private int l;
        private boolean m;
        @Nullable
        private Vec3D n;
        private int o;
        private static final int p = 600;
        private Long2LongOpenHashMap q;

        k() {
            this.d = iblockdata -> iblockdata.b(BlockProperties.D) && iblockdata.c(BlockProperties.D).booleanValue() ? false : (iblockdata.a(TagsBlock.W) ? (iblockdata.a(Blocks.iU) ? iblockdata.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a : true) : false);
            this.q = new Long2LongOpenHashMap();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cQ > 0) {
                return false;
            }
            if (EntityBee.this.gA()) {
                return false;
            }
            if (EntityBee.this.dW().af()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cR = optional.get();
                EntityBee.this.bS.a((double)EntityBee.this.cR.u() + 0.5, (double)EntityBee.this.cR.v() + 0.5, (double)EntityBee.this.cR.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cQ = MathHelper.a(EntityBee.this.ae, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            return !this.m ? false : (!EntityBee.this.t() ? false : (EntityBee.this.dW().af() ? false : (this.k() ? EntityBee.this.ae.i() < 0.2f : true)));
        }

        private boolean k() {
            return this.k > 400;
        }

        boolean l() {
            return this.m;
        }

        void m() {
            this.m = false;
        }

        @Override
        public void d() {
            this.k = 0;
            this.o = 0;
            this.l = 0;
            this.m = true;
            EntityBee.this.gp();
        }

        @Override
        public void e() {
            if (this.k()) {
                EntityBee.this.x(true);
            }
            this.m = false;
            EntityBee.this.bS.o();
            EntityBee.this.cQ = 200;
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityBee.this.t()) {
                ++this.o;
                if (this.o > 600) {
                    EntityBee.this.gH();
                    this.m = false;
                    EntityBee.this.cQ = 200;
                } else if (EntityBee.this.cR != null) {
                    Vec3D vec3d = Vec3D.c(EntityBee.this.cR).b(0.0, 0.6f, 0.0);
                    if (vec3d.f(EntityBee.this.du()) > 1.0) {
                        this.n = vec3d;
                        this.n();
                    } else {
                        if (this.n == null) {
                            this.n = vec3d;
                        }
                        boolean flag = EntityBee.this.du().f(this.n) <= 0.1;
                        boolean flag1 = true;
                        if (!flag && this.o > 600) {
                            EntityBee.this.gH();
                        } else {
                            if (flag) {
                                boolean flag2;
                                boolean bl = flag2 = EntityBee.this.ae.a(25) == 0;
                                if (flag2) {
                                    this.n = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                    EntityBee.this.bS.o();
                                } else {
                                    flag1 = false;
                                }
                                EntityBee.this.H().a(vec3d.a(), vec3d.b(), vec3d.c());
                            }
                            if (flag1) {
                                this.n();
                            }
                            ++this.k;
                            if (EntityBee.this.ae.i() < 0.05f && this.k > this.l + 60) {
                                this.l = this.k;
                                EntityBee.this.a(SoundEffects.bT, 1.0f, 1.0f);
                            }
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.I().a(this.n.a(), this.n.b(), this.n.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.ae.i() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            Iterable<BlockPosition> iterable = BlockPosition.a(EntityBee.this.dw(), 5, 5, 5);
            Long2LongOpenHashMap long2longopenhashmap = new Long2LongOpenHashMap();
            for (BlockPosition blockposition : iterable) {
                long i2 = this.q.getOrDefault(blockposition.a(), Long.MIN_VALUE);
                if (EntityBee.this.dW().ac() < i2) {
                    long2longopenhashmap.put(blockposition.a(), i2);
                    continue;
                }
                if (!this.d.test(EntityBee.this.dW().a_(blockposition))) continue;
                PathEntity pathentity = EntityBee.this.bS.a(blockposition, 1);
                if (pathentity != null && pathentity.j()) {
                    return Optional.of(blockposition);
                }
                long2longopenhashmap.put(blockposition.a(), EntityBee.this.dW().ac() + 600L);
            }
            this.q = long2longopenhashmap;
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cM == 0 && !EntityBee.this.gq() && EntityBee.this.gI();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void d() {
            EntityBee.this.cM = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cU.k();
                    EntityBee.this.cS = list.get(0);
                    return;
                } while (EntityBee.this.cU.b(blockposition = iterator.next()));
                EntityBee.this.cS = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.dw();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.dW()).z();
            Stream<VillagePlaceRecord> stream = villageplace.c(holder -> holder.a(PoiTypeTags.c), blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::g).filter(EntityBee.this::k).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 2400;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.ae.a(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cS != null && !EntityBee.this.l(EntityBee.this.cS) && !EntityBee.this.ga() && EntityBee.this.gI() && !this.d(EntityBee.this.cS) && EntityBee.this.dW().a_(EntityBee.this.cS).a(TagsBlock.aJ);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bS.o();
            EntityBee.this.bS.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.cS != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    this.l();
                } else if (!EntityBee.this.bS.n()) {
                    if (!EntityBee.this.b(EntityBee.this.cS, 16)) {
                        if (EntityBee.this.l(EntityBee.this.cS)) {
                            EntityBee.this.gG();
                        } else {
                            EntityBee.this.j(EntityBee.this.cS);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cS);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bS.k().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                EntityBee.this.gG();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bS.k();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            int i2 = EntityBee.this.b(pos, 3) ? 1 : 2;
            EntityBee.this.bS.b(10.0f);
            EntityBee.this.bS.a(pos.u(), (double)pos.v(), pos.w(), i2, 1.0);
            return EntityBee.this.bS.k() != null && EntityBee.this.bS.k().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cS != null) {
                this.c(EntityBee.this.cS);
            }
            EntityBee.this.gG();
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bS.k();
            return pathentity != null && pathentity.l().equals(pos) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 2400;
        int d;

        f() {
            this.d = EntityBee.this.ae.a(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cR != null && !EntityBee.this.ga() && this.k() && !EntityBee.this.b(EntityBee.this.cR, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void d() {
            this.d = 0;
            super.d();
        }

        @Override
        public void e() {
            this.d = 0;
            EntityBee.this.bS.o();
            EntityBee.this.bS.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.cR != null) {
                ++this.d;
                if (this.d > this.a(2400)) {
                    EntityBee.this.gH();
                } else if (!EntityBee.this.bS.n()) {
                    if (EntityBee.this.l(EntityBee.this.cR)) {
                        EntityBee.this.gH();
                    } else {
                        EntityBee.this.j(EntityBee.this.cR);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cI > 600;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.gL() >= 10 ? false : (EntityBee.this.ae.i() < 0.3f ? false : EntityBee.this.gA() && EntityBee.this.gP());
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void a() {
            if (EntityBee.this.ae.a(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    IBlockFragilePlantElement iblockfragileplantelement;
                    BlockPosition blockposition = EntityBee.this.dw().c(i2);
                    IBlockData iblockdata = EntityBee.this.dW().a_(blockposition);
                    Block block = iblockdata.b();
                    IBlockData iblockdata1 = null;
                    if (!iblockdata.a(TagsBlock.aL)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.i(iblockdata)) {
                            iblockdata1 = blockcrops.b(blockcrops.h(iblockdata) + 1);
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.c);
                        if (j2 < 7) {
                            iblockdata1 = (IBlockData)iblockdata.b(BlockStem.c, j2 + 1);
                        }
                    } else if (iblockdata.a(Blocks.oD)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.c);
                        if (j3 < 3) {
                            iblockdata1 = (IBlockData)iblockdata.b(BlockSweetBerryBush.c, j3 + 1);
                        }
                    } else if ((iblockdata.a(Blocks.sQ) || iblockdata.a(Blocks.sR)) && (iblockfragileplantelement = (IBlockFragilePlantElement)((Object)iblockdata.b())).b(EntityBee.this.dW(), blockposition, iblockdata)) {
                        iblockfragileplantelement.a((WorldServer)EntityBee.this.dW(), EntityBee.this.ae, blockposition, iblockdata);
                        iblockdata1 = EntityBee.this.dW().a_(blockposition);
                    }
                    if (iblockdata1 == null || !CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, iblockdata1)) continue;
                    EntityBee.this.dW().c(2011, blockposition, 15);
                    EntityBee.this.dW().b(blockposition, iblockdata1);
                    EntityBee.this.gN();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityBee.this.bS.m() && EntityBee.this.ae.a(10) == 0;
        }

        @Override
        public boolean c() {
            return EntityBee.this.bS.n();
        }

        @Override
        public void d() {
            Vec3D vec3d = this.h();
            if (vec3d != null) {
                EntityBee.this.bS.a(EntityBee.this.bS.a(BlockPosition.a(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec3d;
            if (EntityBee.this.gP() && !EntityBee.this.b(EntityBee.this.cS, this.i())) {
                Vec3D vec3d1 = Vec3D.b(EntityBee.this.cS);
                vec3d = vec3d1.d(EntityBee.this.du()).d();
            } else {
                vec3d = EntityBee.this.g(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.d, vec3d.f, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.d, vec3d.f, 1.5707963705062866);
        }

        private int i() {
            int i2 = !EntityBee.this.gq() && !EntityBee.this.t() ? 16 : 24;
            return 48 - i2;
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean c() {
            return EntityBee.this.ad_() && super.c();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.E(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee bee) {
            super(bee, EntityHuman.class, 10, true, false, bee::a);
        }

        @Override
        public boolean b() {
            return this.i() && super.b();
        }

        @Override
        public boolean c() {
            boolean flag = this.i();
            if (flag && this.e.O_() != null) {
                return super.c();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.ad_() && !entitybee.gB();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean b() {
            return this.h() && !EntityBee.this.ad_();
        }

        @Override
        public boolean c() {
            return this.i() && !EntityBee.this.ad_();
        }
    }
}

