/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<Holder<CatVariant>> {
    public static final double cd = 0.6;
    public static final double ce = 0.8;
    public static final double cf = 1.33;
    private static final DataWatcherObject<Holder<CatVariant>> cg = DataWatcher.a(EntityCat.class, DataWatcherRegistry.x);
    private static final DataWatcherObject<Boolean> ch = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ci = DataWatcher.a(EntityCat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cj = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private static final ResourceKey<CatVariant> ck = CatVariant.c;
    @Nullable
    private a<EntityHuman> cl;
    @Nullable
    private PathfinderGoalTempt cm;
    private float cn;
    private float co;
    private float cp;
    private float cq;
    private boolean cr;
    private float cs;
    private float ct;

    public EntityCat(EntityTypes<? extends EntityCat> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.gG();
    }

    @Override
    protected void B() {
        this.cm = new PathfinderGoalTemptChance(this, 0.6, itemstack -> itemstack.a(TagsItem.aj), true);
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(1, new EntityTameableAnimal.a(1.5));
        this.bT.a(2, new PathfinderGoalSit(this));
        this.bT.a(3, new b(this));
        this.bT.a(4, this.cm);
        this.bT.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bT.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.bT.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bT.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bT.a(9, new PathfinderGoalOcelotAttack(this));
        this.bT.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bT.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bT.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bU.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, (PathfinderTargetCondition.a)null));
        this.bU.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bZ));
    }

    public Holder<CatVariant> gA() {
        return this.al.a(cg);
    }

    public void j(Holder<CatVariant> holder) {
        this.al.a(cg, holder);
    }

    public void A(boolean sleeping) {
        this.al.a(ch, sleeping);
    }

    public boolean gB() {
        return this.al.a(ch);
    }

    public void B(boolean headDown) {
        this.al.a(ci, headDown);
    }

    public boolean gH() {
        return this.al.a(ci);
    }

    public EnumColor gC() {
        return EnumColor.a(this.al.a(cj));
    }

    @Override
    public void a(EnumColor color) {
        this.al.a(cj, color.a());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cg, BuiltInRegistries.ai.b(ck));
        builder.a(ch, false);
        builder.a(ci, false);
        builder.a(cj, EnumColor.o.a());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("variant", this.gA().e().orElse(ck).a().toString());
        nbt.a("CollarColor", (byte)this.gC().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        Optional<ResourceKey> optional = Optional.ofNullable(MinecraftKey.c(nbt.l("variant"))).map(minecraftkey -> ResourceKey.a(Registries.l, minecraftkey));
        IRegistry<CatVariant> iregistry = BuiltInRegistries.ai;
        Objects.requireNonNull(iregistry);
        optional.flatMap(iregistry::a).ifPresent(this::j);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
    }

    @Override
    public void a(WorldServer world) {
        if (this.I().b()) {
            double d0 = this.I().c();
            if (d0 == 0.6) {
                this.b(EntityPose.f);
                this.h(false);
            } else if (d0 == 1.33) {
                this.b(EntityPose.a);
                this.h(true);
            } else {
                this.b(EntityPose.a);
                this.h(false);
            }
        } else {
            this.b(EntityPose.a);
            this.h(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return this.p() ? (this.gy() ? SoundEffects.dZ : (this.ae.a(4) == 0 ? SoundEffects.ea : SoundEffects.dS)) : SoundEffects.dT;
    }

    @Override
    public int Q() {
        return 120;
    }

    public void gD() {
        this.b(SoundEffects.dW);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.dY;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.dU;
    }

    public static AttributeProvider.Builder gE() {
        return EntityAnimal.gt().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected void gu() {
        this.a(SoundEffects.dV, 1.0f, 1.0f);
    }

    @Override
    public void h() {
        super.h();
        if (this.cm != null && this.cm.i() && !this.p() && this.af % 100 == 0) {
            this.a(SoundEffects.dX, 1.0f, 1.0f);
        }
        this.gI();
    }

    private void gI() {
        if ((this.gB() || this.gH()) && this.af % 5 == 0) {
            this.a(SoundEffects.dZ, 0.6f + 0.4f * (this.ae.i() - this.ae.i()), 1.0f);
        }
        this.gJ();
        this.gK();
        this.cr = false;
        if (this.gB()) {
            BlockPosition blockposition = this.dw();
            List<EntityHuman> list = this.dW().a(EntityHuman.class, new AxisAlignedBB(blockposition).c(2.0, 2.0, 2.0));
            for (EntityHuman entityhuman : list) {
                if (!entityhuman.fR()) continue;
                this.cr = true;
                break;
            }
        }
    }

    public boolean gF() {
        return this.cr;
    }

    private void gJ() {
        this.co = this.cn;
        this.cq = this.cp;
        if (this.gB()) {
            this.cn = Math.min(1.0f, this.cn + 0.15f);
            this.cp = Math.min(1.0f, this.cp + 0.08f);
        } else {
            this.cn = Math.max(0.0f, this.cn - 0.22f);
            this.cp = Math.max(0.0f, this.cp - 0.13f);
        }
    }

    private void gK() {
        this.ct = this.cs;
        this.cs = this.gH() ? Math.min(1.0f, this.cs + 0.1f) : Math.max(0.0f, this.cs - 0.13f);
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.co, this.cn);
    }

    public float K(float tickDelta) {
        return MathHelper.h(tickDelta, this.cq, this.cp);
    }

    public float L(float tickDelta) {
        return MathHelper.h(tickDelta, this.ct, this.cs);
    }

    @Nullable
    public EntityCat b(WorldServer world, EntityAgeable entity) {
        EntityCat entitycat = EntityTypes.u.a(world, EntitySpawnReason.e);
        if (entitycat != null && entity instanceof EntityCat) {
            EntityCat entitycat1 = (EntityCat)entity;
            if (this.ae.h()) {
                entitycat.j(this.gA());
            } else {
                entitycat.j(entitycat1.gA());
            }
            if (this.p()) {
                entitycat.b(this.ab_());
                entitycat.b(true, true);
                if (this.ae.h()) {
                    entitycat.a(this.gC());
                } else {
                    entitycat.a(entitycat1.gC());
                }
            }
        }
        return entitycat;
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!this.p()) {
            return false;
        }
        if (!(other instanceof EntityCat)) {
            return false;
        }
        EntityCat entitycat = (EntityCat)other;
        return entitycat.p() && super.a(other);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        entityData = super.a(world, difficulty, spawnReason, entityData);
        boolean flag = world.aq() > 0.9f;
        TagKey<CatVariant> tagkey = flag ? CatVariantTags.b : CatVariantTags.a;
        BuiltInRegistries.ai.a(tagkey, world.H_()).ifPresent(this::j);
        WorldServer worldserver = world.a();
        if (worldserver.b().getStructureWithPieceAt(this.dw(), StructureTags.o, world).b()) {
            this.j(BuiltInRegistries.ai.b(CatVariant.l));
            this.ai();
        }
        return entityData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.h();
        if (this.p()) {
            if (this.j(player)) {
                EnumInteractionResult enuminteractionresult2;
                if (item instanceof ItemDye) {
                    ItemDye itemdye = (ItemDye)item;
                    EnumColor enumcolor = itemdye.b();
                    if (enumcolor != this.gC()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.d;
                        }
                        enumcolor = EnumColor.a(event.getColor().getWoolData());
                        if (!this.dW().B_()) {
                            this.a(enumcolor);
                            itemstack.a(1, (EntityLiving)player);
                            this.ai();
                        }
                        return EnumInteractionResult.a;
                    }
                } else if (this.j(itemstack) && this.eE() < this.eS()) {
                    if (!this.dW().B_()) {
                        this.a(player, hand, itemstack);
                        FoodInfo foodinfo = itemstack.a(DataComponents.w);
                        this.heal(foodinfo != null ? (float)foodinfo.a() : 1.0f, EntityRegainHealthEvent.RegainReason.EATING);
                        this.gu();
                    }
                    return EnumInteractionResult.a;
                }
                if (!(enuminteractionresult2 = super.b(player, hand)).a()) {
                    this.z(!this.go());
                    return EnumInteractionResult.a;
                }
                return enuminteractionresult2;
            }
        } else if (this.j(itemstack)) {
            if (!this.dW().B_()) {
                this.a(player, hand, itemstack);
                this.g(player);
                this.ai();
                this.gu();
            }
            return EnumInteractionResult.a;
        }
        if ((enuminteractionresult = super.b(player, hand)).a()) {
            this.ai();
        }
        return enuminteractionresult;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aj);
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.p() && this.af > 2400;
    }

    @Override
    public void b(boolean tamed, boolean updateAttributes) {
        super.b(tamed, updateAttributes);
        this.gG();
    }

    protected void gG() {
        if (this.cl == null) {
            this.cl = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bT.a(this.cl);
        if (!this.p()) {
            this.bT.a(4, this.cl);
        }
    }

    private void g(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.z(true);
            this.dW().a((Entity)this, (byte)7);
        } else {
            this.dW().a((Entity)this, (byte)6);
        }
    }

    @Override
    public boolean ce() {
        return this.ci() || super.ce();
    }

    private static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speed, Predicate<ItemStack> foodPredicate, boolean canBeScared) {
            super(cat, speed, foodPredicate, canBeScared);
            this.d = cat;
        }

        @Override
        public void a() {
            super.a();
            if (this.selectedPlayer == null && this.a.dZ().a(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.dZ().a(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return this.selectedPlayer != null && this.selectedPlayer.equals(this.player) ? false : super.h();
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.p();
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean b() {
            if (!this.a.p()) {
                return false;
            }
            if (this.a.go()) {
                return false;
            }
            EntityLiving entityliving = this.a.ah_();
            if (entityliving instanceof EntityHuman) {
                this.b = (EntityHuman)entityliving;
                if (!entityliving.fR()) {
                    return false;
                }
                if (this.a.g((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockposition = this.b.dw();
                IBlockData iblockdata = this.a.dW().a_(blockposition);
                if (iblockdata.a(TagsBlock.T)) {
                    this.c = iblockdata.d(BlockFacingHorizontal.aF).map(enumdirection -> blockposition.a(enumdirection.g())).orElseGet(() -> new BlockPosition(blockposition));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            EntityCat entitycat;
            List<EntityCat> list = this.a.dW().a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0));
            Iterator<EntityCat> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((entitycat = iterator.next()) == this.a || !entitycat.gB() && !entitycat.gH());
            return true;
        }

        @Override
        public boolean c() {
            return this.a.p() && !this.a.go() && this.b != null && this.b.fR() && this.c != null && !this.h();
        }

        @Override
        public void d() {
            if (this.c != null) {
                this.a.y(false);
                this.a.L().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void e() {
            this.a.A(false);
            float f2 = this.a.dW().f(1.0f);
            if (this.b.gn() >= 100 && (double)f2 > 0.77 && (double)f2 < 0.8 && (double)this.a.dW().H_().i() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.B(false);
            this.a.L().o();
        }

        private void i() {
            RandomSource randomsource = this.a.dZ();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            blockposition_mutableblockposition.g(this.a.P_() ? this.a.A().dw() : this.a.dw());
            this.a.b(blockposition_mutableblockposition.u() + randomsource.a(11) - 5, blockposition_mutableblockposition.v() + randomsource.a(5) - 2, blockposition_mutableblockposition.w() + randomsource.a(11) - 5, false);
            blockposition_mutableblockposition.g(this.a.dw());
            this.a.a(net.minecraft.world.entity.animal.EntityCat$b.a(this.a), LootTables.aq, (worldserver, itemstack) -> {
                EntityItem entityitem = new EntityItem((World)worldserver, (double)blockposition_mutableblockposition.u() - (double)MathHelper.a(this.a.aX * ((float)Math.PI / 180)), blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + (double)MathHelper.b(this.a.aX * ((float)Math.PI / 180)), (ItemStack)itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
                entityitem.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                worldserver.b(entityitem);
            });
        }

        @Override
        public void a() {
            if (this.b != null && this.c != null) {
                this.a.y(false);
                this.a.L().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.g((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.A(true);
                        this.a.B(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.B(true);
                    }
                } else {
                    this.a.A(false);
                }
            }
        }
    }

    private static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super(cat, fleeFromType, distance, slowSpeed, fastSpeed, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean b() {
            return !this.i.p() && super.b();
        }

        @Override
        public boolean c() {
            return !this.i.p() && super.c();
        }
    }
}

