/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize ch = EntityTypes.z.n().a(0.5f).b(0.2975f);
    public float bZ;
    public float ca;
    public float cb;
    public float cd;
    public float ce = 1.0f;
    private float ci = 1.0f;
    public int cf = this.ae.a(6000) + 6000;
    public boolean cg;

    public EntityChicken(EntityTypes<? extends EntityChicken> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void B() {
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalPanic(this, 1.4));
        this.bT.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(3, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.a(TagsItem.ap), false));
        this.bT.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bT.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ch : super.e(pose);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.cd = this.bZ;
        this.cb = this.ca;
        this.ca += (this.aJ() ? -1.0f : 4.0f) * 0.3f;
        this.ca = MathHelper.a(this.ca, 0.0f, 1.0f);
        if (!this.aJ() && this.ce < 1.0f) {
            this.ce = 1.0f;
        }
        this.ce *= 0.9f;
        Vec3D vec3d = this.dz();
        if (!this.aJ() && vec3d.e < 0.0) {
            this.h(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bZ += this.ce * 2.0f;
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bL() && !this.e_() && !this.t() && --this.cf <= 0) {
                this.forceDrops = true;
                if (this.a(worldserver, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eV, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.t);
                }
                this.forceDrops = false;
                this.cf = this.ae.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean ba() {
        return this.Y > this.ci;
    }

    @Override
    protected void aZ() {
        this.ci = this.Y + this.ca / 2.0f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.eT;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.eW;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.eU;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.eX, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.z.a(world, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ap);
    }

    @Override
    protected int e(WorldServer world) {
        return this.t() ? 10 : super.e(world);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cg = nbt.q("IsChickenJockey");
        if (nbt.e("EggLayTime")) {
            this.cf = nbt.h("EggLayTime");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsChickenJockey", this.cg);
        nbt.a("EggLayTime", this.cf);
    }

    @Override
    public boolean h(double distanceSquared) {
        return this.t();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aX = this.aX;
        }
    }

    public boolean t() {
        return this.cg;
    }

    public void x(boolean hasJockey) {
        this.cg = hasJockey;
    }
}

