/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> ce = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cf = 1;
    public static final int bZ = 4;
    public static final int ca = 8;
    public static final int cb = 16;
    private static final int cg = 32;
    private static final int ch = 64;
    private static final int ci = 128;
    public static final DataWatcherObject<Optional<UUID>> cj = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<UUID>> ck = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> cl = entityitem -> !entityitem.v() && entityitem.bL();
    private static final Predicate<Entity> cm = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.es() != null && entityliving.et() < entityliving.af + 600;
    };
    static final Predicate<Entity> cn = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> co = entity -> !entity.cg() && IEntitySelector.e.test((Entity)entity);
    private static final int cp = 600;
    private static final EntitySize cq = EntityTypes.ab.n().a(0.5f).b(0.2975f);
    private PathfinderGoal cr;
    private PathfinderGoal cs;
    private PathfinderGoal ct;
    private float cu;
    private float cv;
    float cw;
    float cx;
    private int cy;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bP = new k();
        this.bQ = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
        this.L().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cj, Optional.empty());
        builder.a(ck, Optional.empty());
        builder.a(cd, 0);
        builder.a(ce, (byte)0);
    }

    @Override
    protected void B() {
        this.cr = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entityliving, worldserver) -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cs = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bZ);
        this.ct = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entityliving, worldserver) -> entityliving instanceof EntityFishSchool);
        this.bT.a(0, new g());
        this.bT.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dW()));
        this.bT.a(1, new b());
        this.bT.a(2, new n(2.2));
        this.bT.a(3, new e(this, this, 1.0));
        this.bT.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> co.test((Entity)entityliving) && !this.c(entityliving.cG()) && !this.gC()));
        this.bT.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).p() && !this.gC()));
        this.bT.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gC()));
        this.bT.a(5, new u());
        this.bT.a(6, new o());
        this.bT.a(6, new s(1.25));
        this.bT.a(7, new l((double)1.2f, true));
        this.bT.a(7, new t());
        this.bT.a(8, new h(this, this, this, 1.25));
        this.bT.a(9, new q(32, 200));
        this.bT.a(10, new f((double)1.2f, 12, 1));
        this.bT.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bT.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(11, new p());
        this.bT.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bT.a(13, new r());
        this.bU.a(3, new a(EntityLiving.class, false, false, (entityliving, worldserver) -> cm.test(entityliving) && !this.c(entityliving.cG())));
    }

    @Override
    public void d_() {
        if (!this.dW().C && this.bL() && this.dk()) {
            EntityLiving entityliving;
            ++this.cy;
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (this.i(itemstack)) {
                if (this.cy > 600) {
                    ItemStack itemstack1 = itemstack.a(this.dW(), (EntityLiving)this);
                    if (!itemstack1.f()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cy = 0;
                } else if (this.cy > 560 && this.ae.i() < 0.1f) {
                    this.gu();
                    this.dW().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.O_()) == null || !entityliving.bL()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.fR() || this.fi()) {
            this.bn = false;
            this.bo = 0.0f;
            this.bq = 0.0f;
        }
        super.d_();
        if (this.gC() && this.ae.i() < 0.05f) {
            this.a(SoundEffects.jz, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fi() {
        return this.eF();
    }

    private boolean i(ItemStack stack) {
        return stack.b(DataComponents.w) && this.O_() == null && this.aJ() && !this.fR();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.2f) {
            float f2 = random.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.oW) : (f2 < 0.2f ? new ItemStack(Items.rp) : (f2 < 0.4f ? (random.h() ? new ItemStack(Items.vt) : new ItemStack(Items.vu)) : (f2 < 0.6f ? new ItemStack(Items.pS) : (f2 < 0.8f ? new ItemStack(Items.rb) : new ItemStack(Items.pP)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (!itemstack.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dO() * ((float)Math.PI / 180)).b(-this.dM() * ((float)Math.PI / 180));
                    this.dW().a(new ParticleParamItem(Particles.S, itemstack), this.dB() + this.bT().d / 2.0, this.dD(), this.dH() + this.bT().f / 2.0, vec3d.d, vec3d.e + 0.05, vec3d.f);
                }
            }
        } else {
            super.b(status);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.x, 5.0).a(GenericAttributes.m, 32.0);
    }

    @Nullable
    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.ab.a(world, EntitySpawnReason.e);
        if (entityfox != null) {
            entityfox.a(this.ae.h() ? this.t() : ((EntityFox)entity).t());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cg) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        Holder<BiomeBase> holder = world.t(this.dw());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (entityData instanceof i) {
            i entityfox_i = (i)entityData;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (world instanceof WorldServer) {
            this.gA();
        }
        this.a(world.H_(), difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    private void gA() {
        if (this.t() == Type.a) {
            this.bU.a(4, this.cr);
            this.bU.a(4, this.cs);
            this.bU.a(6, this.ct);
        } else {
            this.bU.a(4, this.ct);
            this.bU.a(6, this.cr);
            this.bU.a(6, this.cs);
        }
    }

    @Override
    protected void gu() {
        this.a(SoundEffects.jD, 1.0f, 1.0f);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cq : super.e(pose);
    }

    public Type t() {
        return Type.a(this.al.a(cd));
    }

    @Override
    public void a(Type variant) {
        this.al.a(cd, variant.a());
    }

    List<UUID> gB() {
        Optional<UUID> optional = this.al.a(cj);
        Optional<UUID> optional1 = this.al.a(ck);
        return optional.isPresent() && optional1.isPresent() ? List.of(optional.get(), optional1.get()) : (optional.isPresent() ? List.of(optional.get()) : (optional1.isPresent() ? List.of(optional1.get()) : List.of()));
    }

    void b(@Nullable UUID uuid) {
        if (this.al.a(cj).isPresent()) {
            this.al.a(ck, Optional.ofNullable(uuid));
        } else {
            this.al.a(cj, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.gB();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fR());
        nbt.a("Type", this.t().c());
        nbt.a("Sitting", this.x());
        nbt.a("Crouching", this.ci());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (NBTBase nbtbase : nbttaglist) {
            this.b(GameProfileSerializer.a(nbtbase));
        }
        this.D(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.setSitting(nbt.q("Sitting"), false);
        this.z(nbt.q("Crouching"));
        if (this.dW() instanceof WorldServer) {
            this.gA();
        }
    }

    public boolean x() {
        return this.s(1);
    }

    public void x(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean go() {
        return this.s(64);
    }

    public void B(boolean walking) {
        this.d(64, walking);
    }

    public boolean gC() {
        return this.s(128);
    }

    public void C(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fR() {
        return this.s(32);
    }

    public void D(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.al.a(ce, (byte)(this.al.a(ce) | mask));
        } else {
            this.al.a(ce, (byte)(this.al.a(ce) & ~mask));
        }
    }

    private boolean s(int bitmask) {
        return (this.al.a(ce) & bitmask) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.fN();
    }

    @Override
    public boolean g(ItemStack stack) {
        ItemStack itemstack1 = this.a(EnumItemSlot.a);
        return itemstack1.f() || this.cy > 0 && stack.b(DataComponents.w) && !itemstack1.b(DataComponents.w);
    }

    private void k(ItemStack stack) {
        if (!stack.f() && !this.dW().C) {
            EntityItem entityitem = new EntityItem(this.dW(), this.dB() + this.bT().d, this.dD() + 1.0, this.dH() + this.bT().f, stack);
            entityitem.b(40);
            entityitem.b((Entity)this);
            this.a(SoundEffects.jI, 1.0f, 1.0f);
            this.spawnAtLocation((WorldServer)this.dW(), entityitem);
        }
    }

    private void l(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.dW(), this.dB(), this.dD(), this.dH(), stack);
        this.spawnAtLocation((WorldServer)this.dW(), entityitem);
    }

    @Override
    protected void a(WorldServer world, EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.l();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, itemEntity, itemstack.L() - 1, !this.g(itemstack)).isCancelled()) {
            itemstack = itemEntity.l();
            int i2 = itemstack.L();
            if (i2 > 1) {
                this.l(itemstack.a(i2 - 1));
            }
            this.k(this.a(EnumItemSlot.a));
            this.a(itemEntity);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)itemEntity, itemstack.L());
            itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cy = 0;
        }
    }

    @Override
    public void h() {
        super.h();
        if (this.dk()) {
            boolean flag = this.bj();
            if (flag || this.O_() != null || this.dW().ae()) {
                this.gD();
            }
            if (flag || this.fR()) {
                this.x(false);
            }
            if (this.go() && this.dW().A.i() < 0.2f) {
                BlockPosition blockposition = this.dw();
                IBlockData iblockdata = this.dW().a_(blockposition);
                this.dW().c(2001, blockposition, Block.j(iblockdata));
            }
        }
        this.cv = this.cu;
        this.cu = this.gs() ? (this.cu += (1.0f - this.cu) * 0.4f) : (this.cu += (0.0f - this.cu) * 0.4f);
        this.cx = this.cw;
        if (this.ci()) {
            this.cw += 0.2f;
            if (this.cw > 3.0f) {
                this.cw = 3.0f;
            }
        } else {
            this.cw = 0.0f;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ae);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cG());
    }

    public boolean gp() {
        return this.s(16);
    }

    public void y(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean gq() {
        return this.bn;
    }

    public boolean gr() {
        return this.cw == 3.0f;
    }

    public void z(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean ci() {
        return this.s(4);
    }

    public void A(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean gs() {
        return this.s(8);
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.cv, this.cu) * 0.11f * (float)Math.PI;
    }

    public float K(float tickDelta) {
        return MathHelper.h(tickDelta, this.cx, this.cw);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (this.gC() && target == null) {
            this.C(false);
        }
        super.h(target);
    }

    void gD() {
        this.D(false);
    }

    void gE() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean gF() {
        return !this.fR() && !this.x() && !this.go();
    }

    @Override
    public void R() {
        SoundEffect soundeffect = this.u();
        if (soundeffect == SoundEffects.jF) {
            this.a(soundeffect, 2.0f, this.fh());
        } else {
            super.R();
        }
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        List<Entity> list;
        if (this.fR()) {
            return SoundEffects.jG;
        }
        if (!this.dW().U() && this.ae.i() < 0.1f && (list = this.dW().a(EntityHuman.class, this.cR().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.jF;
        }
        return SoundEffects.jA;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.jE;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.jC;
    }

    boolean c(UUID uuid) {
        return this.gB().contains(uuid);
    }

    @Override
    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return slot == EnumItemSlot.a;
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer world, DamageSource damageSource) {
        EntityDeathEvent deathEvent;
        ItemStack itemstack = this.a(EnumItemSlot.a);
        boolean releaseMouth = false;
        if (!itemstack.f() && world.N().b(GameRules.f)) {
            this.a(world, itemstack);
            releaseMouth = true;
        }
        if ((deathEvent = super.dropAllDeathLoot(world, damageSource)) == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (releaseMouth) {
            this.a(EnumItemSlot.a, ItemStack.j);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.dH() - fox.dH();
        double d1 = chasedEntity.dB() - fox.dB();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.dW().a_(BlockPosition.a(fox.dB() + d4, fox.dD() + (double)j2, fox.dH() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.55f * this.cS(), this.dr() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fR()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gp() && !EntityFox.this.ci() && !EntityFox.this.gs() && !EntityFox.this.go();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gF()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gE();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bj() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bx();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.go();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gC() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, EntityFox chance, double fox) {
            super(chance, fox);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gE();
            ((EntityFox)this.c).gE();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer worldserver = this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gx();
                EntityPlayer entityplayer1 = this.c.gx();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cG());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cG());
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dB(), this.a.dD(), this.a.dH(), 0.0f, 0.0f);
                int experience = this.a.dZ().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.p.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gz();
                this.c.gz();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (worldserver.N().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dB(), this.a.dD(), this.a.dH(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.fR()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.O_();
            return entityliving != null && entityliving.bL() && cn.test(entityliving) && EntityFox.this.g((Entity)entityliving) > 36.0 && !EntityFox.this.ci() && !EntityFox.this.gs() && !EntityFox.this.bn;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.L().o();
                EntityFox.this.H().a(entityliving, (float)EntityFox.this.aa(), (float)EntityFox.this.Z());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null) {
                EntityFox.this.H().a(entityliving, (float)EntityFox.this.aa(), (float)EntityFox.this.Z());
                if (EntityFox.this.g((Entity)entityliving) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.L().o();
                } else {
                    EntityFox.this.L().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gr()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null && entityliving.bL()) {
                if (entityliving.cP() != entityliving.cO()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.L().a((Entity)entityliving, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null && entityliving.bL()) {
                double d0 = EntityFox.this.dz().e;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dO()) >= 15.0f || !EntityFox.this.aJ()) && !EntityFox.this.go();
            }
            return false;
        }

        @Override
        public boolean U_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null) {
                EntityFox.this.H().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dB() - EntityFox.this.dB(), entityliving.dD() - EntityFox.this.dD(), entityliving.dH() - EntityFox.this.dH()).d();
                EntityFox.this.h(EntityFox.this.dz().b(vec3d.d * 0.8, 0.9, vec3d.f * 0.8));
            }
            EntityFox.this.L().o();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cw = 0.0f;
            EntityFox.this.cx = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.O_();
            if (entityliving != null) {
                EntityFox.this.H().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.go()) {
                Vec3D vec3d = EntityFox.this.dz();
                if (vec3d.e * vec3d.e < (double)0.03f && EntityFox.this.dO() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.dO(), 0.0f));
                } else {
                    double d0 = vec3d.i();
                    double d1 = Math.signum(-vec3d.e) * Math.acos(d0 / vec3d.g()) * 57.2957763671875;
                    EntityFox.this.w((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.f((Entity)entityliving) <= 2.0f) {
                EntityFox.this.c(net.minecraft.world.entity.animal.EntityFox$o.a(EntityFox.this.dW()), (Entity)entityliving);
            } else if (EntityFox.this.dO() > 0.0f && EntityFox.this.aJ() && (float)EntityFox.this.dz().e != 0.0f && EntityFox.this.dW().a_(EntityFox.this.dw()).a(Blocks.ea)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.fR() && this.a.O_() == null) {
                if (EntityFox.this.dW().ae() && EntityFox.this.dW().h(this.a.dw())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dw();
                return EntityFox.this.dW().U() && EntityFox.this.dW().h(blockposition) && !((WorldServer)EntityFox.this.dW()).c(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gE();
            super.d();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityFox$l.a(this.a), (Entity)target);
                EntityFox.this.a(SoundEffects.jB, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.x() && !EntityFox.this.fR() && !EntityFox.this.ci() && !EntityFox.this.go() && super.b();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ae.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bo == 0.0f && EntityFox.this.bp == 0.0f && EntityFox.this.bq == 0.0f ? this.k() || EntityFox.this.fR() : false;
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dW().U() && this.h() && !this.i() && !EntityFox.this.av;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.ae.a(c);
            EntityFox.this.gE();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.L().o();
            EntityFox.this.I().a(EntityFox.this.dB(), EntityFox.this.dD(), EntityFox.this.dH(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox entityFox, EntityFox fox, EntityFox speed, double d0) {
            super(speed, d0);
            this.d = speed;
        }

        @Override
        public boolean b() {
            return !this.d.gC() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gC() && super.c();
        }

        @Override
        public void d() {
            this.d.gE();
            super.d();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void d() {
            EntityFox.this.gE();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fR() && !EntityFox.this.x() && !EntityFox.this.gC() && EntityFox.this.O_() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.oD) && iblockdata.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(iblockdata);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ae.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.jH, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (f.a(EntityFox.this.dW()).N().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.dW().a_(this.e);
                if (iblockdata.a(Blocks.oD)) {
                    this.b(iblockdata);
                } else if (CaveVines.j_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.dW(), this.e);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.c);
            state.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.dW().A.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.xl));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.dW(), this.e, new ItemStack(Items.xl, j2));
            }
            EntityFox.this.a(SoundEffects.zR, 1.0f, 1.0f);
            EntityFox.this.dW().a(this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.dW().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.fR() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.O_() == null && EntityFox.this.eq() == null) {
                if (!EntityFox.this.gF()) {
                    return false;
                }
                if (EntityFox.this.dZ().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.dW().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), cl);
                return !list.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
            }
            return false;
        }

        @Override
        public void a() {
            List<EntityItem> list = EntityFox.this.dW().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), cl);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f() && !list.isEmpty()) {
                EntityFox.this.L().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> list = EntityFox.this.dW().a(EntityItem.class, EntityFox.this.cR().c(8.0, 8.0, 8.0), cl);
            if (!list.isEmpty()) {
                EntityFox.this.L().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.go() && !EntityFox.this.gs();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.go() && !EntityFox.this.gs();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.eq() == null && EntityFox.this.dZ().i() < 0.02f && !EntityFox.this.fR() && EntityFox.this.O_() == null && EntityFox.this.L().m() && !this.i() && !EntityFox.this.gp() && !EntityFox.this.ci();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.dZ().a(3);
            EntityFox.this.x(true);
            EntityFox.this.L().o();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.H().a(EntityFox.this.dB() + this.c, EntityFox.this.dF(), EntityFox.this.dH() + this.d, EntityFox.this.aa(), EntityFox.this.Z());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.dZ().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.dZ().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(EntityFox.this, oclass, 10, flag, flag1, pathfindertargetcondition_a);
        }

        @Override
        public boolean b() {
            EntityLiving entityliving;
            UUID uuid;
            Entity entity;
            if (this.b > 0 && this.e.dZ().a(this.b) != 0) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.animal.EntityFox$a.a(EntityFox.this.dW());
            Iterator<UUID> iterator = EntityFox.this.gB().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((entity = worldserver.a(uuid = iterator.next())) instanceof EntityLiving));
            this.k = entityliving = (EntityLiving)entity;
            this.j = entityliving.eq();
            int i2 = entityliving.er();
            return i2 != this.l && this.a(this.j, this.d);
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.er();
            }
            EntityFox.this.a(SoundEffects.jz, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.gD();
            super.d();
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String name) {
            return c.a(name, a);
        }

        public static Type a(int id) {
            return d.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.ar) ? b : a;
        }

        static {
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving target, WorldServer world) {
            return target instanceof EntityFox ? false : (!(target instanceof EntityChicken || target instanceof EntityRabbit || target instanceof EntityMonster) ? (target instanceof EntityTameableAnimal ? !((EntityTameableAnimal)target).p() : (target instanceof EntityHuman && (target.aa_() || ((EntityHuman)target).b()) ? false : (EntityFox.this.c(target.cG()) ? false : !target.fR() && !target.cg()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dB(), EntityFox.this.cR().e, EntityFox.this.dH());
            return !EntityFox.this.dW().h(blockposition) && EntityFox.this.c(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.EntityFox$d.a(EntityFox.this.dW()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cR().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

