/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private int bZ;
    private int ca;
    private static final UniformInt cb = TimeRange.a(20, 39);
    private int cc;
    @Nullable
    private UUID cd;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bT.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.bT.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.bT.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.bT.a(5, new PathfinderGoalOfferFlower(this));
        this.bT.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalDefendVillage(this));
        this.bU.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (entityliving, worldserver) -> entityliving instanceof IMonster && !(entityliving instanceof EntityCreeper)));
        this.bU.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.C().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.p, 1.0).a(GenericAttributes.c, 15.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected int l(int air) {
        return air;
    }

    @Override
    protected void D(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.dZ().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION, true);
        }
        super.D(entity);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bZ > 0) {
            --this.bZ;
        }
        if (this.ca > 0) {
            --this.ca;
        }
        if (!this.dW().C) {
            this.a((WorldServer)this.dW(), true);
        }
    }

    @Override
    public boolean bv() {
        return this.dz().j() > 2.500000277905201E-7 && this.ae.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return this.go() && type == EntityTypes.bS ? false : (type == EntityTypes.F ? false : super.a(type));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("PlayerCreated", this.go());
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.y(nbt.q("PlayerCreated"));
        this.a(this.dW(), nbt);
    }

    @Override
    public void c() {
        this.a(cb.a(this.ae));
    }

    @Override
    public void a(int angerTime) {
        this.cc = angerTime;
    }

    @Override
    public int a() {
        return this.cc;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cd = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cd;
    }

    private float gp() {
        return (float)this.h(GenericAttributes.c);
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        this.bZ = 10;
        world.a((Entity)this, (byte)4);
        float f2 = this.gp();
        float f1 = (int)f2 > 0 ? f2 / 2.0f + (float)this.ae.a((int)f2) : f2;
        DamageSource damagesource = this.dX().b(this);
        boolean flag = target.a(world, damagesource, f1);
        if (flag) {
            double d0;
            if (target instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)target;
                d0 = entityliving.h(GenericAttributes.p);
            } else {
                d0 = 0.0;
            }
            double d1 = d0;
            double d2 = Math.max(0.0, 1.0 - d1);
            target.h(target.dz().b(0.0, (double)0.4f * d2, 0.0));
            EnchantmentManager.a(world, target, damagesource);
        }
        this.a(SoundEffects.nG, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        Crackiness.a crackiness_a = this.p();
        boolean flag = super.a(world, source, amount);
        if (flag && this.p() != crackiness_a) {
            this.a(SoundEffects.nH, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a p() {
        return Crackiness.a.a(this.eE() / this.eS());
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.bZ = 10;
            this.a(SoundEffects.nG, 1.0f, 1.0f);
        } else if (status == 11) {
            this.ca = 400;
        } else if (status == 34) {
            this.ca = 0;
        } else {
            super.b(status);
        }
    }

    public int t() {
        return this.bZ;
    }

    public void x(boolean lookingAtVillager) {
        if (lookingAtVillager) {
            this.ca = 400;
            this.dW().a((Entity)this, (byte)11);
        } else {
            this.ca = 0;
            this.dW().a((Entity)this, (byte)34);
        }
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.nJ;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.nI;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.pb)) {
            return EnumInteractionResult.e;
        }
        float f2 = this.eE();
        this.c(25.0f);
        if (this.eE() == f2) {
            return EnumInteractionResult.e;
        }
        float f1 = 1.0f + (this.ae.i() - this.ae.i()) * 0.2f;
        this.a(SoundEffects.nK, 1.0f, f1);
        itemstack.a(1, (EntityLiving)player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.nL, 1.0f, 1.0f);
    }

    public int x() {
        return this.ca;
    }

    public boolean go() {
        return (this.al.a(c) & 1) != 0;
    }

    public void y(boolean playerCreated) {
        byte b0 = this.al.a(c);
        if (playerCreated) {
            this.al.a(c, (byte)(b0 | 1));
        } else {
            this.al.a(c, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
    }

    @Override
    public boolean a(IWorldReader world) {
        BlockPosition blockposition = this.dw();
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!iblockdata.a((IBlockAccess)world, blockposition1, (Entity)this) && !this.dW().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData iblockdata1;
            BlockPosition blockposition2 = blockposition.b(i2);
            if (SpawnerCreature.a(world, blockposition2, iblockdata1 = world.a_(blockposition2), iblockdata1.y(), EntityTypes.aq)) continue;
            return false;
        }
        return SpawnerCreature.a(world, blockposition, world.a_(blockposition), FluidTypes.a.g(), EntityTypes.aq) && world.f(this);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.875f * this.cS(), this.dr() * 0.4f);
    }
}

