/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> bZ = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.e);
    private static final int ca = 1024;
    private static final String cb = "stew_effects";
    @Nullable
    public SuspiciousStewEffects cd;
    @Nullable
    private UUID ce;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> type, World world) {
        super((EntityTypes<? extends EntityCow>)type, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.e()).a(Blocks.fz) ? 10.0f : world.w(pos);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cc) && EntityMushroomCow.a(world, pos);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        UUID uuid = lightning.cG();
        if (!uuid.equals(this.ce)) {
            this.a(this.t() == Type.a ? Type.b : Type.a);
            this.ce = uuid;
            this.a(SoundEffects.pg, 2.0f, 1.0f);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, Type.a.d);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.oP) && !this.e_()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.cd != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.wM);
                itemstack1.b(DataComponents.R, this.cd);
                this.cd = null;
            } else {
                itemstack1 = new ItemStack(Items.pN);
            }
            ItemStack itemstack2 = ItemLiquidUtil.a(itemstack, player, itemstack1, false);
            player.a(hand, itemstack2);
            SoundEffect soundeffect = flag ? SoundEffects.pj : SoundEffects.pi;
            this.a(soundeffect, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        if (itemstack.a(Items.sJ) && this.a()) {
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(worldserver, itemstack);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(worldserver, SoundCategory.h, itemstack, drops);
                this.a(GameEvent.M, (Entity)player);
                itemstack.a(1, (EntityLiving)player, EntityMushroomCow.d(hand));
            }
            return EnumInteractionResult.a;
        }
        if (this.t() == Type.b && itemstack.a(TagsItem.P)) {
            if (this.cd != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.dW().a(Particles.af, this.dB() + this.ae.j() / 2.0, this.e(0.5), this.dH() + this.ae.j() / 2.0, 0.0, this.ae.j() / 5.0, 0.0);
                }
            } else {
                Optional<SuspiciousStewEffects> optional = this.i(itemstack);
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
                itemstack.a(1, (EntityLiving)player);
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.dW().a(Particles.p, this.dB() + this.ae.j() / 2.0, this.e(0.5), this.dH() + this.ae.j() / 2.0, 0.0, this.ae.j() / 5.0, 0.0);
                }
                this.cd = optional.get();
                this.a(SoundEffects.ph, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears) {
        this.shear(world, shearedSoundCategory, shears, this.generateDefaultDrops(world, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aR, shears, (arg_0, arg_1) -> EntityMushroomCow.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears, List<ItemStack> drops) {
        world.a((EntityHuman)null, this, SoundEffects.pk, shearedSoundCategory, 1.0f, 1.0f);
        this.convertTo(EntityTypes.C, ConversionParams.a(this, false, false), (T entitycow) -> {
            world.a(Particles.w, this.dB(), this.e(0.5), this.dH(), 1, 0.0, 0.0, 0.0, 0.0);
            drops.forEach(drop -> {
                EntityItem entityitem = new EntityItem(this.dW(), this.dB(), this.e(1.0), this.dH(), (ItemStack)drop);
                this.spawnAtLocation(world, entityitem);
            });
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean a() {
        return this.bL() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Type", this.t().c());
        if (this.cd != null) {
            SuspiciousStewEffects.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cd).ifSuccess(nbtbase -> nbt.a(cb, (NBTBase)nbtbase));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Type.a(nbt.l("Type")));
        if (nbt.b(cb, 9)) {
            SuspiciousStewEffects.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(cb)).ifSuccess(suspicioussteweffects -> {
                this.cd = suspicioussteweffects;
            });
        }
    }

    private Optional<SuspiciousStewEffects> i(ItemStack flower) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.a(flower.h());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.b()) : Optional.empty();
    }

    @Override
    public void a(Type variant) {
        this.al.a(bZ, variant.d);
    }

    public Type t() {
        return Type.a(this.al.a(bZ));
    }

    @Nullable
    public EntityMushroomCow c(WorldServer world, EntityAgeable entity) {
        EntityMushroomCow entitymushroomcow = EntityTypes.aF.a(world, EntitySpawnReason.e);
        if (entitymushroomcow != null) {
            entitymushroomcow.a(this.a((EntityMushroomCow)entity));
        }
        return entitymushroomcow;
    }

    private Type a(EntityMushroomCow mooshroom) {
        Type entitymushroomcow_type1;
        Type entitymushroomcow_type = this.t();
        Type entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = mooshroom.t()) && this.ae.a(1024) == 0 ? (entitymushroomcow_type == Type.b ? Type.a : Type.b) : (this.ae.h() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.L(); ++i2) {
            drops.add(stack.c(1));
        }
    }

    public static enum Type implements INamable
    {
        a("red", Blocks.cn.m()),
        b("brown", Blocks.cm.m());

        public static final INamable.a<Type> c;
        final String d;
        private final IBlockData e;

        private Type(String s2, IBlockData iblockdata) {
            this.d = s2;
            this.e = iblockdata;
        }

        public IBlockData a() {
            return this.e;
        }

        @Override
        public String c() {
            return this.d;
        }

        static Type a(String name) {
            return c.a(name, a);
        }

        static {
            c = INamable.a(Type::values);
        }
    }
}

