/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements VariantHolder<Variant>,
EntityBird {
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> ci = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && cj.containsKey(entityinsentient.aq());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cj = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.o, SoundEffects.td);
        hashmap.put(EntityTypes.q, SoundEffects.te);
        hashmap.put(EntityTypes.r, SoundEffects.tf);
        hashmap.put(EntityTypes.v, SoundEffects.tC);
        hashmap.put(EntityTypes.F, SoundEffects.th);
        hashmap.put(EntityTypes.L, SoundEffects.ti);
        hashmap.put(EntityTypes.N, SoundEffects.tj);
        hashmap.put(EntityTypes.Q, SoundEffects.tk);
        hashmap.put(EntityTypes.P, SoundEffects.tl);
        hashmap.put(EntityTypes.T, SoundEffects.tm);
        hashmap.put(EntityTypes.ae, SoundEffects.tn);
        hashmap.put(EntityTypes.aj, SoundEffects.to);
        hashmap.put(EntityTypes.ak, SoundEffects.tp);
        hashmap.put(EntityTypes.an, SoundEffects.tq);
        hashmap.put(EntityTypes.ao, SoundEffects.tr);
        hashmap.put(EntityTypes.aA, SoundEffects.ts);
        hashmap.put(EntityTypes.aQ, SoundEffects.tt);
        hashmap.put(EntityTypes.aS, SoundEffects.tu);
        hashmap.put(EntityTypes.aT, SoundEffects.tv);
        hashmap.put(EntityTypes.aU, SoundEffects.tw);
        hashmap.put(EntityTypes.aZ, SoundEffects.tx);
        hashmap.put(EntityTypes.bc, SoundEffects.ty);
        hashmap.put(EntityTypes.be, SoundEffects.tz);
        hashmap.put(EntityTypes.bf, SoundEffects.tA);
        hashmap.put(EntityTypes.bh, SoundEffects.tB);
        hashmap.put(EntityTypes.bo, SoundEffects.tC);
        hashmap.put(EntityTypes.bs, SoundEffects.tD);
        hashmap.put(EntityTypes.bC, SoundEffects.tE);
        hashmap.put(EntityTypes.bE, SoundEffects.tF);
        hashmap.put(EntityTypes.bG, SoundEffects.tG);
        hashmap.put(EntityTypes.bI, SoundEffects.tH);
        hashmap.put(EntityTypes.bJ, SoundEffects.tI);
        hashmap.put(EntityTypes.bK, SoundEffects.tJ);
        hashmap.put(EntityTypes.bN, SoundEffects.tK);
        hashmap.put(EntityTypes.D, SoundEffects.tg);
        hashmap.put(EntityTypes.E, SoundEffects.tg);
        hashmap.put(EntityTypes.bO, SoundEffects.tL);
        hashmap.put(EntityTypes.bQ, SoundEffects.tM);
    });
    public float cd;
    public float ce;
    public float cf;
    public float cg;
    private float ck = 1.0f;
    private float cl = 1.0f;
    private boolean cm;
    @Nullable
    private BlockPosition cn;

    public EntityParrot(EntityTypes<? extends EntityParrot> type, World world) {
        super((EntityTypes<? extends EntityPerchable>)type, world);
        this.bQ = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.a((Variant)SystemUtils.a((Object[])Variant.values(), world.H_()));
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void B() {
        this.bT.a(0, new EntityTameableAnimal.a(1.25));
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(2, new PathfinderGoalSit(this));
        this.bT.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.bT.a(2, new a(this, 1.0));
        this.bT.a(3, new PathfinderGoalPerch(this));
        this.bT.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gA() {
        return EntityAnimal.gt().a(GenericAttributes.s, 6.0).a(GenericAttributes.l, 0.4f).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    public void d_() {
        if (this.cn == null || !this.cn.a(this.du(), 3.46) || !this.dW().a_(this.cn).a(Blocks.eg)) {
            this.cm = false;
            this.cn = null;
        }
        if (this.dW().A.a(400) == 0) {
            EntityParrot.a(this.dW(), this);
        }
        super.d_();
        this.gF();
    }

    @Override
    public void a(BlockPosition songPosition, boolean playing) {
        this.cn = songPosition;
        this.cm = playing;
    }

    public boolean gB() {
        return this.cm;
    }

    private void gF() {
        this.cg = this.cd;
        this.cf = this.ce;
        this.ce += (float)(!this.aJ() && !this.bZ() ? 4 : -1) * 0.3f;
        this.ce = MathHelper.a(this.ce, 0.0f, 1.0f);
        if (!this.aJ() && this.ck < 1.0f) {
            this.ck = 1.0f;
        }
        this.ck *= 0.9f;
        Vec3D vec3d = this.dz();
        if (!this.aJ() && vec3d.e < 0.0) {
            this.h(vec3d.d(1.0, 0.6, 1.0));
        }
        this.cd += this.ck * 2.0f;
    }

    public static boolean a(World world, Entity parrot) {
        if (parrot.bL() && !parrot.bb() && world.A.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, parrot.cR().g(20.0), ci);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.A.a(list.size()))).bb()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.aq());
                world.a((EntityHuman)null, parrot.dB(), parrot.dD(), parrot.dH(), soundeffect, parrot.dn(), 0.7f, EntityParrot.a(world.A));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!this.p() && itemstack.a(TagsItem.aC)) {
            this.a(player, hand, itemstack);
            if (!this.bb()) {
                this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.ta, this.dn(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
            }
            if (!this.dW().C) {
                if (this.ae.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.a(player);
                    this.dW().a((Entity)this, (byte)7);
                } else {
                    this.dW().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemstack.a(TagsItem.aD)) {
            if (!this.gD() && this.p() && this.j(player)) {
                if (!this.dW().C) {
                    this.z(!this.go());
                }
                return EnumInteractionResult.a;
            }
            return super.b(player, hand);
        }
        this.a(player, hand, itemstack);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (player.b() || !this.cC()) {
            this.a(this.dX().a(player), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean j(ItemStack stack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cd) && EntityParrot.a(world, pos);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect u() {
        return EntityParrot.a(this.dW(), this.dW().A);
    }

    public static SoundEffect a(World world, RandomSource random) {
        if (world.al() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cj.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.sY;
    }

    private static SoundEffect b(EntityTypes<?> imitate) {
        return cj.getOrDefault(imitate, SoundEffects.sY);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.tc;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.sZ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tN, 0.15f, 1.0f);
    }

    @Override
    protected boolean ba() {
        return this.Y > this.cl;
    }

    @Override
    protected void aZ() {
        this.a(SoundEffects.tb, 0.15f, 1.0f);
        this.cl = this.Y + this.ce / 2.0f;
    }

    @Override
    public float fh() {
        return EntityParrot.a(this.ae);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void D(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.D(entity);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.a(world, source)) {
            return false;
        }
        boolean result = super.a(world, source, amount);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    public Variant gC() {
        return Variant.a(this.al.a(ch));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(ch, variant.h);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ch, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gC().h);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
    }

    @Override
    public boolean gD() {
        return !this.aJ();
    }

    @Override
    protected boolean gs() {
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dr() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Codec<Variant> f;
        private static final IntFunction<Variant> g;
        final int h;
        private final String i;

        private Variant(int i2, String s2) {
            this.h = i2;
            this.i = s2;
        }

        public int a() {
            return this.h;
        }

        public static Variant a(int index) {
            return g.apply(index);
        }

        @Override
        public String c() {
            return this.i;
        }

        static {
            f = INamable.a(Variant::values);
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speed) {
            super(mob, speed);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.bj()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.dZ().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dw();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            Iterable<BlockPosition> iterable = BlockPosition.b(MathHelper.a(this.b.dB() - 3.0), MathHelper.a(this.b.dD() - 6.0), MathHelper.a(this.b.dH() - 3.0), MathHelper.a(this.b.dB() + 3.0), MathHelper.a(this.b.dD() + 6.0), MathHelper.a(this.b.dH() + 3.0));
            for (BlockPosition blockposition1 : iterable) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.dW().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.u)) || !this.b.dW().u(blockposition1) || !this.b.dW().u(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

