/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityPig.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    public final SaddleStorage cb;

    public EntityPig(EntityTypes<? extends EntityPig> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cb = new SaddleStorage(this.al, ca, bZ);
    }

    @Override
    protected void B() {
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bT.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(Items.ok), false));
        this.bT.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(TagsItem.ax), false));
        this.bT.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bT.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cX() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.j() && (entity = this.da()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.ok)) {
            return entityhuman;
        }
        return super.cX();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (ca.equals(data) && this.dW().C) {
            this.cb.a();
        }
        super.a(data);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, false);
        builder.a(ca, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.cb.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cb.b(nbt);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.tU;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.tW;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.tV;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tY, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.j(player.b(hand));
        if (!flag && this.j() && !this.ca() && !player.fY()) {
            if (!this.dW().C) {
                player.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.oe) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean f() {
        return this.bL() && !this.e_();
    }

    @Override
    protected void f(WorldServer world) {
        super.f(world);
        if (this.j()) {
            this.a(world, Items.oe);
        }
    }

    @Override
    public boolean j() {
        return this.cb.d();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundCategory) {
        this.cb.a(true);
        if (soundCategory != null) {
            this.dW().a((EntityHuman)null, this, SoundEffects.tX, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cP();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dw();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : passenger.fO()) {
            AxisAlignedBB axisalignedbb = passenger.f(entitypose);
            int[][] aint1 = aint;
            int i2 = aint.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                int[] aint2 = aint1[j2];
                blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v(), blockposition.w() + aint2[1]);
                double d0 = this.dW().j(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0)) continue;
                Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                if (!DismountUtil.a(this.dW(), passenger, axisalignedbb.c(vec3d))) continue;
                passenger.b(entitypose);
                return vec3d;
            }
        }
        return super.b(passenger);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.al() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = this.convertTo(EntityTypes.bR, ConversionParams.a(this, false, true), (T entitypigzombie1) -> {
                if (this.eZ().f()) {
                    entitypigzombie1.a(EnumItemSlot.a, new ItemStack(Items.ps));
                }
                entitypigzombie1.ai();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, lightning, entitypigzombie).isCancelled()) {
                return;
            }
            world.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (entitypigzombie == null) {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        this.b(controllingPlayer.dM(), controllingPlayer.dO() * 0.5f);
        this.aX = this.aZ = this.dM();
        this.N = this.aZ;
        this.cb.b();
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)(this.h(GenericAttributes.v) * 0.225 * (double)this.cb.c());
    }

    @Override
    public boolean a() {
        return this.cb.a(this.dZ());
    }

    @Nullable
    public EntityPig b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aR.a(world, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ax);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dr() * 0.4f);
    }
}

