/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float ca = 6.0f;
    private float cb;
    private float cd;
    private int ce;
    private static final UniformInt cf = TimeRange.a(20, 39);
    private int cg;
    @Nullable
    private UUID ch;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    @Nullable
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aV.a(world, EntitySpawnReason.e);
    }

    @Override
    @Override
    public boolean j(ItemStack stack) {
        return false;
    }

    @Override
    @Override
    protected void B() {
        super.B();
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new c());
        this.bT.a(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, polarBear -> polarBear.e_() ? DamageTypeTags.F : DamageTypeTags.G));
        this.bT.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bT.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(7, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new b());
        this.bU.a(2, new a());
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bU.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bU.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.s, 30.0).a(GenericAttributes.m, 20.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.c, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> holder = world.t(pos);
        if (holder.a(BiomeTags.ao)) {
            return EntityPolarBear.a(world, pos) && world.a_(pos.e()).a(TagsBlock.ce);
        }
        return EntityPolarBear.b(type, world, spawnReason, pos, random);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.dW(), nbt);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.a_(nbt);
    }

    @Override
    @Override
    public void c() {
        this.a(cf.a(this.ae));
    }

    @Override
    @Override
    public void a(int angerTime) {
        this.cg = angerTime;
    }

    @Override
    @Override
    public int a() {
        return this.cg;
    }

    @Override
    @Override
    public void a(@Nullable UUID angryAt) {
        this.ch = angryAt;
    }

    @Override
    @Nullable
    @Override
    public UUID b() {
        return this.ch;
    }

    @Override
    @Override
    protected SoundEffect u() {
        if (this.e_()) {
            return SoundEffects.uR;
        }
        return SoundEffects.uQ;
    }

    @Override
    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.uT;
    }

    @Override
    @Override
    public SoundEffect o_() {
        return SoundEffects.uS;
    }

    @Override
    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.uU, 0.15f, 1.0f);
    }

    protected void t() {
        if (this.ce <= 0) {
            this.b(SoundEffects.uV);
            this.ce = 40;
        }
    }

    @Override
    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, false);
    }

    @Override
    @Override
    public void h() {
        super.h();
        if (this.dW().C) {
            if (this.cd != this.cb) {
                this.m_();
            }
            this.cb = this.cd;
            this.cd = this.x() ? MathHelper.a(this.cd + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.cd - 1.0f, 0.0f, 6.0f);
        }
        if (this.ce > 0) {
            --this.ce;
        }
        if (!this.dW().C) {
            this.a((WorldServer)this.dW(), true);
        }
    }

    @Override
    @Override
    public EntitySize e(EntityPose pose) {
        if (this.cd > 0.0f) {
            float f2 = this.cd / 6.0f;
            float g2 = 1.0f + f2;
            return super.e(pose).a(1.0f, g2);
        }
        return super.e(pose);
    }

    public boolean x() {
        return this.al.a(bZ);
    }

    public void x(boolean warning) {
        this.al.a(bZ, warning);
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.cb, this.cd) / 6.0f;
    }

    @Override
    @Override
    protected float fm() {
        return 0.98f;
    }

    @Override
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityPolarBear$c.a(this.a), (Entity)target);
                EntityPolarBear.this.x(false);
            } else if (this.a.g((Entity)target) < (double)((target.dr() + 3.0f) * (target.dr() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.x(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.x(true);
                    EntityPolarBear.this.t();
                }
            } else {
                this.h();
                EntityPolarBear.this.x(false);
            }
        }

        @Override
        @Override
        public void e() {
            EntityPolarBear.this.x(false);
            super.e();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        @Override
        public void d() {
            super.d();
            if (EntityPolarBear.this.e_()) {
                this.h();
                this.e();
            }
        }

        @Override
        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.e_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        @Override
        public boolean b() {
            if (EntityPolarBear.this.e_()) {
                return false;
            }
            if (super.b()) {
                List<EntityPolarBear> list = EntityPolarBear.this.dW().a(EntityPolarBear.class, EntityPolarBear.this.cR().c(8.0, 4.0, 8.0));
                for (EntityPolarBear polarBear : list) {
                    if (!polarBear.e_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

