/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.PufferFishStateChangeEvent;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPufferFish
extends EntityFish {
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityPufferFish.class, DataWatcherRegistry.b);
    int ca;
    int cb;
    private static final PathfinderTargetCondition.a cc = (entityliving, worldserver) -> {
        EntityHuman entityhuman;
        if (entityliving instanceof EntityHuman && (entityhuman = (EntityHuman)entityliving).b()) {
            return false;
        }
        return !entityliving.aq().a(TagsEntity.A);
    };
    static final PathfinderTargetCondition cd = PathfinderTargetCondition.b().e().d().a(cc);
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;

    public EntityPufferFish(EntityTypes<? extends EntityPufferFish> type, World world) {
        super((EntityTypes<? extends EntityFish>)type, world);
        this.m_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, 0);
    }

    public int gp() {
        return this.al.a(bZ);
    }

    public void b(int puffState) {
        this.al.a(bZ, puffState);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bZ.equals(data)) {
            this.m_();
        }
        super.a(data);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("PuffState", this.gp());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.b(Math.min(nbt.h("PuffState"), 2));
    }

    @Override
    public ItemStack X_() {
        return new ItemStack(Items.rd);
    }

    @Override
    protected void B() {
        super.B();
        this.bT.a(1, new a(this));
    }

    @Override
    public void h() {
        if (!this.dW().C && this.bL() && this.dk()) {
            if (this.ca > 0) {
                boolean increase = true;
                if (this.gp() == 0) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vl);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.ca > 40 && this.gp() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 2).callEvent()) {
                        this.b(SoundEffects.vl);
                        this.b(2);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.ca;
                }
            } else if (this.gp() != 0) {
                boolean increase = true;
                if (this.cb > 60 && this.gp() == 2) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.b(SoundEffects.vk);
                        this.b(1);
                    } else {
                        increase = false;
                    }
                } else if (this.cb > 100 && this.gp() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 0).callEvent()) {
                        this.b(SoundEffects.vk);
                        this.b(0);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.cb;
                }
            }
        }
        super.h();
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bL() && this.gp() > 0) {
                List<EntityInsentient> list = this.dW().a(EntityInsentient.class, this.cR().g(0.3), (? super T entityinsentient) -> cd.a(worldserver, this, (EntityLiving)entityinsentient));
                for (EntityInsentient entityinsentient2 : list) {
                    if (!entityinsentient2.bL()) continue;
                    this.a(worldserver, entityinsentient2);
                }
            }
        }
    }

    private void a(WorldServer world, EntityInsentient target) {
        int i2 = this.gp();
        if (target.a(world, this.dX().b(this), (float)(1 + i2))) {
            target.addEffect(new MobEffect(MobEffects.s, 60 * i2, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            this.a(SoundEffects.vp, 1.0f, 1.0f);
        }
    }

    @Override
    public void a_(EntityHuman player) {
        int i2 = this.gp();
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            if (i2 > 0 && player.a(entityplayer.y(), this.dX().b(this), (float)(1 + i2))) {
                if (!this.bb()) {
                    entityplayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.k, 0.0f));
                }
                player.addEffect(new MobEffect(MobEffects.s, 60 * i2, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.vj;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.vm;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.vo;
    }

    @Override
    protected SoundEffect go() {
        return SoundEffects.vn;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return super.e(pose).a(EntityPufferFish.c(this.gp()));
    }

    private static float c(int puffState) {
        switch (puffState) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityPufferFish a;

        public a(EntityPufferFish pufferfish) {
            this.a = pufferfish;
        }

        @Override
        public boolean b() {
            List<EntityLiving> list = this.a.dW().a(EntityLiving.class, this.a.cR().g(2.0), entityliving -> cd.a(net.minecraft.world.entity.animal.EntityPufferFish$a.a(this.a), this.a, (EntityLiving)entityliving));
            return !list.isEmpty();
        }

        @Override
        public void d() {
            this.a.ca = 1;
            this.a.cb = 0;
        }

        @Override
        public void e() {
            this.a.ca = 0;
        }
    }
}

