/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bZ = 40;
    private static final DataWatcherObject<Byte> ca = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, Integer> cb = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(enumcolor -> enumcolor, EntitySheep::c)));
    private int cd;
    private PathfinderGoalEatTile ce;

    private static int c(EnumColor color) {
        if (color == EnumColor.a) {
            return -1644826;
        }
        int i2 = color.d();
        float f2 = 0.75f;
        return ARGB.a(255, MathHelper.d((float)ARGB.b(i2) * 0.75f), MathHelper.d((float)ARGB.c(i2) * 0.75f), MathHelper.d((float)ARGB.d(i2) * 0.75f));
    }

    public static int a(EnumColor dyeColor) {
        return cb.get(dyeColor);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void B() {
        this.ce = new PathfinderGoalEatTile(this);
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bT.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(3, new PathfinderGoalTempt(this, 1.1, itemstack -> itemstack.a(TagsItem.ah), false));
        this.bT.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bT.a(5, this.ce);
        this.bT.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ah);
    }

    @Override
    protected void a(WorldServer world) {
        this.cd = this.ce.h();
        super.a(world);
    }

    @Override
    public void d_() {
        if (this.dW().C) {
            this.cd = Math.max(0, this.cd - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, (byte)0);
    }

    @Override
    public void b(byte status) {
        if (status == 10) {
            this.cd = 40;
        } else {
            super.b(status);
        }
    }

    public float J(float delta) {
        return this.cd <= 0 ? 0.0f : (this.cd >= 4 && this.cd <= 36 ? 1.0f : (this.cd < 4 ? ((float)this.cd - delta) / 4.0f : -((float)(this.cd - 40) - delta) / 4.0f));
    }

    public float K(float delta) {
        if (this.cd > 4 && this.cd <= 36) {
            float f1 = ((float)(this.cd - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f1 * 28.7f);
        }
        return this.cd > 0 ? 0.62831855f : this.dO() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.sJ)) {
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.a()) {
                    List<ItemStack> drops = this.generateDefaultDrops(worldserver, itemstack);
                    PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
                    if (event != null) {
                        if (event.isCancelled()) {
                            return EnumInteractionResult.e;
                        }
                        drops = CraftItemStack.asNMSCopy(event.getDrops());
                    }
                    this.shear(worldserver, SoundCategory.h, itemstack, drops);
                    this.a(GameEvent.M, (Entity)player);
                    itemstack.a(1, (EntityLiving)player, EntitySheep.d(hand));
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears) {
        this.shear(world, shearedSoundCategory, shears, this.generateDefaultDrops(world, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aV, shears, (arg_0, arg_1) -> EntitySheep.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears, List<ItemStack> drops) {
        WorldServer worldserver1 = world;
        world.a((EntityHuman)null, this, SoundEffects.wV, shearedSoundCategory, 1.0f, 1.0f);
        drops.forEach(itemstack1 -> {
            this.forceDrops = true;
            EntityItem entityitem = this.a(worldserver1, (ItemStack)itemstack1, 1.0f);
            this.forceDrops = false;
            if (entityitem != null) {
                entityitem.h(entityitem.dz().b((this.ae.i() - this.ae.i()) * 0.1f, this.ae.i() * 0.05f, (this.ae.i() - this.ae.i()) * 0.1f));
            }
        });
        this.x(true);
    }

    @Override
    public boolean a() {
        return this.bL() && !this.x() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Sheared", this.x());
        nbt.a("Color", (byte)this.t().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("Sheared"));
        this.b(EnumColor.a(nbt.f("Color")));
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.wS;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.wU;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.wT;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.wW, 0.15f, 1.0f);
    }

    public EnumColor t() {
        return EnumColor.a(this.al.a(ca) & 0xF);
    }

    public void b(EnumColor color) {
        byte b0 = this.al.a(ca);
        this.al.a(ca, (byte)(b0 & 0xF0 | color.a() & 0xF));
    }

    public boolean x() {
        return (this.al.a(ca) & 0x10) != 0;
    }

    public void x(boolean sheared) {
        byte b0 = this.al.a(ca);
        if (sheared) {
            this.al.a(ca, (byte)(b0 | 0x10));
        } else {
            this.al.a(ca, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(RandomSource random) {
        int i2 = random.a(100);
        return i2 < 5 ? EnumColor.p : (i2 < 10 ? EnumColor.h : (i2 < 15 ? EnumColor.i : (i2 < 18 ? EnumColor.m : (random.a(500) == 0 ? EnumColor.g : EnumColor.a))));
    }

    @Nullable
    public EntitySheep b(WorldServer world, EntityAgeable entity) {
        EntitySheep entitysheep = EntityTypes.bb.a(world, EntitySpawnReason.e);
        if (entitysheep != null) {
            entitysheep.b(this.a(world, this, (EntitySheep)entity));
        }
        return entitysheep;
    }

    @Override
    public void P() {
        SheepRegrowWoolEvent event = new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity());
        this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        super.P();
        this.x(false);
        if (this.e_()) {
            this.b_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.b(EntitySheep.a(world.H_()));
        return super.a(world, difficulty, spawnReason, entityData);
    }

    private EnumColor a(WorldServer world, EntitySheep firstParent, EntitySheep secondParent) {
        EnumColor enumcolor = firstParent.t();
        EnumColor enumcolor1 = secondParent.t();
        CraftingInput craftinginput = EntitySheep.a(enumcolor, enumcolor1);
        Optional<Item> optional = world.s().a(Recipes.a, craftinginput, world).map(recipeholder -> ((RecipeCrafting)recipeholder.b()).a(craftinginput, world.K_())).map(ItemStack::h);
        Objects.requireNonNull(ItemDye.class);
        optional = optional.filter(ItemDye.class::isInstance);
        Objects.requireNonNull(ItemDye.class);
        return optional.map(ItemDye.class::cast).map(ItemDye::b).orElseGet(() -> world.A.h() ? enumcolor : enumcolor1);
    }

    private static CraftingInput a(EnumColor firstColor, EnumColor secondColor) {
        return CraftingInput.a(2, 1, List.of(new ItemStack(ItemDye.a(firstColor)), new ItemStack(ItemDye.a(secondColor))));
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.L(); ++i2) {
            drops.add(stack.c(1));
        }
    }
}

