/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte b = 16;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bT.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bT.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(4, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, (entityliving, worldserver) -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.C().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.2f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Pumpkin", this.p());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Pumpkin")) {
            this.x(nbt.q("Pumpkin"));
        }
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.dW().t(this.dw()).a(BiomeTags.ae)) {
                this.a(worldserver, this.dX().melting(), 1.0f);
            }
            if (!worldserver.N().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.ea.m();
            for (int i2 = 0; i2 < 4; ++i2) {
                int j2 = MathHelper.a(this.dB() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.a(this.dD());
                int l2 = MathHelper.a(this.dH() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (!this.dW().a_(blockposition).l() || !iblockdata.a((IWorldReader)this.dW(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.dW(), blockposition, iblockdata, this)) continue;
                this.dW().a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        double d0 = target.dB() - this.dB();
        double d1 = target.dF() - (double)1.1f;
        double d2 = target.dH() - this.dH();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ItemStack itemstack = new ItemStack(Items.ra);
            IProjectile.a(new EntitySnowball(worldserver, this, itemstack), worldserver, itemstack, entitysnowball -> entitysnowball.c(d0, d1 + d3 - entitysnowball.dD(), d2, 1.6f, 12.0f));
        }
        this.a(SoundEffects.zf, 1.0f, 0.4f / (this.dZ().i() * 0.4f + 0.8f));
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.sJ) && this.a()) {
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(worldserver, itemstack);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(worldserver, SoundCategory.h, itemstack, drops);
                this.a(GameEvent.M, (Entity)player);
                itemstack.a(1, (EntityLiving)player, EntitySnowman.d(hand));
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void a(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears) {
        this.shear(world, shearedSoundCategory, shears, this.generateDefaultDrops(world, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(serverLevel, LootTables.aU, shears, (arg_0, arg_1) -> EntitySnowman.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer world, SoundCategory shearedSoundCategory, ItemStack shears, List<ItemStack> drops) {
        WorldServer worldserver1 = world;
        world.a((EntityHuman)null, this, SoundEffects.zg, shearedSoundCategory, 1.0f, 1.0f);
        this.x(false);
        drops.forEach(itemstack1 -> {
            this.forceDrops = true;
            this.a(worldserver1, (ItemStack)itemstack1, this.cS());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean a() {
        return this.bL() && this.p();
    }

    public boolean p() {
        return (this.al.a(a) & 0x10) != 0;
    }

    public void x(boolean hasPumpkin) {
        byte b0 = this.al.a(a);
        if (hasPumpkin) {
            this.al.a(a, (byte)(b0 | 0x10));
        } else {
            this.al.a(a, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return SoundEffects.zc;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.ze;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.zd;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.75f * this.cS(), this.dr() * 0.4f);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, WorldServer ignored, ItemStack stack) {
        drops.add(stack);
    }
}

