/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.util.MCUtil;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> ca = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<BlockPosition> ce = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cg = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.k);
    private static final float ch = 0.3f;
    private static final EntitySize ci = EntityTypes.bB.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bB.m(), -0.25f)).a(0.3f);
    int cj;
    public static final PathfinderTargetCondition.a bZ = (entityliving, worldserver) -> entityliving.e_() && !entityliving.bj();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.a(PathType.r, -1.0f);
        this.bQ = new e(this);
    }

    public void h(BlockPosition pos) {
        this.al.a(ca, pos);
    }

    public BlockPosition go() {
        return this.al.a(ca);
    }

    void i(BlockPosition pos) {
        this.al.a(ce, pos);
    }

    BlockPosition gp() {
        return this.al.a(ce);
    }

    public boolean p() {
        return this.al.a(cb);
    }

    public void x(boolean hasEgg) {
        this.al.a(cb, hasEgg);
    }

    public boolean t() {
        return this.al.a(cd);
    }

    void y(boolean diggingSand) {
        this.cj = diggingSand ? 1 : 0;
        this.al.a(cd, diggingSand);
    }

    public boolean gq() {
        return this.al.a(cf);
    }

    public void z(boolean landBound) {
        this.al.a(cf, landBound);
    }

    public boolean gr() {
        return this.al.a(cg);
    }

    public void A(boolean traveling) {
        this.al.a(cg, traveling);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, BlockPosition.c);
        builder.a(cb, false);
        builder.a(ce, BlockPosition.c);
        builder.a(cf, false);
        builder.a(cg, false);
        builder.a(cd, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("HomePosX", this.go().u());
        nbt.a("HomePosY", this.go().v());
        nbt.a("HomePosZ", this.go().w());
        nbt.a("HasEgg", this.p());
        nbt.a("TravelPosX", this.gp().u());
        nbt.a("TravelPosY", this.gp().v());
        nbt.a("TravelPosZ", this.gp().w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2 = nbt.h("HomePosX");
        int j2 = nbt.h("HomePosY");
        int k2 = nbt.h("HomePosZ");
        this.h(new BlockPosition(i2, j2, k2));
        super.a(nbt);
        this.x(nbt.q("HasEgg"));
        int l2 = nbt.h("TravelPosX");
        int i1 = nbt.h("TravelPosY");
        int j1 = nbt.h("TravelPosZ");
        this.i(new BlockPosition(l2, i1, j1));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.h(this.dw());
        this.i(BlockPosition.c);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public static boolean c(EntityTypes<EntityTurtle> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return pos.v() < world.O() + 4 && BlockTurtleEgg.a(world, pos) && EntityTurtle.a(world, pos);
    }

    @Override
    protected void B() {
        this.bT.a(0, new f(this, 1.2));
        this.bT.a(1, new a(this, 1.0));
        this.bT.a(1, new d(this, 1.0));
        this.bT.a(2, new PathfinderGoalTempt(this, 1.1, itemstack -> itemstack.a(TagsItem.aB), false));
        this.bT.a(3, new c(this, 1.0));
        this.bT.a(4, new b(this, 1.0));
        this.bT.a(7, new i(this, 1.0));
        this.bT.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder x() {
        return EntityAnimal.gt().a(GenericAttributes.s, 30.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.B, 1.0);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    public int Q() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return !this.bj() && this.aJ() && !this.e_() ? SoundEffects.AE : super.u();
    }

    @Override
    protected void f(float volume) {
        super.f(volume * 1.5f);
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.AP;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return this.e_() ? SoundEffects.AL : SoundEffects.AK;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return this.e_() ? SoundEffects.AG : SoundEffects.AF;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffect soundeffect = this.e_() ? SoundEffects.AO : SoundEffects.AN;
        this.a(soundeffect, 0.15f, 1.0f);
    }

    @Override
    public boolean gv() {
        return super.gv() && !this.p();
    }

    @Override
    protected float aU() {
        return this.X + 0.15f;
    }

    @Override
    public float ej() {
        return this.e_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new g(this, world);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bB.a(world, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aB);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return !this.gq() && world.b_(pos).a(TagsFluid.a) ? 10.0f : (BlockTurtleEgg.a(world, pos) ? 10.0f : world.w(pos));
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bL() && this.t() && this.cj >= 1 && this.cj % 5 == 0) {
            BlockPosition blockposition = this.dw();
            if (BlockTurtleEgg.a(this.dW(), blockposition)) {
                this.dW().c(2001, blockposition, Block.j(this.dW().a_(blockposition.e())));
                ((Entity)this).a(GameEvent.u);
            }
        }
    }

    @Override
    protected void i() {
        WorldServer worldserver;
        World world;
        super.i();
        if (!this.e_() && (world = this.dW()) instanceof WorldServer && (worldserver = (WorldServer)world).N().b(GameRules.f)) {
            this.forceDrops = true;
            this.a(worldserver, Items.oL, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void a_(Vec3D movementInput) {
        if (this.di() && this.bj()) {
            this.a(0.1f, movementInput);
            this.a(EnumMoveType.a, this.dz());
            this.h(this.dz().c(0.9));
            if (!(this.O_() != null || this.gq() && this.go().a(this.du(), 20.0))) {
                this.h(this.dz().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a_(movementInput);
        }
    }

    @Override
    public boolean y() {
        return false;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        this.a(world, this.dX().c().customEventDamager(lightning), Float.MAX_VALUE);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ci : super.e(pose);
    }

    private static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle turtle) {
            super(turtle);
            this.l = turtle;
        }

        private void g() {
            if (this.l.bj()) {
                this.l.h(this.l.dz().b(0.0, 0.005, 0.0));
                if (!this.l.go().a(this.l.du(), 16.0)) {
                    this.l.C(Math.max(this.l.fp() / 2.0f, 0.08f));
                }
                if (this.l.e_()) {
                    this.l.C(Math.max(this.l.fp() / 3.0f, 0.06f));
                }
            } else if (this.l.aJ()) {
                this.l.C(Math.max(this.l.fp() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.L().m()) {
                double d2;
                double d1;
                double d0 = this.e - this.l.dB();
                double d3 = Math.sqrt(d0 * d0 + (d1 = this.f - this.l.dD()) * d1 + (d2 = this.g - this.l.dH()) * d2);
                if (d3 < (double)1.0E-5f) {
                    this.d.C(0.0f);
                } else {
                    d1 /= d3;
                    float f2 = (float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f;
                    this.l.v(this.b(this.l.dM(), f2, 90.0f));
                    this.l.aX = this.l.dM();
                    float f1 = (float)(this.h * this.l.h(GenericAttributes.v));
                    this.l.C(MathHelper.h(0.125f, this.l.fp(), f1));
                    this.l.h(this.l.dz().b(0.0, (double)this.l.fp() * d1 * 0.1, 0.0));
                }
            } else {
                this.l.C(0.0f);
            }
        }
    }

    private static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speed) {
            super(turtle, speed);
        }

        @Override
        public boolean b() {
            if (!this.h()) {
                return false;
            }
            BlockPosition blockposition = this.a(this.c.dW(), this.c, 7);
            if (blockposition != null) {
                this.e = blockposition.u();
                this.f = blockposition.v();
                this.g = blockposition.w();
                return true;
            }
            return this.i();
        }
    }

    private static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speed) {
            super(turtle, speed);
            this.d = turtle;
        }

        @Override
        public boolean b() {
            return super.b() && !this.d.p();
        }

        @Override
        protected void g() {
            EntityFertilizeEggEvent event;
            EntityPlayer entityplayer = this.a.gx();
            if (entityplayer == null && this.c.gx() != null) {
                entityplayer = this.c.gx();
            }
            if ((event = CraftEventFactory.callEntityFertilizeEggEvent(this.a, this.c)).isCancelled()) {
                return;
            }
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.p.a(entityplayer, this.a, this.c, null);
            }
            this.d.x(true);
            this.a.c_(6000);
            this.c.c_(6000);
            this.a.gz();
            this.c.gz();
            RandomSource randomsource = this.a.dZ();
            if (net.minecraft.world.entity.animal.EntityTurtle$a.a(this.b).N().b(GameRules.f) && event.getExperience() > 0) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dB(), this.a.dD(), this.a.dH(), event.getExperience(), ExperienceOrb.SpawnReason.BREED, entityplayer));
            }
        }
    }

    private static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speed) {
            super(turtle, speed, 16);
            this.g = turtle;
        }

        @Override
        public boolean b() {
            return this.g.p() && this.g.go().a(this.g.du(), 9.0) ? super.b() : false;
        }

        @Override
        public boolean c() {
            return super.c() && this.g.p() && this.g.go().a(this.g.du(), 9.0);
        }

        @Override
        public void a() {
            super.a();
            BlockPosition blockposition = this.g.dw();
            if (!this.g.bj() && this.m()) {
                if (this.g.cj < 1) {
                    this.g.y(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dW(), this.e)).callEvent());
                } else if (this.g.cj > this.a(200)) {
                    World world = this.g.dW();
                    int eggCount = this.g.ae.a(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.dW(), this.e.d()), eggCount);
                    if (layEggEvent.callEvent() && CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.d(), (IBlockData)Blocks.mA.m().b(BlockTurtleEgg.f, layEggEvent.getEggCount()))) {
                        world.a((EntityHuman)null, blockposition, SoundEffects.AM, SoundCategory.e, 0.3f, 0.9f + world.A.i() * 0.2f);
                        BlockPosition blockposition1 = this.e.d();
                        IBlockData iblockdata = (IBlockData)Blocks.mA.m().b(BlockTurtleEgg.f, layEggEvent.getEggCount());
                        world.a(blockposition1, iblockdata, 3);
                        world.a(GameEvent.i, blockposition1, GameEvent.a.a(this.g, iblockdata));
                    }
                    this.g.x(false);
                    this.g.y(false);
                    this.g.r(600);
                }
                if (this.g.t()) {
                    ++this.g.cj;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return !world.u(pos.d()) ? false : BlockTurtleEgg.b(world, pos);
        }
    }

    private static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speed) {
            super(turtle, turtle.e_() ? 2.0 : speed, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean c() {
            return !this.h.bj() && this.d <= 1200 && this.a(this.h.dW(), this.e);
        }

        @Override
        public boolean b() {
            return this.h.e_() && !this.h.bj() ? super.b() : (!this.h.gq() && !this.h.bj() && !this.h.p() ? super.b() : false);
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.J);
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean b() {
            return this.a.e_() ? false : (this.a.p() || this.a.dZ().a(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.go().a(this.a.du(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.a.z(true);
            this.c = false;
            this.d = 0;
        }

        @Override
        public void e() {
            this.a.z(false);
        }

        @Override
        public boolean c() {
            return !this.a.go().a(this.a.du(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void a() {
            BlockPosition blockposition = this.a.go();
            boolean flag = blockposition.a(this.a.du(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.L().m()) {
                Vec3D vec3d = Vec3D.c(blockposition);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null && !flag && !this.a.dW().a_(BlockPosition.a(vec3d1)).a(Blocks.J)) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.L().a(vec3d1.d, vec3d1.e, vec3d1.f, this.b);
            }
        }
    }

    private static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean b() {
            return !this.a.gq() && !this.a.p() && this.a.bj();
        }

        @Override
        public void d() {
            boolean flag = true;
            boolean flag1 = true;
            RandomSource randomsource = this.a.ae;
            int i2 = randomsource.a(1025) - 512;
            int j2 = randomsource.a(9) - 4;
            int k2 = randomsource.a(1025) - 512;
            if ((double)j2 + this.a.dD() > (double)(this.a.dW().O() - 1)) {
                j2 = 0;
            }
            BlockPosition blockposition = BlockPosition.a((double)i2 + this.a.dB(), (double)j2 + this.a.dD(), (double)k2 + this.a.dH());
            this.a.i(blockposition);
            this.a.A(true);
            this.c = false;
        }

        @Override
        public void a() {
            if (this.a.L().m()) {
                Vec3D vec3d = Vec3D.c(this.a.gp());
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null) {
                    int i2 = MathHelper.a(vec3d1.d);
                    int j2 = MathHelper.a(vec3d1.f);
                    boolean flag = true;
                    if (!this.a.dW().b(i2 - 34, j2 - 34, i2 + 34, j2 + 34)) {
                        vec3d1 = null;
                    }
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.L().a(vec3d1.d, vec3d1.e, vec3d1.f, this.b);
            }
        }

        @Override
        public boolean c() {
            return !this.a.L().m() && !this.c && !this.a.gq() && !this.a.gy() && !this.a.p();
        }

        @Override
        public void e() {
            this.a.A(false);
            super.e();
        }
    }

    private static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speed, int chance) {
            super(turtle, speed, chance);
            this.i = turtle;
        }

        @Override
        public boolean b() {
            return !this.b.bj() && !this.i.gq() && !this.i.p() ? super.b() : false;
        }
    }

    private static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle owner, World world) {
            super(owner, world);
        }

        @Override
        public boolean a(BlockPosition pos) {
            EntityTurtle entityturtle;
            EntityInsentient entityinsentient = this.a;
            if (entityinsentient instanceof EntityTurtle && (entityturtle = (EntityTurtle)entityinsentient).gr()) {
                return this.b.a_(pos).a(Blocks.J);
            }
            return !this.b.a_(pos.e()).l();
        }
    }
}

