/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable,
VariantHolder<Holder<WolfVariant>> {
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> ci = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.y);
    public static final PathfinderTargetCondition.a cd = (entityliving, worldserver) -> {
        EntityTypes<?> entitytypes = entityliving.aq();
        return entitytypes == EntityTypes.bb || entitytypes == EntityTypes.aY || entitytypes == EntityTypes.ab;
    };
    private static final float cj = 8.0f;
    private static final float ck = 40.0f;
    private static final float cl = 0.125f;
    public static final float ce = 0.62831855f;
    private float cm;
    private float cn;
    public boolean co;
    private boolean cp;
    private float cq;
    private float cr;
    private static final UniformInt cs = TimeRange.a(20, 39);
    @Nullable
    private UUID ct;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.b(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.bT.a(2, new PathfinderGoalSit(this));
        this.bT.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bT.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bT.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bT.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.bT.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bT.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(10, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bU.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bU.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bU.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.bU.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cd));
        this.bU.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bZ));
        this.bU.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bU.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gA() {
        WolfVariant wolfvariant = this.gB().a();
        return this.p() ? wolfvariant.b() : (this.ad_() ? wolfvariant.c() : wolfvariant.a());
    }

    public Holder<WolfVariant> gB() {
        return this.al.a(ci);
    }

    public void j(Holder<WolfVariant> holder) {
        this.al.a(ci, holder);
    }

    public static AttributeProvider.Builder gC() {
        return EntityAnimal.gt().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistryCustom iregistrycustom = this.dY();
        IRegistry<WolfVariant> iregistry = iregistrycustom.e(Registries.m);
        DataWatcherObject<Holder<WolfVariant>> datawatcherobject = ci;
        Optional optional = iregistry.a(WolfVariants.j);
        Objects.requireNonNull(iregistry);
        builder.a(datawatcherobject, (Holder)optional.or(iregistry::a).orElseThrow());
        builder.a(cf, false);
        builder.a(cg, EnumColor.o.a());
        builder.a(ch, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Ds, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CollarColor", (byte)this.gE().a());
        this.gB().e().ifPresent(resourcekey -> nbt.a("variant", resourcekey.a().toString()));
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        Optional.ofNullable(MinecraftKey.c(nbt.l("variant"))).map(minecraftkey -> ResourceKey.a(Registries.m, minecraftkey)).flatMap(resourcekey -> this.dY().e(Registries.m).a((ResourceKey)resourcekey)).ifPresent(this::j);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
        this.a(this.dW(), nbt);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        Holder<WolfVariant> holder1;
        Holder<BiomeBase> holder = world.t(this.dw());
        if (entityData instanceof b) {
            b entitywolf_b = (b)entityData;
            holder1 = entitywolf_b.a;
        } else {
            holder1 = WolfVariants.a(this.dY(), holder);
            entityData = new b(holder1);
        }
        this.j(holder1);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected SoundEffect u() {
        return this.ad_() ? SoundEffects.Dn : (this.ae.a(3) == 0 ? (this.p() && this.eE() < 20.0f ? SoundEffects.Dt : SoundEffects.Dq) : SoundEffects.Dl);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return this.h(source) ? SoundEffects.Dj : SoundEffects.Dp;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Dm;
    }

    @Override
    public float fg() {
        return 0.4f;
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dW().C && this.co && !this.cp && !this.gk() && this.aJ()) {
            this.cp = true;
            this.cq = 0.0f;
            this.cr = 0.0f;
            this.dW().a((Entity)this, (byte)8);
        }
        if (!this.dW().C) {
            this.a((WorldServer)this.dW(), true);
        }
    }

    @Override
    public void h() {
        super.h();
        if (this.bL()) {
            this.cn = this.cm;
            this.cm = this.gF() ? (this.cm += (1.0f - this.cm) * 0.4f) : (this.cm += (0.0f - this.cm) * 0.4f);
            if (this.bl()) {
                this.co = true;
                if (this.cp && !this.dW().C) {
                    this.dW().a((Entity)this, (byte)56);
                    this.gG();
                }
            } else if ((this.co || this.cp) && this.cp) {
                if (this.cq == 0.0f) {
                    this.a(SoundEffects.Dr, this.fg(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a((Holder<GameEvent>)GameEvent.u);
                }
                this.cr = this.cq;
                this.cq += 0.05f;
                if (this.cr >= 2.0f) {
                    this.co = false;
                    this.cp = false;
                    this.cr = 0.0f;
                    this.cq = 0.0f;
                }
                if (this.cq > 0.4f) {
                    float f2 = (float)this.dD();
                    int i2 = (int)(MathHelper.a((this.cq - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dz();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.ae.i() * 2.0f - 1.0f) * this.dr() * 0.5f;
                        float f22 = (this.ae.i() * 2.0f - 1.0f) * this.dr() * 0.5f;
                        this.dW().a(Particles.an, this.dB() + (double)f1, (double)(f2 + 0.8f), this.dH() + (double)f22, vec3d.d, vec3d.e, vec3d.f);
                    }
                }
            }
        }
    }

    private void gG() {
        this.cp = false;
        this.cq = 0.0f;
        this.cr = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.co = false;
        this.cp = false;
        this.cr = 0.0f;
        this.cq = 0.0f;
        super.a(damageSource);
    }

    public float J(float tickDelta) {
        return !this.co ? 1.0f : Math.min(0.75f + MathHelper.h(tickDelta, this.cr, this.cq) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float tickDelta) {
        return MathHelper.h(tickDelta, this.cr, this.cq);
    }

    public float L(float tickDelta) {
        return MathHelper.h(tickDelta, this.cn, this.cm) * 0.15f * (float)Math.PI;
    }

    @Override
    public int Z() {
        return this.x() ? 20 : super.Z();
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.a(world, source)) {
            return false;
        }
        boolean result = super.a(world, source, amount);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.h(damagesource)) {
            return super.actuallyHurt(worldserver, damagesource, f2, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.af();
        int i2 = itemstack.o();
        int j2 = itemstack.p();
        itemstack.a(MathHelper.f(f2), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(i2, j2) != Crackiness.b.a(this.af())) {
            this.a(SoundEffects.Di);
            worldserver.a(new ParticleParamItem(Particles.S, Items.oM.n()), this.dB(), this.dD() + 1.0, this.dH(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean h(DamageSource source) {
        return this.af().a(Items.oN) && !source.a(DamageTypeTags.C);
    }

    @Override
    protected void t() {
        if (this.p()) {
            this.g(GenericAttributes.s).a(40.0);
            this.x(this.eS());
        } else {
            this.g(GenericAttributes.s).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.g);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.h();
        if (this.p()) {
            ItemStack itemstack1;
            if (this.j(itemstack) && this.eE() < this.eS()) {
                this.a(player, hand, itemstack);
                FoodInfo foodinfo = itemstack.a(DataComponents.w);
                float f2 = foodinfo != null ? (float)foodinfo.a() : 1.0f;
                this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(player)) {
                    EnumColor enumcolor = itemdye.b();
                    if (enumcolor != this.gE()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.d;
                        }
                        enumcolor = EnumColor.a(event.getColor().getWoolData());
                        this.a(enumcolor);
                        itemstack.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    return super.b(player, hand);
                }
            }
            if (this.a(itemstack, EnumItemSlot.g) && !this.ag() && this.j(player) && !this.e_()) {
                this.h(itemstack.c(1));
                itemstack.a(1, (EntityLiving)player);
                return EnumInteractionResult.a;
            }
            if (itemstack.a(Items.sJ) && this.j(player) && this.ag() && (!EnchantmentManager.a(this.af(), EnchantmentEffectComponents.E) || player.b())) {
                itemstack.a(1, (EntityLiving)player, EntityWolf.d(hand));
                this.a(SoundEffects.az);
                itemstack1 = this.af();
                this.h(ItemStack.j);
                World world = this.dW();
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    this.forceDrops = true;
                    this.a(worldserver, itemstack1);
                    this.forceDrops = false;
                }
                return EnumInteractionResult.a;
            }
            if (this.x() && this.ag() && this.j(player) && this.af().n() && this.af().b(itemstack)) {
                itemstack.h(1);
                this.a(SoundEffects.Dk);
                itemstack1 = this.af();
                int i2 = (int)((float)itemstack1.p() * 0.125f);
                itemstack1.b(Math.max(0, itemstack1.o() - i2));
                return EnumInteractionResult.a;
            }
            EnumInteractionResult enuminteractionresult = super.b(player, hand);
            if (!enuminteractionresult.a() && this.j(player)) {
                this.z(!this.go());
                this.bn = false;
                this.bS.o();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.a.b();
            }
            return enuminteractionresult;
        }
        if (!this.dW().C && itemstack.a(Items.sn) && !this.ad_()) {
            itemstack.a(1, (EntityLiving)player);
            this.g(player);
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    private void g(EntityHuman player) {
        if (this.ae.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.bS.o();
            this.h((EntityLiving)null);
            this.z(true);
            this.dW().a((Entity)this, (byte)7);
        } else {
            this.dW().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 8) {
            this.cp = true;
            this.cq = 0.0f;
            this.cr = 0.0f;
        } else if (status == 56) {
            this.gG();
        } else {
            super.b(status);
        }
    }

    public float gD() {
        if (this.ad_()) {
            return 1.5393804f;
        }
        if (this.p()) {
            float f2 = this.eS();
            float f1 = (f2 - this.eE()) / f2;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ai);
    }

    @Override
    public int ad() {
        return 8;
    }

    @Override
    public int a() {
        return this.al.a(ch);
    }

    @Override
    public void a(int angerTime) {
        this.al.a(ch, angerTime);
    }

    @Override
    public void c() {
        this.a(cs.a(this.ae));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ct;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.ct = angryAt;
    }

    public EnumColor gE() {
        return EnumColor.a(this.al.a(cg));
    }

    @Override
    public void a(EnumColor color) {
        this.al.a(cg, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer world, EntityAgeable entity) {
        EntityWolf entitywolf = EntityTypes.bM.a(world, EntitySpawnReason.e);
        if (entitywolf != null && entity instanceof EntityWolf) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (this.ae.h()) {
                entitywolf.j(this.gB());
            } else {
                entitywolf.j(entitywolf1.gB());
            }
            if (this.p()) {
                entitywolf.b(this.ab_());
                entitywolf.b(true, true);
                if (this.ae.h()) {
                    entitywolf.a(this.gE());
                } else {
                    entitywolf.a(entitywolf1.gE());
                }
            }
        }
        return entitywolf;
    }

    public void A(boolean begging) {
        this.al.a(cf, begging);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (!this.p()) {
            return false;
        }
        if (!(other instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)other;
        return !entitywolf.p() ? false : (entitywolf.x() ? false : this.gy() && entitywolf.gy());
    }

    public boolean gF() {
        return this.al.a(cf);
    }

    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (!(target instanceof EntityCreeper || target instanceof EntityGhast || target instanceof EntityArmorStand)) {
            EntityTameableAnimal entitytameableanimal;
            EntityHorseAbstract entityhorseabstract;
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                return !entitywolf.p() || entitywolf.ah_() != owner;
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman1;
                EntityHuman entityhuman = (EntityHuman)target;
                if (owner instanceof EntityHuman && !(entityhuman1 = (EntityHuman)owner).a(entityhuman)) {
                    return false;
                }
            }
            if (target instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)target).gF()) {
                return false;
            }
            if (target instanceof EntityTameableAnimal && (entitytameableanimal = (EntityTameableAnimal)target).p()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean y() {
        return !this.ad_();
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dr() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.ch) && EntityWolf.a(world, pos);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama ? !this.j.p() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama llama) {
            return llama.gs() >= EntityWolf.this.ae.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.h((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.h((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> variant) {
            super(false);
            this.a = variant;
        }
    }
}

