/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class Axolotl
extends EntityAnimal
implements VariantHolder<Variant>,
Bucketable {
    public static final int bZ = 200;
    private static final int ck = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> ca = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.p, SensorType.q);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cb = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.K, (Object[])new MemoryModuleType[]{MemoryModuleType.y, MemoryModuleType.N, MemoryModuleType.B, MemoryModuleType.O, MemoryModuleType.P, MemoryModuleType.R, MemoryModuleType.U, MemoryModuleType.Z});
    private static final DataWatcherObject<Integer> cl = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cm = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cn = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double cd = 20.0;
    public static final int ce = 1200;
    private static final int co = 6000;
    public static final String cf = "Variant";
    private static final int cp = 1800;
    private static final int cq = 2400;
    public final BinaryAnimator cg = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator ch = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator ci = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator cj = new BinaryAnimator(10, MathHelper::m);
    private static final int cr = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.bQ = new d(this);
        this.bP = new c(this, 20);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cl, 0);
        builder.a(cm, false);
        builder.a(cn, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cf, this.go().a());
        nbt.a("FromBucket", this.p());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h(cf)));
        this.x(nbt.q("FromBucket"));
    }

    @Override
    public void R() {
        if (!this.gp()) {
            super.R();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        boolean flag = false;
        if (spawnReason == EntitySpawnReason.l) {
            return entityData;
        }
        RandomSource randomsource = world.H_();
        if (entityData instanceof b) {
            if (((b)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new b(Variant.a(randomsource), Variant.a(randomsource));
        }
        this.a(((b)entityData).a(randomsource));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void az() {
        int i2 = this.ct();
        super.az();
        if (!this.gb()) {
            this.s(i2);
        }
        if (this.dW().B_()) {
            this.gr();
        }
    }

    private void gr() {
        a axolotl_a = this.gp() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.bm() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aJ() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.cg.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.ch.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.ci.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.aT.d() || this.dO() != this.O || this.dM() != this.N;
        this.cj.a(flag);
    }

    protected void s(int air) {
        if (this.bL() && !this.bl()) {
            this.j(air - 1);
            if (this.ct() == -20) {
                this.j(0);
                this.a(this.dX().t(), 2.0f);
            }
        } else {
            this.j(this.cs());
        }
    }

    public void x() {
        int i2 = this.ct() + 1800;
        this.j(Math.min(i2, this.cs()));
    }

    @Override
    public int cs() {
        return this.maxAirTicks;
    }

    public Variant go() {
        return Variant.a(this.al.a(cl));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(cl, variant.a());
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    public void y(boolean playingDead) {
        this.al.a(cm, playingDead);
    }

    public boolean gp() {
        return this.al.a(cm);
    }

    @Override
    public boolean p() {
        return this.al.a(cn);
    }

    @Override
    public void x(boolean fromBucket) {
        this.al.a(cn, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Axolotl axolotl = EntityTypes.h.a(world, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.ae) ? Variant.b(this.ae) : (this.ae.h() ? this.go() : ((Axolotl)entity).go());
            axolotl.a(axolotl_variant);
            axolotl.ai();
        }
        return axolotl;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aE);
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("axolotlBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        gameprofilerfiller.c();
        if (!this.gb()) {
            Optional<Integer> optional = this.ec().c(MemoryModuleType.N);
            this.y(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder gq() {
        return EntityAnimal.gt().a(GenericAttributes.s, 14.0).a(GenericAttributes.v, 1.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new AmphibiousPathNavigation(this, world);
    }

    @Override
    public void gf() {
        this.a(SoundEffects.aK, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        float f1 = this.eE();
        if (!this.gb() && this.dW().A.a(3) == 0 && ((float)this.dW().A.a(3) < amount || f1 / this.eS() < 0.5f) && amount < f1 && this.bj() && (source.d() != null || source.c() != null) && !this.gp()) {
            this.bF.a(MemoryModuleType.N, Integer.valueOf(200));
        }
        return super.a(world, source, amount);
    }

    @Override
    public int Z() {
        return 1;
    }

    @Override
    public int aa() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void i(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        CustomData.a(DataComponents.X, stack, (NBTTagCompound nbttagcompound) -> {
            nbttagcompound.a(cf, this.go().a());
            nbttagcompound.a("Age", this.Z_());
            BehaviorController<Axolotl> behaviorcontroller = this.ec();
            if (behaviorcontroller.a(MemoryModuleType.U)) {
                nbttagcompound.a("HuntingCooldown", behaviorcontroller.e(MemoryModuleType.U));
            }
        });
    }

    @Override
    public void h(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        this.a(Variant.a(nbt.h(cf)));
        if (nbt.e("Age")) {
            this.c_(nbt.h("Age"));
        }
        if (nbt.e("HuntingCooldown")) {
            this.ec().a(MemoryModuleType.U, true, nbt.i("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack X_() {
        return new ItemStack(Items.rh);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.dk;
    }

    @Override
    public boolean ex() {
        return !this.gp() && super.ex();
    }

    public static void a(WorldServer world, Axolotl axolotl, EntityLiving target) {
        Entity entity;
        DamageSource damagesource;
        if (target.eF() && (damagesource = target.eG()) != null && (entity = damagesource.d()) != null && entity.aq() == EntityTypes.bS) {
            EntityHuman entityhuman = (EntityHuman)entity;
            List<EntityHuman> list = world.a(EntityHuman.class, axolotl.cR().g(20.0));
            if (list.contains(entityhuman)) {
                axolotl.a(entityhuman);
            }
        }
    }

    @Override
    public void a(EntityHuman player) {
        MobEffect mobeffect = player.c(MobEffects.j);
        if (mobeffect == null || mobeffect.a(2399)) {
            int i2 = mobeffect != null ? mobeffect.d() : 0;
            int j2 = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, j2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean W() {
        return super.W() || this.p();
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.aM;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.aL;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return this.bj() ? SoundEffects.aO : SoundEffects.aN;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.aP;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.aQ;
    }

    protected BehaviorController.b<Axolotl> ed() {
        return BehaviorController.a(cb, ca);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Axolotl> ec() {
        return super.ec();
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public void a_(Vec3D movementInput) {
        if (this.di() && this.bj()) {
            this.a(this.fp(), movementInput);
            this.a(EnumMoveType.a, this.dz());
            this.h(this.dz().c(0.9));
        } else {
            super.a_(movementInput);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.rg)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.qX)));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.p() && !this.l_();
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.O();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> type, WorldAccess world, EntitySpawnReason reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.ca);
    }

    private static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gp()) {
                super.a();
            }
        }
    }

    private class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl axolotl2, int i2) {
            super(axolotl2, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gp()) {
                super.a();
            }
        }
    }

    public static enum Variant implements INamable
    {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        private static final IntFunction<Variant> g;
        public static final Codec<Variant> f;
        private final int h;
        private final String i;
        private final boolean j;

        private Variant(int i2, String s2, boolean flag) {
            this.h = i2;
            this.i = s2;
            this.j = flag;
        }

        public int a() {
            return this.h;
        }

        public String b() {
            return this.i;
        }

        @Override
        public String c() {
            return this.i;
        }

        public static Variant a(int id) {
            return g.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean natural) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(Variant.values()).filter(axolotl_variant -> axolotl_variant.j == natural).toArray(Variant[]::new);
            return (Variant)SystemUtils.a((Object[])aaxolotl_variant, random);
        }

        static {
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            f = INamable.a(Variant::values);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... variants) {
            super(false);
            this.a = variants;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

