/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class Frog
extends EntityAnimal
implements VariantHolder<Holder<FrogVariant>> {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> bZ = ImmutableList.of(SensorType.c, SensorType.f, SensorType.v, SensorType.s, SensorType.w);
    protected static final ImmutableList<MemoryModuleType<?>> ca = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.r, MemoryModuleType.S, MemoryModuleType.T, MemoryModuleType.o, MemoryModuleType.O, MemoryModuleType.P, (Object[])new MemoryModuleType[]{MemoryModuleType.R, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.B, MemoryModuleType.X, MemoryModuleType.Y, MemoryModuleType.Z, MemoryModuleType.aa});
    private static final DataWatcherObject<Holder<FrogVariant>> ch = DataWatcher.a(Frog.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<OptionalInt> ci = DataWatcher.a(Frog.class, DataWatcherRegistry.v);
    private static final int cj = 5;
    public static final String cb = "variant";
    private static final ResourceKey<FrogVariant> ck = FrogVariant.b;
    public final AnimationState cd = new AnimationState();
    public final AnimationState ce = new AnimationState();
    public final AnimationState cf = new AnimationState();
    public final AnimationState cg = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.bP = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.bQ = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
    }

    protected BehaviorController.b<Frog> ed() {
        return BehaviorController.a(ca, bZ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Frog> ec() {
        return super.ec();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ch, BuiltInRegistries.aj.b(ck));
        builder.a(ci, OptionalInt.empty());
    }

    public void p() {
        this.al.a(ci, OptionalInt.empty());
    }

    public Optional<Entity> t() {
        return this.al.a(ci).stream().mapToObj(this.dW()::a).filter(Objects::nonNull).findFirst();
    }

    public void b(Entity entity) {
        this.al.a(ci, OptionalInt.of(entity.ar()));
    }

    @Override
    public int ac() {
        return 35;
    }

    @Override
    public int aa() {
        return 5;
    }

    public Holder<FrogVariant> x() {
        return this.al.a(ch);
    }

    public void j(Holder<FrogVariant> holder) {
        this.al.a(ch, holder);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cb, this.x().e().orElse(ck).a().toString());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        Optional.ofNullable(MinecraftKey.c(nbt.l(cb))).map(variant -> ResourceKey.a(Registries.F, variant)).flatMap(BuiltInRegistries.aj::a).ifPresent(this::j);
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("frogBrain");
        this.ec().a(world, this);
        profilerFiller.c();
        profilerFiller.a("frogActivityUpdate");
        FrogAi.a(this);
        profilerFiller.c();
        super.a(world);
    }

    @Override
    public void h() {
        if (this.dW().B_()) {
            this.cg.a(this.bm() && !this.aT.d(), this.af);
        }
        super.h();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.aq.equals(data)) {
            EntityPose pose = this.aw();
            if (pose == EntityPose.g) {
                this.cd.a(this.af);
            } else {
                this.cd.a();
            }
            if (pose == EntityPose.i) {
                this.ce.a(this.af);
            } else {
                this.ce.a();
            }
            if (pose == EntityPose.j) {
                this.cf.a(this.af);
            } else {
                this.cf.a();
            }
        }
        super.a(data);
    }

    @Override
    protected void B(float posDelta) {
        float f2 = this.cd.b() ? 0.0f : Math.min(posDelta * 25.0f, 1.0f);
        this.aT.a(f2, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void gu() {
        this.dW().a(null, this, SoundEffects.kh, SoundCategory.g, 2.0f, 1.0f);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Frog frog = EntityTypes.ac.a(world, EntitySpawnReason.e);
        if (frog != null) {
            FrogAi.a(frog, world.H_());
        }
        return frog;
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    public void a(boolean baby) {
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        this.ec().a(MemoryModuleType.Y, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        Holder<BiomeBase> holder = world.t(this.dw());
        if (holder.a(BiomeTags.ai)) {
            this.j(BuiltInRegistries.aj.b(FrogVariant.d));
        } else if (holder.a(BiomeTags.aj)) {
            this.j(BuiltInRegistries.aj.b(FrogVariant.c));
        } else {
            this.j(BuiltInRegistries.aj.b(ck));
        }
        FrogAi.a(this, world.H_());
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public static AttributeProvider.Builder go() {
        return EntityAnimal.gt().a(GenericAttributes.v, 1.0).a(GenericAttributes.s, 10.0).a(GenericAttributes.c, 10.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return SoundEffects.kf;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.ki;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.kg;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.kl, 0.15f, 1.0f);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    protected int f(float fallDistance, float damageMultiplier) {
        return super.f(fallDistance, damageMultiplier) - 5;
    }

    @Override
    public void a_(Vec3D movementInput) {
        if (this.di() && this.bj()) {
            this.a(this.fp(), movementInput);
            this.a(EnumMoveType.a, this.dz());
            this.h(this.dz().c(0.9));
        } else {
            super.a_(movementInput);
        }
    }

    public static boolean j(EntityLiving entity) {
        EntitySlime slime;
        if (entity instanceof EntitySlime && (slime = (EntitySlime)entity).go() != 1) {
            return false;
        }
        return entity.aq().a(TagsEntity.n);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new c(this, world);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.O();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aq);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EntitySpawnReason reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.ci) && Frog.a(world, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected boolean c() {
            return Frog.this.t().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog frog, World world) {
            super(frog, world);
        }

        @Override
        public boolean b(PathType nodeType) {
            return nodeType != PathType.k && super.b(nodeType);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new b(true);
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition a = new BlockPosition.MutableBlockPosition();

        public b(boolean penalizeDeepWater) {
            super(penalizeDeepWater);
        }

        @Override
        public PathPoint a() {
            return !this.c.bj() ? super.a() : this.c(new BlockPosition(MathHelper.a(this.c.cR().a), MathHelper.a(this.c.cR().b), MathHelper.a(this.c.cR().c)));
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            this.a.d(x2, y2 - 1, z2);
            IBlockData blockState = context.a(this.a);
            return blockState.a(TagsBlock.bT) ? PathType.b : super.a(context, x2, y2, z2);
        }
    }
}

