/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class Tadpole
extends EntityFish {
    @VisibleForTesting
    public static int a = Math.abs(-24000);
    public static final float b = 0.4f;
    public static final float c = 0.3f;
    public int cb;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> bZ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.s);
    protected static final ImmutableList<MemoryModuleType<?>> ca = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.K, MemoryModuleType.P, MemoryModuleType.R, MemoryModuleType.O, MemoryModuleType.r, MemoryModuleType.Z);
    public boolean ageLocked;

    public Tadpole(EntityTypes<? extends EntityFish> type, World world) {
        super(type, world);
        this.bQ = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.bP = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    protected BehaviorController.b<Tadpole> ed() {
        return BehaviorController.a(ca, bZ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return TadpoleAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Tadpole> ec() {
        return super.ec();
    }

    @Override
    protected SoundEffect go() {
        return SoundEffects.zT;
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("tadpoleBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("tadpoleActivityUpdate");
        TadpoleAi.a(this);
        gameprofilerfiller.c();
        super.a(world);
    }

    public static AttributeProvider.Builder gp() {
        return EntityAnimal.gt().a(GenericAttributes.v, 1.0).a(GenericAttributes.s, 6.0);
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.dW().C && !this.ageLocked) {
            this.c(this.cb + 1);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Age", this.cb);
        nbt.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.c(nbt.h("Age"));
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.zV;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.zS;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.j(itemstack)) {
            this.a(player, itemstack);
            return EnumInteractionResult.a;
        }
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public boolean p() {
        return true;
    }

    @Override
    public void x(boolean fromBucket) {
    }

    @Override
    public void i(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        CustomData.a(DataComponents.X, stack, (NBTTagCompound nbttagcompound) -> {
            nbttagcompound.a("Age", this.gq());
            nbttagcompound.a("AgeLocked", this.ageLocked);
        });
    }

    @Override
    public void h(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        if (nbt.e("Age")) {
            this.c(nbt.h("Age"));
        }
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    public ItemStack X_() {
        return new ItemStack(Items.ri);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.do;
    }

    private boolean j(ItemStack stack) {
        return stack.a(TagsItem.aq);
    }

    private void a(EntityHuman player, ItemStack stack) {
        this.b(player, stack);
        this.b(EntityAgeable.d_(this.gs()));
        this.dW().a(Particles.O, this.d(1.0), this.dE() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
    }

    private void b(EntityHuman player, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    private int gq() {
        return this.cb;
    }

    private void b(int seconds) {
        if (this.ageLocked) {
            return;
        }
        this.c(this.cb + seconds * 20);
    }

    private void c(int tadpoleAge) {
        this.cb = tadpoleAge;
        if (this.cb >= a) {
            this.gr();
        }
    }

    private void gr() {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Frog converted = this.convertTo(EntityTypes.ac, ConversionParams.a(this, false, false), (T frog) -> {
                frog.a((WorldAccess)worldserver, this.dW().d_(frog.dw()), EntitySpawnReason.i, (GroupDataEntity)null);
                frog.ai();
                frog.a(this.a(this.aw()));
                this.a(SoundEffects.zU, 0.15f, 1.0f);
            }, EntityTransformEvent.TransformReason.METAMORPHOSIS, CreatureSpawnEvent.SpawnReason.METAMORPHOSIS);
            if (converted == null) {
                this.c(0);
            }
        }
    }

    private int gs() {
        return Math.max(0, a - this.cb);
    }

    @Override
    public boolean en() {
        return false;
    }
}

